<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Poligrafico extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
		$this->load->model('servicio/Servicio_model','servicio');
		/*************************************************/		
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Poligrafico_model','poligrafico');
		$this->load->helper('util');  
    }
    

    public function nuevo_cedula($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $medico = $this->session->user;
        $empresa = $this->cliente->get_empresa_by_clte($cliente_id);

        if(isset($_POST) && count($_POST) > 0)  
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
            /*************************************************/ 
 
            if($this->form_validation->run())
            {
                $data_insert['polig_tipo_cve']        = 'CEDULA';
                $data_insert['emp_id']                = $persona['emp_id'];
                $data_insert['clte_id']               = $persona['clte_id'];
                $data_insert['usr_id']                = $medico['usr_id'];
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/
                $data_insert['polig_motivo']                =	$this->input->post('motivo');
                $data_insert['polig_fecha_eval']            =	formatea_fecha_mysql($this->input->post('fecha_eval'));
                $data_insert['polig_tecnica']               =	$this->input->post('tecnica');
                $data_insert['polig_cedula_resultado']      =	$this->input->post('cedula_resultado');
                //$data_insert['nombre_conclusiones']    = $this->input->post('nombre_conclusiones');
                $data_insert['polig_conclusiones']               = $this->input->post('leyenda');
                $data_insert['polig_ap']              =	$this->input->post('polig_ap');
                $data_insert['polig_nombre']          =	$this->input->post('polig_nombre');
                $data_insert['polig_ap01_nombre']           =	$this->input->post('polig_ap01_nombre');
                $data_insert['polig_ap01_cedula']           =	$this->input->post('polig_ap01_cedula');
                $data_insert['polig_ap02_nombre']           =	$this->input->post('ap02_nombre');
                $data_insert['polig_ap02_cedula']           =	$this->input->post('ap02_cedula');
                
                $data_insert['polig_grado_acad_detalle'] = $this->input->post('polig_grado_acad_detalle');
				$data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');				
                if($this->poligrafico->insert(array_to_upper($data_insert)))
                {
                    send_json_ok('Se guardó de forma correcta');
					/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
					$servicios=$persona['domserv'];					
					
					$servicio='CED;'; /*CODIGO DEL EXAMEN*/
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
					/**************************************************/					
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $data['empresa'] = $empresa;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/poligrafico/nuevo_cedula_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }


    public function nuevo_reporte($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $medico = $this->session->user;
        $empresa = $this->cliente->get_empresa_by_clte($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)  
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
            /*************************************************/ ;
            $this->form_validation->set_rules('fecha_eval','Fecha de evaluación','required');
            $this->form_validation->set_rules('motivo','Motivo de evaluación','required');
            $this->form_validation->set_rules('tecnica','Técnica utilizada','required');
            
            
            if($this->form_validation->run())
            {
                $data_insert['polig_tipo_cve']            = 'POLI';
                $data_insert['emp_id']                    = $persona['emp_id'];
                $data_insert['clte_id']                   = $persona['clte_id'];
                $data_insert['usr_id']                    = $medico['usr_id'];
                $data_insert['polig_grado_acad_detalle'] = $this->input->post('polig_grado_acad_detalle');
				$data_insert['polig_motivo']                    = $this->input->post('motivo');
				$data_insert=array_to_upper($data_insert);
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/
			
                $data_insert['polig_fecha_eval']                = $this->input->post('fecha_eval'); //formatea_fecha_mysql($this->input->post('fecha_eval'));
                $data_insert['polig_tecnica']                   = $this->input->post('tecnica');
                $data_insert['polig_resultado_criterio']  = $this->input->post('polig_resultado_criterio');
                $data_insert['polig_resultado_tecnico']   = $this->input->post('polig_resultado_tecnico');
                $data_insert['polig_trayectoria']         = $this->input->post('polig_trayectoria');
                $data_insert['polig_ilicito']             = $this->input->post('polig_ilicito');
                $data_insert['polig_droga']               = $this->input->post('polig_droga');
                $data_insert['polig_alcohol']             = $this->input->post('polig_alcohol');
                $data_insert['polig_delito']              = $this->input->post('polig_delito');
                $data_insert['polig_delictivo']           = $this->input->post('polig_delictivo');
            	    
                $data_insert['polig_bienes']              = $this->input->post('polig_bienes');
                $data_insert['polig_ant_personales']      = $this->input->post('polig_ant_personales');
                $data_insert['polig_ant_laborales']       = $this->input->post('polig_ant_laborales');
                $data_insert['polig_conducta']            = $this->input->post('polig_conducta');
                
                $data_insert['polig_veracidad']            = $this->input->post('veracidad');
                $data_insert['polig_conclusiones']         = $this->input->post('conclusiones');
           	   /* $data_insert['polig_estado']               =  $this->input->post('estado');*/
			  
				$data_insert['polig_q1'] = $this->input->post('polig_q1');
				$data_insert['polig_r1'] = $this->input->post('polig_r1');
				$data_insert['polig_rr1'] = $this->input->post('polig_rr1');
				$data_insert['polig_q2'] = $this->input->post('polig_q2');
				$data_insert['polig_r2'] = $this->input->post('polig_r2');
				$data_insert['polig_rr2'] = $this->input->post('polig_rr2');
				$data_insert['polig_q3'] = $this->input->post('polig_q3');
				$data_insert['polig_r3'] = $this->input->post('polig_r3');
				$data_insert['polig_rr3'] = $this->input->post('polig_rr3');
				$data_insert['polig_q4'] = $this->input->post('polig_q4');
				$data_insert['polig_r4'] = $this->input->post('polig_r4');
				$data_insert['polig_rr4'] = $this->input->post('polig_rr4');
				$data_insert['polig_analisis_resumen'] = $this->input->post('analisis_resumen'); 
				
				
                $data_insert['polig_ap']              =	$this->input->post('polig_ap');
                $data_insert['polig_nombre']          =	$this->input->post('polig_nombre');
                $data_insert['polig_ap01_nombre']           =	strtoupper($this->input->post('polig_ap01_nombre'));
                $data_insert['polig_ap01_cedula']           =	strtoupper($this->input->post('polig_ap01_cedula'));
                $data_insert['polig_ap02_nombre']           =	$this->input->post('ap02_nombre');
                $data_insert['polig_ap02_cedula']           =	$this->input->post('ap02_cedula');
                $data_insert['polig_envia']           =			$this->input->post('poli_envia');
				$data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');
				$data_insert['log_updt_f']  =  $data_insert['log_insrt_f'];
              

			  if($this->poligrafico->insert($data_insert))
                {
                    send_json_ok('Se guardó de forma correcta');
					/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
					$servicios=$persona['domserv'];					
					
					$servicio='POL;'; /*CODIGO DEL EXAMEN*/
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
					/**************************************************/						
					
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $data['empresa'] = $empresa;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/poligrafico/nuevo_reporte_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }

   public function edit($cliente_id, $fsm_id)
    {
		
        $persona = $this->cliente->get($cliente_id);
        $medico = $this->session->user;
        $data['fsm'] = $this->poligrafico->get($fsm_id);
        $empresa = $this->cliente->get_empresa_by_clte($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)  
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('motivo','Motivo de evaluación','required');
            $this->form_validation->set_rules('tecnica','Técnica utilizada','required');
            

            if($this->form_validation->run())
            {
                
                $data_insert['polig_tipo_cve']            = 'POLI';
                $data_insert['emp_id']                    = $persona['emp_id'];
                $data_insert['clte_id']                   = $persona['clte_id'];
                $data_insert['usr_id']                    = $medico['usr_id'];
				$data_insert['polig_grado_acad_detalle'] = $this->input->post('polig_grado_acad_detalle');
				$data_insert['polig_motivo']                    = $this->input->post('motivo');
				$data_insert = array_to_upper($data_insert);
				
                
                $data_insert['polig_fecha_eval']                =  $this->input->post('fecha_eval');//formatea_fecha_mysql($this->input->post('fecha_eval'));
                $data_insert['polig_tecnica']                   = $this->input->post('tecnica');
                $data_insert['polig_resultado_criterio']  = $this->input->post('polig_resultado_criterio');
                $data_insert['polig_resultado_tecnico']   = $this->input->post('polig_resultado_tecnico');
                $data_insert['polig_trayectoria']         = $this->input->post('polig_trayectoria');
                $data_insert['polig_ilicito']             = $this->input->post('polig_ilicito');
                $data_insert['polig_droga']               = $this->input->post('polig_droga');
                $data_insert['polig_alcohol']             = $this->input->post('polig_alcohol');
                $data_insert['polig_delito']              = $this->input->post('polig_delito');
                $data_insert['polig_delictivo']           = $this->input->post('polig_delictivo');
                
                $data_insert['polig_bienes']              = $this->input->post('polig_bienes');
                $data_insert['polig_ant_personales']      = $this->input->post('polig_ant_personales');
                $data_insert['polig_ant_laborales']       = $this->input->post('polig_ant_laborales');
                $data_insert['polig_conducta']            = $this->input->post('polig_conducta');
                $data_insert['polig_estado']               = $this->input->post('estado');
                $data_insert['polig_veracidad']            = $this->input->post('veracidad');
				
				$data_insert['polig_q1'] = $this->input->post('polig_q1');
				$data_insert['polig_r1'] = $this->input->post('polig_r1');
				$data_insert['polig_rr1'] = $this->input->post('polig_rr1');
				$data_insert['polig_q2'] = $this->input->post('polig_q2');
				$data_insert['polig_r2'] = $this->input->post('polig_r2');
				$data_insert['polig_rr2'] = $this->input->post('polig_rr2');
				$data_insert['polig_q3'] = $this->input->post('polig_q3');
				$data_insert['polig_r3'] = $this->input->post('polig_r3');
				$data_insert['polig_rr3'] = $this->input->post('polig_rr3');
				$data_insert['polig_q4'] = $this->input->post('polig_q4');
				$data_insert['polig_r4'] = $this->input->post('polig_r4');
				$data_insert['polig_rr4'] = $this->input->post('polig_rr4');
				$data_insert['polig_analisis_resumen'] = $this->input->post('analisis_resumen'); 				
				
                $data_insert['polig_conclusiones']               = $this->input->post('conclusiones');
                
                $data_insert['polig_ap']              =	$this->input->post('polig_ap');
                $data_insert['polig_nombre']          =	$this->input->post('polig_nombre');
                $data_insert['polig_ap01_nombre']           =	strtoupper($this->input->post('polig_ap01_nombre'));
                $data_insert['polig_ap01_cedula']           =	strtoupper($this->input->post('polig_ap01_cedula'));
                $data_insert['polig_ap02_nombre']           =	$this->input->post('ap02_nombre');
                $data_insert['polig_ap02_cedula']           =	$this->input->post('ap02_cedula');
                
				
				$data_insert['polig_envia']           =	$this->input->post('poli_envia');
                
				$data_insert['log_updt_f']  =  date('Y-m-d H:i:s');

                
                $this->db->trans_start();
                if($this->poligrafico->update($fsm_id ,$data_insert))
                {
                    send_json_ok('Se actualizó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
                $this->db->trans_complete();
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $data['empresa'] = $empresa;
            $this->load->helper('template');
			
            $params_view = array(
                'title' => '',
                'view' => 'examen/poligrafico/ed',
                'view_data' => $data 
               );
            render_template($params_view);
        }
        
    }
     
    public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['medico'] = $this->session->user;
		
        $data['fsm'] = $this->poligrafico->get($fsm_id,get_desp_id_usr());
		
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');

		$evaluado= $data['persona']['clte_nombre'].' ';		
		if ( strlen($data['persona']['clte_2_nombre']) > 0)
		{
			$evaluado= $evaluado.$data['persona']['clte_2_nombre'].' ';
		}				
		$evaluado= $evaluado.$data['persona']['clte_paterno'].' ';			
		$evaluado= $evaluado.$data['persona']['clte_materno'].' ';

		
        if($data['fsm']['polig_tipo_cve'] == 'CEDULA')
        {
            $html = $this->load->view('examen/poligrafico/cedula_pdf',$data,TRUE);
			
			//$evaluado=get_SSPCDMX($data['fsm']['log_insrt_f']).$evaluado;
		}
        else
        {
            $html = $this->load->view('examen/poligrafico/reporte_nw_pdf',$data,TRUE);
        	// $html = $this->load->view('examen/poligrafico/reporte_pdf',$data,TRUE);
		}
        genera_pdf_new_reporte_poli($html,'poligrafico','poligrafico',$evaluado);
		//genera_pdf_reporte_poli($html,'poligrafico','poligrafico',$evaluado);
        //genera_pdf($html,'poligrafico','poligrafico','poligrafico');
	
    }
}