 <?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Corporativos extends CI_Controller {
    
    function __construct() {
        parent::__construct();
		$this->load->model('corporativos/Corporativos_model','catalogo');
        $this->load->model('empleado/Empleado_model','empleado');
		$this->load->model('empresa/Empresa_model','empresa');
    }

   public function borra($fsm_id)
    {
        if($this->catalogo->borra($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


   public function index()
    {		
		
        $rows = 30; 
        $this->load->library('pagination');
        $config['base_url'] = base_url('corporativos/index/');
        $config['total_rows'] = $this->catalogo->count_all();
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        
        $data['catalogo'] = $this->catalogo->get_allo($rows);
		$data['empresas'] = $this->empresa->get_all_empresas_clean();
	    $this->load->helper('template');
      
		$params_view = array(
            'title' => 'Usuario',
            'view' => 'corporativos/index',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
 

    public function edita($corp_id)
    {
        $item = $this->catalogo->get($corp_id);		
		$user = $this->session->user;
        
        if($item)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {

				$this->load->library('form_validation');
				$this->form_validation->set_rules('empresa','Empresa','required');
				$this->form_validation->set_rules('corp_nombre','Nombre de Corporativo','required');
				$this->form_validation->set_rules('cat_estatus_cve','Estatus','required');
	  
            if($this->form_validation->run())
            {
					$data_usr['emp_id'] = trim($this->input->post('empresa'));       
					$data_usr['corp_nombre'] = trim($this->input->post('corp_nombre')); 
					$data_usr['emp_razon_social'] = get_empresa($data_usr['emp_id']); 
					$data_usr['log_updt_f'] =   date('Y-m-d H:i:s');
					$data_usr['log_updt_usr_cve'] = $usr['usr_id']; 				
					$data_usr['cat_estatus_cve'] = trim($this->input->post('cat_estatus_cve')); 
				    $data_usr = array_to_upper($data_usr);
					
                    if($this->catalogo->actualiza($corp_id, $data_usr))
                    {
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar el item.');
                    }
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				

                $data['item'] =  $item;
				$data['empresas'] = $this->empresa->get_all_empresas_clean();
				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Empleados',
                    'view' => 'corporativos/edit',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el item');
        }
    }
 
    public function nuevo()
    {$user = $this->session->user;
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('empresa','Empresa','required');
            $this->form_validation->set_rules('corp_nombre','Nombre de Corporativo','required');
            $this->form_validation->set_rules('cat_estatus_cve','Estatus','required');
  
            if($this->form_validation->run())
            {
                $data_usr['emp_id'] = trim($this->input->post('empresa'));       
				$data_usr['corp_nombre'] = trim($this->input->post('corp_nombre')); 
				$data_usr['emp_razon_social'] = get_empresa($data_usr['emp_id']); 
				$data_usr['log_insrt_f'] =   date('Y-m-d H:i:s');
				$data_usr['log_insrt_usr_cve'] = $usr['usr_id']; 				
				$data_usr['cat_estatus_cve'] = trim($this->input->post('cat_estatus_cve')); 
                $data_usr = array_to_upper($data_usr);
				
                if($this->catalogo->inserta($data_usr))
                {
                    send_json_ok('Se registro de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar el empleado.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			$data['empresas'] = $this->empresa->get_all_empresas_clean();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Empleados',
                'view' => 'corporativos/add',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }



    function busca()
    {        
        $empresa  = trim(strtoupper($this->input->post('empresa')));
		$corp_nombre = trim(strtoupper($this->input->post('corp_nombre')));
		$estatus = $this->input->post('estatus');  
		$data['catalogo'] = $this->catalogo->busca($empresa,$corp_nombre,$estatus);
        send_json_ok($this->load->view('corporativos/busca',$data,TRUE));
    }



   public function duplicar($corp_id)
    {
        $item = $this->catalogo->get($corp_id);		
		$user = $this->session->user;
		
        if($item)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
				$this->load->library('form_validation');
				$this->form_validation->set_rules('empresa','Empresa','required');
				$this->form_validation->set_rules('corporativo','Nombre de Corporativo','required');
				$this->form_validation->set_rules('cat_estatus_cve','Estatus','required');

			   // if($this->form_validation->run())
				if(1)   
				{
					$data_usr['emp_id'] = trim($this->input->post('empresa'));       
					$data_usr['corp_nombre'] = trim($this->input->post('corp_nombre')); 
					$data_usr['emp_razon_social'] = get_empresa($data_usr['emp_id']); 
					$data_usr['log_insrt_f'] =   date('Y-m-d H:i:s');
					$data_usr['log_insrt_usr_cve'] = $usr['usr_id']; 				
					$data_usr['cat_estatus_cve'] = trim($this->input->post('cat_estatus_cve')); 

					$data_usr = array_to_upper($data_usr);
				
					if($this->catalogo->inserta($data_usr))				
					{
						send_json_ok(array('msg' =>'Se ha creado un nuevo registro.', 'id' => $corp_id));
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar el nuevo nombre.');
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
                $data['item'] = 	$item;						
				$data['empresas'] = $this->empresa->get_all_empresas_clean();
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Medicinas',
                    'view' => 'corporativos/copy',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el registro');
        }
    }


    public function reporte_card()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'corporativos/inicio_view_rep',
            'view_data' => $data
            );
        render_template($params_view);
    }
 

	
     function reporte_catalogos()
    {
        $grupo  = trim(strtoupper($this->input->post('grupo')));
		$subgrupo  = trim(strtoupper($this->input->post('subgrupo')));
		$clave = trim(strtoupper($this->input->post('clave')));
		$estatus = $this->input->post('estatus');  
		$detalle= trim(strtoupper($this->input->post('detalle'))); 
		$catalogo = $this->catalogo->busca($grupo,$subgrupo ,$clave, $estatus, $detalle);
		
        //$this->load->model('empresa/Empresa_model','empresa');
        //$data['empresas'] = $this->empresa->get_all_empresas();
        $this->load->helper('template');		
		?>
		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">

		<head>
		<meta content="es-mx" http-equiv="Content-Language" />
		<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
				<?php
					date_default_timezone_set('America/Mexico_City');
					$date2today = date("_dmY_His");
					header("Content-type: application/octet-stream; charset=latin1");
					header("Content-Disposition: attachment; filename=rep_catalogo".$date2today.".xls");
					header("Pragma: no-cache");
					header("Expires: 0");
					$date2today = date("d/m/Y H:i:s");
				?>
				<title>REPORTE USUARIOS</title>
				<style type="text/css">
					.auto-style1 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: small;
					}
					.auto-style4 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
					}
					.auto-style5 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: medium;
					}
					.auto-style6 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-large;
						text-align: right;
						font-weight: normal;
					}
					.auto-style7 {
						font-size: small;
					}
					.auto-style8 {
						color: #3D5588;
					}
					.auto-style9 {
						color: #3AD4A7;
					}
								.auto-style11 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: right;
					}
					.auto-style12 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: center;
					}
					.auto-style13 {
						font-size: xx-small;
					}
					.auto-style14 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: xx-small;
					}
					.auto-style15 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
					}
					.auto-style16 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: right;
					}
					.auto-style17 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: left;
					}
					.auto-style18 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
					}
								.auto-style19 {
						color: #3D5588;
						font-size: medium;
					}
					.auto-style20 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
						background-color: #BFEADD;
					}
					.auto-style21 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						background-color: #BFEADD;
					}
				</style>
			</head>

			<body>
				<table>
					<thead>
						<tr>
							<th class="auto-style5" style="width: 75px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 350px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5"><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">Reporte de Catálogos en Plataforma</th>
						</tr>
						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" style=" height: 27px;"><span class="auto-style19">online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" style=" height: 27px;"><?php echo $date2today; ?></th>
						</tr>
						<tr>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style14" >ID</th>
							<th class="auto-style14" >Grupo</th>
							<th class="auto-style14" >Sub Grupo</th>
							<th class="auto-style14">Secuencia</th>
							<th class="auto-style14" >Clave</th>
							<th class="auto-style14" >Detalle</th>
							<th class="auto-style14" >Estatus</th>
						</tr>
					</thead>
					<tbody id="resultado">
						<?php
						$class18=" ";
                        if($catalogo): 
                            foreach ($catalogo as $elemento): 

								if ($class18 != "auto-style18")
								{
									$class18="auto-style18";
									$class4="auto-style4";
								}	
								else
								{
									$class18="auto-style20";
									$class4="auto-style21";							
								}

								if ( $elemento['cat_estatus_cve'] === 'ACTIVO')
								{ $color='dark';} else { $color='red';}
								?>
								
                                <tr>
                                    <td class=<?php echo $class18; ?>>
										<b>
											<?php echo $elemento['corp_id']; ?> 
										</b>	
                                    </td>								
                                    <td class=<?php echo $class18; ?>>
										<b>
											<?php echo $elemento['cat_grupo']; ?> 
										</b>	
                                    </td>
                                    <td class=<?php echo $class18; ?>>
										<b>
											<?php echo $elemento['cat_grupo_nombre']; ?>
										</b>
									</td>
                                    <td class=<?php echo $class18; ?>>
										<b>
											<?php echo $elemento['cat_seq']; ?>
										</b>	
									</td>
									<td class=<?php echo $class18; ?>>
										<b>
											<?php echo $elemento['cat_cve']; ?>
										</b>	
									</td>
									<td class=<?php echo $class18; ?>>
										<b>
											<?php echo $elemento['cat_nombre']; ?>
										</b>	
									</td>	
									<td class=<?php echo $class18; ?>>
										<b>
											<?php echo $elemento['cat_estatus_cve']; ?>
										</b>	
									</td>									
                                </tr>
                            <?php 
                            endforeach;
                        endif;
                    ?>						
						
		
					</tbody>
				</table>
			</body>
		</html>
		<?php 
	}
		
	
}