<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Medico_fisico_ext extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		$this->load->model('servicio/Servicio_model','servicio');
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Medico_fisico_ext_model','medico_fisico');
		$this->load->helper('util');
    }
 
    public function edita($cliente_id,$fsm_id)
    {
        $persona = $this->cliente->get($cliente_id);		
        $user = $this->session->user;
		//$medico = $this->medico->get_id(293);
		$data['fsm'] = $this->medico_fisico->get($fsm_id);
		$empresa = $this->cliente->get_empresa_by_id($persona['emp_id']);
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            
            if(true)
            {
				//$data_insert['emp_id']  = $persona['emp_id'];
                //$data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['usr_id']  = $user['usr_id'];
				$data_insert['log_updt_usr_cve']  = $user['usr_id'];
		
                $data_insert['med_id']  = $this->input->post('medicos');;
                $data_insert['fsm_f']   = date("Y-m-d H:i:s");
				$data_insert['log_updt_f']  =  $data_insert['fsm_f'];
				$data_insert['fsm_f_evaluacion']     =   $this->input->post('f_evaluacion');
				$data_insert['fsm_peso']     =   $this->input->post('peso');
				$data_insert['fsm_talla']     =   $this->input->post('talla');
				if ($this->input->post('talla') >0)
				{	
					$data_insert['fsm_imc']     =   round(($this->input->post('peso') / ( ($this->input->post('talla')/100.0) * ($this->input->post('talla')/100.0)  ) ), 1);
				}
				$data_insert['fsm_fc']     =   $this->input->post('fc');
				$data_insert['fsm_fr']     =   $this->input->post('fr');
				$data_insert['fsm_ta_sist']     =   $this->input->post('ta_sist');
				$data_insert['fsm_ta_dias']     =   $this->input->post('ta_dias');
				
				$data_insert['fsm_menarca']     =   $this->input->post('menarca');
				$data_insert['fsm_fur']     =   $this->input->post('fur');
				$data_insert['fsm_gestas']     =   $this->input->post('gestas');
				$data_insert['fsm_abortos']     =   $this->input->post('abortos');
				$data_insert['fsm_partos']     =   $this->input->post('partos');
				$data_insert['fsm_cesareas']     =   $this->input->post('cesareas');
				$data_insert['fsm_f_ultimo_apc']     =   $this->input->post('f_ultimo_apc');
				$data_insert['fsm_f_ultimo_pap']     =   $this->input->post('f_ultimo_pap');
				$data_insert['fsm_gineco_resultado']     =   $this->input->post('gineco_resultado');
				
                $data_insert['fsm_med_vis_cve']     =   $this->input->post('fsm_med_vis_cve');
                $data_insert['fsm_med_vis_info']    =	($this->input->post('fsm_med_vis_info') != '')?$this->input->post('fsm_med_vis_info'):$res;
                $data_insert['fsm_med_aud_cve']     =	$this->input->post('fsm_med_aud_cve');
                $data_insert['fsm_med_aud_info']    =	($this->input->post('fsm_med_aud_info') != '')?$this->input->post('fsm_med_aud_info'):$res;
                $data_insert['fsm_med_olf_cve']     =	$this->input->post('fsm_med_olf_cve');
                $data_insert['fsm_med_olf_info']    =	($this->input->post('fsm_med_olf_info') != '')?$this->input->post('fsm_med_olf_info'):$res;
                $data_insert['fsm_med_pul_cve']     =	$this->input->post('fsm_med_pul_cve');
                $data_insert['fsm_med_pul_info']    =	($this->input->post('fsm_med_pul_info') != '')?$this->input->post('fsm_med_pul_info'):$res;
                $data_insert['fsm_fis_ref_cve']     =	$this->input->post('fsm_fis_ref_cve');
                $data_insert['fsm_fis_ref_info']    =	($this->input->post('fsm_fis_ref_info') != '')?$this->input->post('fsm_fis_ref_info'):$res;
                $data_insert['fsm_fis_cond_cve']    =	$this->input->post('fsm_fis_cond_cve');
                $data_insert['fsm_fis_cond_info']   =	($this->input->post('fsm_fis_cond_info') != '')?$this->input->post('fsm_fis_cond_info'):$res;
                $data_insert['fsm_fis_res_cve']     =	$this->input->post('fsm_fis_res_cve');
                $data_insert['fsm_fis_res_info']    =	($this->input->post('fsm_fis_res_info') != '')?$this->input->post('fsm_fis_res_info'):$res;
                $data_insert['fsm_fis_loc_cve']     =	$this->input->post('fsm_fis_loc_cve');
                $data_insert['fsm_fis_loc_info']    =	($this->input->post('fsm_fis_loc_info') != '')?$this->input->post('fsm_fis_loc_info'):$res;
                
				$data_insert['fsm_anf_cve'] = $this->input->post('anf');
                $data_insert['fsm_coc_cve'] = $this->input->post('coc');
                $data_insert['fsm_mar_cve'] = $this->input->post('mar');
                $data_insert['fsm_opi_cve'] = $this->input->post('opi');
                $data_insert['fsm_pcp_cve'] = $this->input->post('pcp');
				$data_insert['fsm_alergia'] = $this->input->post('alergia');
				$data_insert['fsm_cronica'] = $this->input->post('cronica');
				$data_insert['fsm_ex_obs'] = $this->input->post('ex_obs');
				$data_insert['fsm_ex_reco'] = $this->input->post('ex_reco');
				$data_insert['fsm_resultados'] = $this->input->post('fsm_resultados');

				$data_insert=array_to_upper($data_insert);
				$this->db->trans_start();
               
                if($this->medico_fisico->update($fsm_id, $data_insert)) 
                {
                    send_json_ok('Se actualizo de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/medico_fisico_ext/edit_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
 
    public function nuevo($cliente_id)
    {	
		
        $persona = $this->cliente->get($cliente_id);
		
        $user = $this->session->user;
		
		//$medico = $this->medico->get_id(293);
	
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            
            /*$this->form_validation->set_rules('fsm_med_vis_cve','Visual','required');      
            $this->form_validation->set_rules('fsm_med_aud_cve','Auditivo','required');            
            $this->form_validation->set_rules('fsm_med_olf_cve','Percepción de olores','required');            
            $this->form_validation->set_rules('fsm_med_pul_cve','Cardiopulmonar','required');            
            $this->form_validation->set_rules('fsm_fis_ref_cve','Reflejo','required');            
            $this->form_validation->set_rules('fsm_fis_cond_cve','Condición','required');            
            $this->form_validation->set_rules('fsm_fis_res_cve','Resistencia','required');            
            $this->form_validation->set_rules('fsm_fis_loc_cve','Locomoción','required');*/
            $this->form_validation->set_rules('peso','Peso','required');            
            $this->form_validation->set_rules('talla','Talla','required');
			//$this->form_validation->set_rules('fsm_fis_cond_info','required');
			//$this->form_validation->set_rules('fsm_fis_ref_info','required');
			//$this->form_validation->set_rules('fsm_med_olf_info','required');
			//$this->form_validation->set_rules('fsm_med_pul_info','required');			
			//$this->form_validation->set_rules('fsm_med_aud_info','required');
			//$this->form_validation->set_rules('fsm_med_vis_info','required');
			
			
            if($this->form_validation->run())
            {
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}				
				
                $data_insert['emp_id']  = $persona['emp_id'];
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['usr_id']  = $user['usr_id'];
				$data_insert['log_insrt_usr_cve']  = $user['usr_id'];
			
                $data_insert['med_id']  = $this->input->post('medicos');;
                $data_insert['fsm_f']   = date("Y-m-d H:i:s");
				$data_insert['log_insrt_f']  =  $data_insert['fsm_f'];
				$data_insert['log_updt_f']  =  $data_insert['fsm_f'];
				$data_insert['fsm_peso']     =   $this->input->post('peso');
				$data_insert['fsm_talla']     =   $this->input->post('talla');
				$data_insert['fsm_f_evaluacion']     =   $this->input->post('f_evaluacion');
				
				
				if ($this->input->post('talla') >0)
				{	
					$data_insert['fsm_imc']     =   round(($this->input->post('peso') / ( ($this->input->post('talla')/100.0) * ($this->input->post('talla')/100.0)  ) ), 1);
				}
	
				$data_insert['fsm_fc']     =   $this->input->post('fc');
				$data_insert['fsm_fr']     =   $this->input->post('fr');
				$data_insert['fsm_ta_sist']     =   $this->input->post('ta_sist');
				$data_insert['fsm_ta_dias']     =   $this->input->post('ta_dias');
				
				$data_insert['fsm_menarca']     =   $this->input->post('menarca');
				$data_insert['fsm_fur']     =   $this->input->post('fur');
				$data_insert['fsm_gestas']     =   $this->input->post('gestas');
				$data_insert['fsm_abortos']     =   $this->input->post('abortos');
				$data_insert['fsm_partos']     =   $this->input->post('partos');
				$data_insert['fsm_cesareas']     =   $this->input->post('cesareas');
				$data_insert['fsm_f_ultimo_apc']     =   $this->input->post('f_ultimo_apc');
				$data_insert['fsm_f_ultimo_pap']     =   $this->input->post('f_ultimo_pap');
				$data_insert['fsm_gineco_resultado']     =   $this->input->post('gineco_resultado');
				
                $data_insert['fsm_med_vis_cve']     =   $this->input->post('fsm_med_vis_cve');
                $data_insert['fsm_med_vis_info']    =	($this->input->post('fsm_med_vis_info') != '')?$this->input->post('fsm_med_vis_info'):$res;
                $data_insert['fsm_med_aud_cve']     =	$this->input->post('fsm_med_aud_cve');
                $data_insert['fsm_med_aud_info']    =	($this->input->post('fsm_med_aud_info') != '')?$this->input->post('fsm_med_aud_info'):$res;
                $data_insert['fsm_med_olf_cve']     =	$this->input->post('fsm_med_olf_cve');
                $data_insert['fsm_med_olf_info']    =	($this->input->post('fsm_med_olf_info') != '')?$this->input->post('fsm_med_olf_info'):$res;
                $data_insert['fsm_med_pul_cve']     =	$this->input->post('fsm_med_pul_cve');
                $data_insert['fsm_med_pul_info']    =	($this->input->post('fsm_med_pul_info') != '')?$this->input->post('fsm_med_pul_info'):$res;
                $data_insert['fsm_fis_ref_cve']     =	$this->input->post('fsm_fis_ref_cve');
                $data_insert['fsm_fis_ref_info']    =	($this->input->post('fsm_fis_ref_info') != '')?$this->input->post('fsm_fis_ref_info'):$res;
                $data_insert['fsm_fis_cond_cve']    =	$this->input->post('fsm_fis_cond_cve');
                $data_insert['fsm_fis_cond_info']   =	($this->input->post('fsm_fis_cond_info') != '')?$this->input->post('fsm_fis_cond_info'):$res;
                $data_insert['fsm_fis_res_cve']     =	$this->input->post('fsm_fis_res_cve');
                $data_insert['fsm_fis_res_info']    =	($this->input->post('fsm_fis_res_info') != '')?$this->input->post('fsm_fis_res_info'):$res;
                $data_insert['fsm_fis_loc_cve']     =	$this->input->post('fsm_fis_loc_cve');
                $data_insert['fsm_fis_loc_info']    =	($this->input->post('fsm_fis_loc_info') != '')?$this->input->post('fsm_fis_loc_info'):$res;
                
				$data_insert['fsm_anf_cve'] = $this->input->post('anf');
                $data_insert['fsm_coc_cve'] = $this->input->post('coc');
                $data_insert['fsm_mar_cve'] = $this->input->post('mar');
                $data_insert['fsm_opi_cve'] = $this->input->post('opi');
                $data_insert['fsm_pcp_cve'] = $this->input->post('pcp');
				
				$data_insert['fsm_alergia'] = $this->input->post('alergia');
				$data_insert['fsm_cronica'] = $this->input->post('cronica');

				$data_insert['fsm_ex_obs'] = $this->input->post('ex_obs');
				$data_insert['fsm_ex_reco'] = $this->input->post('ex_reco');
				$data_insert['fsm_resultados'] = $this->input->post('fsm_resultados');				

				if($this->medico_fisico->insert(array_to_upper($data_insert)))
                {
                    send_json_ok('Se guardó de forma correcta');
					
					$servicios=$persona['domserv'];					
					
					$servicio='HMEDXFIS;';
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
					
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                //send_json_error(validation_errors('<div />'));
				 send_json_error('Ocurrió un error en la validación de datos, llena PESO y/o TALLA');
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/medico_fisico_ext/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function pdf($cliente_id, $fsm_id) 
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->medico_fisico->get($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');
		xamplete_b($this->load->view('examen/medico_fisico_ext/pdf',$data,TRUE),'medico_fisico','medico_fisico','medico_fisico','Humancenter Review S.A de C.V.');
	}


    public function borra($fsm_id)
    {
        if($this->medico_fisico->delete_medico_fisico($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

	
 	
	
}