﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Iso extends CI_Controller {
    
    function __construct() {
        parent::__construct();
        $this->load->model('iso/Iso_model','cliente');
        $this->load->model('empleado/Empleado_model','medico');
    }
    
    
    public function id($id)
    {
		
        $data['cliente'] = $this->cliente->get($id);
        if($data['cliente'])
        {
            $id=1; 
            $data['docs'] = $this->cliente->get_docs($id);

			$data['docs_calida'] = $this->cliente->get_docs_section($id,'MANUAL DE CALIDAD');
			$data['docs_gestion'] = $this->cliente->get_docs_section($id,'PROCEDIMIENTOS DE GESTION');
			$data['docs_maestra'] = $this->cliente->get_docs_section($id,'LISTA MAESTRA');
			$data['docs_humanos'] = $this->cliente->get_docs_section($id,'RECURSOS HUMANOS');
			$data['docs_materiales'] = $this->cliente->get_docs_section($id,'RECURSOS MATERIALES');
			$data['docs_tecnologia'] = $this->cliente->get_docs_section($id,'TECNOLOGIA DE LA INFORMACION');
			$data['docs_servicios'] = $this->cliente->get_docs_section($id,'COORDINACION DE SERVICIOS');
			$data['docs_psico'] = $this->cliente->get_docs_section($id,'PSICOLOGIA');
			$data['docs_poli'] = $this->cliente->get_docs_section($id,'POLIGRAFIA');
			$data['docs_med'] = $this->cliente->get_docs_section($id,'MEDICINA');
			$data['docs_laboratorio'] = $this->cliente->get_docs_section($id,'LABORATORIO');
			$data['docs_essoco'] = $this->cliente->get_docs_section($id,'ESTUDIOS SOCIECONOMICOS');
			$data['docs_marina'] = $this->cliente->get_docs_section($id,'CAPACITACION MARITIMA');
			$data['docs_odontologicos'] = $this->cliente->get_docs_section($id,'ODONTOLOGIA');
			$data['docs_control'] = $this->cliente->get_docs_section($id,'CONTROL DE SERVICIOS');
			$data['docs_ventas'] = $this->cliente->get_docs_section($id,'VENTAS');			
			$data['docs_orga'] = $this->cliente->get_docs_section($id,'ORGANIGRAMA');
			$data['docs_sgc'] = $this->cliente->get_docs_section($id,'DOCUMENTOS SGC');
			$data['docs_marina_contancias'] = $this->cliente->get_docs_section($id,'CONSTANCIAS CAPACITACION MARITIMA');
			$data['docs_reclutamiento_seleccion'] = $this->cliente->get_docs_section($id,'RECLUTAMIENTO Y SELECCION DE PERSONAL');
			
			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Persona',
                'view' => 'iso/cliente',
                'view_data' => $data 
               );
            render_template($params_view);  
        }
        else
        {
            show_error('El cliente no existe.');
        }
    }
    
 
    public function idhc($id)
    {
		
        $data['cliente'] = $this->cliente->get($id);
        if($data['cliente'])
        {
            $id=1; 
            $data['docs'] = $this->cliente->get_docs($id);

			//$data['docs_calida'] = $this->cliente->get_docs_section($id,'MANUAL DE CALIDAD');
			//$data['docs_gestion'] = $this->cliente->get_docs_section($id,'PROCEDIMIENTOS DE GESTION');
			//$data['docs_maestra'] = $this->cliente->get_docs_section($id,'LISTA MAESTRA');
			
			$data['docs_humanos'] = $this->cliente->get_docs_section($id,'RECURSOS HUMANOS');
			
			//$data['docs_materiales'] = $this->cliente->get_docs_section($id,'RECURSOS MATERIALES');
			//$data['docs_tecnologia'] = $this->cliente->get_docs_section($id,'TECNOLOGIA DE LA INFORMACION');
			//$data['docs_servicios'] = $this->cliente->get_docs_section($id,'COORDINACION DE SERVICIOS');
			//$data['docs_psico'] = $this->cliente->get_docs_section($id,'PSICOLOGIA');
			//$data['docs_poli'] = $this->cliente->get_docs_section($id,'POLIGRAFIA');
			//$data['docs_med'] = $this->cliente->get_docs_section($id,'MEDICINA');
			//$data['docs_laboratorio'] = $this->cliente->get_docs_section($id,'LABORATORIO');
			//$data['docs_essoco'] = $this->cliente->get_docs_section($id,'ESTUDIOS SOCIECONOMICOS');
			//$data['docs_marina'] = $this->cliente->get_docs_section($id,'CAPACITACION MARITIMA');
			//$data['docs_odontologicos'] = $this->cliente->get_docs_section($id,'ODONTOLOGIA');
			//$data['docs_control'] = $this->cliente->get_docs_section($id,'CONTROL DE SERVICIOS');
			//$data['docs_ventas'] = $this->cliente->get_docs_section($id,'VENTAS');			
			//$data['docs_orga'] = $this->cliente->get_docs_section($id,'ORGANIGRAMA');
			//$data['docs_sgc'] = $this->cliente->get_docs_section($id,'DOCUMENTOS SGC');
			//$data['docs_marina_contancias'] = $this->cliente->get_docs_section($id,'CONSTANCIAS CAPACITACION MARITIMA');
			//$data['docs_reclutamiento_seleccion'] = $this->cliente->get_docs_section($id,'RECLUTAMIENTO Y SELECCION DE PERSONAL');
			
			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Persona',
                'view' => 'iso/clientehc',
                'view_data' => $data 
               );
            render_template($params_view);  
        }
        else
        {
            show_error('El cliente no existe.');
        }
    }
 
    
    public function nuevo_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] = 1;  //$cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['empresa'] =  $this->input->post('empre');
				$data_clte['doc_fecha_efectiva'] =  formatea_fecha_mysql($this->input->post('fecha_efe'));
				
                $this->load->library('upload');
				
				
				
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/isos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx|xls|xlsx',
                            'max_size'      => '10000'
                    );
					
					
                    
					$this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'iso/add_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
    
    function descarga_doc($file)
    {
        $this->load->helper('download');
        force_download('./docs/'.$file, NULL);
    }
    
   

    
    function busca()
    {        
        $empresa = $this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
        $rfc     = strtoupper($this->input->post('rfc'));
        $data['clientes'] = $this->cliente->busca($empresa, $nombre, $rfc);
        send_json_ok($this->load->view('persona/busca',$data,TRUE));
    }
    
    public function borra_iso($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		$documento['doc_path']=strtolower($documento['doc_path']);
		$this->cliente->inserta_borrado($documento);
        if($this->cliente->delete_iso($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


}