﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Matdif extends CI_Controller {
    
    function __construct() {
        parent::__construct();
        $this->load->model('matdif/Matdif_model','cliente');
        //$this->load->model('empleado/Empleado_model','medico');
		$this->load->model('empleado/Empleado_model','empleado');
    }
    
    
    public function id()
    {	$user = $this->session->user;
		$usuario = $this->empleado->get($user['usr_id']);
        $data['usuario'] = $usuario;
        if($data['usuario'])
        {
          //  $data['docs'] = $this->cliente->get_docs($usuario['emp_id']);
		
			$data['docs_presentaciones'] = $this->cliente->get_docs($usuario['emp_id']);
			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Material de Difusión',
                'view' => 'matdif/cliente',
                'view_data' => $data 
               );
            render_template($params_view);  
        }
        else
        {
            show_error('El cliente no existe.');
        }
    }
    
  
    
    public function nuevo_doc()
    {
        $user = $this->session->user;
		$usuario = $this->empleado->get($user['usr_id']);
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
				$data_clte['usr_id'] = $user['usr_id'];
				$data_clte['emp_id'] = $usuario['emp_id'];
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['doc_tipo'] =  $this->input->post('empre');
				$data_clte['doc_fecha_efectiva'] =  formatea_fecha_mysql($this->input->post('fecha_efe'));
				
				$data_clte['log_insrt_f']=date('Y-m-d H:i:s');
				$data_clte['log_insrt_usr_cve']=$usuario['emp_id'];
				$data_clte['log_insrt_prg']='add.doc';
				$data_clte['log_updt_f']=date('Y-m-d H:i:s');
				$data_clte['log_updt_usr_cve']=$usuario['emp_id'];
				
                $this->load->library('upload');	
				
				
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/matdif/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx|xls|xlsx|pptx|ppt|mp4',
                            'max_size'      => '50000'
                    );
					
					
                    
					$this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se ha subido en la Platafoma de forma correcta el Material');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al subir el Material.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'matdif/add_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
    
    function descarga_doc($file)
    {
        $this->load->helper('download');
        force_download('./docs/'.$file, NULL);
    }
    
   

    
    function busca()
    {        
        $empresa = $this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
        $rfc     = strtoupper($this->input->post('rfc'));
        $data['clientes'] = $this->cliente->busca($empresa, $nombre, $rfc);
        send_json_ok($this->load->view('matdif/busca',$data,TRUE));
    }
    
    public function borra($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		$documento['doc_path']=strtolower($documento['doc_path']);
		$this->cliente->inserta_borrado($documento);
        if($this->cliente->delete_doc($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


}