﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Presenta extends CI_Controller {
    
    function __construct() {
        parent::__construct();
        $this->load->model('presenta/Presenta_model','cliente');
        $this->load->model('empleado/Empleado_model','medico');
		$this->load->model('persona/Persona_model','persona');
		$this->load->model('empresa/Empresa_model','empresa');
    }
    
    
    public function id($id)
    {
		
       // $data['cliente'] = $this->cliente->get($id);
		$user = $this->session->user;
		$usuario = $this->medico->get($user['usr_id']);
		$corporacion=get_corporacion($user['emp_id']);
		
       // if($data['cliente'])
		if(1)   
        {
            
            //$data['docs'] = $this->cliente->get_docs($id,'PRESENTACIONES');		
			
			
			if ( ($user['usr_id'] == 261) || (strstr($usuario['modulos'],'C4LID4D')) || (strstr($usuario['modulos'],'COM3RC14L')) || (strstr($usuario['modulos'],'PR3S3NT4')) )
			{	
				
				$data['docs_presentaciones'] = $this->cliente->get_docs_section('PRESENTACIONES');
			
			}
			else
			{ 
				
			  $data['docs_presentaciones'] = $this->cliente->get_docs_section_corp('PRESENTACIONES',$corporacion);
				
			}	
			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Persona',
                'view' => 'presenta/cliente',
                'view_data' => $data 
               );
            render_template($params_view);  
        }
        else
        {
            show_error('El cliente no existe.');
        }
    }

     public function edita_iso($fsm_id)
     {

		$item = $this->cliente->get_a_doc($fsm_id,'PRESENTACIONES');
		$user = $this->session->user;
	
        if(isset($_POST) && count($_POST) > 0)     
        {
           // $this->load->library('form_validation');
            
            if(true)
            {
					$data_clte['clte_id'] = $user['usr_id'];//1;  //$cliente_id;
					$data_clte['doc_nombre'] =  $this->input->post('nombre');
					$data_clte['emp_id'] =  $this->input->post('emp_id');
					$data_clte['corp_nombre'] =  $this->input->post('corp_nombre');
					$data_clte['doc_f'] =  date('Y-m-d H:i:s');
					$data_clte['empresa'] =  $this->input->post('empre');
					$data_clte['doc_fecha_efectiva'] =  $this->input->post('fecha_efe');

					$data_clte=array_to_upper($data_clte);
					$res=$this->cliente->actualiza_doc($fsm_id,$data_clte);
					if (1)
					{
						send_json_ok('Se actualizo de forma correcta');
					}
					else
					{
						send_json_error('Ocurrió un error al guardar el documento.');
					}  
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['item'] = $item;
			$data['empresas'] = $this->empresa->get_all_empresas_clean();
            $data['corporativos'] = $this->empresa->get_all_corporativos_clean();
			$this->load->helper('template');
            $params_view = array(
                'title' => 'presenta',
                'view' => 'presenta/mod_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
 
 
      public function copy_iso($fsm_id)
     {

		$item = $this->cliente->get_a_doc($fsm_id,'PRESENTACIONES');
		$user = $this->session->user;
	
        if(isset($_POST) && count($_POST) > 0)     
        {
           // $this->load->library('form_validation');
            
            if(true)
            {
					$data_clte['doc_path']=$item['doc_path'];
					$data_clte['clte_id'] = $user['usr_id'];//1;  //$cliente_id;
					$data_clte['doc_nombre'] =  $this->input->post('nombre');
					$data_clte['emp_id'] =  $this->input->post('emp_id');
					$data_clte['corp_nombre'] =  $this->input->post('corp_nombre');
					$data_clte['doc_f'] =  date('Y-m-d H:i:s');
					$data_clte['empresa'] =  $this->input->post('empre');
					$data_clte['doc_fecha_efectiva'] =  $this->input->post('fecha_efe');

					$data_clte=array_to_upper($data_clte);
					$res=$this->cliente->add_doc($data_clte);
					if ($res)
					{
						send_json_ok('Se se duplico de forma correcta');
					}
					else
					{
						send_json_error('Ocurrió un error al guardar el documento.');
					}  
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['item'] = $item;
			$data['empresas'] = $this->empresa->get_all_empresas_clean();
            $data['corporativos'] = $this->empresa->get_all_corporativos_clean();
			$this->load->helper('template');
            $params_view = array(
                'title' => 'presenta',
                'view' => 'presenta/copy_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
 
 
    
    public function nuevo_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		$user = $this->session->user;
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('emp_id','Empresa','required');
			$this->form_validation->set_rules('corporativo','Corporativo','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] = $user['usr_id'];//1;  //$cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
				$data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['corp_nombre'] =  $this->input->post('corporativo');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['empresa'] =  $this->input->post('empre');
				$data_clte['doc_fecha_efectiva'] =  formatea_fecha_mysql($this->input->post('fecha_efe'));
				
                $this->load->library('upload');
				
				
				
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/isos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx|xls|xlsx|pptx|ppt|mp4',
                            'max_size'      => '50000'
                    );
					
					
                    
					$this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['empresas'] = $this->empresa->get_all_empresas_clean();
            $data['corporativos'] = $this->empresa->get_all_corporativos_clean();
			$this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'presenta/add_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
    
    function descarga_doc($file)
    {
        $this->load->helper('download');
        force_download('./docs/'.$file, NULL);
    }
    
   

    
    function busca()
    {        
        $empresa = $this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
        $rfc     = strtoupper($this->input->post('rfc'));
        $data['clientes'] = $this->cliente->busca($empresa, $nombre, $rfc);
        send_json_ok($this->load->view('presenta/busca',$data,TRUE));
    }
    
    public function borra_iso($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		$documento['doc_path']=strtolower($documento['doc_path']);
		$this->cliente->inserta_borrado($documento);
        if($this->cliente->delete_iso($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


}