<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Entorno_social extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
		$this->load->model('servicio/Servicio_model','servicio');
		/*************************************************/			
        $this->load->model('examen/Entorno_social_model','entorno_social');
		$this->load->helper('util'); 
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $medico = $this->session->user;
        $empresa = $this->cliente->get_empresa_by_clte($cliente_id);

        if(isset($_POST) && count($_POST) > 0)  
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
            /*************************************************/ 
            $this->form_validation->set_rules('motivo','Motivo de evaluación','required');
            $this->form_validation->set_rules('fecha_eval','Fecha de evaluación','required');
            
            if($this->form_validation->run())
            {
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['usr_id'] = $medico['usr_id'];
                $data_insert['emp_id'] = $empresa['emp_id'];
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/
                
                /* motivo y fecha de evaluación*/
                $data_insert['motivo'] = $this->input->post('motivo');
               // $data_insert['fecha_eval'] = formatea_fecha_mysql($this->input->post('fecha_eval'));//fecha
				$data_insert['fecha_eval'] = $this->input->post('fecha_eval');//fecha
                $data_insert['matrimonios'] = $this->input->post('matrimonios');
                $data_insert['uniones'] = $this->input->post('uniones');
                
				$data_insert['observacionesf'] = $this->input->post('observacionesf');
				
                $data_insert['tipo_vivienda'] = $this->input->post('tipo_vivienda');
                $data_insert['regimen_prop'] = $this->input->post('regimen_prop');
                $data_insert['valor_casa'] = $this->input->post('valor_aprox');
                $data_insert['t_residir_casa'] = $this->input->post('t_domicilio');
				$data_insert['t_residir_casa_meses'] = $this->input->post('t_domicilio_meses');
				$data_insert['t_anterior_domicilio'] = $this->input->post('anterior_domicilio');
				
				
                $data_insert['n_cambios_casa'] = $this->input->post('n_domicilios');
                $data_insert['n_personas_casa'] = $this->input->post('n_personas');
                
                $data_insert['dist_sala'] = $this->input->post('sala');
                $data_insert['dist_comedor'] = $this->input->post('comedor');
                $data_insert['dist_dormitorios'] = $this->input->post('dormitorios');
                $data_insert['dist_banios'] = $this->input->post('completos_b');
                $data_insert['dist_cocina'] = $this->input->post('cocina');
                $data_insert['dist_zotehuela'] = $this->input->post('zotehuela');
                $data_insert['dist_jardin'] = $this->input->post('jardin');
                $data_insert['dist_cochera'] = $this->input->post('cochera');
                $data_insert['dist_otro'] = $this->input->post('otros_dist');
                $data_insert['dist_n_otro'] = $this->input->post('otros_dist_n');
                
                $data_insert['comparte_dormitorios'] = $this->input->post('como_dormitorios');
                
                $data_insert['zona_ubica_casa'] = $this->input->post('zona_ub');
                $data_insert['tipo_construccion'] = $this->input->post('construccion');
                $data_insert['clase_colonia'] = $this->input->post('colonia_clase');
                
                $data_insert['servicios'] = implode(',', $this->input->post('servicios'));
                $data_insert['servicio_otro'] = $this->input->post('servicio_otro');
                
                $data_insert['mobiliario_otro'] = $this->input->post('mobiliario_otro');
                $data_insert['mobiliario_cant'] = $this->input->post('mobiliario_cant');
                $data_insert['mobiliario_valor'] = $this->input->post('mobiliario_valor');
                
                $data_insert['obs_orden'] = $this->input->post('orden');
                $data_insert['obs_limpieza'] = $this->input->post('limpieza');
                $data_insert['obs_mobiliario'] = $this->input->post('mobiliario_2');
                $data_insert['obs_inmueble'] = $this->input->post('inmueble');
                
                $data_insert['fsm_visita_eva'] = $this->input->post('visita_eva');
				$data_insert['fsm_fecha_hora_visita'] = $this->input->post('fecha_hora_visita');
				
				
                /* situacion economica  */
                $data_insert['ingreso_mensual'] = $this->input->post('ingreso_mensual');
                $data_insert['ingreso_extra'] = $this->input->post('ingreso_extra');
                $data_insert['ingreso_otro'] = $this->input->post('ingreso_otro');
                $data_insert['egreso_otro'] = $this->input->post('egreso_otro');
                $data_insert['dif_aport_egreso'] = $this->input->post('dif_ingr_egre');
                $data_insert['deficit'] = $this->input->post('deficit');
                $data_insert['excedente'] = $this->input->post('excedente');

                $data_insert['tiene_auto'] = $this->input->post('auto');
                $data_insert['modelo_auto'] = $this->input->post('modelo_auto');
                $data_insert['marca_auto'] = $this->input->post('marca_auto');
                $data_insert['tipo_auto'] = $this->input->post('tipo_auto');
                
                $data_insert['dictamen'] = $this->input->post('dictamen');
                $data_insert['fsm_apto'] = $this->input->post('fsm_apto');
                
				$data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');
				$data_insert['log_updt_f']= $data_insert['log_insrt_f'];
				
                $data_insert = array_to_upper($data_insert);
                
                if($this->input->post('firma_med') != '')
                {
                    $data_insert['fsm_firma_med'] = $this->input->post('firma_med');
                }
                if($this->input->post('firma_pac') != '')
                {
                    $data_insert['fsm_firma_pac'] = $this->input->post('firma_pac');
                }
                
                $this->db->trans_start();
                $fsm_id = $this->entorno_social->add($data_insert);
                if ($fsm_id)//($this->entorno_social->add($data_insert))
                {
                    $this->entorno_social->insert_arreglo($this->input->post('escuela'), 'nivel', $fsm_id, 'entorno_soc_academico');   
                    $this->entorno_social->insert_arreglo($this->input->post('familia'), 'parentesco', $fsm_id, 'entorno_soc_familiar');
                    $this->entorno_social->insert_arreglo($this->input->post('referencia_p'), 'nombre', $fsm_id, 'entorno_soc_ref_personal');
                    $this->entorno_social->insert_empleos($this->input->post('empleo'), $fsm_id);
                    $this->entorno_social->insert_arreglo($this->input->post('mobiliario'), 'tipo_cve', $fsm_id, 'entorno_soc_mobiliario');
                    $this->entorno_social->insert_arreglo($this->input->post('ingreso'), 'tipo_cve', $fsm_id, 'entorno_soc_ingreso');
                    $this->entorno_social->insert_arreglo($this->input->post('egreso'), 'tipo_cve', $fsm_id, 'entorno_soc_egreso');
                    send_json_ok('Se insertó de forma correcta TODOS LOS DATOS');
					/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
					$servicios=$persona['domserv'];					
					
					$servicio='ENTSOC;'; /*CODIGO DEL EXAMEN*/
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
					/**************************************************/					
					
					
                }
                else
                {
                    send_json_error('Ocurrió un error al insertar.');
                }
                $this->db->trans_complete();
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $data['empresa'] = $empresa;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/entorno_social/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function edita($cliente_id, $fsm_id)
    {
        $this->load->model('empleado/Empleado_model','empleado');
        $persona = $this->cliente->get($cliente_id);        
        $data['fsm'] = $this->entorno_social->get($fsm_id);
        $medico = $this->empleado->get_id($data['fsm']['usr_id']);
        $empresa = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);

        if(isset($_POST) && count($_POST) > 0)  
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('motivo','Motivo de evaluación','required');
            $this->form_validation->set_rules('fecha_eval','Fecha de evaluación','required');
            
            if($this->form_validation->run())
            {

                /* motivo y fecha de evaluación*/
                $data_update['motivo'] = $this->input->post('motivo');
                //$data_update['fecha_eval'] = formatea_fecha_mysql($this->input->post('fecha_eval'));//fecha
				$data_update['fecha_eval'] = $this->input->post('fecha_eval');//fecha

                $data_update['matrimonios'] = $this->input->post('matrimonios');
                $data_update['uniones'] = $this->input->post('uniones');
                $data_update['observacionesf'] = $this->input->post('observacionesf');
                $data_update['tipo_vivienda'] = $this->input->post('tipo_vivienda');
                $data_update['regimen_prop'] = $this->input->post('regimen_prop');
                $data_update['valor_casa'] = $this->input->post('valor_aprox');
                $data_update['t_residir_casa'] = $this->input->post('t_domicilio');
				$data_update['t_residir_casa_meses'] = $this->input->post('t_domicilio_meses');
                $data_update['n_cambios_casa'] = $this->input->post('n_domicilios');
                $data_update['n_personas_casa'] = $this->input->post('n_personas');
                $data_update['t_anterior_domicilio'] = $this->input->post('anterior_domicilio');
                $data_update['dist_sala'] = $this->input->post('sala');
                $data_update['dist_comedor'] = $this->input->post('comedor');
                $data_update['dist_dormitorios'] = $this->input->post('dormitorios');
                $data_update['dist_banios'] = $this->input->post('completos_b');
                $data_update['dist_cocina'] = $this->input->post('cocina');
                $data_update['dist_zotehuela'] = $this->input->post('zotehuela');
                $data_update['dist_jardin'] = $this->input->post('jardin');
                $data_update['dist_cochera'] = $this->input->post('cochera');
                $data_update['dist_otro'] = $this->input->post('otros_dist');
                $data_update['dist_n_otro'] = $this->input->post('otros_dist_n');
                
                $data_update['comparte_dormitorios'] = $this->input->post('como_dormitorios');
                
                $data_update['zona_ubica_casa'] = $this->input->post('zona_ub');
                $data_update['tipo_construccion'] = $this->input->post('construccion');
                $data_update['clase_colonia'] = $this->input->post('colonia_clase');
                
                $data_update['servicios'] = implode(',', $this->input->post('servicios'));
                $data_update['servicio_otro'] = $this->input->post('servicio_otro');
                
                $data_update['mobiliario_otro'] = $this->input->post('mobiliario_otro');
                $data_update['mobiliario_cant'] = $this->input->post('mobiliario_cant');
                $data_update['mobiliario_valor'] = $this->input->post('mobiliario_valor');
                
                $data_update['obs_orden'] = $this->input->post('orden');
                $data_update['obs_limpieza'] = $this->input->post('limpieza');
                $data_update['obs_mobiliario'] = $this->input->post('mobiliario_2');
                $data_update['obs_inmueble'] = $this->input->post('inmueble');
                
                /* situacion economica*/
                $data_update['ingreso_mensual'] = $this->input->post('ingreso_mensual');
                $data_update['ingreso_extra'] = $this->input->post('ingreso_extra');
                $data_update['ingreso_otro'] = $this->input->post('ingreso_otro');
                $data_update['egreso_otro'] = $this->input->post('egreso_otro');
                $data_update['dif_aport_egreso'] = $this->input->post('dif_ingr_egre');
                $data_update['deficit'] = $this->input->post('deficit');
                $data_update['excedente'] = $this->input->post('excedente');

                $data_update['tiene_auto'] = $this->input->post('auto');
                $data_update['modelo_auto'] = $this->input->post('modelo_auto');
                $data_update['marca_auto'] = $this->input->post('marca_auto');
                $data_update['tipo_auto'] = $this->input->post('tipo_auto');
                
                $data_update['dictamen'] = $this->input->post('dictamen');
                $data_update['fsm_apto'] = $this->input->post('fsm_apto');
                $data_update['entorno_envia'] = $this->input->post('entorno_envia');
				
				$data_update['log_updt_f']  =  date('Y-m-d H:i:s');
				$data_update['no_encuenstador']  =  $this->input->post('cerrar_encuesta');
				
                $data_update = array_to_upper($data_update);
                
                if($this->input->post('firma_med') != '')
                {
                    $data_update['fsm_firma_med'] = $this->input->post('firma_med');
                }
                if($this->input->post('firma_pac') != '')
                {
                    $data_update['fsm_firma_pac'] = $this->input->post('firma_pac');
                }
                $this->db->trans_start();
                //$fsm_id = $this->entorno_social->update($fsm_id, $data_update);
                if($this->entorno_social->update($fsm_id, $data_update))
                {
                    /*
                    $this->entorno_social->update_arreglo($this->input->post('escuela'), 'nivel','acad_id', $fsm_id, 'entorno_soc_academico');   
                    $this->entorno_social->update_arreglo($this->input->post('familia'), 'parentesco','fam_id', $fsm_id, 'entorno_soc_familiar');
                    $this->entorno_social->update_arreglo($this->input->post('referencia_p'), 'nombre','ref_pers_id', $fsm_id, 'entorno_soc_ref_personal');
                    $this->entorno_social->update_empleos($this->input->post('empleo'), $fsm_id,'empleo_id');
                    $this->entorno_social->update_arreglo($this->input->post('mobiliario'), 'tipo_cve','mobiliario_id', $fsm_id, 'entorno_soc_mobiliario');
                    $this->entorno_social->update_arreglo($this->input->post('ingreso'), 'tipo_cve','ingreso_id', $fsm_id, 'entorno_soc_ingreso');
                    $this->entorno_social->update_arreglo($this->input->post('egreso'), 'tipo_cve','egreso_id', $fsm_id, 'entorno_soc_egreso');*/
                    $this->entorno_social->insert_arreglo($this->input->post('escuela'), 'nivel', $fsm_id, 'entorno_soc_academico');   
                    $this->entorno_social->insert_arreglo($this->input->post('familia'), 'parentesco', $fsm_id, 'entorno_soc_familiar');
                    $this->entorno_social->insert_arreglo($this->input->post('referencia_p'), 'nombre', $fsm_id, 'entorno_soc_ref_personal');
					
					$this->entorno_social->update_empleos($this->input->post('empleo'), $fsm_id, 'empleo_id');
					
					$this->entorno_social->update_arreglo($this->input->post('mobiliario'), 'tipo_cve','mobiliario_id', $fsm_id, 'entorno_soc_mobiliario');
                    $this->entorno_social->update_arreglo($this->input->post('ingreso'), 'tipo_cve','ingreso_id', $fsm_id, 'entorno_soc_ingreso');
                    $this->entorno_social->update_arreglo($this->input->post('egreso'), 'tipo_cve','egreso_id', $fsm_id, 'entorno_soc_egreso');                    
                    send_json_ok('Se actualizó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar.');
                }
                $this->db->trans_complete();
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['fsm']['escuelas'] = $this->entorno_social->get_escuelas($fsm_id);
            $data['fsm']['familiares'] = $this->entorno_social->get_familiares($fsm_id);
			
            $data['fsm']['empleos'] = $this->entorno_social->get_empleos($fsm_id);
			
            $data['fsm']['referencias'] = $this->entorno_social->get_ref_personales($fsm_id);
            $data['fsm']['ingresos'] = $this->entorno_social->get_ingresos($fsm_id);
            $data['fsm']['egresos'] = $this->entorno_social->get_egresos($fsm_id);
            $data['fsm']['mobiliarios'] = $this->entorno_social->get_mobiliarios($fsm_id);
            $data['fsm']['imagenes'] = $this->entorno_social->get_imagenes($fsm_id);
            
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $data['empresa'] = $empresa;

            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/entorno_social/edita_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    } 
    
    public function pdf($cliente_id, $fsm_id)
    {
        $this->load->model('empleado/Empleado_model','empleado');
        $this->load->helper('util');
        $persona = $this->cliente->get($cliente_id,get_desp_id_usr());        
        $data['fsm'] = $this->entorno_social->get($fsm_id,get_desp_id_usr());
        $medico = $this->empleado->get_id($data['fsm']['usr_id']);
        $empresa = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        
        $data['fsm']['escuelas'] = $this->entorno_social->get_escuelas($fsm_id);
        $data['fsm']['familiares'] = $this->entorno_social->get_familiares($fsm_id);
        $data['fsm']['empleos'] = $this->entorno_social->get_empleos($fsm_id);
        $data['fsm']['referencias'] = $this->entorno_social->get_ref_personales($fsm_id);
        $data['fsm']['ingresos'] = $this->entorno_social->get_ingresos($fsm_id);
        $data['fsm']['egresos'] = $this->entorno_social->get_egresos($fsm_id);
        $data['fsm']['mobiliarios'] = $this->entorno_social->get_mobiliarios($fsm_id);
        $data['fsm']['imagenes'] = $this->entorno_social->get_imagenes($fsm_id);
        
        $data['persona'] = $persona;
        $data['medico'] = $medico;
        $data['empresa'] = $empresa;
        
        $this->load->helper('pdf');
        genera_pdf($this->load->view('examen/entorno_social/pdf',$data,TRUE),'entorno_social','entorno_social','entorno_social');
    }
    
    public function sube_imagen($fsm_id)
    {
        if(!empty($_FILES['socio-img']['name']))
        {
            $this->load->library('upload');
            $filename = $fsm_id.'_'.md5(time());
            $config = array(
					'upload_path'   => './../../files/soc/',
                    //'upload_path'   => './soc/',
                    'overwrite'     => TRUE,
                    'file_name'     => $filename,
                    'allowed_types' => 'png|jpg|jpeg',
                    'max_size'      => '5000'
            );

            $this->upload->initialize($config);
            if ( ! $this->upload->do_upload('socio-img'))
            {
                send_json_error($this->upload->display_errors());
            }
            else 
            {
                $data = $this->upload->data();
                $img_data['fsm_id'] = $fsm_id;
                $img_data['path'] = $data['file_name'];
                $img_data['nombre'] = $_POST['imagen_nombre'];
                $this->entorno_social->insert_imagen($img_data);
                send_json_ok('Se subío de forma correcta la foto');
            }
        }
        else 
        {
            send_json_error('No envió ninguna imagen.');
        }
    }
    
    public function borra_imagen($fsm_id, $img_id)
    {
        if($this->entorno_social->delete_imagen($fsm_id,$img_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
    
    
    public function borra_escuela($fsm_id, $id)
    {
        if($this->entorno_social->delete_escuela($fsm_id,$id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
    
    public function borra_familiar($fsm_id, $id)
    {
        if($this->entorno_social->delete_familiar($fsm_id,$id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
    
    public function borra_referencia($fsm_id, $id)
    {
        if($this->entorno_social->delete_referencia($fsm_id,$id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
	
    public function borra_empleo($fsm_id, $id)
    {
        if($this->entorno_social->delete_empleo($fsm_id,$id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }	
}