<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Biometria_hematica extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		$this->load->model('servicio/Servicio_model','servicio');
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Biometria_hematica_model','biometria_hematica'); 
		$this->load->helper('laboratoru');
		$this->load->helper('util');
		$this->load->helper('report');
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
		$metodo=0;
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
 			//NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}

            
            if($this->form_validation->run())
            {
				//NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}

				$data_insert['usr_id']  = $user['usr_id']; 
				$data_insert['med_id']  = $this->input->post('laboratorista'); 
				
				$data_insert['clte_id'] = $persona['clte_id'];
				$data_insert['emp_id']  = $persona['emp_id'];				 
				
				$data_insert['bio_medico_sol'] = $this->input->post('medico_sol');
                $data_insert['bio_f_recibido']   =  formatea_fecha_mysql($this->input->post('f_recibido'));
                $data_insert['bio_f_impresion']  =  formatea_fecha_mysql($this->input->post('f_impresion'));
                $data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');
				
				$data_insert['bio_metodo'] = $this->input->post('laboratorio_metodo');
				$metodo=$this->input->post('laboratorio_metodo');
			
				$data_insert['bio_r_heritrocito']     =  $this->input->post('r_heritrocito');
                $data_insert['bio_r_heritrocito_a']     =  $this->input->post('r_heritrocito_a');
                
				$data_insert['bio_r_hemoglobina']   =  $this->input->post('r_hemoglobina');
                $data_insert['bio_r_hemoglobina_a']   =  $this->input->post('r_hemoglobina_a');
                $data_insert['bio_r_hematocrito']  =  $this->input->post('r_hematocrito');
                $data_insert['bio_r_hematocrito_a']  =  $this->input->post('r_hematocrito_a');
               
				$data_insert['bio_r_volgm']  =  $this->input->post('r_volgm');
               $data_insert['bio_r_volgm_a']  =  $this->input->post('r_volgm_a');
                 
				$data_insert['bio_r_concmhb']  =  $this->input->post('r_concmhb');
                $data_insert['bio_r_concmhb_a']  =  $this->input->post('r_concmhb_a');
                $data_insert['bio_r_concmhbc']  =  $this->input->post('r_concmhbc');
                $data_insert['bio_r_concmhbc_a']  =  $this->input->post('r_concmhbc_a');
               
				$data_insert['bio_r_rdw']  =  $this->input->post('r_rdw');
                $data_insert['bio_r_rdw_a']  =  $this->input->post('r_rdw_a');
                
				$data_insert['bio_r_plaquetas']  =  $this->input->post('r_plaquetas');
                $data_insert['bio_r_plaquetas_a']  =  $this->input->post('r_plaquetas_a');
                
				$data_insert['bio_r_vpm']  =  $this->input->post('r_vpm');
                $data_insert['bio_r_vpm_a']  =  $this->input->post('r_vpm_a');
                 
				$data_insert['bio_b_leucocitos']  =  $this->input->post('b_leucocitos');
                $data_insert['bio_b_leucocitos_a']  =  $this->input->post('b_leucocitos_a');
                $data_insert['bio_b_neutrofilos']  =  $this->input->post('b_neutrofilos');
                $data_insert['bio_b_neutrofilos_a']  =  $this->input->post('b_neutrofilos_a');
				
				if ($data_insert['bio_metodo'] ==1)
				{
					$data_insert['bio_b_linfocitos']  =  $this->input->post('b_linfocitos1');
					$data_insert['bio_b_neutrofiloss']  =  $this->input->post('b_neutrofiloss1');
				}
				elseif ($data_insert['bio_metodo'] ==4)
				{
					$data_insert['bio_b_linfocitos']  =  $this->input->post('b_linfocitos'); 
					$data_insert['bio_b_neutrofiloss']  =  $this->input->post('b_neutrofiloss');
				}
				elseif ($data_insert['bio_metodo'] ==11)
				{
					$data_insert['bio_b_linfocitos']  =  $this->input->post('b_linfocitos3'); 
					$data_insert['bio_b_neutrofiloss']  =  $this->input->post('b_neutrofiloss3');
				}				
				
				$data_insert['bio_frotis'] = $this->input->post('bio_frotis');
				$data_insert['bio_b_monocitos']  =  $this->input->post('b_monocitos');
				$data_insert['bio_b_mielocitos']  =  $this->input->post('b_mielocitos');
				$data_insert['bio_b_metamielocitos']  =  $this->input->post('b_metamielocitos');
                $data_insert['bio_b_promielocitos']  =  $this->input->post('b_promielocitos');
			    $data_insert['bio_b_blastos']  =  $this->input->post('b_blastos');
			   
				
                $data_insert['bio_b_neutrofiloss_a']  =  $this->input->post('b_neutrofiloss_a');
                $data_insert['bio_b_neutrofilosb']  =  $this->input->post('b_neutrofilosb');
                $data_insert['bio_b_neutrofilosb_a']  =  $this->input->post('b_neutrofilosb_a');
               
                $data_insert['bio_b_metamielocitos_a']  =  $this->input->post('b_metamielocitos_a');    
					
				
                $data_insert['bio_b_mielocitos_a']  =  $this->input->post('b_mielocitos_a');

				

				
                $data_insert['bio_b_blastos_a']  =  $this->input->post('b_blastos_a');
                $data_insert['bio_b_eosinofilos']  =  $this->input->post('b_eosinofilos');
                $data_insert['bio_b_eosinofilos_a']  =  $this->input->post('b_eosinofilos_a');
                $data_insert['bio_b_basofilos']  =  $this->input->post('b_basofilos');
                $data_insert['bio_b_basofilos_a']  =  $this->input->post('b_basofilos_a');
               
                $data_insert['bio_b_monocitos_a']  =  $this->input->post('b_monocitos_a');
                
                $data_insert['bio_b_linfocitos_a']  =  $this->input->post('b_linfocitos_a');
   				
				$data_insert['bio_lab'] = $this->input->post('laboratorista');
	  			
				$data_insert['bio_sidementacion_g'] = $this->input->post('sidementacion_g');
				
				$data_insert['bio_obs'] = $this->input->post('biometria_h_obs');
				
				$data_insert=array_to_upper($data_insert);
		
		
				if ($metodo > 0)
                {
		
					if ($this->biometria_hematica->insert($data_insert))
					{
						send_json_ok('Se guardó de forma correcta');
						$servicios=$persona['domserv'];					
						$servicio='BIOHEM;'; 
						if (!(strstr($servicios,$servicio)))
						{							
							$servicios.=$servicio;
							$data_clte['domserv']=$servicios;
							$data_clte['clte_status_proc'] = 'EN PROCESO';
							$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
						}
					
					}
					else
					{
						send_json_error('Ocurrió un error al guardar.');
					}
				}
				else
				{
					send_json_error('No has elegido el Método.'); 
					
				}				
				
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $user;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/biometria_hematica/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->biometria_hematica->get($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');
		$med_name=$data['fsm']['bio_lab'];
		$emp_id=$data['fsm']['emp_id'];
		//$observaciones=$data['fsm']['bio_obs'];
		$fuera_rango=$data['fsm']['bio_fuera_rango'];
		
		$data_empresa = $this->cliente->get_empresa_by_id($emp_id);

	/*	if ($data_empresa['emp_giro'] == 'SEGURIDAD')
		{
			$med_name=$data['fsm']['bio_lab']; //'Q.F.B. JAIMES FLORES MONTSERRAT    11322160                                                                                                                        ';
			//genera_pdf_lab($this->load->view('examen/biometria_hematica/pdf',$data,TRUE),'biometria_hematica','biometria_hematica',$med_name);	
			genera_pdf_tohuanti($this->load->view('examen/biometria_hematica/pdf',$data,TRUE),'biometria_hematica','biometria_hematica','biometria_hematica');
		}
		else
		
		if ($data_empresa['emp_giro'] == 'SEGURIDAD')
		{
			if ($data['fsm']['med_id'] ==113)
			{
				$med_name= 'Q.F.B. JAIMES FLORES MONTSERRAT 11322160                                                                                                                                             ';
			}
			else
			{	
				$med_name= 'Q.F.B. MUÑOZ GARCÍA LETICIA 1392938                                                                                                                                                         SSP 009-22';
			}
			
			genera_pdf_lab($this->load->view('examen/biometria_hematica/pdf',$data,TRUE),'biometria_hematica','biometria_hematica',$med_name);

		}
		else	*/	
		{	
			if (($data['fsm']['med_id'] ==113) || ($data['fsm']['med_id'] == 0))
			{
				$med_name= 'Q.F.B. JAIMES FLORES MONTSERRAT            Cédula Profesional: 11322160'; 
			}
			else
			{	
				$med_name=agrega_cedula_ext($data['fsm']['med_id']);
			}			
			//genera_pdf_lab_new($this->load->view('examen/biometria_hematica/pdf',$data,TRUE),'biometria_hematica','biometria_hematica',$med_name,$observaciones,$fuera_rango);		
			genera_pdf_lab_new_x($this->load->view('examen/biometria_hematica/pdf',$data,TRUE),'biometria_hematica','biometria_hematica',$med_name,$observaciones,$fuera_rango);
		}		
    }
	
    public function borra_biometria_hematica($fsm_id)
    {
        if($this->biometria_hematica->delete_biometria_hematica($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }	

}