<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Exudado extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		$this->load->model('servicio/Servicio_model','servicio');
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Exudado_model','exudado');
		$this->load->helper('util');
		$this->load->helper('report');
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;
		$llave_de_paso=0;
		

        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
            
			$this->form_validation->set_rules('resultado','Resultado','required'); 
           
            if($this->form_validation->run())
            {
                $data_insert['usr_id']  = $user['usr_id'];
                $data_insert['med_id']  = $this->input->post('laboratorista');
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['emp_id']  = $persona['emp_id'];

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}

                $data_insert['exudado_medico_sol'] = $this->input->post('medico_sol');
                $data_insert['exudado_f_recibido']   =  formatea_fecha_mysql($this->input->post('f_recibido'));
                $data_insert['exudado_f_impresion']  =  formatea_fecha_mysql($this->input->post('f_impresion'));
				
				$resultado=$this->input->post('resultado');
				$data_insert['exudado_rr_resultado']=$this->input->post('resultado');
	

				$medico = $this->medico->get_id($data_insert['med_id']);
				
				$data_insert['exudado_lab'] = agrega_cedula_ext($medico['usr_id']);
				
                $data_insert['log_insrt_f']= date('Y-m-d H:i:s'); 
	
				if ($resultado == 0)
				{	
					$llave_de_paso=1;
				}
				elseif ($resultado == 1)
				{	
					if ( $this->input->post('fis_resultado') == '' )
					{
						$llave_de_paso=1;
					}
					else
					{	
						$data_insert['exudado_fis_resultado']= $this->input->post('fis_resultado');
					}
				}
				elseif ($resultado == 2)
				{
					$data_insert['exudado_com01']= $this->input->post('com01');
					$data_insert['exudado_com02']= $this->input->post('com02');
					$data_insert['exudado_com03']= $this->input->post('com03');
					$data_insert['exudado_com04']= $this->input->post('com04');
					$data_insert['exudado_com05']= $this->input->post('com05');
					$data_insert['exudado_com06']= $this->input->post('com06');
					$data_insert['exudado_com07']= $this->input->post('com07');
					$data_insert['exudado_com08']= $this->input->post('com08');
					$data_insert['exudado_com09']= $this->input->post('com09');
					$data_insert['exudado_com10']= $this->input->post('com10');
					$data_insert['exudado_com11']= $this->input->post('com11');
					$data_insert['exudado_com12']= $this->input->post('com12');					
					$data_insert['exudado_com21']= $this->input->post('com21');
					$data_insert['exudado_com22']= $this->input->post('com22');
					$data_insert['exudado_com23']= $this->input->post('com23');
					$data_insert['exudado_com24']= $this->input->post('com24');
					$data_insert['exudado_com25']= $this->input->post('com25');
					$data_insert['exudado_com26']= $this->input->post('com26');
					$data_insert['exudado_com27']= $this->input->post('com27');
					$data_insert['exudado_com28']= $this->input->post('com29');
					$data_insert['exudado_com29']= $this->input->post('com29');					
					
					$data_insert['exudado_fis_resultado']= $this->input->post('fis_resultado_positivo');
					$data_insert['exudado_fis_tipo_pruebas']= $this->input->post('fis_tipo_pruebas');
					
					if (
							($data_insert['exudado_fis_resultado'] == '')  /* &&
							($this->input->post('fis_tipo_pruebas') == '' ) */ &&
							(
								(( $this->input->post('com01')) == '') ||
								(( $this->input->post('com02')) == '') ||
								(( $this->input->post('com03')) == '') ||
								(( $this->input->post('com04')) == '') ||
								(( $this->input->post('com05')) == '') ||
								(( $this->input->post('com06')) == '') ||
								(( $this->input->post('com07')) == '') ||
								(( $this->input->post('com08')) == '') ||
								(( $this->input->post('com09')) == '') ||
								(( $this->input->post('com10')) == '') ||
								(( $this->input->post('com11')) == '') ||
								(( $this->input->post('com12')) == '') ||								
								(( $this->input->post('com21')) == '') ||
								(( $this->input->post('com22')) == '') ||
								(( $this->input->post('com23')) == '') ||
								(( $this->input->post('com24')) == '') ||
								(( $this->input->post('com25')) == '') ||
								(( $this->input->post('com26')) == '') ||
								(( $this->input->post('com27')) == '') ||
								(( $this->input->post('com29')) == '') ||
								(( $this->input->post('com29')) == '')									
							)
						)
						{
							$llave_de_paso=1;							
						}
						$data_insert=array_to_upper($data_insert);						
				}	
				
				$data_insert['exudado_fuera_rango'] = $this->input->post('fuera_rango');
                $data_insert['exudado_obs']= $this->input->post('exudado_obs');  
				
                if ( ($this->exudado->insert($data_insert)) && ($llave_de_paso==0) )
                {
                    send_json_ok('Se guardó de forma correcta');
					/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
					$servicios=$persona['domserv'];					
					
					$servicio='HBA1C;'; /*CODIGO DEL EXAMEN*/
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
					/**************************************************/						
                }
                else
                {
                    send_json_error('Ocurrió un error al realizar el registro; por favor validar que se escribieron todos lso campós requeridos pro la respuesta.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Exudado',
                'view' => 'examen/exudado/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
 

    public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id);
        $data['fsm'] = $this->exudado->get($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
       
	   $this->load->helper('pdf');
		
		$med_name=$data['fsm']['exudado_lab'];
		$emp_id=$data['fsm']['emp_id'];
		$observaciones=$data['fsm']['exudado_obs'];		
		$fuera_rango=$data['fsm']['exudado_fuera_rango'];
        $data_empresa = $this->cliente->get_empresa_by_id($emp_id);	
		$med_name=agrega_cedula_ext($data['fsm']['med_id']);
		genera_pdf_lab_new_x($this->load->view('examen/exudado/pdf',$data,TRUE),'exudado faringeo','exudado faringeo',$med_name,$observaciones,$fuera_rango);	
 
	}

 
  /*  public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->exudado->get($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');

		$med_name=$data['fsm']['exudado_lab'];
		$emp_id=$data['fsm']['emp_id'];
		$observaciones=$data['fsm']['exudado_obs'];
		$data_empresa = $this->cliente->get_empresa_by_id($emp_id);
		{	$med_name=agrega_cedula($med_name,'Cédula Profesional:');
			genera_pdf_lab_new($this->load->view('examen/exudado/pdf',$data,TRUE),'exudado','exudado',$med_name,$observaciones);		
		}
    }*/

    public function borra_exudado($fsm_id)
    {
        if($this->exudado->delete_exudado($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


}