<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Generico extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		$this->load->model('servicio/Servicio_model','servicio');
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Generico_model','generico');
		$this->load->helper('util');
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;		
		$medico = $this->medico->get_id(113);

        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
            
			$this->form_validation->set_rules('fis_resultado','GONADOTROPINA CORIÓNICA HUMANA','required'); 
           
            if($this->form_validation->run())
            {
                $data_insert['usr_id']  = $medico['usr_id'];
                $data_insert['med_id']  = $medico['usr_id'];
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['emp_id']  = $persona['emp_id'];

				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}

                $data_insert['generico_medico_sol'] = $this->input->post('medico_sol');
                $data_insert['generico_f_recibido']   =  formatea_fecha_mysql($this->input->post('f_recibido'));
                $data_insert['generico_f_impresion']  =  formatea_fecha_mysql($this->input->post('f_impresion'));
				$data_insert['generico_fis_resultado']= $this->input->post('fis_resultado');
				$data_insert['generico_lab'] = $this->input->post('laboratorista');
				$data_insert['generico_obs']= $this->input->post('generico_obs'); 
                $data_insert['log_insrt_f']= date('Y-m-d H:i:s'); 
				
				
				
				$data_insert=array_to_upper($data_insert);	
				
                 
				
                if($this->generico->insert($data_insert))
                {
                    send_json_ok('Se guardó de forma correcta');
					/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
					$servicios=$persona['domserv'];					
					
					$servicio='GENERICO;'; /*CODIGO DEL EXAMEN*/
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
					/**************************************************/						
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Generico',
                'view' => 'examen/generico/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function pdf($cliente_id, $fsm_id)
    {
        $data['persona'] = $this->cliente->get($cliente_id,get_desp_id_usr());
        $data['fsm'] = $this->generico->get($fsm_id,get_desp_id_usr());
        $data['medico'] = $this->medico->get_id($data['fsm']['med_id']);
        $data['empresa'] = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        $this->load->helper('pdf');

		$med_name=$data['fsm']['generico_lab'];
		$emp_id=$data['fsm']['emp_id'];
		$observaciones=$data['fsm']['generico_obs'];
		$data_empresa = $this->cliente->get_empresa_by_id($emp_id);
		if ($data_empresa['emp_giro'] == 'SEGURIDAD')
		{
			genera_pdf_lab($this->load->view('examen/generico/pdf',$data,TRUE),'generico','generico',$med_name);
		}
		else
		{	
			genera_pdf_lab_new($this->load->view('examen/generico/pdf',$data,TRUE),'generico','generico',$med_name,$observaciones);		
		}
    }

    public function borra_generico($fsm_id)
    {
        if($this->generico->delete_generico($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


}