<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Socioeconomico extends CI_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('persona/Persona_model','cliente');
		/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
		$this->load->model('servicio/Servicio_model','servicio');
		/*************************************************/		
        $this->load->model('empleado/Empleado_model','medico');
        $this->load->model('examen/Socioeconomico_model','socio_eco');
		$this->load->helper('util'); 
    }
    
    public function nuevo($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        $medico = $this->session->user;
        $empresa = $this->cliente->get_empresa_by_clte($cliente_id);

        if(isset($_POST) && count($_POST) > 0)  
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{					
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
			else
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','integer');
			}
            /*************************************************/ 
            $this->form_validation->set_rules('motivo','Motivo de evaluación','required');
            $this->form_validation->set_rules('fecha_eval','Fecha de evaluación','required');
			$this->form_validation->set_rules('visita_eva','Confirmar la visita al evaluado','required');
            
            if($this->form_validation->run())
            {
                
                //para los socieconomicos 
                $this->load->model('examen/socioeconomico/Auto_model','auto');
                $this->load->model('examen/socioeconomico/Credito_model','credito');
                $this->load->model('examen/socioeconomico/Egreso_model','egreso');
                $this->load->model('examen/socioeconomico/Empleo_model','empleo');
                $this->load->model('examen/socioeconomico/Escuela_model','escuela');
                $this->load->model('examen/socioeconomico/Familiar_model','familiar');
                $this->load->model('examen/socioeconomico/Ingreso_model','ingreso');
                $this->load->model('examen/socioeconomico/Mobiliario_model','mobiliario');
                $this->load->model('examen/socioeconomico/Rbancaria_model','rBancaria');
                $this->load->model('examen/socioeconomico/Rpersonal_model','rPersonal');
                $this->load->model('examen/socioeconomico/Seguro_model','seguro');
                
                $data_insert['clte_id'] = $persona['clte_id'];
                $data_insert['usr_id'] = $medico['usr_id'];
                $data_insert['emp_id'] = $empresa['emp_id'];
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_insert['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_insert['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/
                $data_insert['motivo'] = $this->input->post('motivo');
                //$data_insert['fecha_eval'] = formatea_fecha_mysql($this->input->post('fecha_eval'));//fecha
                $data_insert['fecha_eval'] = $this->input->post('fecha_eval');
				$data_insert['folio_acta_nac'] = $this->input->post('folio_acta_nac');
                $data_insert['folio_acta_mat'] = $this->input->post('folio_acta_mat');
                $data_insert['folio_ife'] = $this->input->post('folio_ife');
                $data_insert['folio_manejo'] = $this->input->post('folio_manejo');
                $data_insert['folio_nss'] = $this->input->post('folio_nss');
                $data_insert['folio_cartilla'] = $this->input->post('folio_cartilla');
                $data_insert['folio_comp_estudios'] = $this->input->post('folio_comp_estudios');
                $data_insert['folio_afore'] = $this->input->post('folio_afore');
                $data_insert['folio_documento'] = $this->input->post('folio_documento');
                $data_insert['folio_a_nombre'] = $this->input->post('folio_a_nombre');
                $data_insert['folio_fecha'] = formatea_fecha_mysql($this->input->post('folio_fecha'));
                $data_insert['matrimonios'] = $this->input->post('matrimonios');
                $data_insert['uniones'] = $this->input->post('uniones');

					
				$data_insert['cuantos_matrimonios'] = $this->input->post('cuantos_matrimonios');
				$data_insert['cuantos_uniones'] = $this->input->post('cuantos_uniones'); 
				$data_insert['anios_divorciado'] = $this->input->post('anios_divorciado');

                $data_insert['tipo_casa'] = $this->input->post('tipo_casa');
                $data_insert['valor_casa'] = $this->input->post('valor_'.$this->input->post('tipo_casa'));
                $data_insert['aportacion_casa'] = $this->input->post('aportacion');


             
                $data_insert['autos_liquidados'] = $this->input->post('autos_liquidados');
                $data_insert['autos_adeudo'] = $this->input->post('autos_adeudo');
                $data_insert['dif_ingr_egre'] = $this->input->post('dif_ingr_egre');
                $data_insert['deficit'] = $this->input->post('deficit');
                $data_insert['excedente'] = $this->input->post('excedente');
				
                $data_insert['religion'] = $this->input->post('religion');
                $data_insert['partido_pol'] = $this->input->post('partido_pol');
                $data_insert['deporte'] = $this->input->post('deporte');
                $data_insert['frecuencia'] = $this->input->post('frecuencia');
                $data_insert['club_dep'] = $this->input->post('club_dep');
                $data_insert['nombre_club'] = $this->input->post('nombre_club');
				
				
                $data_insert['act_libre'] = $this->input->post('act_libre');
                $data_insert['metas_cortas'] = $this->input->post('metas_cortas');
                $data_insert['metas_mediano'] = $this->input->post('metas_mediano');
                
				$data_insert['metas_enfermedad'] = $this->input->post('metas_enfermedad');
                $data_insert['tipo_vivienda'] = $this->input->post('tipo_vivienda');
                $data_insert['tipo_vivienda_otro'] = $this->input->post('tipo_vivienda_otro');
				
				
				$data_insert['residencia_anios'] = $this->input->post('tiempo_residencia_anios');
				$data_insert['residencia_meses'] = $this->input->post('tiempo_residencia_meses');
                $data_insert['est_vivienda'] = $this->input->post('est_vivienda');
                
                $data_insert['paredes'] = $this->input->post('paredes');
                $data_insert['paredes_otro'] = $this->input->post('paredes_otro');
                
                $data_insert['techos'] = $this->input->post('techos');
                $data_insert['techos_otro'] = $this->input->post('techos_otro');
                
                $data_insert['pisos'] = $this->input->post('pisos');
                $data_insert['pisos_otro'] = $this->input->post('pisos_otro');
                
                $data_insert['sala'] = $this->input->post('sala');
                $data_insert['dormitorios'] = $this->input->post('dormitorios');
                $data_insert['comedor'] = $this->input->post('comedor');
                $data_insert['zotehuela'] = $this->input->post('zotehuela');
                $data_insert['cocina'] = $this->input->post('cocina');
                $data_insert['jardin'] = $this->input->post('jardin');
                $data_insert['completos_b'] = $this->input->post('completos_b');
              
				$data_insert['cochera'] = $this->input->post('cochera');
                $data_insert['medios_b'] = $this->input->post('medios_b');
                $data_insert['focos'] = $this->input->post('focos');
                $data_insert['compartidos_b'] = $this->input->post('compartidos_b');
                $data_insert['otros_dist'] = $this->input->post('otros_dist');
                $data_insert['otros_dist_n'] = $this->input->post('otros_dist_n');
                $data_insert['como_dormitorios'] = $this->input->post('como_dormitorios');

                $data_insert['mobiliario_otro'] = $this->input->post('mobiliario_otro');
                $data_insert['mobiliario_cant'] = $this->input->post('mobiliario_cant');
                $data_insert['mobiliario_valor'] = $this->input->post('mobiliario_valor');
                $data_insert['avd_principales'] = $this->input->post('avd_principales');
                $data_insert['entre_calles'] = $this->input->post('entre_calles');
                $data_insert['referencias_ub'] = $this->input->post('referencias_ub');
                
                $data_insert['transporte'] = implode(',', $this->input->post('transporte'));
                $data_insert['transp_otro'] = $this->input->post('transp_otro');
                
                $data_insert['servicios'] = implode(',', $this->input->post('servicios'));
                $data_insert['servicio_otro'] = $this->input->post('servicio_otro');
                
                $data_insert['clase_v'] = $this->input->post('clase_v');
                $data_insert['clase_v_otro'] = $this->input->post('clase_v_otro');
                
                $data_insert['zona_ub'] = $this->input->post('zona_ub');
                $data_insert['nivel_v'] = $this->input->post('nivel_v');
                
                
				
				$data_insert['fsm_visita_eva'] = $this->input->post('visita_eva');
				$data_insert['fsm_fecha_hora_visita'] = $this->input->post('fecha_hora_visita');
			
                $data_insert['ingreso_otro'] = $this->input->post('ingreso_otro');
                $data_insert['egreso_otro'] = $this->input->post('egreso_otro');

				$data_insert['fsm_apto_v_documentos'] = $this->input->post('fsm_apto_v_documentos');
				$data_insert['fsm_apto_v_academicos'] = $this->input->post('fsm_apto_v_academicos');
				$data_insert['fsm_apto_v_personales'] = $this->input->post('fsm_apto_v_personales');
				$data_insert['fsm_apto_v_laboral'] = $this->input->post('fsm_apto_v_laboral');
				$data_insert['fsm_apto_v_economica'] = $this->input->post('fsm_apto_v_economica');
				$data_insert['fsm_apto_v_patrimonial'] = $this->input->post('fsm_apto_v_patrimonial');
				$data_insert['fsm_apto_v_domicilio'] = $this->input->post('fsm_apto_v_domicilio');
                $data_insert['fsm_apto'] = $this->input->post('aptitud');
				$data_insert['log_insrt_f']  =  date('Y-m-d H:i:s');
				$data_insert['log_updt_f']  =  $data_insert['log_insrt_f'];
				

				
                //$data_insert = array_to_upper($data_insert);
				
				$data_insert['dictamen'] = $this->input->post('dictamen');
                
                if($this->input->post('firma_med') != '')
                {
                    $data_insert['fsm_firma_med'] = $this->input->post('firma_med');
                }
                if($this->input->post('firma_pac') != '')
                {
                    $data_insert['fsm_firma_pac'] = $this->input->post('firma_pac');
                }
               
		   
                $this->db->trans_start();
                $fsm_id = $this->socio_eco->insert($data_insert);
                if($fsm_id)
                {
                    $this->escuela->inserta_escuelas($this->input->post('escuela'), $fsm_id);//table info_academico
                    $this->familiar->inserta_familiares($this->input->post('familia'), $fsm_id);//table familia
                    $this->empleo->actualiza_empleos($this->input->post('empleo'), $fsm_id);//table empleo
                    $this->rPersonal->inserta_ref_personales($this->input->post('referencia_p'), $fsm_id);//table ref_personal
                    $this->rBancaria->inserta_ref_bancarias($this->input->post('referencia_b'), $fsm_id);// table ref_bancaria
                    $this->auto->inserta_autos($this->input->post('autos'), $fsm_id);// table auto
                    $this->credito->inserta_creditos($this->input->post('credito'), $fsm_id);// table credito
                    $this->seguro->inserta_seguros($this->input->post('seguro'), $fsm_id);// table seguro
                    $this->ingreso->inserta_ingresos($this->input->post('ingreso'), $fsm_id);// table ingreso
                    $this->egreso->inserta_egresos($this->input->post('egreso'), $fsm_id);// table ingreso
                    $this->mobiliario->inserta_mobiliarios($this->input->post('mobiliario'), $fsm_id);//
                    
                    send_json_ok('Se actualizó de forma correcta');
					
					/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
					$servicios=$persona['domserv'];					
					
					$servicio='SOCIE;'; /*CODIGO DEL EXAMEN*/
					if (!(strstr($servicios,$servicio)))
					{							
						$servicios.=$servicio;
						$data_clte['domserv']=$servicios;
						$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte);
					}
					/**************************************************/					
					
                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar.');
                }
                $this->db->trans_complete();
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $data['empresa'] = $empresa;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/socio_economico/nuevo_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    
    public function edita($cliente_id, $fsm_id)
    {
		
        $persona = $this->cliente->get($cliente_id);
        $medico = $this->session->user;
        $data['fsm'] = $this->socio_eco->get($fsm_id);
        $empresa = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
		

        if(isset($_POST) && count($_POST) > 0)  
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('motivo','Motivo de evaluación','required');
          //  $this->form_validation->set_rules('fecha_eval','Fecha de evaluación','required');
            
            if($this->form_validation->run())
            {
                //para los socieconomicos 
                $this->load->model('examen/socioeconomico/Auto_model','auto');
                $this->load->model('examen/socioeconomico/Credito_model','credito');
                $this->load->model('examen/socioeconomico/Egreso_model','egreso');
                $this->load->model('examen/socioeconomico/Empleo_model','empleo');
                $this->load->model('examen/socioeconomico/Escuela_model','escuela');
                $this->load->model('examen/socioeconomico/Familiar_model','familiar');
                $this->load->model('examen/socioeconomico/Ingreso_model','ingreso');
                $this->load->model('examen/socioeconomico/Mobiliario_model','mobiliario');
                $this->load->model('examen/socioeconomico/Rbancaria_model','rBancaria');
                $this->load->model('examen/socioeconomico/Rpersonal_model','rPersonal');
                $this->load->model('examen/socioeconomico/Seguro_model','seguro');
                
                $data_insert['motivo'] = $this->input->post('motivo');
                //$data_insert['fecha_eval'] = formatea_fecha_mysql($this->input->post('fecha_eval'));//fecha
                $data_insert['fecha_eval'] = $this->input->post('fecha_eval');
				$data_insert['folio_acta_nac'] = $this->input->post('folio_acta_nac');
                $data_insert['folio_acta_mat'] = $this->input->post('folio_acta_mat');
                $data_insert['folio_ife'] = $this->input->post('folio_ife');
                $data_insert['folio_manejo'] = $this->input->post('folio_manejo');
                $data_insert['folio_nss'] = $this->input->post('folio_nss');
                $data_insert['folio_cartilla'] = $this->input->post('folio_cartilla');
                $data_insert['folio_comp_estudios'] = $this->input->post('folio_comp_estudios');
                $data_insert['folio_afore'] = $this->input->post('folio_afore');
                $data_insert['folio_documento'] = $this->input->post('folio_documento');
                $data_insert['folio_a_nombre'] = $this->input->post('folio_a_nombre');
                $data_insert['folio_fecha'] = formatea_fecha_mysql($this->input->post('folio_fecha'));
                $data_insert['matrimonios'] = $this->input->post('matrimonios');
                $data_insert['uniones'] = $this->input->post('uniones');
				
				
				$data_insert['cuantos_matrimonios'] = $this->input->post('cuantos_matrimonios');
				$data_insert['cuantos_uniones'] = $this->input->post('cuantas_uniones');
				$data_insert['anios_divorciado'] = $this->input->post('anios_divorciado');
                
                $data_insert['tipo_casa'] = $this->input->post('tipo_casa');
                $data_insert['valor_casa'] = $this->input->post('valor_'.$this->input->post('tipo_casa'));
                $data_insert['aportacion_casa'] = $this->input->post('aportacion');
                
                $data_insert['autos_liquidados'] = $this->input->post('autos_liquidados');
                $data_insert['autos_adeudo'] = $this->input->post('autos_adeudo');
                $data_insert['dif_ingr_egre'] = $this->input->post('dif_ingr_egre');
                $data_insert['deficit'] = $this->input->post('deficit');
                $data_insert['excedente'] = $this->input->post('excedente');
                $data_insert['religion'] = $this->input->post('religion');
                $data_insert['partido_pol'] = $this->input->post('partido_pol');
                $data_insert['deporte'] = $this->input->post('deporte');
                $data_insert['frecuencia'] = $this->input->post('frecuencia');
                $data_insert['club_dep'] = $this->input->post('club_dep');
                $data_insert['nombre_club'] = $this->input->post('nombre_club');
                $data_insert['act_libre'] = $this->input->post('act_libre');
                $data_insert['metas_cortas'] = $this->input->post('metas_cortas');
                $data_insert['metas_mediano'] = $this->input->post('metas_mediano');
                
                $data_insert['tipo_vivienda'] = $this->input->post('tipo_vivienda');
                $data_insert['tipo_vivienda_otro'] = $this->input->post('tipo_vivienda_otro');
                $data_insert['residencia_anios'] = $this->input->post('tiempo_residencia_anios');
				$data_insert['residencia_meses'] = $this->input->post('tiempo_residencia_meses');
                $data_insert['est_vivienda'] = $this->input->post('est_vivienda');
                
                $data_insert['paredes'] = $this->input->post('paredes');
                $data_insert['paredes_otro'] = $this->input->post('paredes_otro');
                
                $data_insert['techos'] = $this->input->post('techos');
                $data_insert['techos_otro'] = $this->input->post('techos_otro');
                
                $data_insert['pisos'] = $this->input->post('pisos');
                $data_insert['pisos_otro'] = $this->input->post('pisos_otro');
                
                $data_insert['sala'] = $this->input->post('sala');
                $data_insert['dormitorios'] = $this->input->post('dormitorios');
                $data_insert['comedor'] = $this->input->post('comedor');
                $data_insert['zotehuela'] = $this->input->post('zotehuela');
                $data_insert['cocina'] = $this->input->post('cocina');
                $data_insert['jardin'] = $this->input->post('jardin');
                $data_insert['completos_b'] = $this->input->post('completos_b');
                $data_insert['cochera'] = $this->input->post('cochera');
                $data_insert['medios_b'] = $this->input->post('medios_b');
                $data_insert['focos'] = $this->input->post('focos');
                $data_insert['compartidos_b'] = $this->input->post('compartidos_b');
                $data_insert['otros_dist'] = $this->input->post('otros_dist');
                $data_insert['otros_dist_n'] = $this->input->post('otros_dist_n');
                $data_insert['como_dormitorios'] = $this->input->post('como_dormitorios');
                $data_insert['mobiliario_otro'] = $this->input->post('mobiliario_otro');
                $data_insert['mobiliario_cant'] = $this->input->post('mobiliario_cant');
                $data_insert['mobiliario_valor'] = $this->input->post('mobiliario_valor');
                $data_insert['avd_principales'] = $this->input->post('avd_principales');
                $data_insert['entre_calles'] = $this->input->post('entre_calles');
                $data_insert['referencias_ub'] = $this->input->post('referencias_ub');
                $data_insert['metas_enfermedad'] = $this->input->post('metas_enfermedad');
                $data_insert['transporte'] = implode(',', $this->input->post('transporte'));// array numeros
                $data_insert['transp_otro'] = $this->input->post('transp_otro');// array numeros
                
                $data_insert['servicios'] = implode(',', $this->input->post('servicios'));// array numeros
                $data_insert['servicio_otro'] = $this->input->post('servicio_otro');// array numeros
                
                $data_insert['clase_v'] = $this->input->post('clase_v');
                $data_insert['clase_v_otro'] = $this->input->post('clase_v_otro');
                
                $data_insert['zona_ub'] = $this->input->post('zona_ub');
                $data_insert['nivel_v'] = $this->input->post('nivel_v');
                
                
                $data_insert['ingreso_otro'] = $this->input->post('ingreso_otro');
                $data_insert['egreso_otro'] = $this->input->post('egreso_otro');
				$data_insert['fsm_apto_v_documentos'] = $this->input->post('fsm_apto_v_documentos');
				$data_insert['fsm_apto_v_academicos'] = $this->input->post('fsm_apto_v_academicos');
				$data_insert['fsm_apto_v_personales'] = $this->input->post('fsm_apto_v_personales');
				$data_insert['fsm_apto_v_laboral'] = $this->input->post('fsm_apto_v_laboral');
				$data_insert['fsm_apto_v_economica'] = $this->input->post('fsm_apto_v_economica');
				$data_insert['fsm_apto_v_patrimonial'] = $this->input->post('fsm_apto_v_patrimonial');
				$data_insert['fsm_apto_v_domicilio'] = $this->input->post('fsm_apto_v_domicilio');
                $data_insert['fsm_apto'] = $this->input->post('fsm_apto');
				
				$data_insert['socio_envia'] = $this->input->post('socio_envia');
				
				$data_insert['fsm_fecha_hora_visita'] = $this->input->post('fecha_hora_visita');
				
				$data_insert['log_updt_f']  =  date('Y-m-d H:i:s');
				
				$data_insert['no_encuenstador']  =  $this->input->post('cerrar_encuesta');
                
			
				$data_clte['clte_email_crypt'] =  $this->input->post('clte_email');
				$this->cliente->actualiza_registro($cliente_id, array_to_upper($data_clte));

				
				//$data_insert = array_to_upper($data_insert);				
				$data_insert['dictamen'] = $this->input->post('dictamen');
				
                if($this->input->post('firma_med') != '')
                {
                    $data_insert['fsm_firma_med'] = $this->input->post('firma_med');
                }
                if($this->input->post('firma_pac') != '')
                {
                    $data_insert['fsm_firma_pac'] = $this->input->post('firma_pac');
                }
                
				
				
                $this->db->trans_start();
                if($this->socio_eco->update($fsm_id ,$data_insert))
                {
                    $this->escuela->inserta_escuelas($this->input->post('escuela'), $fsm_id);//table info_academico
                    $this->escuela->actualiza_escuelas($this->input->post('academia'), $fsm_id);//table info_academico

					$this->familiar->inserta_familiares($this->input->post('familia'), $fsm_id);//table familia
					$this->familiar->actualiza_familiares($this->input->post('familian'), $fsm_id);//table familia

					$this->empleo->actualiza_empleos($this->input->post('empleo'), $fsm_id);//table empleo
           			
					
					if ($this->input->post('hay_empleo_actual') == 1)
					{	
						$this->empleo->actualiza_empleos($this->input->post('empleo_actual'), $fsm_id);//table empleo
					}
					else
					{
						$this->empleo->inserta_empleo_actual($this->input->post('empleo_actual'), $fsm_id);
					}	
					
					$this->empleo->actualiza_empleos($this->input->post('empleo_anterior'), $fsm_id);//table empleo
				
				    $this->rPersonal->inserta_ref_personales($this->input->post('referencia_p'), $fsm_id);//table ref_personal
                    $this->rPersonal->actualiza_ref_personales($this->input->post('referencias_actuales'), $fsm_id);//table ref_personal
					
					
					$this->rBancaria->inserta_ref_bancarias($this->input->post('referencia_b'), $fsm_id);// table ref_bancaria
                    $this->auto->inserta_autos($this->input->post('autos'), $fsm_id);// table auto
                    $this->auto->actualiza_autos($this->input->post('carritos'), $fsm_id);
					
					$this->credito->inserta_creditos($this->input->post('credito'), $fsm_id);// table credito
					
					$this->credito->actualiza_creditos($this->input->post('abonos'), $fsm_id);
					
					
					
					$this->seguro->inserta_seguros($this->input->post('seguro'), $fsm_id);// table seguro
					$this->seguro->actualiza_seguros($this->input->post('ar_seguro'), $fsm_id);
				   
					
					
					
					$this->ingreso->inserta_ingresos($this->input->post('ingreso'), $fsm_id);// table ingreso
                    $this->egreso->inserta_egresos($this->input->post('egreso'), $fsm_id);// table ingreso
                    $this->mobiliario->inserta_mobiliarios($this->input->post('mobiliario'), $fsm_id);//
                    
                    send_json_ok('Se actualizó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar.');
                }
                $this->db->trans_complete();
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			
            //para los socieconomicos
            $this->load->model('examen/socioeconomico/Auto_model','auto');
            $this->load->model('examen/socioeconomico/Credito_model','credito');
            $this->load->model('examen/socioeconomico/Egreso_model','egreso');
            $this->load->model('examen/socioeconomico/Empleo_model','empleo');
            $this->load->model('examen/socioeconomico/Escuela_model','escuela');
            $this->load->model('examen/socioeconomico/Familiar_model','familiar');
            $this->load->model('examen/socioeconomico/Ingreso_model','ingreso');
            $this->load->model('examen/socioeconomico/Mobiliario_model','mobiliario');
            $this->load->model('examen/socioeconomico/Rbancaria_model','rBancaria');
            $this->load->model('examen/socioeconomico/Rpersonal_model','rPersonal');
            $this->load->model('examen/socioeconomico/Seguro_model','seguro');
          
            $data['fsm']['escuelas'] = $this->escuela->get_escuelas($fsm_id);
            $data['fsm']['familiares'] = $this->familiar->get_familiares($fsm_id);
            $data['fsm']['empleos'] = $this->empleo->get_empleos($fsm_id);
			$data['fsm']['empleo_actual'] = $this->empleo->get_empleos_actual($fsm_id);
			$data['fsm']['empleos_anteriores'] = $this->empleo->get_empleos_anteriores($fsm_id);
		
			
            $data['fsm']['referencias'] = $this->rPersonal->get_ref_personales($fsm_id);
            $data['fsm']['bancos'] = $this->rBancaria->get_ref_bancarias($fsm_id);
            $data['fsm']['autos'] = $this->auto->get_autos($fsm_id);
            $data['fsm']['creditos'] = $this->credito->get_creditos($fsm_id);
            $data['fsm']['seguros'] = $this->seguro->get_seguros($fsm_id);
            $data['fsm']['ingresos'] = $this->ingreso->get_ingresos($fsm_id);
            $data['fsm']['egresos'] = $this->egreso->get_egresos($fsm_id);
            $data['fsm']['mobiliarios'] = $this->mobiliario->get_mobiliarios($fsm_id);
            $data['fsm']['imagenes'] = $this->socio_eco->get_images($fsm_id);
            
            $data['persona'] = $persona;
            $data['medico'] = $medico;
            $data['empresa'] = $empresa;
			
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'examen/socio_economico/edita_form',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
    



    public function sube_imagen2($fsm_id)
    {
        if(!empty($_FILES['socio-img']['name']))
        {
            $this->load->library('upload');
            $filename = $fsm_id.'_'.md5(time());
            $config = array(
                    'upload_path'   => './../../files/soc/',	
                    'overwrite'     => TRUE,
                    'file_name'     => $filename,
                    'allowed_types' => 'png|jpg|jpeg',
                    'max_size'      => '5000'
            );

            $this->upload->initialize($config);
            if ( ! $this->upload->do_upload('socio-img'))
            {
                send_json_error($this->upload->display_errors());
            }
            else 
            {
                $data = $this->upload->data();
                $img_data['fsm_id'] = $fsm_id;
                $img_data['path'] = $data['file_name'];
                $img_data['nombre'] = $_POST['imagen_nombre'];
                $this->socio_eco->insert_image($img_data);
                send_json_ok('Se subío de forma correcta el logo');
            }
        }
        else 
        {
            send_json_error('No envió ninguna imagen.');
        }
    }	
	
    public function sube_imagen($fsm_id)
    {
        if(!empty($_FILES['socio-img']['name']))
        {
            $this->load->library('upload');
            $filename = $fsm_id.'_'.md5(time());
            $config = array(
                    'upload_path'   => './soc/',
                    'overwrite'     => TRUE,
                    'file_name'     => $filename,
                    'allowed_types' => 'png|jpg|jpeg',
                    'max_size'      => '5000'
            );

            $this->upload->initialize($config);
            if ( ! $this->upload->do_upload('socio-img'))
            {
                send_json_error($this->upload->display_errors());
            }
            else 
            {
                $data = $this->upload->data();
                $img_data['fsm_id'] = $fsm_id;
                $img_data['path'] = $data['file_name'];
                $img_data['nombre'] = $_POST['imagen_nombre'];
                $this->socio_eco->insert_image($img_data);
                send_json_ok('Se subío de forma correcta el logo');
            }
        }
        else 
        {
            send_json_error('No envió ninguna imagen.');
        }
    }
    
    public function borra_imagen($fsm_id, $img_id)
    {
        if($this->socio_eco->delete_image($fsm_id,$img_id))
        {
            send_json_ok('Se eiminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
 
    public function borra_escuela($fsm_id, $id)
    {
		$this->load->model('examen/socioeconomico/Escuela_model','escuela');
        if($this->escuela->delete($fsm_id,$id))
        {
            send_json_ok('Se eiminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

 
    public function borra_empleo($fsm_id, $id)
    {
		$this->load->model('examen/socioeconomico/Empleo_model','empleo');
        if($this->empleo->delete($fsm_id,$id))
        {
            send_json_ok('Se eiminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
    
    public function borra_familiar($fsm_id, $id)
    {
		$this->load->model('examen/socioeconomico/Familiar_model','familiar');
        if($this->familiar->delete($fsm_id,$id))
        {
            send_json_ok('Se eiminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
    
    public function borra_referencia($fsm_id, $id)
    {
		$this->load->model('examen/socioeconomico/Rpersonal_model','rPersonal');
        if($this->rPersonal->delete($fsm_id,$id))
        {
            send_json_ok('Se eiminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
    
    public function borra_banco($fsm_id, $id)
    {
		$this->load->model('examen/socioeconomico/Rbancaria_model','rBancaria');
        if($this->rBancaria->delete($fsm_id,$id))
        {
            send_json_ok('Se eiminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
    
    public function borra_auto($fsm_id, $id)
    {
		$this->load->model('examen/socioeconomico/Auto_model','auto');
        if($this->auto->delete($fsm_id,$id))
        {
            send_json_ok('Se eiminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
    
    public function borra_credito($fsm_id, $id)
    {
		$this->load->model('examen/socioeconomico/Credito_model','credito');
        if($this->credito->delete($fsm_id,$id))
        {
            send_json_ok('Se eiminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
    
    public function borra_seguro($fsm_id, $id)
    {
		$this->load->model('examen/socioeconomico/Seguro_model','seguro');
        if($this->seguro->delete($fsm_id,$id))
        {
            send_json_ok('Se eiminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }
 


    public function borra($id,$fsm_id)
    {
        if($this->socio_eco->delete($id,$fsm_id))
        {
            send_json_ok('Se eiminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }



 
    public function pdf($cliente_id, $fsm_id)
    {
        //para los socieconomicos 
        $this->load->model('examen/socioeconomico/Auto_model','auto');
        $this->load->model('examen/socioeconomico/Credito_model','credito');
        $this->load->model('examen/socioeconomico/Egreso_model','egreso');
        $this->load->model('examen/socioeconomico/Empleo_model','empleo');
        $this->load->model('examen/socioeconomico/Escuela_model','escuela');
        $this->load->model('examen/socioeconomico/Familiar_model','familiar');
        $this->load->model('examen/socioeconomico/Ingreso_model','ingreso');
        $this->load->model('examen/socioeconomico/Mobiliario_model','mobiliario');
        $this->load->model('examen/socioeconomico/Rbancaria_model','rBancaria');
        $this->load->model('examen/socioeconomico/Rpersonal_model','rPersonal');
        $this->load->model('examen/socioeconomico/Seguro_model','seguro');
        $this->load->helper('util');
		
        $persona = $this->cliente->get($cliente_id,get_desp_id_usr());
        $medico = $this->session->user;
        $data['fsm'] = $this->socio_eco->get($fsm_id,get_desp_id_usr());
        $empresa = $this->cliente->get_empresa_by_id($data['fsm']['emp_id']);
        
        $data['fsm']['escuelas'] = $this->escuela->get_escuelas($fsm_id);
        $data['fsm']['familiares'] = $this->familiar->get_familiares($fsm_id);
        $data['fsm']['empleos'] = $this->empleo->get_empleos($fsm_id);
        $data['fsm']['referencias'] = $this->rPersonal->get_ref_personales($fsm_id);
        $data['fsm']['bancos'] = $this->rBancaria->get_ref_bancarias($fsm_id);
        $data['fsm']['autos'] = $this->auto->get_autos($fsm_id);
        $data['fsm']['creditos'] = $this->credito->get_creditos($fsm_id);
        $data['fsm']['seguros'] = $this->seguro->get_seguros($fsm_id);
        $data['fsm']['ingresos'] = $this->ingreso->get_ingresos($fsm_id);
        $data['fsm']['egresos'] = $this->egreso->get_egresos($fsm_id);
        $data['fsm']['mobiliarios'] = $this->mobiliario->get_mobiliarios($fsm_id);
        $data['fsm']['imagenes'] = $this->socio_eco->get_images($fsm_id);
        $data['persona'] = $persona;
        $data['medico'] = $medico;
        $data['empresa'] = $empresa;
        $this->load->helper('pdf');
		
		$control_id=352062;
		
		if ($persona['clte_id'] > $control_id)
		{
			$evaluado= $data['persona']['clte_nombre'].' ';
			
			if ( strlen($data['persona']['clte_2_nombre']) > 0)
			{
				$evaluado= $evaluado.$data['persona']['clte_2_nombre'].' ';
			}				
			$evaluado= $evaluado.$data['persona']['clte_paterno'].' ';			
			$evaluado= $evaluado.$data['persona']['clte_materno'].' ';
			
			genera_pdf_new_reporte_poli($this->load->view('examen/socio_economico/pdf',$data,TRUE),'socioeconomico','socioeconomico',$evaluado);
		}
		else
		{
        genera_pdf($this->load->view('examen/socio_economico/pdf',$data,TRUE),'socioeconomico','socioeconomico','socioeconomico');
		}
	}
}