﻿<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Medicinas extends CI_Controller {
    
    function __construct() {
        parent::__construct();
        $this->load->model('medicinas/Medicinas_model','cliente');
		$this->load->model('servicio/Servicio_model','servicio');
		$this->load->model('empleado/Empleado_model','medico');
		$this->load->helper('util');
    }

    function busca()
    {   
		$user = $this->session->user; 
		$emp_id = $user['emp_id'];

		$id = $this->input->post('id');
        $medicamento  = strtoupper(trim($this->input->post('medicamento')));
		$presentacion  = strtoupper(trim($this->input->post('presentacion')));
		$cantidad  = strtoupper(trim($this->input->post('cantidad')));

        $data['clientes'] = $this->cliente->busca($emp_id,$id,$medicamento,$presentacion,$cantidad);
        send_json_ok($this->load->view('medicinas/busca',$data,TRUE));
    }



    public function duplicar($cliente_id)
    {          
		$cliente = $this->cliente->get($cliente_id);		
	    $user = $this->session->user;    
		
        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('medicamento','Medicamento','required');


                if($this->form_validation->run())
                {

                    $data_clte['clte_medicamento'] =  trim($this->input->post('medicamento'));
				    $data_clte['clte_presentacion'] =  trim($this->input->post('presentacion'));
					$data_clte['clte_cantidad'] =  trim($this->input->post('cantidad'));
					$data_clte['clte_f_entrada'] = date('Y-m-d H:i:s');				
					$data_clte['clte_fabricante'] =  trim($this->input->post('fabricante'));
					$data_clte['clte_usos'] =  trim($this->input->post('usos'));
					$data_clte['clte_observaciones'] =  trim($this->input->post('observaciones'));
					$data_clte['clte_autorizacion'] =  trim($this->input->post('autorizacion'));
					$data_clte['log_insrt_f'] =  date('Y-m-d H:i:s');	
					$data_clte['log_insrt_usr_cve'] =  $user['usr_id'];				
					$data_clte['log_updt_f'] =  date('Y-m-d H:i:s');
					$data_clte['log_updt_usr_cve'] =  $user['usr_id'];				
					$data_clte['clte_f_caducidad'] = $this->input->post('fcaducidad');
					$data_clte['emp_id']=$user['emp_id'];
						$data_clte['emp_id']=$user['emp_id'];
				if (trim($data_clte['clte_autorizacion']) == get_cat_nombre_unico('PASS_UNIVERSAL','PASS_UNIVERSAL',$data_clte['emp_id']) )
					{
						$pasa=1;
					}	
					else
					{
						$pasa=0;
					}					
					
					
					if ($pasa == 0)
					{
						send_json_error('La AUTORIZACIÓN no es la correcta.');
					}	
					elseif ($this->cliente->inserta(array_to_upper($data_clte)))					
					{
						send_json_ok(array('msg' =>'Se actualizado el Nombre del Archivo.', 'id' => $cliente_id));
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar el nuevo nombre.');
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {

                $data['cliente'] = 	$cliente;
						

                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Medicinas',
                    'view' => 'medicinas/copy',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el registro');
        }
    }


   public function borra($fsm_id)
    {
        if($this->cliente->borra_medicina($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    } 
 
 
   public function vista($cliente_id)
    {          
		$cliente = $this->cliente->get($cliente_id);		
	      
		
        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('medicamento','Medicamento','required');

                if($this->form_validation->run())
                {

                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {

                $data['cliente'] = 	$cliente;
						

                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Medicinas',
                    'view' => 'medicinas/vista',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el registro');
        }
    }
 
 
    public function edita($cliente_id)
    {          
		$cliente = $this->cliente->get($cliente_id);		
	    $user = $this->session->user;   
		
        if($cliente)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('medicamento','Medicamento','required');


                if($this->form_validation->run())
                {

                    $data_clte['clte_medicamento'] =  trim($this->input->post('medicamento'));
				    $data_clte['clte_presentacion'] =  trim($this->input->post('presentacion'));
					$data_clte['clte_cantidad'] =  trim($this->input->post('cantidad'));
					$data_clte['clte_f_entrada'] = date('Y-m-d H:i:s');				
					$data_clte['clte_fabricante'] =  trim($this->input->post('fabricante'));
					$data_clte['clte_usos'] =  trim($this->input->post('usos'));
					$data_clte['clte_observaciones'] =  trim($this->input->post('observaciones'));
					$data_clte['clte_autorizacion'] =  trim($this->input->post('autorizacion'));
					$data_clte['clte_f_caducidad'] = $this->input->post('fcaducidad');
					$data_clte['emp_id']=$user['emp_id'];
				if (trim($data_clte['clte_autorizacion']) == get_cat_nombre_pass('PASS_UNIVERSAL','PASS_UNIVERSAL',$data_clte['emp_id']) )
					{
						$pasa=1;
					}	
					else
					{
						$pasa=0;
					}					
					
					
					if ($pasa == 0)
					{
						send_json_error('La AUTORIZACIÓN no es la correcta.');
					}	
					elseif($this->cliente->actualiza($cliente_id, array_to_upper($data_clte)))
					{
						send_json_ok(array('msg' =>'Se actualizado el Nombre del Archivo.', 'id' => $cliente_id));
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar el nuevo nombre.');
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {

                $data['cliente'] = 	$cliente;
						

                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Medicinas',
                    'view' => 'medicinas/edit',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el registro');
        }
    }
 
 
 
 

 
 
    public function nuevo()
    {    
		$user = $this->session->user; 
		
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('medicamento','Medicamento','required');

            if($this->form_validation->run())
            {				

				$data_clte['clte_medicamento'] =  trim($this->input->post('medicamento'));
			    $data_clte['clte_presentacion'] =  trim($this->input->post('presentacion'));
				$data_clte['clte_cantidad'] =  trim($this->input->post('cantidad'));
				$data_clte['clte_f_entrada'] = date('Y-m-d H:i:s');				
				$data_clte['clte_fabricante'] =  trim($this->input->post('fabricante'));
				$data_clte['clte_usos'] =  trim($this->input->post('usos'));
				$data_clte['clte_observaciones'] =  trim($this->input->post('observaciones'));
				$data_clte['clte_autorizacion'] =  trim($this->input->post('autorizacion'));
				$data_clte['clte_f_caducidad'] = $this->input->post('fcaducidad');
				$data_clte['emp_id']=$user['emp_id'];
				
				if (trim($data_clte['clte_autorizacion']) == get_cat_nombre_pass('PASS_UNIVERSAL','PASS_UNIVERSAL',$data_clte['emp_id']) )
				{
					$pasa=1;
				}	
				else
				{
					$pasa=0;
				}	
				
				                
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos_vehiculos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
				
				$data_clte=array_to_upper($data_clte);
					
				if ($pasa == 0)
				{
					send_json_error('La AUTORIZACIÓN no es la correcta.');
				}	
				elseif($cliente_id = $this->cliente->inserta(array_to_upper($data_clte)))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta el registro del Medicamento.', 'id' => $cliente_id));
                }
                else
                {
                    send_json_error('Ocurrió un error al registrar el nuevo modicamento.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			$data['emp_id']=$user['emp_id'];
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Medicinas',
                'view' => 'medicinas/add',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
     public function lista()
    {   
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$emp_id=$user['emp_id'];
		
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('medicinas/lista/');

		$config['total_rows'] = $this->cliente->count_allo($emp_id);
		
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
 
		$data['clientes'] = $this->cliente->get_allo($rows,$emp_id);
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'medicinas/index',
            'view_data' => $data 
           );
        render_template($params_view);  
    }

    public function solrep()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'vehiculo/inicio_rep_veh',
            'view_data' => $data
            );
        render_template($params_view);
    } 

 

    public function rep_eva()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'vehiculo/inicio_view_rep_evaluados',
            'view_data' => $data
            );
        render_template($params_view);
    } 

    public function rep_emp()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'vehiculo/inicio_view_rep_empleados',
            'view_data' => $data
            );
        render_template($params_view);
    } 


    public function rep_lab()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'vehiculo/inicio_view_rep_eva_lab',
            'view_data' => $data
            );
        render_template($params_view);
    }



    function rep_medicinas()
    {
		$user = $this->session->user;
        $this->load->model('empresa/Empresa_model','empresa');
		//$this->load->model('medicinas/Medicinas_model','cliente');
		$this->load->helper('util');

		$f_ini = $this->input->post('f_ini');
        $f_fin = $this->input->post('f_fin'); 

		$emp_id=$user['emp_id'];	

/*++++++++++++++++++*/
		
		//date_default_timezone_set('America/Mexico_City');
		$date2today = date("Y-m-d H:i:s");
		?>
		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">

		<head>
			<meta content="es-mx" http-equiv="Content-Language" />
			<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
			<?php
				header("Content-type: application/octet-stream; charset=latin1");
				header("Content-Disposition: attachment; filename=Rep_medicamentos.xls");
				header("Pragma: no-cache");
				header("Expires: 0");
			?>

			<title>#</title>
			<style type="text/css">
				.auto-style1 {
					font-family: Arial, Helvetica, sans-serif;
					color: #FFFFFF;
					background-color: #3D5588;
					font-size: small;
				}
				.auto-style4 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: xx-small;
				}
				.auto-style5 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: medium;
				}
				.auto-style6 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: x-large;
					text-align: right;
					font-weight: normal;
				}
				.auto-style7 {
					font-size: small;
				}
				.auto-style8 {
					color: #3D5588;
				}
				.auto-style9 {
					color: #3AD4A7;
				}
							.auto-style11 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: small;
					text-align: right;
				}
				.auto-style12 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: small;
					text-align: center;
				}
				.auto-style13 {
					font-size: xx-small;
				}
				.auto-style14 {
					font-family: Arial, Helvetica, sans-serif;
					color: #FFFFFF;
					background-color: #3D5588;
					font-size: xx-small;
				}
				.auto-style15 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: x-small;
				}
				.auto-style16 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: x-small;
					text-align: right;
				}
				.auto-style17 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: x-small;
					text-align: left;
				}
				.auto-style18 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: xx-small;
					text-align: center;
				}
				.auto-style19 {
					color: #3D5588;
					font-size: medium;
				}
				.auto-style20 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: xx-small;
					text-align: center;
					background-color: #BFEADD;
				}
				.auto-style21 {
					font-family: Arial, Helvetica, sans-serif;
					font-size: xx-small;
					background-color: #BFEADD;
				}

			</style>
		</head>
		
		<body>
		<?php 
			//date_default_timezone_set('America/Mexico_City');
		?>
				<table> 
					<thead>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style5">&nbsp;</th>
							<th style="width: 625px" class="auto-style5">&nbsp;</th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style6">
							<strong><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
							<th style="width: 281px" class="auto-style11">&nbsp;</th>
							<th style="width: 625px" class="auto-style12">
							Reporte de Inventario de Medicamentos</th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style6">
							<span class="auto-style19">online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>

						<?php if ($emp_id == "")
						{ ?>
							<th style="width: 281px" class="auto-style16">Varias</th>
							<th style="width: 625px" class="auto-style17">&nbsp;Empresas</th>	
						<?php }
						else
						{ 
							$empresa=$this->empresa->get_empresa($emp_id);
							?>
							<th style="width: 281px" class="auto-style16">Empresa:</th>
							<th style="width: 625px" class="auto-style17">&nbsp;&nbsp;<?php echo $empresa['emp_razon_social']; ?></th>							
						<?php } ?>

							<th style="width: 95px" class="auto-style5">&nbsp;</th>
							<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<!--
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style16">Del:</th>
							<th style="width: 625px" class="auto-style17">&nbsp;&nbsp;<?php echo formatea_fecha($this->input->post('f_ini')) ; ?></th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style16">al:</th>
							<th style="width: 625px" class="auto-style17">&nbsp;&nbsp;<?php echo formatea_fecha($this->input->post('f_fin')) ; ?></th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						-->
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style16">Generado el día:</th>
							<th style="width: 625px" class="auto-style17">&nbsp;&nbsp;<?php echo date("d/m/y h:i:sa"); ?></th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
								<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
						<tr>
							<th style="width: 64px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 78px" class="auto-style5">&nbsp;</th>
							<th style="width: 393px" class="auto-style5">&nbsp;</th>
							<th style="width: 281px" class="auto-style15">&nbsp;</th>
							<th style="width: 625px" class="auto-style5">&nbsp;</th>
							<th style="width: 95px" class="auto-style5">&nbsp;</th>
							<th style="width: 303px" class="auto-style5">&nbsp;</th>
						</tr>
					<thead>
				</table> 
				
				<table>
					<thead>
                    <tr>
						<th class="auto-style14" >#</th>
						<th class="auto-style14" >Id</th>
                        <th class="auto-style14" >Medicamento</th>
						<th class="auto-style14" >Presentación</th>
						<th class="auto-style14" >Cantidad Actual</th>
						<th class="auto-style14" >Fabricante</th>
						<th class="auto-style14" >Última Fecha de Resurtido</th>
						<th class="auto-style14" >Última Fecha de Salida</th>
                    </tr>
                </thead>
				
                <tbody id="resultado">
                    <?php
							
						$data['clientes'] = $this->cliente->get_all_m($emp_id);

						$class18=" ";
						$i=1;
                        if($data['clientes']):
                            foreach ($data['clientes'] as $cliente): 
								if ($class18 != "auto-style18")
								{
									$class18="auto-style18";
									$class4="auto-style4";
								}	
								else
								{
									$class18="auto-style20";
									$class4="auto-style21";							
								}										

							?> 	
                                <tr>
									<td class=<?php echo $class18; ?>><?php echo $i; $i++;?></td>
									<td class=<?php echo $class18; ?>><?php echo $cliente['clte_id']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $cliente['clte_medicamento']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $cliente['clte_presentacion']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo $cliente['clte_cantidad']; ?></td>
                                    <td class=<?php echo $class18; ?>><?php echo $cliente['clte_fabricante']; ?></td>
									<td class=<?php echo $class18; ?>><?php echo formatea_fechahora($cliente['clte_f_entrada']); ?></td>
									<td class=<?php echo $class18; ?>><?php echo formatea_fecha($cliente['log_updt_f']); ?></td>
								</tr>
				            <?php              
                            endforeach;
							
							?>
                    <tr>
                        <td class="auto-style14"></td>
						<td class="auto-style14"></td>
                        <td class="auto-style14"></td>
						<td class="auto-style14"></td>
                        <td class="auto-style14"></td>
                        <td class="auto-style14"></td>
						<td class="auto-style14"></td>
						<td class="auto-style14"></td> 	

                    </tr>							
					<?php			
                        endif;

                    ?>
                </tbody>
				</table>
				</html><?php 	
	 }




 

 


 
    public function id($id)
    {   //VEHICULO
		$n=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();		
		//echo '---A---';
		
        $data['cliente'] = $this->cliente->get($id,$n);
		
		if($data['cliente'])
        {
            $user = $this->session->user;
            $data['medico']=$user;
			
			$data['docs'] = $this->cliente->get_docs($id);
			$data['coms'] = $this->cliente->get_coms($id);
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Persona',
                'view' => 'vehiculo/cliente',
                'view_data' => $data 
               );

            render_template($params_view);  
        }
        else
        {
            show_error('El cliente no existe.');
        }
    }
    

  

 



    public function nuevo_doc($cliente_id)
    {	//vehiculos
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
				$data_clte['serv_id'] =  $persona['serv_id'];
                
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs_vehiculos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'vehiculo/add_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function edita_g($fsm_id,$cliente_id)
    {          
		$cliente = $this->cliente->get($cliente_id);		
		$documento=$this->cliente->get_doc($fsm_id);         
		
        if($documento)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
                $this->form_validation->set_rules('nuevo_nombre','Nuevo Nombre del Archivo','required');


                if($this->form_validation->run())
                {

                    $data_clte['doc_nombre'] =  trim($this->input->post('nuevo_nombre'));
					
					if($this->cliente->actualiza_nombre_doc($fsm_id, array_to_upper($data_clte)))
					{
						send_json_ok(array('msg' =>'Se actualizado el Nombre del Archivo.', 'id' => $cliente_id));
					}
					else
					{
						send_json_error('Ocurrió un error al actualizar el nuevo nombre.');
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {

                $data['persona'] = 	$cliente;
				$data['documento'] = 	$documento;
				

                $this->load->helper('template');
                $params_view = array(
                    'title' => 'Personas',
                    'view' => 'vehiculo/edit_g',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el registro');
        }
    }
/*************************************************************************************/
    

    public function nuevo_ELECTRO_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/					
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			//$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/					
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_ELECTRO_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='ELECTRO;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'vehiculo/add_ELECTRO_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_RADIOL_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/				
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			//$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/					
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_RADIOL_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='RADIOL;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'vehiculo/add_RADIOL_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


    public function nuevo_RADIOT_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/				
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			//$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/				
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_RADIOT_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='RADIOT;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/								
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'vehiculo/add_RADIOT_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }



    public function nuevo_PAPAN_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{
					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/				
            $this->form_validation->set_rules('nombre','Nombre documento','required');

			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/				
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_PAPAN_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='PAPAN;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'vehiculo/add_PAPAN_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_PENSA_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{	

					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/			
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/
				
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_PENSA_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='PENSA;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'vehiculo/add_PENSA_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


    public function nuevo_INTE_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{	

					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/				
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/				
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_INTE_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='INTE;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'vehiculo/add_INTE_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_PUESIC_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{	

					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/				
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			//$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/					
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_PUESIC_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='PUESIC;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/								
							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'vehiculo/add_PUESIC_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

    public function nuevo_VISTA_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{	

					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/					
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			//$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/				
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_VISTA_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='VISTA;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'vehiculo/add_VISTA_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }




    public function nuevo_compo_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
        
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{	

					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/					
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			//$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/					
				
                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_compo_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='COMPO;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/								
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'vehiculo/add_compo_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
 
     public function nuevo_prevem_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		
		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
			$this->cliente->borra_sgmty_doc($cliente_id);
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['doc_pkts'] ='';

				$i=1;
				$paquetes='';
				$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
				if($fsm_pakts):
					foreach($fsm_pakts as $fsm_pakt):			
						$indice=str_replace(' ','_',$fsm_pakt['cost_nombre_pkt']).'_'.$i;
						if (strlen($this->input->post($indice)) > 1)
						{	
							$paquetes.=$this->input->post($indice);										
						}
						$i++;									
					endforeach;
				endif;
				$data_clte['doc_pkts'] = $paquetes;
				//$data_clte['contador']=$this->input->post('contador');

                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        //send_json_error($this->upload->display_errors());
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_sgmty_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'vehiculo/add_sgmty_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
    public function nuevo_sgmty_venta($cliente_id, $tipo=0)
    {
        $persona = $this->cliente->get($cliente_id);		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
			$this->cliente->borra_sgmty_venta($cliente_id,$venta);
            $this->load->library('form_validation');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['doc_pkts'] ='';

				$i=0;
				$paquetes='';
				$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
				if($fsm_pakts):
					foreach($fsm_pakts as $fsm_pakt):			
						$indice=str_replace(' ','_',$fsm_pakt['cost_nombre_pkt']).'_'.$i;
						if (strlen($this->input->post($indice)) > 1)
						{	
							$paquetes.=$this->input->post($indice);										
						}
						$i++;									
					endforeach;
				endif;
				
				$data_clte['doc_pkts'] = $paquetes;
				$data_clte['doc_path'] = $this->input->post('cantidad');
				
                $this->load->library('upload');				

				if (strlen($data_clte['doc_path']) > 0)
				{
					$data = $this->upload->data();
					if($this->cliente->add_sgmty_doc(array_to_upper($data_clte)))
					{
						send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='SGMTY_VENTA;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/						
					}
					else
					{
						send_json_error('Ocurrió un error al guardar el documento.');
					}
				}
				else 
				{
					
					send_json_error('No escribio la cantidad, por favor revisa');
				}						
					
            }
            else
            {
                send_json_error(validation_errors('¡Error!<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			$data['tipo'] = $tipo;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/				
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'vehiculo/add_sgmty_venta',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
 
 
    public function nuevo_sgmty_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		
		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
			$this->cliente->borra_sgmty_doc($cliente_id);
            $this->load->library('form_validation');
			/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
			if (($persona['serv_id'] == 0) ||(get_status_serv($persona['serv_id']) != 'PROCESO'))
			{	

					$this->form_validation->set_rules('servicio','Orden de servicio','required');
			}
            /*************************************************/				
			$this->form_validation->set_rules('nombre','Nombre documento','required');
			//$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				//$data_clte['serv_id'] = $this->input->post('servicio');
				/*NUEVA CODIGO PARA CONTROL DE ORDENES DE SERVICIOS*/
				if (($persona['serv_id'] == 0) || (get_status_serv($persona['serv_id']) != 'PROCESO'))
				{	
						$data_clte['serv_id']  = $this->input->post('servicio');
				}
				else
				{	
						$data_clte['serv_id']  = $persona['serv_id'];
				}
				/**************************************************/					
				$data_clte['doc_pkts'] ='';

				$i=1;
				$paquetes='';
				$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
				if($fsm_pakts):
					foreach($fsm_pakts as $fsm_pakt):			
						$indice=str_replace(' ','_',$fsm_pakt['cost_nombre_pkt']).'_'.$i;
						if (strlen($this->input->post($indice)) > 1)
						{	
							$paquetes.=$this->input->post($indice);
							if ($this->input->post('emp_id') == 182)
							{
								if (
									($fsm_pakt['cost_nombre_pkt'] == 'ANALISIS BACTERIOLOGICO DE HIELO') 
									||	($fsm_pakt['cost_nombre_pkt'] == 'ANALISIS BACTERIOLOGICO DE AGUA')
									||	($fsm_pakt['cost_nombre_pkt'] == 'CULTIVO DE ALIMENTO CRUDO')
									||	($fsm_pakt['cost_nombre_pkt'] == 'CULTIVO DE ALIMENTO COCIDO')
									||	($fsm_pakt['cost_nombre_pkt'] == 'CULTIVO DE SUPERFICIE INERTE')
									||	($fsm_pakt['cost_nombre_pkt'] == 'CULTIVO DE SUPERFICIE VIVA')
									)
									{
										$indice_muestra=$indice.'_MUESTRA';
										$paquetes=substr($paquetes, 0, -1);
										$paquetes.='x'.$this->input->post($indice_muestra).';';
									}	
							}

						}
						$i++;									
					endforeach;
				endif;
				
				$data_clte['doc_pkts'] = $paquetes;
				
                $this->load->library('upload');
				
				
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_sgmty_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
							/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
							$servicios=$persona['domserv'];					
							
							$servicio='SGMTY_DOC;';
							if (!(strstr($servicios,$servicio)))
							{							
								$servicios.=$servicio;
								$data_clte_id['domserv']=$servicios;
								$res=$this->cliente->actualiza_registro_individual($cliente_id, $data_clte_id);
							}
							/**************************************************/								
							
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
				
				
				
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
			/****** NUEVA CODIGO PARA CONTROL DE SERVICIOS ****/
			$data['ordeness'] = $this->servicio->get_mis_ordenes_servicios_a_empresa($persona['emp_id']);
			/**************************************************/			
			$this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'vehiculo/add_sgmty_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
  /***/
      public function nuevo_insignia_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		
		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
			$this->cliente->borra_sgmty_doc($cliente_id);
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['doc_pkts'] ='';

				$i=1;
				$paquetes='';
				$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
				if($fsm_pakts):
					foreach($fsm_pakts as $fsm_pakt):			
						$indice=str_replace(' ','_',$fsm_pakt['cost_nombre_pkt']).'_'.$i;
						if (strlen($this->input->post($indice)) > 1)
						{	
							$paquetes.=$this->input->post($indice);										
						}
						$i++;									
					endforeach;
				endif;
				$data_clte['doc_pkts'] = $paquetes;
				//$data_clte['contador']=$this->input->post('contador');

                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        //send_json_error($this->upload->display_errors());
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_sgmty_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'vehiculo/add_sgmty_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
 /***/
      public function nuevo_allianz_doc($cliente_id)
    {
        $persona = $this->cliente->get($cliente_id);
		
		
        
        if(isset($_POST) && count($_POST) > 0)     
        {
			$this->cliente->borra_sgmty_doc($cliente_id);
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre documento','required');
			$this->form_validation->set_rules('servicio','Orden de servicio','required');
			
            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('servicio');
				$data_clte['doc_pkts'] ='';

				$i=1;
				$paquetes='';
				$fsm_pakts= get_costos_paquetes_empresa($this->input->post('emp_id'));
				if($fsm_pakts):
					foreach($fsm_pakts as $fsm_pakt):			
						$indice=str_replace(' ','_',$fsm_pakt['cost_nombre_pkt']).'_'.$i;
						if (strlen($this->input->post($indice)) > 1)
						{	
							$paquetes.=$this->input->post($indice);										
						}
						$i++;									
					endforeach;
				endif;
				$data_clte['doc_pkts'] = $paquetes;
				//$data_clte['contador']=$this->input->post('contador');

                $this->load->library('upload');
                if(!empty($_FILES['doc']['name']))
                {
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/docs/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg|pdf|doc|docx',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('doc'))
                    {
                        //send_json_error($this->upload->display_errors());
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['doc_path'] = $data['file_name'];
                        if($this->cliente->add_sgmty_doc(array_to_upper($data_clte)))
                        {
                            send_json_ok('Se guardó de forma correcta');
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
                    send_json_error($this->upload->display_errors());
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['persona'] = $persona;
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'vehiculo/add_sgmty_doc',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }
 
    function descarga_doc($file)
    {
        $this->load->helper('download');
        force_download('./docs/'.$file, NULL);
    }
	
	


    function busca_evaluado()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $this->input->post('empresa');
		$id_persona = strtoupper($this->input->post('id_persona'));
        $nombre  = strtoupper($this->input->post('nombre'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
        $rfc     = strtoupper($this->input->post('rfc'));
        $ubicacion     = strtoupper($this->input->post('ubicacion'));
        $data['clientes'] = $this->cliente->busca($empresa, $nombre,$paterno, $materno, $rfc, $ubicacion,$despacho,$emp_id_user,$id_persona);
        send_json_ok($this->load->view('vehiculo/busca',$data,TRUE));
    }


    function busca_p()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$user = $this->session->user; 
		//$usuario = $CIs->empleado->get($user['usr_id']);
		$medico=$this->medico->get($user['usr_id']);
		
		$roots=get_my_user_root2();    
        $empresa = $this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));

		//echo '--'.$medico['usr_emp_asig'].'--';
        $data['clientes'] = $this->cliente->busca_p($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$medico['usr_emp_asig']);
        
		send_json_ok($this->load->view('vehiculo/busca_p',$data,TRUE));
    }

	


/*************************************************************************************/
    public function lista_e()
    {   //date_default_timezone_set('America/Mexico_City');
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$emp_id=$user['emp_id'];
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('vehiculo/lista_e/');
        //$config['total_rows'] = $this->cliente->count_all();
		
		if ($user['usr_id'] == 482)
		{
		$config['total_rows'] = $this->cliente->count_allo_m($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);
        }
		else
		{
		$config['total_rows'] = $this->cliente->count_allo_e($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);
        }
		
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
        //echo " Punto ".$medico['usr_emp_asig'];
		//echo " Punto B ";
        //$data['clientes'] = $this->cliente->get_all($rows);
		//echo " Punto ".$emp_id;
		

		if ($user['usr_id'] == 482)
		{
		$data['clientes'] = $this->cliente->get_allo_m($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
        }
		else
		{
		$data['clientes'] = $this->cliente->get_allo_e($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
        }

		
		//echo " Punto C ";
		
        //$this->load->model('empresa/Empresa_model','empresa');
		//echo " Punto D ";
		
        //$data['empresas'] = $this->empresa->trae_empresas(1);//$this->empresa->get_all_empresas();
		//$data['empresas'] = $this->empresa->get_all_empresas_gsi();
		//echo " Punto E ";
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'vehiculo/index_e',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
/*************************************************************************************/
    public function lista_a()
    {   
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$emp_id=$user['emp_id'];
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('vehiculo/lista_a/');
        //$config['total_rows'] = $this->cliente->count_all();
		$config['total_rows'] = $this->cliente->count_allo_a($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);
        
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
		//echo " Punto B ";
		//echo " Punto ".$emp_id;
		$data['clientes'] = $this->cliente->get_allo_a($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
		
		//echo " Punto C ";
		//echo " Punto D ";
		//echo " Punto E ";
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'vehiculo/index_a',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
/*************************************************************************************/
    public function lista_b()
    {   
	    //echo " Punto A ";
		$suc=get_sucursal_id();
		$user_despacho=get_desp_id_usr();
		$user_cei=get_cei_id();
		$user_root1=get_my_user_root1();
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
		$emp_id=$user['emp_id'];
        $rows = 30;
        $this->load->library('pagination');
        $config['base_url'] = base_url('vehiculo/lista_b/');
        //$config['total_rows'] = $this->cliente->count_all();
		$config['total_rows'] = $this->cliente->count_allo_b($emp_id,$suc,$user_despacho,$user_cei,$user_root1,1);
        
		$config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);
		//echo " Punto B ";
		//echo " Punto ".$emp_id;
		$data['clientes'] = $this->cliente->get_allo_b($rows,$emp_id,get_sucursal_id(),$user_despacho,$user_cei,$user_root1,1);
		
		//echo " Punto C ";
		//echo " Punto D ";
		//echo " Punto E ";
        
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Personas',
            'view' => 'vehiculo/index_b',
            'view_data' => $data 
           );
        render_template($params_view);  
    }


    public function nuevo_e()
    {    
		$user = $this->session->user; 
		$medico = $this->medico->get($user['usr_id']);
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('nombre','Nombre','required');
            $this->form_validation->set_rules('paterno','Apellido Paterno','required');
            $this->form_validation->set_rules('materno','Apellido Materno','required');
            $this->form_validation->set_rules('fnac','Fecha de nacimiento','required');
            $this->form_validation->set_rules('genero','Género','required');

            if($this->form_validation->run())
            {
                //informncion general de la pérsona
                $data_clte['clte_nombre_crypt'] =  trim($this->input->post('nombre'));
                $data_clte['clte_2_nombre_crypt'] =  trim($this->input->post('nombre_adic'));
                $data_clte['clte_paterno_crypt'] =  trim($this->input->post('paterno'));
                $data_clte['clte_materno_crypt'] =  trim($this->input->post('materno'));
                
				$data_clte['clte_f_nac'] = formatea_fecha_mysql($this->input->post('fnac'));
                $data_clte['clte_genero_cve'] =  $this->input->post('genero');      				
				$data_clte['clte_rfc_crypt'] =  $this->input->post('rfc');                				
				$data_clte['clte_curp_crypt'] = $this->input->post('curp');
				$data_clte['clte_nss_crypt'] =  $this->input->post('nss');
                $data_clte['clte_grado_acad_cve'] =  $this->input->post('grado');
                $data_clte['clte_edo_civ_cve'] =  $this->input->post('civil');
                $data_clte['clte_nac_cve'] =  $this->input->post('nac');				
				
                $data_clte['empleado'] = 1;
                
                $data_clte['emp_id'] =$this->input->post('empresa');//$medico['usr_emp_asig'];
                $data_clte['clte_puesto'] = $this->input->post('puesto');
				$data_clte['num_empleado'] = $this->input->post('nempleado');
				
				//sucursal
                $data_clte['suc_id'] =0;
				$data_clte['cei_id'] =  4;

				$nomserv='NOM0351;NOM0352;NOM0353;';
				$data_clte['nomserv'] =  $nomserv;

 /***************************** CARGA DE LA FOTO DEL EVALUADO ************************/               
                if(!empty($_FILES['foto']['name']))
                {
                    $this->load->library('upload');
                    $filename = md5(time());
                    $config = array(
                            'upload_path'   => './../../files/fotos/',
                            'overwrite'     => TRUE,
                            'file_name'     => $filename,
                            'allowed_types' => 'png|jpg|jpeg',
                            'max_size'      => '10000'
                    );

                    $this->upload->initialize($config);
                    if ( ! $this->upload->do_upload('foto'))
                    {
                        send_json_error($this->upload->display_errors());
                    }
                    else 
                    {
                        $data = $this->upload->data();
                        $data_clte['clte_path_foto'] = $data['file_name'];
                    }
                }
/*************************************************************************************/
				$data_clte=array_to_upper($data_clte);
				$data_clte['clte_email_crypt'] =  $this->input->post('correo');
				if ($cliente_id = $this->cliente->inserta($data_clte))
                {
                    send_json_ok(array('msg' =>'Se guardó de forma correcta', 'id' => $cliente_id));
                    
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar la persona.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $this->load->model('empresa/Empresa_model','empresa');
            //$data['empresas'] = $this->empresa->get_all_empresas();
			$data['empresas'] =$this->empresa->get_all_empresas_gsi();
			$data['sucursals'] = $this->empresa->get_all_sucursales();
			$data['despachos'] = $this->empresa->get_all_despachos();
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Personas',
                'view' => 'vehiculo/add_e',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }


/*************************************************************************************/	
    function busca_e()
    {   
		$user = $this->session->user;
		$despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $emp_id_user; //$this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		
		$empleado =	strtoupper($this->input->post('empleado'));
		$receta=	strtoupper($this->input->post('receta'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
		
		if ($user['usr_id'] == 482)
		{
        $data['clientes'] = $this->cliente->busca_m($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$emp_id_user);
        }
		else
		{
		  $data['clientes'] = $this->cliente->busca_e($empresa, $nombre, $nombre2,$paterno, $materno, $empleado, $receta,$despacho,$emp_id_user);	
		}
		
		send_json_ok($this->load->view('vehiculo/busca_e',$data,TRUE));
    } 

 /*************************************************************************************/	
    function busca_a()
    {   $despacho=get_desp_id_usr();
		$emp_id_user=get_emp_id();
		$roots=get_my_user_root2();    
        $empresa = $emp_id_user; //$this->input->post('empresa');
        $nombre  = strtoupper($this->input->post('nombre'));
		$nombre2 = strtoupper($this->input->post('nombre2'));
		$paterno  = strtoupper($this->input->post('paterno'));
		$materno  = strtoupper($this->input->post('materno'));
        $data['clientes'] = $this->cliente->busca_a($empresa, $nombre, $nombre2,$paterno, $materno);
        
		send_json_ok($this->load->view('vehiculo/busca_a',$data,TRUE));
    } 
	
	
    public function borra_comentario($fsm_id)
    {
        if($this->cliente->borrar_comentario($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }	

    public function borra_documento($fsm_id)
    {
		$documento=$this->cliente->get_doc($fsm_id);
		
		$doc_borra['clte_id']=$documento['clte_id'];
		$doc_borra['doc_nombre']=$documento['doc_nombre'];
		$doc_borra['doc_path']=strtolower($documento['doc_path']);
		$doc_borra['doc_f']=$documento['doc_f'];
		$doc_borra['empresa']='EVALUADOS';
		$doc_borra['doc_fecha_efectiva']=date();
		
		$this->cliente->inserta_borrado($doc_borra);
        if($this->cliente->delete_doc($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }



	
 
}