 <?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ssiniestros extends CI_Controller {
    
    function __construct() {
        parent::__construct();
		$this->load->model('ssiniestros/Ssiniestros_model','asegurado');
		$this->load->model('sasegurados/Sasegurados_model','sasegurado');
        $this->load->model('empleado/Empleado_model','empleado');
		$this->load->model('empresa/Empresa_model','empresa');
		$this->load->model('easegurados/Easegurados_model','easegurado');
		
        $this->load->model('persona/Persona_model','cliente22');
		$this->load->model('servicio/Servicio_model','servicio');
	
		
    }


    public function carga_fotografia($id_siniestros,$folio,$detalle,$modo)
    {
		

        if(isset($_POST) && count($_POST) > 0)     
        {
			/*
			if(1)				
            {
                $data_clte['clte_id'] =  $cliente_id;
                $data_clte['doc_nombre'] =  $this->input->post('nombre');
                $data_clte['doc_f'] =  date('Y-m-d H:i:s');
                $data_clte['emp_id'] =  $this->input->post('emp_id');
				$data_clte['serv_id'] = $this->input->post('serv_id');
				$data_clte['doc_pkts'] = $paquete;

                if(!empty($_FILES['documento']['name']))
                {
                    
					$pre_croquis= carga_pdf('documento','./../../files/docs_renovaciones/');

					if (!($pre_croquis))
                    {                        
						send_json_error('El documento nos se ha podido cargar, por favor revisa');
                    }
                    else 
                    {

						$data_clte['doc_path'] = $pre_croquis;
                        if($this->cliente->add_renovaciones_doc(array_to_upper($data_clte),$paquete))
                        {	
							send_json_ok(array('msg' =>'Se realizo la carga del archivo', 'id' => $id_siniestros));
                        }
                        else
                        {
                            send_json_error('Ocurrió un error al guardar el documento.');
                        }
                    }
                }
                else
                {
					send_json_error('Se requiere el documento.');
                }				
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
			*/
        }
        else 
        {

            $data['modo'] = $modo;
			$data['folio'] = $folio;
			$data['detalle'] = $detalle;
			$data['id_siniestros'] = $id_siniestros;
			
            $this->load->helper('template');

            $params_view = array(
                'title' => 'Personas',
                'view' => 'ssiniestros/add_fotos_siniestros_jpg',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }

//UPDATE `sis05_ssiniestros` SET `sin_EFD_rep`="noimagen.jpg" WHERE sin_id=8 

  public function borra_foto($id,$detalle)
    {
		$data_clte[$detalle]='noimagen.jpg';
        if($this->asegurado->actualiza_siniestro($id, $data_clte))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }

  public function borra_reg_siniestro($id)
    {
        if($this->asegurado->borra_reg_siniestro($id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


   public function index()
    {	
	
        $rows = 15; 
        $this->load->library('pagination');
        $config['base_url'] = base_url('ssiniestros/index/');
        $config['total_rows'] = $this->asegurado->count_all_siniestros();
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);

        $data['siniestros'] = $this->asegurado->get_allo_siniestros($rows);
		$data['folios_lotes_fotograficos'] = $this->asegurado->obtenEfectivoLoteFotografia($rows);

	   $this->load->helper('template');
        $params_view = array(
            'title' => 'Siniestros',
            'view' => 'ssiniestros/index',
            'view_data' => $data 
           );
        render_template($params_view);  
    }



	public function id($id)
    {   

		$user = $this->session->user; 
		$usuario = $this->empleado->get($user['usr_id']);
		$data['siniestro'] =  $this->asegurado->get_siniestro($id);
		 
		
		$data['cliente'] = $this->asegurado->get_alot($data['siniestro']['fsm_folio']);		
		$data['fotografias'] =  $this->asegurado->get_photo($data['siniestro']['fsm_folio']);
		

		
		
		if($data['cliente'])
        {
						
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Sura Comercial',
                'view' => 'ssiniestros/clientes',
                'view_data' => $data 
               );

            render_template($params_view);  
        }
        else
        {
            show_error('El cliente no existe.');
        }
    }





/****************************************************************************************/



    public function pdf_siniestro($id_sin)
    {
		$user = $this->session->user; 
		$usuario = $this->empleado->get($user['usr_id']);
		$data['siniestro'] =  $this->asegurado->get_siniestro($id_sin);
		
        $this->load->helper('pdf');

		genera_pdf_new_reporte_poli($this->load->view('ssiniestros/pdf_siniestros',$data,TRUE),'SURA_SINIESTROS_'.$data['siniestro']['fsm_folio'],'SURA_SINIESTROS',$data['siniestro']['fsm_folio']);
	}



    public function pdf($id_folio)
    {
		$user = $this->session->user; 
		$usuario = $this->empleado->get($user['usr_id']);
		
		$data['folio']=$id_folio;
		$data['cliente'] = $this->asegurado->get_alot($id_folio);		
		$data['fotografias'] =  $this->asegurado->get_photo($id_folio);

        $this->load->helper('pdf');

		genera_pdf_new_reporte_poli($this->load->view('ssiniestros/pdf',$data,TRUE),'SURA_SINIESTROS_'.$id_folio,'SURA_SINIESTROS',$id_folio);
	}


    function reporte_empleado()
    {

		   $f_ini = $this->input->post('f_ini'); 
           $f_fin = $this->input->post('f_fin'); 
		   $ssiniestros = $this->asegurado->get_all_reg_by_fecha($f_ini,$f_fin);
   
            $this->load->helper('template');	
            	
		?>


		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">

		<head>
		<meta content="es-mx" http-equiv="Content-Language" />
		<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />

            <?php
                $date2today = date("Y-m-d H:i:s");
                $date3today = date("YmdHis");

                header("Content-type: application/octet-stream; charset=latin1");
                header("Content-Disposition: attachment; filename=Rep_reg_insvir_registros_sura_".$date3today.".xls");
                header("Pragma: no-cache");
                header("Expires: 0");
            ?>
				<title>REPORTE USUARIOS</title>
				<style type="text/css">
					.auto-style1 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: small;
					}
					.auto-style4 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
					}
					.auto-style5 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: medium;
					}
					.auto-style6 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-large;
						text-align: right;
						font-weight: normal;
					}
					.auto-style7 {
						font-size: small;
					}
					.auto-style8 {
						color: #3D5588;
                        
					}
					.auto-style9 {
						color: #3AD4A7;
					}
								.auto-style11 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: right;
					}
					.auto-style12 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: center;
					}
					.auto-style13 {
						font-size: xx-small;
					}
					.auto-style14 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: xx-small;
					}
					.auto-style15 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
					}
					.auto-style16 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: right;
					}
					.auto-style17 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: left;
					}
					.auto-style18 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
					}
								.auto-style19 {
						color: #3D5588;
						font-size: medium;
					}
					.auto-style20 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
						background-color: #BFEADD;
					}
					.auto-style21 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						background-color: #BFEADD;
					}

                    
                    
				</style>
			</head>

			<body>
				<table>
					<thead>
						<tr>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5" ><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
							<th class="auto-style5" > <span class="auto-style8" style="text-align: right">Reportes de VINs y Correos Electrónicos para Inspección Virtual</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5" style="height: 27px;"><span class="auto-style19">online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>
							<th class="auto-style5" style="height: 27px;"> <?php echo $date2today; ?></th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" style="height: 27px;"> <?php echo 'Del '.formatea_fecha($f_ini).' al '.formatea_fecha($f_fin); ?></th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
                        
						<tr>
							<th class="auto-style14" style="width: 250px">Id</th>
							<th class="auto-style14" style="width: 700px">Folio (Número de Serie / VIN)</th>
							<th class="auto-style14" style="width: 200px">Fecha de Registro</th>
						</tr>

					</thead>
					<tbody id="resultado">
						<?php        
						$class18=" ";
						if($ssiniestros): 
						
							foreach ($ssiniestros  as $sasegurado): 
								if ($class18 != "auto-style18")
								{
									$class18="auto-style18";
									$class4="auto-style4";
                                    
								}	
								else
								{
									$class18="auto-style20";
									$class4="auto-style21";	
								}
							?>
					
								<tr  style="background-color:<?php echo $renglon; ?>;"  >

                                    <td class=<?php echo $class18; ?>>
										<b>
											<?php echo $sasegurado['sura_id']; ?> 
										</b>	
                                    </td>

									<td class=<?php echo $class18; ?>>
										<b>
											<?php echo $sasegurado['fsm_folio']; ?>
										</b>
									</td>
									

                                    <td class=<?php echo $class18; ?>>
										<b>
											<?php echo formatea_fechahora($sasegurado['fsm_f']); ?>
										</b>
									</td>

                                </tr>
							<?php 
							endforeach;
						endif;
						?> 
					</tbody>
				</table>
			</body>
		</html>
		<?php 
	    }

    public function nuevo_reporte()
    {       
		$this->load->helper('template');
		$params_view = array(
			'title' => 'Servicios',
			'view' => 'ssiniestros/ficha_ssiniestros',
			'view_data' => $data
		   );
		
		render_template($params_view);  
    }


    public function nuevo_comentario($folio, $descripcion)
    {
      /*  $persona = $this->cliente->get($cliente_id);
        $user = $this->session->user;	
		$usuario = $this->empleado->get($user['usr_id']);
        $empresa = $this->cliente->get_empresa_by_clte($cliente_id);*/

        if(isset($_POST) && count($_POST) > 0)  
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('com_comentario','COMENTARIOS','required');
            

            if($this->form_validation->run())
            {
                
				$data_insert['com_folio']           = $this->input->post('folio');
				$data_insert['com_descripcion']     = $this->input->post('descripcion');
                $data_insert['com_comentario']   =	$this->input->post('com_comentario');
                $data_insert['com_f']            =	date('Y-m-d H:i:s');                
				
                if($this->asegurado->insert_comentarios(array_to_upper($data_insert)))
                {	
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['folio'] = $folio;
            $data['descripcion'] = $descripcion;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'ssiniestros/nuevo_comentario',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }



    function busca_log()
    {        
        $folio  = trim(strtoupper($this->input->post('folio')));
		$f_registro =strtoupper($this->input->post('f_registro'));
		
		
		$id= $this->input->post('id');
		$numserie= trim(strtoupper($this->input->post('numserie')));
		$correo= trim(strtoupper($this->input->post('correo')));
		$analista= trim(strtoupper($this->input->post('analista')));	

		//$data['asegurado']  = $this->asegurado->busca($id,$numserie,$correo,$analista);
		$data1['asegurado'] = $this->asegurado->busca($folio,$f_registro);
        send_json_ok($this->load->view('ssiniestros/busca_log',$data1,TRUE));
    }




    function busca()
    {        
        $folio  = trim(strtoupper($this->input->post('folio')));
		$f_registro =strtoupper($this->input->post('f_registro'));
		$data['asegurado'] = $this->asegurado->busca($folio,$f_registro);
        send_json_ok($this->load->view('ssiniestros/busca',$data,TRUE));
    }

	public function idf($id_folio)
    {   

		$user = $this->session->user; 
		$usuario = $this->empleado->get($user['usr_id']);
		
		$data['cliente'] = $this->asegurado->get_alot($id_folio);		
		$data['fotografias'] =  $this->asegurado->get_photo($id_folio);
		if($data['cliente'])
        {
						
            $this->load->helper('template');
            $params_view = array(
                'title' => 'Sura Comercial',
                'view' => 'ssiniestros/clientef',
                'view_data' => $data 
               );

            render_template($params_view);  
        }
        else
        {
            show_error('El cliente no existe.');
        }
    }








   public function borra($fsm_id)
    {
        if($this->asegurado->borra($fsm_id))
        {
            send_json_ok('Se eliminó de forma correcta.');
        }
        else
        {
            send_json_error('Ocurrió un error al eliminar.');
        }
    }


   public function index_folio()
    {	
	
        $rows = 15; 
        $this->load->library('pagination');
        $config['base_url'] = base_url('ssiniestros/index_folio/');
        $config['total_rows'] = $this->asegurado->count_all();
		
		$config['total_rows'] = $this->asegurado->cuentaEfectivaLoteFotografia();
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);

        $data['asegurado'] = $this->asegurado->get_allo($rows);
		$data['folios_lotes_fotograficos'] = $this->asegurado->obtenEfectivoLoteFotografia($rows);

	   $this->load->helper('template');
        $params_view = array(
            'title' => 'Usuario',
            'view' => 'ssiniestros/index_folio',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
 
 
 
 
 
 
    public function index_log()
    {	
        $rows = 15; 
        $this->load->library('pagination');
        $config['base_url'] = base_url('ssiniestros/index_log/');
        $config['total_rows'] = $this->asegurado->count_all();
		
		$config['total_rows'] = $this->asegurado->cuentaEfectivaLog();
        $config['per_page'] = $rows;
        $config['attributes'] = array('class' => 'pagination');
        $config['full_tag_open'] = '<div class="pagination-full">';
        $config['full_tag_close'] = '</div>';
        $config['uri_segment'] = 3;
        $config['query_string_segment'] = 4;
        $config['use_page_numbers'] = TRUE;
        $this->pagination->initialize($config);

		$data['folios_log'] = $this->asegurado->obtenEfectivoLog($rows);
		$data['los_analistas']= $this->easegurado->get_analistas('ANALISTA');
	   $this->load->helper('template');
        $params_view = array(
            'title' => 'Usuario',
            'view' => 'ssiniestros/index_log',
            'view_data' => $data 
           );
        render_template($params_view);  
    }
 
 
 
      public function edita_siniestro($id)
	  {      
		$user = $this->session->user;
		$usuario = $this->empleado->get($user['usr_id']);
		$data['siniestro'] =  $this->asegurado->get_siniestro($id);
		
		
        if(isset($_POST) && count($_POST) > 0)  
        {
            if(1)
            {                
				$data_insert['usr_id']           = $user['usr_id'];
				
				$data_insert['sin_oficina']     = $this->input->post('sin_oficina');
				$data_insert['sin_ramo']        = $this->input->post('sin_ramo');
				$data_insert['sin_poliza']      = $this->input->post('sin_poliza');
				$data_insert['sin_nombre']      = $this->input->post('sin_nombre');
				$data_insert['sin_paterno']     = $this->input->post('sin_paterno');
				$data_insert['sin_materno']     = $this->input->post('sin_materno');
				$data_insert['sin_cve']         = $this->input->post('sin_cve');
				$data_insert['sin_f']           = $this->input->post('sin_f');		
                $data_insert['log_updt_f']     =	date('Y-m-d H:i:s');  
				$data_insert['log_updt_usr_cve']    =	$usuario['usr_username']; 
				$data_insert['log_updt_prg']        =	'EDITA SINIESTRO'; 
				$id_f=$this->input->post('id_f');
				$data_insert=array_to_upper($data_insert);
				
				$data_insert['sin_descripcion'] = $this->input->post('sin_descripcion');
				
                if ($this->asegurado->actualiza_siniestro($id_f, $data_insert))
                {	
                    send_json_ok('Se Actualzación de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al actualizar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'ssiniestros/edita_siniestro',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
 
 
 
       public function cierre_siniestro($id,$folio)
	  {      
		$user = $this->session->user;
		$usuario = $this->empleado->get($user['usr_id']);
		$data['siniestro'] =  $this->asegurado->get_siniestro($id);
		$siniestro=  $this->asegurado->get_siniestro($id);
		
        if(isset($_POST) && count($_POST) > 0)  
        {
            if(1)
            {                
				$data_insert['usr_id']           = $user['usr_id'];				
				$data_insert['sin_estatus']     = 'DESACTIVADO';		
                $data_insert['sin_f_cierre']     =	date('Y-m-d'); 
				$data_insert['log_updt_f']     =	date('Y-m-d H:i:s');  
				$data_insert['log_updt_usr_cve']    =	$usuario['usr_username']; 
				$data_insert['log_updt_prg']        =	'CIERRE SINIESTRO'; 
				$id_f=$this->input->post('id_f');
				$data_insert=array_to_upper($data_insert);
				$data_insert['sin_descripcion'] = $this->input->post('sin_descripcion');
				$sin_folio= $this->input->post('sin_folio');
				$sin_id= $this->input->post('sin_id');
                if ($this->asegurado->actualiza_siniestro($id_f, $data_insert))
                {	

					if (estoy_en_linux())
					{
						$real[0]        = $sin_folio.'_EFD.jpg';
						$real[1]        = $sin_folio.'_EFI.jpg';
						$real[2]        = $sin_folio.'_ETI.jpg';
						$real[3]        = $sin_folio.'_ETD.jpg';	
						
						$rep[0]        = $sin_folio.'_'.$sin_id.'_EFD_REP.jpg';
						$rep[1]        = $sin_folio.'_'.$sin_id.'_EFI_REP.jpg';
						$rep[2]        = $sin_folio.'_'.$sin_id.'_ETI_REP.jpg';
						$rep[3]        = $sin_folio.'_'.$sin_id.'_ETD_REP.jpg';	
						
						for($j=0; $j<4; $j++ )
						{
							$filename_o = "/var/www/files/sura_iv_reparados/".$rep[$j];
							$filename_d = "/var/www/files/sura_iv_imagenes/".$real[$j];
							$filename_dd = "/var/www/files/sura_iii_imagenes/".$real[$j];
							unlink($filename_d);
							copy($filename_o,$filename_d);
							copy($filename_o,$filename_dd);
						}							
					}
					else
					{
						

						$real[0]        = $sin_folio.'_EFD.jpg';
						$real[1]        = $sin_folio.'_EFI.jpg';
						$real[2]        = $sin_folio.'_ETI.jpg';
						$real[3]        = $sin_folio.'_ETD.jpg';	
						
						$rep[0]        = $sin_folio.'_'.$sin_id.'_EFD_REP.jpg';
						$rep[1]        = $sin_folio.'_'.$sin_id.'_EFI_REP.jpg';
						$rep[2]        = $sin_folio.'_'.$sin_id.'_ETI_REP.jpg';
						$rep[3]        = $sin_folio.'_'.$sin_id.'_ETD_REP.jpg';	
						
					
						for($j=0; $j<4; $j++ )
						{								
							$filename = "C:\\xampp\\files\\sura_iv_reparados\\".$rep[$j];
							$fp = fopen($filename, "rb");
							$contenido = fread($fp, filesize($filename));
							fclose($fp);
							
							$filename = "C:\\xampp\\files\\sura_iv_imagenes\\".$real[$j];
							$fp = fopen($filename , 'w');
							fwrite($fp,$contenido);
							fclose($fp);
						}
						
					}	
					
					$data_update['fsm_latitud']     = $this->input->post('sin_latitud_rep');		
					$data_update['fsm_longitud']     =	$this->input->post('sin_longitud_rep'); 
					$data_update['log_updt_f']     =	date('Y-m-d H:i:s'); 					
					$this->sasegurado-> actualiza_por_folio($sin_folio, $data_update);
			
                    send_json_ok('Se realizo el cierre de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al cerrar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'ssiniestros/cierra_siniestro',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
 
 
 
 
 
        public function activar_reg_siniestro($id)
	  {      
		$user = $this->session->user;
		$usuario = $this->empleado->get($user['usr_id']);
		$data['siniestro'] =  $this->asegurado->get_siniestro($id);
		
		
        if(isset($_POST) && count($_POST) > 0)  
        {
            if(1)
            {                
				$data_insert['usr_id']           = $user['usr_id'];				
				$data_insert['sin_estatus']     = 'ACTIVO';		
               // $data_insert['sin_f_cierre']     =	date('Y-m-d'); 
				$data_insert['log_updt_f']     =	date('Y-m-d H:i:s');  
				$data_insert['log_updt_usr_cve']    =	$usuario['usr_username']; 
				$data_insert['log_updt_prg']        =	'REABIERTO SINIESTRO'; 
				$id_f=$this->input->post('id_f');
				$data_insert=array_to_upper($data_insert);
                if ($this->asegurado->actualiza_siniestro($id_f, $data_insert))
                {	
                    send_json_ok('Se realizo la REAPERTURA de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error en la REAPERTUA.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
			
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'ssiniestros/activar_reg_siniestro',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
 
 
 
 
 
      public function adiciona_siniestro($folio)
	  {      
		$user = $this->session->user;
		$usuario = $this->empleado->get($user['usr_id']);
		$sasegurado = $this->sasegurado->get_a_lot($folio);
		
        if(isset($_POST) && count($_POST) > 0)  
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('sin_oficina','OFICINA','required');
            $this->form_validation->set_rules('sin_ramo','RAMO','required');
			$this->form_validation->set_rules('sin_poliza','POLIZA','required');

            if($this->form_validation->run())
            {                
				$data_insert['fsm_folio']        = $folio;
				$data_insert['usr_id']           = $user['usr_id'];
				
				$data_insert['sin_oficina']     = $this->input->post('sin_oficina');
				$data_insert['sin_ramo']        = $this->input->post('sin_ramo');
				$data_insert['sin_poliza']      = $this->input->post('sin_poliza');
				$data_insert['sin_nombre']      = $this->input->post('sin_nombre');
				$data_insert['sin_paterno']     = $this->input->post('sin_paterno');
				$data_insert['sin_materno']     = $this->input->post('sin_materno');
				$data_insert['sin_cve']         = $this->input->post('sin_cve');
				$data_insert['sin_f']           = $this->input->post('sin_f');		
				$data_insert['sin_estatus']     = 'ACTIVO';	
                $data_insert['log_insrt_f']     =	date('Y-m-d H:i:s');  
				$data_insert['log_insrt_usr_cve']    =	$usuario['usr_username']; 
				$data_insert['log_insrt_prg']        =	'REG SINIESTRO'; 

				$data_insert=array_to_upper($data_insert);
				$data_insert['sin_descripcion']           = $this->input->post('sin_descripcion');
				$data_insert['sin_EFD_ori']        = $folio.'_EFD.jpg';
				$data_insert['sin_EFI_ori']        = $folio.'_EFI.jpg';
				$data_insert['sin_ETI_ori']        = $folio.'_ETI.jpg';
				$data_insert['sin_ETD_ori']        = $folio.'_ETD.jpg';	

				$data_insert['sin_latitud_ori']        = $sasegurado[0]['fsm_latitud'];
				$data_insert['sin_longitud_ori']        = $sasegurado[0]['fsm_longitud'];	

				$data_insert['sin_EFD_sin']        = 'noimagen.jpg';
				$data_insert['sin_EFI_sin']        = 'noimagen.jpg';
				$data_insert['sin_ETI_sin']        = 'noimagen.jpg';
				$data_insert['sin_ETD_sin']        = 'noimagen.jpg';	
				
				$data_insert['sin_EFD_rep']        = 'noimagen.jpg';
				$data_insert['sin_EFI_rep']        = 'noimagen.jpg';
				$data_insert['sin_ETI_rep']        = 'noimagen.jpg';
				$data_insert['sin_ETD_rep']        = 'noimagen.jpg';	
				$ids=$this->asegurado->inserta_siniestro($data_insert);
                if ($ids)
                {	
					if (estoy_en_linux())
					{
						$sin[0]        = $folio.'_EFD.jpg';
						$sin[1]        = $folio.'_EFI.jpg';
						$sin[2]        = $folio.'_ETI.jpg';
						$sin[3]        = $folio.'_ETD.jpg';	
						
						$ori[0]        = $folio.'_'.$ids.'_EFD.jpg';
						$ori[1]        = $folio.'_'.$ids.'_EFI.jpg';
						$ori[2]        = $folio.'_'.$ids.'_ETI.jpg';
						$ori[3]        = $folio.'_'.$ids.'_ETD.jpg';							
						
						for($j=0; $j<4; $j++ )
						{
							$filename_o = "/var/www/files/sura_iv_imagenes/".$sin[$j];
							$filename_d = "/var/www/files/sura_iv_originales/".$ori[$j];
							copy($filename_o,$filename_d);
						}	
						
						$data_update['sin_EFD_ori']        = $folio.'_'.$ids.'_EFD.jpg';
						$data_update['sin_EFI_ori']        = $folio.'_'.$ids.'_EFI.jpg';
						$data_update['sin_ETI_ori']        = $folio.'_'.$ids.'_ETI.jpg';
						$data_update['sin_ETD_ori']        = $folio.'_'.$ids.'_ETD.jpg';
						
					}
					else
					{
						
					/*	$dir_origen='C:\\xampp\files\sura_iv_imagenes';
						$dir_destino='C:\\xampp\files\sura_iv_originales';*/
						$sin[0]        = $folio.'_EFD.jpg';
						$sin[1]        = $folio.'_EFI.jpg';
						$sin[2]        = $folio.'_ETI.jpg';
						$sin[3]        = $folio.'_ETD.jpg';	
						
						$ori[0]        = $folio.'_'.$ids.'_EFD.jpg';
						$ori[1]        = $folio.'_'.$ids.'_EFI.jpg';
						$ori[2]        = $folio.'_'.$ids.'_ETI.jpg';
						$ori[3]        = $folio.'_'.$ids.'_ETD.jpg';	
						
						
						
						
						//$comando='copy $dir_origen\$sin_EFD  $dir_destino\$sin_EFD_ori';
						
						//exec('gusarapo.bat '.'gusarap0_'.$ids.'.txt');
						//exec('comando.bat '.'gusarap0_'.$ids.'.txt');
						//copy($dir_origen.'\'.$sin_EFD, $dir_destino.'\'.$sin_EFD_ori );
						
						for($j=0; $j<4; $j++ )
						{	
							$filename = "C:\\xampp\\files\\sura_iv_imagenes\\".$sin[$j];
							$fp = fopen($filename, "rb");
							$contenido = fread($fp, filesize($filename));
							fclose($fp);

							$filename = "C:\\xampp\\files\\sura_iv_originales\\".$ori[$j];
							$fp = fopen($filename , 'w');
							fwrite($fp,$contenido);
							fclose($fp);
						}
						
						$data_update['sin_EFD_ori']        = $folio.'_'.$ids.'_EFD.jpg';
						$data_update['sin_EFI_ori']        = $folio.'_'.$ids.'_EFI.jpg';
						$data_update['sin_ETI_ori']        = $folio.'_'.$ids.'_ETI.jpg';
						$data_update['sin_ETD_ori']        = $folio.'_'.$ids.'_ETD.jpg';
					}	
					
					
					$this->asegurado->actualiza_siniestro($ids, $data_update);
                    send_json_ok('Se Registro de forma correcta');
					
                }
                else
                {
                    send_json_error('Ocurrió un error al registrar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['folio'] = $folio;
            $data['descripcion'] = $descripcion;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'ssiniestros/adiciona_siniestro',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
 
 
 
 
     public function adiciona($folio, $descripcion)
    {
      

        if(isset($_POST) && count($_POST) > 0)  
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('com_comentario','COMENTARIOS','required');
            

            if($this->form_validation->run())
            {
                
				$data_insert['com_folio']           = $this->input->post('folio');
				$data_insert['com_descripcion']     = $this->input->post('descripcion');
                $data_insert['com_comentario']   =	$this->input->post('com_comentario');
                $data_insert['com_f']            =	date('Y-m-d H:i:s');                
				
                if($this->asegurado->insert_comentarios(array_to_upper($data_insert)))
                {	
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {
            $data['folio'] = $folio;
            $data['descripcion'] = $descripcion;
            $this->load->helper('template');
            $params_view = array(
                'title' => '',
                'view' => 'ssiniestros/nuevo_comentario',
                'view_data' => $data 
               );
            render_template($params_view);
        }
    }
 
 

    public function edita($aseg_id)
    {
        $item = $this->asegurado->get($aseg_id);		
		$user = $this->session->user;
        
        if($item)
        {

            if(isset($_POST) && count($_POST) > 0)     
            {
                $this->load->library('form_validation');
				$this->form_validation->set_rules('cat_grupo','Grupo (cat_grupo)','required');
				$this->form_validation->set_rules('cat_grupo_nombre','Sub Grupo','required');
				$this->form_validation->set_rules('cat_seq','Secuencia','required');
				$this->form_validation->set_rules('cat_cve','Clave','required');
				$this->form_validation->set_rules('cat_nombre','Detalle','required');
				$this->form_validation->set_rules('cat_estatus_cve','Estatus','required');

                if($this->form_validation->run())
                {
					$data_usr['cat_grupo'] = trim($this->input->post('cat_grupo'));       
					$data_usr['cat_grupo_nombre'] = trim($this->input->post('cat_grupo_nombre')); 
					$data_usr['cat_seq'] = trim($this->input->post('cat_seq')); 
					$data_usr['cat_cve'] = trim($this->input->post('cat_cve')); 
					$data_usr['cat_nombre'] = trim($this->input->post('cat_nombre')); 
					$data_usr['cat_estatus_cve'] = trim($this->input->post('cat_estatus_cve')); 
				    $data_usr = array_to_upper($data_usr);
					
                    if($this->asegurado->actualiza($aseg_id, $data_usr))
                    {
                        send_json_ok('Se actualizó de forma correcta');
                    }
                    else
                    {
                        send_json_error('Ocurrió un error al actualizar el item.');
                    }
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
				

                $data['item'] =  $item;

				$this->load->helper('template');
                $params_view = array(
                    'title' => 'Empleados',
                    'view' => 'ssiniestros/edit',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el item');
        }
    }
 
    public function nuevo()
    {
        if(isset($_POST) && count($_POST) > 0)     
        {
            $this->load->library('form_validation');
            $this->form_validation->set_rules('cat_grupo','Grupo (cat_grupo)','required');
            $this->form_validation->set_rules('cat_grupo_nombre','Sub Grupo','required');
            $this->form_validation->set_rules('cat_seq','Secuencia','required');
            $this->form_validation->set_rules('cat_cve','Clave','required');
            $this->form_validation->set_rules('cat_nombre','Detalle','required');
            $this->form_validation->set_rules('cat_estatus_cve','Estatus','required');
  
            if($this->form_validation->run())
            {
                $data_usr['cat_grupo'] = trim($this->input->post('cat_grupo'));       
				$data_usr['cat_grupo_nombre'] = trim($this->input->post('cat_grupo_nombre')); 
				$data_usr['cat_seq'] = trim($this->input->post('cat_seq')); 
				$data_usr['cat_cve'] = trim($this->input->post('cat_cve')); 
				$data_usr['cat_nombre'] = trim($this->input->post('cat_nombre')); 				
				$data_usr['cat_estatus_cve'] = trim($this->input->post('cat_estatus_cve')); 
                $data_usr = array_to_upper($data_usr);
				
                if($this->asegurado->inserta($data_usr))
                {
                    send_json_ok('Se guardó de forma correcta');
                }
                else
                {
                    send_json_error('Ocurrió un error al guardar el empleado.');
                }
            }
            else
            {
                send_json_error(validation_errors('<div />'));
            }
        }
        else 
        {

            $this->load->helper('template');
            $params_view = array(
                'title' => 'Empleados',
                'view' => 'ssiniestros/add',
                'view_data' => $data
               );
            render_template($params_view);  
        }
    }







   public function duplicar($aseg_id)
    {
        $item = $this->asegurado->get($aseg_id);		
		$user = $this->session->user;
		
        if($item)
        {

            if(isset($_POST) && count($_POST) > 0)     
            { 

                $this->load->library('form_validation');
				$this->form_validation->set_rules('cat_grupo','Grupo (cat_grupo)','required');
				$this->form_validation->set_rules('cat_grupo_nombre','Sub Grupo','required');
				$this->form_validation->set_rules('cat_seq','Secuencia','required');
				$this->form_validation->set_rules('cat_cve','Clave','required');
				$this->form_validation->set_rules('cat_nombre','Detalle','required');
				$this->form_validation->set_rules('cat_estatus_cve','Estatus','required');
				
				if($this->form_validation->run())
                { 
					$data_usr['cat_grupo'] = trim($this->input->post('cat_grupo'));       
					$data_usr['cat_grupo_nombre'] = trim($this->input->post('cat_grupo_nombre')); 
					$data_usr['cat_seq'] = trim($this->input->post('cat_seq')); 
					$data_usr['cat_cve'] = trim($this->input->post('cat_cve')); 
					$data_usr['cat_nombre'] = trim($this->input->post('cat_nombre')); 
					$data_usr['cat_estatus_cve'] = trim($this->input->post('cat_estatus_cve')); 
					$data_usr = array_to_upper($data_usr);
					if($this->asegurado->inserta($data_usr))
					{
						send_json_ok('Se guardó de forma correcta');
					}
					else
					{
						send_json_error('Ocurrió un error al guardar el empleado.');
					}
                }
                else
                {
                    send_json_error(validation_errors('<div />'));
                }
            }
            else 
            {
                $data['item'] = 	$item;
                $this->load->helper('template');
                $params_view = array(
                    'title' => 'ssiniestros',
                    'view' => 'ssiniestros/copy',
                    'view_data' => $data
                   );
                render_template($params_view);  
            }
        }
        else 
        {
            show_error('No existe el registro');
        }
    }


    public function reporte_card()
    {
        $this->load->helper('template');
        $params_view = array(
            'title' => 'Inicio',
            'view' => 'ssiniestros/inicio_view_rep',
            'view_data' => $data
            );
        render_template($params_view);
    }
 

	
     function reporte_asegurados()
    {
        $grupo  = trim(strtoupper($this->input->post('grupo')));
		$subgrupo  = trim(strtoupper($this->input->post('subgrupo')));
		$clave = trim(strtoupper($this->input->post('clave')));
		$estatus = $this->input->post('estatus');  
		$detalle= trim(strtoupper($this->input->post('detalle'))); 
		$asegurado = $this->asegurado->busca($grupo,$subgrupo ,$clave, $estatus, $detalle);
		
        //$this->load->model('empresa/Empresa_model','empresa');
        //$data['empresas'] = $this->empresa->get_all_empresas();
        $this->load->helper('template');		
		?>
		<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">

		<head>
		<meta content="es-mx" http-equiv="Content-Language" />
		<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
				<?php
					date_default_timezone_set('America/Mexico_City');
					$date2today = date("_dmY_His");
					header("Content-type: application/octet-stream; charset=latin1");
					header("Content-Disposition: attachment; filename=rep_asegurado".$date2today.".xls");
					header("Pragma: no-cache");
					header("Expires: 0");
					$date2today = date("d/m/Y H:i:s");
				?>
				<title>REPORTE USUARIOS</title>
				<style type="text/css">
					.auto-style1 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: small;
					}
					.auto-style4 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
					}
					.auto-style5 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: medium;
					}
					.auto-style6 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-large;
						text-align: right;
						font-weight: normal;
					}
					.auto-style7 {
						font-size: small;
					}
					.auto-style8 {
						color: #3D5588;
					}
					.auto-style9 {
						color: #3AD4A7;
					}
								.auto-style11 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: right;
					}
					.auto-style12 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: small;
						text-align: center;
					}
					.auto-style13 {
						font-size: xx-small;
					}
					.auto-style14 {
						font-family: Arial, Helvetica, sans-serif;
						color: #FFFFFF;
						background-color: #3D5588;
						font-size: xx-small;
					}
					.auto-style15 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
					}
					.auto-style16 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: right;
					}
					.auto-style17 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: x-small;
						text-align: left;
					}
					.auto-style18 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
					}
								.auto-style19 {
						color: #3D5588;
						font-size: medium;
					}
					.auto-style20 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						text-align: center;
						background-color: #BFEADD;
					}
					.auto-style21 {
						font-family: Arial, Helvetica, sans-serif;
						font-size: xx-small;
						background-color: #BFEADD;
					}
				</style>
			</head>

			<body>
				<table>
					<thead>
						<tr>
							<th class="auto-style5" style="width: 75px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
							<th class="auto-style5" style="width: 350px">&nbsp;</th>
							<th class="auto-style5" style="width: 150px">&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5"><span class="auto-style8">human</span><span class="auto-style9">center</span></strong></th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">Reporte de Catálogos en Plataforma</th>
						</tr>
						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" style=" height: 27px;"><span class="auto-style19">online</span><sup><span class="auto-style13" style="color: rgb(34, 34, 34); font-family: arial, sans-serif; font-style: normal; font-variant-ligatures: normal; font-variant-caps: normal; font-weight: 400; letter-spacing: normal; orphans: 2; text-align: left; text-indent: 0px; text-transform: none; white-space: normal; widows: 2; word-spacing: 0px; -webkit-text-stroke-width: 0px; background-color: rgb(255, 255, 255); text-decoration-style: initial; text-decoration-color: initial; display: inline !important; float: none;">®</span></sup></th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" style=" height: 27px;"><?php echo $date2today; ?></th>
						</tr>
						<tr>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5">&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
							<th class="auto-style5" >&nbsp;</th>
						</tr>
						<tr>
							<th class="auto-style14" >ID</th>
							<th class="auto-style14" >Grupo</th>
							<th class="auto-style14" >Sub Grupo</th>
							<th class="auto-style14">Secuencia</th>
							<th class="auto-style14" >Clave</th>
							<th class="auto-style14" >Detalle</th>
							<th class="auto-style14" >Estatus</th>
						</tr>
					</thead>
					<tbody id="resultado">
						<?php
						$class18=" ";
                        if($asegurado): 
                            foreach ($asegurado as $elemento): 

								if ($class18 != "auto-style18")
								{
									$class18="auto-style18";
									$class4="auto-style4";
								}	
								else
								{
									$class18="auto-style20";
									$class4="auto-style21";							
								}

								if ( $elemento['cat_estatus_cve'] === 'ACTIVO')
								{ $color='dark';} else { $color='red';}
								?>
								
                                <tr>
                                    <td class=<?php echo $class18; ?>>
										<b>
											<?php echo $elemento['aseg_id']; ?> 
										</b>	
                                    </td>								
                                    <td class=<?php echo $class18; ?>>
										<b>
											<?php echo $elemento['cat_grupo']; ?> 
										</b>	
                                    </td>
                                    <td class=<?php echo $class18; ?>>
										<b>
											<?php echo $elemento['cat_grupo_nombre']; ?>
										</b>
									</td>
                                    <td class=<?php echo $class18; ?>>
										<b>
											<?php echo $elemento['cat_seq']; ?>
										</b>	
									</td>
									<td class=<?php echo $class18; ?>>
										<b>
											<?php echo $elemento['cat_cve']; ?>
										</b>	
									</td>
									<td class=<?php echo $class18; ?>>
										<b>
											<?php echo $elemento['cat_nombre']; ?>
										</b>	
									</td>	
									<td class=<?php echo $class18; ?>>
										<b>
											<?php echo $elemento['cat_estatus_cve']; ?>
										</b>	
									</td>									
                                </tr>
                            <?php 
                            endforeach;
                        endif;
                    ?>						
						
		
					</tbody>
				</table>
			</body>
		</html>
		<?php 
	}
		
	
}