<?php 
defined('BASEPATH') OR exit('No direct script access allowed');


if (!function_exists('get_options_nombre_n'))
{
    function get_options_nombre_n($grupo, $optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_catalogo($grupo);
        if($cat)
        {
            foreach ($cat as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['cat_nombre'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['cat_nombre'].'" '.$selected.'>'.$row['cat_nombre'].'</option>';
            }
        }
        return $options;
    }
}


if (!function_exists('get_pass_word'))
{
    function get_pass_word()
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        $res = $CI->cat->get_pass_word();
        return $res;
    }
}


if (!function_exists('get_quincena_nomina'))
{
    function get_quincena_nomina($fsm_f)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        $cats = $CI->cat->quincena_nomina($fsm_f);
        return $cats;
    }
}

if (!function_exists('get_serv_estatus'))
{
    function get_serv_estatus($serv_id)
    {
        $CI =& get_instance();
        $CI->load->model('servicio/Servicio_model','servicio');        
        $servs = $CI->servicio->get_serv_emp($serv_id);		
		$resultado=$servs['serv_estatus_cve'];
        return $resultado;
    }
}


if (!function_exists('chk_autoridad_total'))
{
    function chk_autoridad_total($id,$cat_grupo)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $cats = $CI->cat->chk_autoridad_total($id,$cat_grupo);
		
		$resultado=$cats[0]['cat_cve'];

        return $resultado;
    }
}


if (!function_exists('get_options_cat_seq_preselec'))
{
    function get_options_cat_seq_preselec($grupo, $optSelected = 0)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_catalogo($grupo);
        if($cat)
        {
            foreach ($cat as $row)
            {
                $selected = '';
                if($row['cat_seq'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['cat_seq'].'" '.$selected.'>'.$row['cat_nombre'].'</option>';
            }
        }
        return $options;
    }
}



if (!function_exists('validar_correo'))
{
    function validar_correo($optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
		$grupo='EMAIL_A';
        $options = 0;
        $cat = $CI->cat->get_catalogo($grupo);
        if($cat)
        {
            foreach ($cat as $row)
            {
                if($row['cat_cve'] == $optSelected)
                {
                    $options = 1;
                }
            }
        }
        return $options;
    }
}



if (!function_exists('get_options_paquetes_costo'))
{
    function get_options_paquetes_costo($emp_id, $optSelected = '')
    {
        $CI =& get_instance();
		$CI->load->model('empresa/Empresa_model','empresa');
        
        
        $options = '';
        $cat = $CI->empresa->get_paquetes_costo($emp_id);
        if($cat)
        {
            foreach ($cat as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['cost_nombre_pkt'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['cost_nombre_pkt'].'" '.$selected.'>'.$row['cost_nombre_pkt'].'  -  $'.$row['cost_monto'].'</option>';
            }
        }
        return $options;
    }
}


if (!function_exists('get_examenes_by_emp'))
{
    function get_examenes_by_emp($emp_id, $optSelected = '')
    {
        $CI =& get_instance();
		$CI->load->model('empresa/Empresa_model','empresa');
        
        
        $options = '';
        $cat = $CI->empresa->get_paquetes_costo($emp_id);
        if($cat)
        {
            foreach ($cat as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['cost_nombre_pkt'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['cost_id'].'" '.$selected.'>'.$row['cost_nombre_pkt'].'  -  $'.$row['cost_monto'].'</option>';
            }
        }
        return $options;
    }
}



if (!function_exists('get_nombre_examen_by_emp'))
{
    function get_nombre_examen_by_emp($cost_nombre_pkt,$emp_id)
    {
        $CI =& get_instance();
		$CI->load->model('empresa/Empresa_model','empresa');
        
        
        $options = '';
        $cat = $CI->empresa->get_nombre_examen_by_emp($cost_nombre_pkt,$emp_id);
        return $cat;
    }
}




if (!function_exists('get_x'))
{
    function get_x()
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        $res = $CI->cat->get_x();
        return $res;
    }
}


if (!function_exists('get_version'))
{
    function get_version()
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        $res = $CI->cat->get_version();
        return $res;
    }
}


if (!function_exists('get_options_secuencial_alfabetica'))
{
    function get_options_secuencial_alfabetica($grupo, $optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_catalogo_orden_cve($grupo);
        if($cat)
        {
            foreach ($cat as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['cat_cve'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_cve'].'  -  '.$row['cat_nombre'].'</option>';
            }
        }
        return $options;
    }
}

if (!function_exists('get_options_secuencial_alfabetica_2'))
{
    function get_options_secuencial_alfabetica_2($grupo, $optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_catalogo_orden_cve($grupo);
        if($cat)
        {
            foreach ($cat as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['cat_cve'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_nombre'].'</option>';
            }
        }
        return $options;
    }
}

if (!function_exists('get_cat_list_by_grupo'))
{
    function get_cat_list_by_grupo($grupo)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $cat = $CI->cat->get_catalogo_orden_cve($grupo);
        /*$row['cat_cve'].$row['cat_nombre']*/

        return $cat;
    }
}


if (!function_exists('get_list_examenes_by_grupo_nombre'))
{
    function get_list_examenes_by_grupo_nombre($cat_grupo_nombre)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $examenes = $CI->cat->get_catalogo_grupo_by_name_grupo('EXAMEN',$cat_grupo_nombre);

		$lista='';
		foreach ( $examenes as $row)
		{
			$lista.=$row['cat_cve'].',';
		}

        return $lista;
    }
}






if (!function_exists('get_options_servicios'))
{
    function get_options_servicios($grupo, $optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_catalogo($grupo);
        if($cat)
        {
            foreach ($cat as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['cat_cve'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
				$color='';
				if ($row['cat_nombre'] == 'CANCELADO')
				{ $color=' style="color: red;" ';}	
				elseif ($row['cat_nombre'] == 'EN PROCESO')
				{ $color=' style="color: green;" ';}
				elseif ($row['cat_nombre'] == 'CONCLUIDO')
				{ $color=' style="color: chocolate;" ';}
				elseif ($row['cat_nombre'] == 'FACTURADO')
				{ $color=' style="color: teal;" ';}
                elseif ($row['cat_nombre'] == 'SIN FACTURA')
				{ $color=' style="color: teal;" ';}
				elseif ($row['cat_nombre'] == 'PAGADO')
				{ $color=' style="color: blue;" ';}
				
                $options .= '<option '.$color.'value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_nombre'].'</option>';
            }
        }
        return $options;
    }
}



if (!function_exists('get_options_gasolina_by_order'))
{
    function get_options_gasolina_by_order($grupo, $optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_catalogo_inverso($grupo);
        if($cat)
        {
            foreach ($cat as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['cat_cve'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
				$color='';
				if ($row['cat_nombre'] == 'VACIO')
				{ $color=' style="color: red;  font-size: 200%; "';
				  $tanque=$row['cat_nombre'];
				}	
				elseif ($row['cat_nombre'] == '1/8')
				{ $color=' style="color: orange; font-size: 150%;"';
				  $tanque='<b>-'.$row['cat_nombre'].'</b>';
				}
				elseif ($row['cat_nombre'] == '1/4')
				{ $color=' style="color: black; font-size: 200%;"';
				  $tanque='<b>--'.$row['cat_nombre'].'</b>';
				}	
				elseif ($row['cat_nombre'] == '3/8')
				{ $color=' style="color: green; font-size: 150%;"';
				  $tanque='<b>-'.$row['cat_nombre'].'</b>';
				}
				elseif ($row['cat_nombre'] == '1/2')
				{ $color=' style="color: black; font-size: 200%;"';
				  $tanque='<b>--'.$row['cat_nombre'].'</b>';
				}				

				elseif ($row['cat_nombre'] == '5/8')
				{ $color=' style="color: green; font-size: 150%;"';
				  $tanque='<b>-'.$row['cat_nombre'].'</b>';
				}


				elseif ($row['cat_nombre'] == '3/4')
				{ $color=' style="color: black; font-size: 200%;"';
				  $tanque='<b>--'.$row['cat_nombre'].'</b>';
				}

				elseif ($row['cat_nombre'] == '7/8')
				{ $color=' style="color: green; font-size: 150%;"';
				  $tanque='<b>-'.$row['cat_nombre'].'</b>';
				}

				elseif ($row['cat_nombre'] == 'LLENO')
				{ $color=' style="color: blue; font-size: 200%;" ';
				  $tanque='<b>'.$row['cat_nombre'].'</b>';
				}
				
                $options .= '<option '.$color.'value="'.$row['cat_cve'].'" '.$selected.'>'.$tanque.'</option>';
            }
        }
        return $options;
    }
}



if (!function_exists('get_options'))
{
    function get_options($grupo, $optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_catalogo($grupo);
        if($cat)
        {
            foreach ($cat as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['cat_cve'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_nombre'].'</option>';
            }
        }
        return $options;
    }
}


if (!function_exists('get_options_salud_ocupaciones'))
{
    function get_options_salud_ocupaciones($grupo, $optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
		$CI->load->model('persona/Persona_model','usuarios');			
			
        
        $options = '';
        $cat = $CI->cat->get_catalogo($grupo);
        if($cat)
        {
            foreach ($cat as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['cat_cve'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_nombre'].'-'.get_empresa($row['cat_grupo_nombre']).'</option>';
            }
        }
        return $options;
    }
}



if (!function_exists('get_cat_nombre_unico'))
{
    function get_cat_nombre_unico($cat_grupo,$cat_grupo_nombre,$cat_cve)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $cat = $CI->cat->get_cat_nombre_unico($cat_grupo,$cat_grupo_nombre,$cat_cve);
        if($cat)
        {
            foreach ($cat as $row)
            {
                if($row['cat_cve'] == $cat_cve)
                {
                    $selected = $row['cat_nombre'];
                }
            }
        }
        return $selected;
    }
}



if (!function_exists('get_cve_by_cve'))
{
    function get_cve_by_cve($grupo, $optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $cat = $CI->cat->get_catalogo($grupo);
        if($cat)
        {
            foreach ($cat as $row)
            {
                if($row['cat_cve'] == $optSelected)
                {
                    $selected = $row['cat_cve'];
                }
            }
        }
        return $selected;
    }
}



if (!function_exists('get_cve_by_data'))
{
    function get_cve_by_data($grupo, $optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $cat = $CI->cat->get_catalogo($grupo);
        if($cat)
        {
            foreach ($cat as $row)
            {
                if($row['cat_cve'] == $optSelected)
                {
                    $selected = $row['cat_nombre'];
                }
            }
        }
        return $selected;
    }
}



if (!function_exists('get_options_grupo_by_name_grupo'))
{
    function get_options_grupo_by_name_grupo($grupo,$nombre, $optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_catalogo_grupo_by_name_grupo($grupo,$nombre);
        if($cat)
        {
            foreach ($cat as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['cat_cve'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_nombre'].'</option>';
            }
        }
        return $options;
    }
}




if (!function_exists('get_options_per_grupo'))
{
    function get_options_per_grupo($grupo, $optSelected)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $cat = $CI->cat->get_catalogo($grupo);
        if($cat)
        {
            foreach ($cat as $row)
            {
                if($row['cat_cve'] == $optSelected)
                {
                    $selected = $row['cat_nombre'];
                }
            }
        }
        return $selected;
    }
}





if (!function_exists('get_options_preselec'))
{
    function get_options_preselec($grupo, $optSelected = 0)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_catalogo($grupo);
        if($cat)
        {
            foreach ($cat as $row)
            {
                $selected = '';
                if($row['cat_seq'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_nombre'].'</option>';
            }
        }
        return $options;
    }
}



if (!function_exists('get_options_preselec_str'))
{
    function get_options_preselec_str($grupo, $optSelected = 0)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_catalogo($grupo);
        if($cat)
        {
            foreach ($cat as $row)
            {
                $selected = '';
                if($row['cat_cve'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_nombre'].'</option>';
            }
        }
        return $options;
    }
}



if (!function_exists('get_options_secuencia_preselec'))
{
    function get_options_secuencia_preselec($grupo, $optSelected = 0)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_catalogo_secuencia($grupo);
        if($cat)
        {
            foreach ($cat as $row)
            {
                $selected = '';
                if($row['cat_seq'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_nombre'].'</option>';
            }
        }
        return $options;
    }
}



if (!function_exists('get_radio_options'))
{
    function get_radio_options($grupo,$name = '', $optSelected = '', $separator = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_catalogo($grupo);
        if($cat)
        {
            foreach ($cat as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['cat_cve'] == $optSelected)
                {
                    $selected = 'checked="checked"';
                }
                //$options .= '<option value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_nombre'].'</option>';
                $options .= '<label class="radio-inline"><input type="radio" name="'.$name.'" value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_nombre'].'</label>'.$separator;
            }
        }
        return $options;
    }
}

if (!function_exists('contador_de_elementos_arreglos'))
{
    function contador_de_elementos_arreglos($arreglo,$separator = ';')
    {
			$i=0;
            foreach (explode($separator,$arreglo) as $detalle)
            {
                if(strlen($detalle) > 2)
                {
                    $i++;
                }
			}
        
        return $i;
    }
}



if (!function_exists('get_radio_options_secuencial_x'))
{
    function get_radio_options_secuencial_x($grupo,$name = '', $optSelected = '', $separator = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_catalogo_secuencial($grupo);
        if($cat)
        {
            foreach ($cat as $row)
            {  
                $selected = '';
                if( ($optSelected != '') && ( strtoupper($row['cat_cve']) == strtoupper($optSelected)) )
                {
                    $selected = 'checked';
                }
                //$options .= '<option value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_nombre'].'</option>';
                $options .= '<label class="radio-inline"><input  type="radio" name="'.$name.'" value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_nombre'].'</label>'.$separator;
            }
        }
        return $options;
    }
}


if (!function_exists('get_radio_options_secuencial'))
{
    function get_radio_options_secuencial($grupo,$name = '', $optSelected = '', $separator = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_catalogo_secuencial($grupo);
        if($cat)
        {
            foreach ($cat as $row)
            {  
                $selected = '';
                if($optSelected != '' && $row['cat_cve'] == $optSelected)
                {
                    $selected = 'checked';
                }
                //$options .= '<option value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_nombre'].'</option>';
                $options .= '<label class="radio-inline"><input type="radio" name="'.$name.'" value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_nombre'].'</label>'.$separator;
            }
        }
        return $options;
    }
}



if (!function_exists('get_radio_options_inversa'))
{
    function get_radio_options_inversa($grupo,$name = '', $optSelected = '', $separator = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_catalogo_inverso($grupo);
        if($cat)
        {
            foreach ($cat as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['cat_cve'] == $optSelected)
                {
                    $selected = 'checked="checked"';
                }
                //$options .= '<option value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_nombre'].'</option>';
                $options .= '<label class="radio-inline"><input type="radio" name="'.$name.'" value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_nombre'].'</label>'.$separator;
            }
        }
        return $options;
    }
}


if (!function_exists('get_cat_nombre'))
{
    function get_cat_nombre($grupo, $optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_catalogo($grupo);
        if($cat)
        {
            foreach ($cat as $row)
            {
                if($row['cat_cve'] == $optSelected)
                {
                    $options = $row['cat_nombre'];
                }
            }
        }
        return $options;
    }
}

if (!function_exists('get_cat_cve_by_nombre'))
{
    function get_cat_cve_by_nombre($grupo, $optSelected)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');

        $cat_name = $CI->cat->get_catalogo_by_name($grupo,$optSelected);
        return $cat_name;
    }
}


if (!function_exists('get_catalogo_by_clave'))
{
    function get_catalogo_by_clave($grupo, $optSelected)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');

        $cat_name = $CI->cat->get_catalogo_by_clave($grupo,$optSelected);
        return $cat_name;
    }
}



if (!function_exists('get_serv_monto_by_cve'))
{
    function get_serv_monto_by_cve($servicio, $optSelected)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');

        $cat_precio = $CI->cat->get_serv_monto_by_cve($servicio, $optSelected);
        return $cat_precio;
    }
}

if (!function_exists('get_serv_clte_doc_path'))
{
    function get_serv_clte_doc_path($clte_id, $servicio)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');

        $cat_precio = $CI->cat->get_serv_clte_doc_path($clte_id, $servicio);
        return $cat_precio;
    }
}

if (!function_exists('get_serv_clte_doc_path_by_table'))
{
    function get_serv_clte_doc_path_by_table($clte_id, $servicio,$table,$detalle='')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');

        $cat_precio = $CI->cat->get_serv_clte_doc_path_by_table($clte_id, $servicio,$table,$detalle);
        return $cat_precio;
    }
}

if (!function_exists('count_serv_clte_doc_path_by_table'))
{
    function count_serv_clte_doc_path_by_table($clte_id, $servicio,$table,$detalle='')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');

        $cat_precio = $CI->cat->count_serv_clte_doc_path_by_table($clte_id, $servicio,$table,$detalle);
        return $cat_precio;
    }
}

if (!function_exists('all_serv_clte_doc_path_by_table'))
{
    function all_serv_clte_doc_path_by_table($clte_id, $servicio,$table,$detalle='')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');

        $cat_precio = $CI->cat->all_serv_clte_doc_path_by_table($clte_id, $servicio,$table,$detalle);
        return $cat_precio;
    }
}

if (!function_exists('count_examen_form'))
{
    function count_examen_form($clte_id,$servicio,$table)
    {
		$CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');

        $cat_conteo = $CI->cat->count_examen_form($clte_id,$servicio,$table);
        return $cat_conteo;
    }
}

if (!function_exists('get_fsm_id_examen_form'))
{
    function get_fsm_id_examen_form($clte_id,$servicio,$table,$det='')
    {
		$CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
		
		if ($det=='')
		{	
			$cat_conteo = $CI->cat->get_fsm_id_examen_form($clte_id,$servicio,$table);
        }
		else
		{
			if ($det == 'CED')
			{
			 $deta='CEDULA';	
			}
			else
			{
			 $deta='POLI';
			}
			
			$cat_conteo = $CI->cat->get_fsm_id_examen_form_poli($clte_id,$servicio,$table,$deta);
		}	
		
		return $cat_conteo;
    }
}


if (!function_exists('all_fsm_id_examen_form'))
{
    function all_fsm_id_examen_form($clte_id,$servicio,$table,$det='')
    {
		$CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
		
		if ($det=='')
		{	
			$cat_conteo = $CI->cat->all_fsm_id_examen_form($clte_id,$servicio,$table);
        }
		else
		{
			if ($det == 'CED')
			{
			 $deta='CEDULA';	
			}
			else
			{
			 $deta='POLI';
			}
			
			$cat_conteo = $CI->cat->all_fsm_id_examen_form_poli($clte_id,$servicio,$table,$deta);
		}	
		
		return $cat_conteo;
    }
}


if (!function_exists('count_fsm_id_examen_form'))
{
    function count_fsm_id_examen_form($clte_id,$servicio,$table,$det='')
    {
		$CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
		
		if ($det=='')
		{	
			$cat_conteo = $CI->cat->count_fsm_id_examen_form($clte_id,$servicio,$table);
        }
		else
		{
			if ($det == 'CED')
			{
			 $deta='CEDULA';	
			}
			else
			{
			 $deta='POLI';
			}
			
			$cat_conteo = $CI->cat->count_fsm_id_examen_form_poli($clte_id,$servicio,$table,$deta);
		}	
		
		return $cat_conteo;
    }
}


if (!function_exists('get_empresa'))
{
    function get_empresa($emp_id)
    {
		if ($emp_id != 1)
		{	
        $CI =& get_instance();
        $CI->load->model('empresa/Empresa_model','empresa');
        
        $emp_razon_social = '';
        $emp = $CI->empresa->get_empresa($emp_id);
        if($emp)
        {
            $emp_razon_social = $emp['emp_razon_social'];
        }
        return $emp_razon_social;
		}
		else
		{
		 return "HUMAN CENTER REVIEW S.A. DE C.V."; 
		}
    }
}



if (!function_exists('get_cei'))
{
    function get_cei($cei_id)
    {
        $CI =& get_instance();
        $CI->load->model('empresa/Empresa_model','empresa');
        
        //$cei_alias = 'SIN CEI';
		$cei_alias = '';
        $emp = $CI->empresa->get_cei($cei_id);

		if($emp)
        {
            $cei_alias = $emp['cei_alias'];
        }
        return  $cei_alias;


    }
}


if (!function_exists('get_detail_cei'))
{
    function get_detail_cei($cei_id)
    {
        $CI =& get_instance();
        $CI->load->model('empresa/Empresa_model','empresa');
        $cei = $CI->empresa->get_cei($cei_id);
        return  $cei;
    }
}






if (!function_exists('es_despacho'))
{
    function es_despacho($emp_id)
    {
        $CI =& get_instance();
        $CI->load->model('empresa/Empresa_model','empresa');
       
		$alias = 0;
        $emp = $CI->empresa->get_empresa($emp_id);

		if($emp)
        {
            $alias = $emp['emp_desp'];
        }
        return  $alias;


    }
}


if (!function_exists('get_doc_cotizacion'))
{
    function get_doc_cotizacion($suc_id)
    {
        $CI =& get_instance();
        $CI->load->model('empresa/Empresa_model','empresa');
        
        $doc_cotiza = 'error';
        $suc = $CI->empresa->get_una_cotizacion($suc_id);
        if($suc)
        {
             $doc_cotizas= $suc['doc_path'];
        }
        return  $doc_cotiza;
    }
}


if (!function_exists('get_un_consultorio'))
{
    function get_un_consultorio($suc_id)
    {
        $CI =& get_instance();
        $CI->load->model('empresa/Empresa_model','empresa');
        
        $suc_alias = '';
        $suc = $CI->empresa->get_un_consultorio($suc_id);
        if($suc)
        {
            $suc_alias= $suc['cons_razon_social'];
        }
        return $suc_alias;
    }
}



if (!function_exists('get_una_sucursal'))
{
    function get_una_sucursal($suc_id)
    {
        $CI =& get_instance();
        $CI->load->model('empresa/Empresa_model','empresa');
        
        $suc_alias = '';
        $suc = $CI->empresa->get_una_sucursal($suc_id);
        if($suc)
        {
            $suc_alias= $suc['suc_alias'];
        }
        return $suc_alias;
    }
}




if (!function_exists('get_sucursal_gsi'))
{
    function get_sucursal_gsi($suc_id)
    {
        $CI =& get_instance();
        $CI->load->model('empresa/Empresa_model','empresa');
        
        $suc_alias = '';
        $suc = $CI->empresa->get_sucursal_gsi($suc_id);
        if($suc)
        {
            $suc_alias= $suc['suc_gsi_nombre'];
        }
        return $suc_alias;
    }
}

if (!function_exists('get_empresa_gsi'))
{
    function get_empresa_gsi($emp_id)
    {
        $CI =& get_instance();
        $CI->load->model('empresa/Empresa_model','empresa');
        
        $suc_alias = '';
        $suc = $CI->empresa->get_empresa_gsi($emp_id);
        if($suc)
        {
            $suc_alias= $suc['emp_gsi_nombre'];
        }
        return $suc_alias;
    }
}

if (!function_exists('get_empresa_razon_social_gs'))
{
    function get_empresa_razon_social_gsi($emp_id)
    {
        $CI =& get_instance();
        $CI->load->model('empresa/Empresa_model','empresa');
        
        $suc_alias = '';
        $suc = $CI->empresa->get_empresa_gsi($emp_id);
        if($suc)
        {
            $suc_alias= $suc['emp_razon_social'];
        }
        return $suc_alias;
    }
}


if (!function_exists('get_ajuste_logo_gsi'))
{
    function get_ajuste_logo_gsi($emp_id)
    {
        $CI =& get_instance();
        $CI->load->model('empresa/Empresa_model','empresa');
        
        $suc_alias = '';
        $suc = $CI->empresa->get_empresa_gsi($emp_id);
        if($suc)
        {
            $suc_alias= $suc['emp_ajuste_logo'];
        }
        return $suc_alias;
    }
}

if (!function_exists('get_logo_gsi'))
{
    function get_logo_gsi($emp_id)
    {
        $CI =& get_instance();
        $CI->load->model('empresa/Empresa_model','empresa');
        
        $suc_alias = '';
        $suc = $CI->empresa->get_empresa_gsi($emp_id);
        if($suc)
        {
            $suc_alias= $suc['emp_logo'];
        }
        return $suc_alias;
    }
}

if (!function_exists('get_especialidad'))
{
    function get_especialidad($esp_id)
    {
        $options = '';
            $CI =& get_instance();
            $CI->load->model('cat/Catalogo_model','cat');

            $options = 'SIN ESPECIALIDAD';
            $cat = $CI->cat->get_cat_esp_med_by_id($esp_id);
            if($cat)
            {
                $options = $cat['esp_especialidad'];
            }
        return $options;
    }
}

if (!function_exists('get_especialidades'))
{
    function get_especialidades($esp_id = '')
    {
        $options = '';
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cate');

        $options = '';
        $cat = $CI->cate->get_cat_esp_med();
        if($cat)
        {
            foreach ($cat as $row)
            {
                $selected = '';
                if($row['esp_id'] == $esp_id)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['esp_id'].'" '.$selected.'>'.$row['esp_especialidad'].'</option>';
            }
        }
        return $options;
    }
}


	if (!function_exists('consultorios_gsi_option'))
	{
		function consultorios_gsi_options($optSelected = '')
		{	$CI =& get_instance();
			$CI->load->model('empresa/Empresa_model','empresa');
			$emp = $CI->empresa->consultorios_gsi();	
			$options = '';
			if($emp)
			{
				foreach ($emp as $row)
				{
					$selected = '';
					
					if($optSelected != '' && $row['emp_id'] == $optSelected)
					{
						$selected = 'selected="selected"';
					}
					$options .= '<option value="'.$row['emp_id'].'" '.$selected.'>'.$row['emp_razon_social'].'</option>';
				}
			}
			return $options;			

		}		
		 
	}

	if (!function_exists('consultorios_gsi'))
	{
		function consultorios_gsi()
		{	$CI =& get_instance();
			$CI->load->model('empresa/Empresa_model','empresa');
			$emp = $CI->empresa->consultorios_gsi();	
			return $emp;
		}		
		 
	}


if (!function_exists('get_un_cei'))
{
    function get_un_cei($cei_id = '')
    {
		$options = '';
		$CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cate');
        $options = '';
		$cat = $CI->cate->get_cat_ceis();
		
        if($cat)
        {
           foreach ($cat as $row)
            {
                $selected = '';
                if($row['cei_id'] == $cei_id)
                {
                    $selected = 'selected="selected"';
					$options .= '<option value="'.$row['cei_id'].'" '.$selected.'->'.$row['cei_alias'].'</option>';
                }                
            }
		} 
        return $options;
    }
}



if (!function_exists('get_los_ceis'))
{
    function get_los_ceis($cei_id = '')
    {
		$options = '';
		$CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cate');
        $options = '';
		$cat = $CI->cate->get_cat_ceis();
		
        if($cat)
        {
           foreach ($cat as $row)
            {
                $selected = '';
                if($row['cei_id'] == $cei_id)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['cei_id'].'" '.$selected.'->'.$row['cei_alias'].'</option>';
            }
		} 
        return $options;
    }
}

if (!function_exists('get_los_despachos'))
{
    function get_los_despachos($desp_id = '')
    {
		$options = '';
		$CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cate');
        $options = '';
		$cat = $CI->cate->get_cat_los_despachos();
		
        if($cat)
        {
           foreach ($cat as $row)
            {
                $selected = '';
                if($row['emp_desp'] == $desp_id)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['emp_desp'].'" '.$selected.'->'.$row['emp_razon_social'].'</option>';
            }
		} 
        return $options;
    }
}


if (!function_exists('get_los_ceis_lista'))
{
    function get_los_ceis_lista($cei_id = '')
    {
		$options = '';
		$CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cate');
        $options = '';
		$cat = $CI->cate->get_cat_ceis();
		
        if($cat)
        {
           foreach ($cat as $row)
            {
                $selected = '';
                if($row['cei_id'] == $cei_id)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['cei_id'].'" '.$selected.'->'.$row['cei_alias'].'</option>';
            }
		} 
        return $options;
    }
}




if (!function_exists('get_los_ceis_con_consulta'))
{
    function get_los_ceis_con_consulta($cei_id = '')
    {
		$options = '';
		$CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cate');
        $options = '';
		$cat = $CI->cate->get_cat_ceis();
		
        if($cat)
        {
           foreach ($cat as $row)
            {
                $selected = '';
                if($row['cei_id'] == $cei_id)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['cei_id'].'" '.$selected.'->'.$row['cei_alias'].'</option>';
            }
			$selected = '';
			if($cei_id == 0 )
			{
				$selected = 'selected="selected"';
			}
			$options .= '<option value="'.'0'.'" '.$selected.'->'.'CONSULTORIO MÉDICO DE LA EMPRESA'.'</option>';

		} 
        return $options;
    }
}
/***********************************************************/
if (!function_exists('get_los_ceis_con_cliente_ss'))
{
    function get_los_ceis_con_cliente_ss($cei_id = '')
    {
		$options = '';
		$CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cate');
        $options = '';
		$cat = $CI->cate->get_cat_ceis();
		
        if($cat)
        {
           foreach ($cat as $row)
            {
                $selected = '';
                if($row['cei_id'] == $cei_id)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['cei_id'].'" '.$selected.'->'.$row['cei_alias'].'</option>';
            }
			$selected = '';
			if($cei_id == 0 )
			{
				$selected = 'selected="selected"';
			}
			$options .= '<option value="'.'0'.'" '.$selected.'->'.'INSTALACIONES DEL CLIENTE'.'</option>';

		} 
        return $options;
    }
}
/***********************************************************/
if (!function_exists('get_los_ceis_con_cliente_ss'))
{
    function get_los_ceis_con_cliente_ss($cei_id = '')
    {
		$options = '';
		$CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cate');
        $options = '';
		$cat = $CI->cate->get_cat_ceis();
		
        if($cat)
        {
           foreach ($cat as $row)
            {
                $selected = '';
                if($row['cei_id'] == $cei_id)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['cei_id'].'" '.$selected.'->'.$row['cei_alias'].'</option>';
            }
			$selected = '';
			if($cei_id == 0 )
			{
				$selected = 'selected="selected"';
			}
			$options .= '<option value="'.'0'.'" '.$selected.'->'.'INSTALACIONES DEL CLIENTE'.'</option>';

		} 
        return $options;
    }
}
/***********************************************************/
if (!function_exists('get_los_ceis_con_cliente'))
{
    function get_los_ceis_con_cliente($cei_id = '')
    {
		$options = '';
		$CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cate');
        $options = '';
		$cat = $CI->cate->get_cat_ceis();
		
        if($cat)
        {
           foreach ($cat as $row)
            {
                $selected = '';
                if($row['cei_id'] == $cei_id)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['cei_id'].'" '.$selected.'->'.$row['cei_alias'].'</option>';
            }
			$selected = '';
			if($cei_id == 0 )
			{
				$selected = 'selected="selected"';
			}
			$options .= '<option value="'.'0'.'" '.$selected.'->'.'EN DOMICILIO INDICADO'.'</option>';

		} 
        return $options;
    }
}
/***********************************************************/
if (!function_exists('get_los_seguros_con_cliente'))
{
    function get_los_seguros_con_cliente($seguros_id = '')
    {
		$options = '';
		$CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cate');
        $options = '';
		$cat = $CI->cate->get_cat_seguros();
		
        if($cat)
        {
           foreach ($cat as $row)
            {
                $selected = '';
                if($row['seguros_id'] == $seguros_id)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['seguros_id'].'" '.$selected.'->'.$row['seguros_alias'].'</option>';
            }
			$selected = '';
			if($seguros_id == 0 )
			{
				$selected = 'selected="selected"';
			}
			$options .= '<option value="'.'0'.'" '.$selected.'->'.'EN EL DOMICILIO DEL EVALUADO'.'</option>';

		} 
        return $options;
    }
}
/**********************************************************/
if (!function_exists('get_cie_nombre'))
{
    function get_cie_nombre($cie_clave = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cate');
        $cat = $CI->cate->get_cie_by_clave($cie_clave);
        if($cat)
        {
            return $cat['cie_nombre'];
        }
        else 
        {
            return FALSE;
        }
    }
}

if (!function_exists('get_cat_nombre_var'))
{
    function get_cat_nombre_var($grupo, $optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_catalogo_cat($grupo);
        if($cat)
        {
            return $cat;
        }
    }
}


if (!function_exists('get_cat_grupo_nombre_clave'))
{
    function get_cat_grupo_nombre_clave($cat_clave,$cat_grupo)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $cat = $CI->cat->get_cat_grupo_nombre_clave($cat_clave,$cat_grupo);
        if($cat)
        {
            return $cat;
        }
    }
}


if (!function_exists('get_cat_nombre_id'))
{
    function get_cat_nombre_id($cat_clave,$cat_grupo)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $cat = $CI->cat->get_cat_nombre_id($cat_clave,$cat_grupo);
        return $cat;
    }
}


if (!function_exists('get_cat_grupo_nombre_var'))
{
    function get_cat_grupo_nombre_var($grupo, $optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_grupo_nombre($grupo);
        if($cat)
        {
            return $cat;
        }
    }
}




if (!function_exists('get_grupo_grupo_nombre'))
{
    function get_grupo_grupo_nombre($cat_grupo, $cat_grupo_nombre)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_grupo_grupo_nombre($cat_grupo, $cat_grupo_nombre);
        if($cat)
        {
            return $cat;
        }
    }
}


if (!function_exists('get_grupo_grupo_nombre_seq'))
{
    function get_grupo_grupo_nombre_seq($cat_seq,$cat_grupo, $cat_grupo_nombre)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_grupo_grupo_nombre_seq($cat_seq,$cat_grupo, $cat_grupo_nombre);
        if($cat)
        {
            return $cat;
        }
    }
}


if (!function_exists('get_cat_grupo_clave_var'))
{
    function get_cat_grupo_clave_var($grupo, $cat_grupo_nombre)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_grupo_clave($grupo,$cat_grupo_nombre);
        if($cat)
        {
            return $cat;
        }
    }
}


if (!function_exists('get_options_preselec_g_gm'))
{
    function get_options_preselec_g_gm($grupo, $cat_grupo_nombre, $optSelected = 0)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_grupo_clave($grupo, $cat_grupo_nombre);
		
        if($cat)
        { 	$free=0;
            foreach ($cat as $row)
            {
                $selected = '';
				
                if ($row['cat_cve'] === $optSelected)
                {
                    $selected = 'selected="selected"';
					$free=1;
                }
                $options .= '<option value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_nombre'].'</option>';
            }
			if ($free == 0)
			{	
				$options .= '<option value="" selected="selected">Selecciona</option>';
			} 
		}
        return $options;
    }
}

if (!function_exists('get_cat_grupo_nombre_clave_var'))
{
    function get_cat_grupo_nombre_clave_var($clave,$grupo, $cat_grupo_nombre)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_grupo_nombre_clave($clave,$grupo,$cat_grupo_nombre);
        if($cat)
        {
            return $cat;
        }
    }
}


if (!function_exists('get_nombre_de_examen'))
{
    function get_nombre_de_examen($clave,$grupo)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');

        $cat = $CI->cat->get_grupo_nombre_clave_sin_grupo_nombre($clave,$grupo);
        if($cat)
        {
            return $cat;
        }
    }
}


if (!function_exists('get_nombre_de_examen_por_empresa'))
{
    function get_nombre_de_examen_por_empresa($paquete,$emp_id)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');

        $cat = $CI->cat->get_nombre_de_examen_por_empresa($paquete,$emp_id);
		
        if($cat)
        {
            return $cat;
        }
    }
}


if (!function_exists('get_cat_nombre_cache'))
{
    function get_cat_nombre_cache($array, $optSelected = '')
    {
        $options = '';
        if($array)
        {
            foreach ($array as $row)
            {
                if($row['cat_cve'] == $optSelected)
                {
                    $options = $row['cat_nombre'];
                }
            }
        }
        return $options;
    }
}

if (!function_exists('get_options_relig'))
{
    function get_options_relig($optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_religion();
        if($cat)
        {
            foreach ($cat as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['relig_id'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['relig_id'].'" '.$selected.'>'.$row['relig_descrip'].'</option>';
            }
        }
        return $options;
    }
}

if (!function_exists('get_options_religiones'))
{
    function get_options_religiones($optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_religiones();
        if($cat)
        {
            foreach ($cat as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['relig_id'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['relig_id'].'" '.$selected.'>'.$row['relig_descrip'].'</option>';
            }
        }
        return $options;
    }
}




if (!function_exists('get_options_relig_nombre'))
{
    function get_options_relig_nombre($optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_religion();
        if($cat)
        {
            foreach ($cat as $row)
            {
                if($optSelected != '' && $row['relig_id'] == $optSelected)
                {
                    $options = $row['relig_descrip'];
                }
            }
        }
        return $options;
    }
}


if (!function_exists('get_options_religiones_nombre'))
{
    function get_options_religiones_nombre($optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_religiones();
        if($cat)
        {
            foreach ($cat as $row)
            {
                if($optSelected != '' && $row['relig_id'] == $optSelected)
                {
                    $options = $row['relig_descrip'];
                }
            }
        }
        return $options;
    }
}


if (!function_exists('get_radio_options_var_secuencial'))
{
    function get_radio_options_var_secuencial($grupo)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $cat = $CI->cat->get_catalogo_secuencia($grupo);
        if($cat)
        {
            return $cat;
        }
    }
}

if (!function_exists('get_radio_options_var'))
{
    function get_radio_options_var($grupo)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $cat = $CI->cat->get_catalogo($grupo);
        if($cat)
        {
            return $cat;
        }
    }
}


if (!function_exists('get_radio_options_var_order'))
{
    function get_radio_options_var_order($grupo)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $cat = $CI->cat->get_catalogo_secuencial($grupo);
        if($cat)
        {
            return $cat;
        }
    }
}


if (!function_exists('get_radio_options_cache'))
{
    function get_radio_options_cache($array, $name, $optSelected = '')
    {
        $options = '';
        if($array)
        {
            foreach ($array as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['cat_cve'] == $optSelected)
                {
                    $selected = 'checked="checked"';
                }
                //$options .= '<option value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_nombre'].'</option>';
                $options .= '<label class="radio-inline"><input type="radio" name="'.$name.'" value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_nombre'].'</label>';
            }
        }
        return $options;
    }
}

if (!function_exists('get_checkbox_options'))
{
    function get_checkbox_options($grupo, $name = '', $optsSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_catalogo($grupo);
        if($cat)
        {
            foreach ($cat as $row)
            {
                $selected = '';
                if($optsSelected != '')
                {
                    if(in_array($row['cat_cve'],$optsSelected))
                    {
                        $selected = 'checked="checked"';
                    }
                }
                $options .= '<label class="checkbox-inline"><input type="checkbox" name="'.$name.'" value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_nombre'].'</label>&nbsp;&nbsp;&nbsp;';
            }
        }
        return $options;
    }
}


if (!function_exists('get_checkbox_options_secuencial'))
{
    function get_checkbox_options_secuencial($grupo, $name = '', $optsSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = '';
        $cat = $CI->cat->get_catalogo_secuencial($grupo);
        if($cat)
        {
            foreach ($cat as $row)
            {
                $selected = '';
                if($optsSelected != '')
                {
                    if(in_array($row['cat_cve'],$optsSelected))
                    {
                        $selected = 'checked="checked"';
                    }
                }
                $options .= '<label class="checkbox-inline"><input type="checkbox" name="'.$name.'" value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_nombre'].'</label>&nbsp;&nbsp;&nbsp;';
            }
        }
        return $options;
    }
}



if (!function_exists('get_checkbox_nombre'))
{
    function get_checkbox_nombre($grupo, $optsSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $options = array();
        $cat = $CI->cat->get_catalogo($grupo);
        if($cat)
        {
            foreach ($cat as $row)
            {
                if($optsSelected != '')
                {
                    if(in_array($row['cat_cve'],$optsSelected))
                    {
                        $options[] = $row['cat_nombre'];
                    }
                }
            }
        }
        return implode(',&nbsp;', $options);
    }
}

if (!function_exists('get_cat_estado'))
{
    function get_cat_estado($edo_cve)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $cat = $CI->cat->get_estado($edo_cve);
        if($cat)
        {
            return $cat['estado'];
        }
        return $edo_cve;
    }
}


if (!function_exists('get_asignados_by_categoria'))
{
    function get_asignados_by_categoria($categoria,$empresa)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');
        
        $cats = $CI->cat->get_catalogo_grupo_by_name_grupo($categoria,$empresa);
		
		$resultado='';
		foreach($cats  as $cat):
			$resultado.=';';
			$resultado.=$cat['cat_cve'];
		endforeach;
		$resultado.=';';
        return $resultado;
    }
}


if (!function_exists('get_servicios_options'))
{
    function get_servicios_options($emp_id, $optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('servicio/Servicio_model','servicio');
        
        $array = $CI->servicio->get_by_empresa_l($emp_id);
        $options = '';
        if($array)
        {
            foreach ($array as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['serv_id'] == $optSelected)
                {
                    $selected = 'checked="checked"';
                }
                //$options .= '<option value="'.$row['serv_id'].'" '.$selected.'>'.$row['serv_orden'].'</option>';
				$options .= '<option value="'.$row['serv_id'].'" '.$selected.'>'.'Orden de Servicio: '.$row['serv_id'].' - Pedido: '.$row['serv_orden'].'</option>';
				//echo  '<option value="'.$ordenes['serv_id'].'" '.$selected.'>'.'Orden de Servicio:'.$ordenes['serv_id'].' Pedido:'.$ordenes['serv_orden'].'</option>';
				
				
            }
        }
        else 
        {
            return '<option value="">NO HAY ORDEN DE SERVICIO ACTIVA</option>';
        }
        return $options;
    }
}


if (!function_exists('get_servicios_para_evaluados'))
{
    function get_servicios_para_evaluados($emp_id, $optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('servicio/Servicio_model','servicio');
        
        $array = $CI->servicio->get_servicios_a_empresa($emp_id);
		
        $options = '';
        if($array)
        {
            foreach ($array as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['serv_id'] == $optSelected)
                {
                    $selected = 'checked="checked"';
                }
                $options .= '<option value="'.$row['serv_id'].'" '.$selected.'>'.get_empresa($row['emp_id']).' OS:'.$row['serv_id'].' OV:'.$row['serv_orden'].'</option>';
            }
        }
        else 
        {
            return '<option value="">NO HAY ORDEN DE SERVICIO ACTIVA</option>';
        }
        return $options;
    }
}



if (!function_exists('get_servicios_realizados'))
{
    function get_servicios_realizados($serv_id)
    {
        $CI =& get_instance();
        $CI->load->model('stats/Estadisticas_model','stats');
        
        $array = $CI->stats->estudios_realizados($serv_id);
        $options = '';
        if($array)
        {
            return $array['total'];
        }
        else 
        {
            return 0;
        }
        return $options;
    }
}

if (!function_exists('get_options_cache'))
{
    function get_options_cache($array, $optSelected = '')
    {
        $options = '';
        if($array)
        {
            foreach ($array as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['cat_cve'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_nombre'].'</option>';
                //$options .= '<label class="radio-inline"><input type="radio" name="'.$name.'" value="'.$row['cat_cve'].'" '.$selected.'>'.$row['cat_nombre'].'</label>';
            }
        }
        return $options;
    }
}

if (!function_exists('get_cat_evaluadores'))
{
    function get_cat_evaluadores($optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('evaluadores/Evaluadores_model','evaluadores');
        
        $options = '';
        $array = $CI->evaluadores->get_evaluadores();
        if($array)
        {
            foreach ($array as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['ev_id'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['ev_id'].'"'.$selected.'>'.$row['ev_nombre'].' '.$row['ev_paterno'].' '.$row['ev_materno'].'</option>';
            }
        }
        return $options;
    }
}

if (!function_exists('get_servicio'))
{
    function get_servicio($serv_id)
    {
        $CI =& get_instance();
        $CI->load->model('servicio/Servicio_model','servicio');
        
        $array = $CI->servicio->get($serv_id);
        if($array)
        {
            return $array;
        }
        else
        {
            return 'No existe el servicio';
        }
        
    }
}

if (!function_exists('get_consultorio_n'))
{
    function get_consultorio_n($cons_id)
    {
        $CI =& get_instance();
        $CI->load->model('consultorio/Consultorios_model','consultorio');
        
        $nombrec = '';
        $cons = $CI->consultorio->get_consultorio($cons_id);
        if($cons)
        {
        $nombrec = $cons['cons_alias'];
        }
        return $nombrec;
    }
}

if (!function_exists('get_evaluador'))
{
    function get_evaluador($ev_id)
    {
        $CI =& get_instance();
        $CI->load->model('evaluadores/Evaluadores_model','evaluadores');
        
        $nombre = '';
        $ev= $CI->evaluadores->get_evaluador($ev_id);
        if($ev)
        {
            $nombre = $ev['ev_nombre']." ". $ev['ev_paterno']." ".$ev['ev_materno'];
        }
        return $nombre;
    }
}

if (!function_exists('get_ev_cedula'))
{
    function get_ev_cedula($ev_id)
    {
        $CI =& get_instance();
        $CI->load->model('evaluadores/Evaluadores_model','evaluadores');
        
        $cedula = '';
        $ev= $CI->evaluadores->get_evaluador($ev_id);
        if($ev)
        {
            $cedula = $ev['ev_cedula'];
        }
        return $cedula;
    }
}

if (!function_exists('get_costos_paquetes_empresa'))
{
    function get_costos_paquetes_empresa($emp_id)
    {
        $CI =& get_instance();
        $CI->load->model('empresa/Empresa_model','empresa');

        $ev= $CI->empresa->get_costos_paquetes($emp_id);

        return $ev;
    }
}


if (!function_exists('get_costos_paquetes_outsourcing_empresa'))
{
    function get_costos_paquetes_outsourcing_empresa($emp_id)
    {
        $CI =& get_instance();
        $CI->load->model('empresa/Empresa_model','empresa');

        $ev= $CI->empresa->get_costos_outsourcing_paquetes($emp_id);

        return $ev;
    }
}




if (!function_exists('get_cve_exam_per_pakts_by_empresa'))
{
    function get_cve_exam_per_pakts_by_empresa($emp_id,$pakt)
    {
        $CI =& get_instance();
        $CI->load->model('empresa/Empresa_model','empresa');

        $ev= $CI->empresa->get_cve_exam_per_pakts_by_empresa($emp_id,$pakt);

        return $ev;
    }
}


if (!function_exists('get_paquete_desde_servicio'))
{
    function get_paquete_desde_servicio($serv_id,$pakt)
    {
        $CI =& get_instance();
        $CI->load->model('servicio/Servicio_model','servicio');

        $ev= $CI->servicio->get_paquete_desde_serv($serv_id,$pakt);

        return $ev;
    }
}

if (!function_exists('get_costo_unitario'))
{
    function get_costo_unitario($examen, $costos)
    {
        $costo = array();        
        if($examen)
        {
            foreach ($costos as $row)
            {
                if($examen['cat_cve'] == $row['cost_examen_cve'])
                {
                    $costo = $row;
                }
            }
        }
        if(empty($costo))
        {
            $costo['cost_monto'] = 0;
        }
        return $costo;
    }
}

if (!function_exists('get_costo_emp'))
{
    function get_costo_emp($emp_id) {
        $costo = array();        
        if($examen) {
            foreach ($costos as $row) {
                if($examen['cat_cve'] == $row['cost_examen_cve']) {
                    $costo = $row;
                }
            }
        }
        if(empty($costo)) {
            $costo['cost_monto'] = 0;
        }
        return $costo;
    }
}


if (!function_exists('get_empresas_categoria_options'))
{
    function get_empresas_categoria_options($categoria,$optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('empresa/Empresa_model','empresa');
        $emp = $CI->empresa->trae_empresas_giro($categoria);//$CI->empresa->get_all_empresas();
        if($emp)
        {
            foreach ($emp as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['emp_id'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['emp_id'].'" '.$selected.'>'.$row['emp_razon_social'].'</option>';
            }
        }
        return $options;
    }
}


if (!function_exists('get_empresas_by_categoria_options'))
{
    function get_empresas_by_categoria_options($categoria,$optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('empresa/Empresa_model','empresa');
        $emp = $CI->empresa->trae_empresas_categoria($categoria);
        if($emp)
        {
            foreach ($emp as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['emp_id'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['emp_id'].'" '.$selected.'>'.$row['emp_razon_social'].'</option>';
            }
        }
        return $options;
    }
}


if (!function_exists('get_empresas_options'))
{
    function get_empresas_options($optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('empresa/Empresa_model','empresa');
        $emp = $CI->empresa->trae_empresas();//$CI->empresa->get_all_empresas();
        if($emp)
        {
            foreach ($emp as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['emp_id'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['emp_id'].'" '.$selected.'>'.$row['emp_razon_social'].'</option>';
            }
        }
        return $options;
    }
}

if (!function_exists('get_empresas_activas_no_gsi'))
{
    function get_empresas_activas_no_gsi($optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('empresa/Empresa_model','empresa');
        $emp = $CI->empresa->trae_empresas_activas_no_gsi();//$CI->empresa->get_all_empresas();
        if($emp)
        {
            foreach ($emp as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['emp_id'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['emp_id'].'" '.$selected.'>'.$row['emp_razon_social'].'</option>';
            }
        }
        return $options;
    }
}


if (!function_exists('get_empresas_options_os'))
{
    function get_empresas_options_os($optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('empresa/Empresa_model','empresa');
        $emp = $CI->empresa->trae_empresas_os();//$CI->empresa->get_all_empresas();
        if($emp)
        {
            foreach ($emp as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['emp_id'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['emp_id'].'" '.$selected.'>'.$row['emp_razon_social'].'</option>';
            }
        }
        return $options;
    }
}


if (!function_exists('get_all_empresas_subcorp'))
{
    function get_all_empresas_subcorp($corporativo, $subcorporativo,$optSelected='')
    {
        $CI =& get_instance();
        $CI->load->model('empresa/Empresa_model','empresa');
        $emp = $CI->empresa->get_all_empresas_subcorp($corporativo, $subcorporativo);
        if($emp)
        {
            foreach ($emp as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['emp_id'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['emp_id'].'" '.$selected.'>'.$row['emp_razon_social'].'</option>';
            }
        }
        return $options;
    }
}


if (!function_exists('get_empresas_gsi_options'))
{
    function get_empresas_gsi_options($optSelected = '')
    {
        $CI =& get_instance();
        $CI->load->model('empresa/Empresa_model','empresa');
        $emp = $CI->empresa->get_all_empresas_gsi();//$CI->empresa->get_all_empresas();
        if($emp)
        {
            foreach ($emp as $row)
            {
                $selected = '';
                if($optSelected != '' && $row['emp_id'] == $optSelected)
                {
                    $selected = 'selected="selected"';
                }
                $options .= '<option value="'.$row['emp_id'].'" '.$selected.'>'.$row['emp_razon_social'].'</option>';
            }
        }
        return $options;
    }
}

if (!function_exists('get_emp_id_gsi_options'))
{
    function get_emp_id_gsi_options()
    {
        $CI =& get_instance();
        $CI->load->model('empresa/Empresa_model','empresa');
        $emp = $CI->empresa->get_all_empresas_gsi();//$CI->empresa->get_all_empresas();
        if($emp)
        {
			$i=0;
            foreach ($emp as $row)
            {
                $res[$i]=$row['emp_id'];
				$i++;
            }
        }
        return $res;
    }
}

if (!function_exists('get_costo'))
{
    function get_costo($examen, $costos)
    {
        $costo = 0;
        if( ! empty($costos))
        {
            foreach ($costos as $row)
            {
                if($examen == $row['cost_examen_cve'])
                {
                    $costo = $row['cost_monto'];
                }
            }
        }
        return $costo;
    }
}



if (!function_exists('get_tipo_foto_socio'))
{
    function get_tipo_foto_socio($fsm_id, $tipo_foto)
    {
        $CI =& get_instance();
        $CI->load->model('cat/Catalogo_model','cat');;
		
        $res = $CI->cat->get_tipo_foto_socio($fsm_id, $tipo_foto);
		
		
        if($res)
        {
			return 1;
        }
		else
		{
			return 0;
		}	
        
    }
}






if (!function_exists('estadisticas_recetas_gsi'))
{
    function estadisticas_recetas_gsi($todas_las_recetas,$genero,$edad_ini,$edad_fin,$modo,$titulo_reporte,$titulo_consultorio,$empresa)
    {

		//filtro de edad
		$indice=0;
		$mujeres=0;
		$hombres=0;
		//$edad_total_mujeres=0;
		//$edad_total_hombres=0;
		$edad_total=0;
		$edad_promedio=0;
		
		$edad_promedio_mujeres=0;
		
		$edad_promedio_hombres=0;
		$edad_minimo_mujeres=3000;
		$edad_minimo_hombres=3000;
		$edad_maximo_mujeres=0;
		$edad_maximo_hombres=0;	

		$peso_total=0;
		$peso_promedio=0;
		$peso_promedio_mujeres=0;
		$peso_maximo_mujeres=0;
		$peso_maximo_hombres=0;
		$peso_promedio_hombres=0;
		$peso_minimo_mujeres=500;
		$peso_minimo_hombres=500;							

		$imc_total=0;
		$imc_promedio=0;
		$imc_promedio_mujeres=0;
		$imc_maximo_mujeres=0;
		$imc_maximo_hombres=0;
		$imc_promedio_hombres=0;
		$imc_minimo_mujeres=500;
		$imc_minimo_hombres=500;			
		
		$diagnosticos='';
		$alergias='';
			
		foreach($todas_las_recetas as $la_receta)
		{

			$CI =& get_instance();
			$CI->load->model('persona/Persona_model','paciente');
			$paciente = $CI->paciente->get_especial($la_receta['clte_id'],$genero);
		
			$paciente_edad=intval(trim(str_replace("años", "",get_edad($paciente['clte_f_nac']))));
			$paciente_genero=get_cat_nombre('GENERO',$paciente['clte_genero_cve']);

			if (!(($paciente_edad < $edad_ini) || ($paciente_edad > $edad_fin)))
			{
				//$todas_las_recetas_1[$indice]=$la_receta;
				$indice++;
				$edad_total+=$paciente_edad;
				$peso_total+=$la_receta['fsm_peso'];

				$diagnosticos=$diagnosticos.$la_receta['fsm_rx'].'|';
				$alergias=$alergias.$la_receta['fsm_alergias'].',';
				
				if ($paciente_genero == "HOMBRE")
				{
					$hombres++;

					if ($la_receta['fsm_edad'] > $edad_maximo_hombres)
					{$edad_maximo_hombres = $la_receta['fsm_edad'];}

					if ($la_receta['fsm_edad'] < $edad_minimo_hombres)
					{$edad_minimo_hombres = $la_receta['fsm_edad'];}
					
					$edad_promedio_hombres+=$paciente_edad;
					
					
					
					if ($la_receta['fsm_peso'] > $peso_maximo_hombres)
					{$peso_maximo_hombres = $la_receta['fsm_peso'];}

					if ($la_receta['fsm_peso'] < $peso_minimo_hombres)
					{$peso_minimo_hombres = $la_receta['fsm_peso'];}

					$peso_promedio_hombres+=$la_receta['fsm_peso'];



					if ($la_receta['fsm_talla'] > 0) 
					{$imc=$la_receta['fsm_peso']/($la_receta['fsm_talla']*$la_receta['fsm_talla']);}
					else
					{$imc =0;}					
							
					if ($imc > $imc_maximo_hombres)
					{$imc_maximo_hombres = $imc;}

					if ($imc < $imc_minimo_hombres)
					{$imc_minimo_hombres = $imc;}

					$imc_promedio_hombres+=$imc;				
					
				} 
				else 
				{
					$mujeres++;
					
					if ($la_receta['fsm_edad'] > $edad_maximo_mujeres)
					{$edad_maximo_mujeres = $la_receta['fsm_edad'];}

					if ($la_receta['fsm_edad'] < $edad_minimo_mujeres)
					{$edad_minimo_mujeres = $la_receta['fsm_edad'];}
				
					$edad_promedio_mujeres+=$paciente_edad;
					
					
					if ($la_receta['fsm_peso'] > $peso_maximo_mujeres)
					{$peso_maximo_mujeres = $la_receta['fsm_peso'];}

					if ($la_receta['fsm_peso'] < $peso_minimo_mujeres)
					{$peso_minimo_mujeres = $la_receta['fsm_peso'];}

					$peso_promedio_mujeres+=$la_receta['fsm_peso'];
					
					
					if ($la_receta['fsm_talla'] > 0) 
					{$imc=$la_receta['fsm_peso']/($la_receta['fsm_talla']*$la_receta['fsm_talla']);}
					else
					{$imc =0;}					
							
					if ($imc > $imc_maximo_mujeres)
					{$imc_maximo_mujeres = $imc;}

					if ($imc < $imc_minimo_mujeres)
					{$imc_minimo_mujeres = $imc;}

					$imc_promedio_mujeres+=$imc;											
				}

				$imc_total+=$imc;
			}
			
		}
		
		 
		if ($edad_minimo_mujeres==3000) {$edad_minimo_mujeres=0;}
		if ($edad_minimo_hombres==3000) {$edad_minimo_hombres=0;}
		if ($peso_minimo_mujeres==500) {$peso_minimo_mujeres=0;}
		if ($peso_minimo_hombres==500) {$peso_minimo_hombres=0;}						
		if ($imc_minimo_mujeres==500) {$imc_minimo_mujeres=0;}
		if ($imc_minimo_hombres==500) {$imc_minimo_hombres=0;}

		$dx_stat=list_to_array_cat_dx($diagnosticos);
		
		$ale_stat=list_to_array_cat($alergias);

		if ($modo == 'VISUAL' )
		{	
			graph_recetas_gsi($indice,
			$hombres,
			$mujeres,
			$edad_total,
			$edad_promedio_hombres,
			$edad_promedio_mujeres,
			$edad_minimo_mujeres,
			$edad_minimo_hombres,
			$edad_maximo_mujeres,
			$edad_maximo_hombres,			
			$peso_total,
			$peso_promedio_hombres,
			$peso_minimo_hombres,
			$peso_maximo_hombres,
			$peso_promedio_mujeres,
			$peso_minimo_mujeres,
			$peso_maximo_mujeres,
			$dx_stat,
			$ale_stat,$empresa);
		 }	
		?>
	
		<?php if ($modo == 'VISUAL' )
		{	?>		
		<table  border="0" style="width: 100%">
			<tr>
				<td style="width: 15%"></td>		
				<td><div id="<?php echo "chart_pacientes_". $empresa;?>" style="border: 1px solid #ccc"></div></td>
				<td style="width:15%"></td>
			</tr>
			<tr>
				<td style="width: 15%"></td>		
				<td><div id="<?php echo "tabla_pacientes_". $empresa;?>" style="border: 1px solid #ccc"></div></td>
				<td style="width:15%"></td>
			</tr>
			
			
			<tr>
				<td></td>		
				<td><br><br><br></td>
				<td></td>
			</tr>	
			<tr>
				<td style="width: 15%"></td>		
				<td><div id="<?php echo "chart_edad_". $empresa;?>" style="border: 1px solid #ccc"></div></td>
				<td style="width:15%"></td>
			</tr>
			<tr>
				<td style="width: 15%"></td>		
				<td><div id="<?php echo "tabla_edad_". $empresa;?>" style="border: 1px solid #ccc"></div></td>
				<td style="width:15%"></td>
			</tr>			
			<tr>
				<td></td>		
				<td><br><br><br></td>
				<td></td>
			</tr>	
			<tr>
				<td style="width: 15%"></td>		
				<td><div id="<?php echo "chart_peso_". $empresa;?>" style="border: 1px solid #ccc"></div></td>
				<td style="width:15%"></td>
			</tr>
			<tr>
				<td style="width: 15%"></td>		
				<td><div id="<?php echo "tabla_mm_peso_". $empresa;?>" style="border: 1px solid #ccc"></div></td>
				<td style="width:15%"></td>
			</tr>
			<tr>
				<td></td>		
				<td><br><br><br></td>
				<td></td>
			</tr>	
			<tr>
				<td style="width: 15%"></td>		
				<td><div id="<?php echo "cheese_3d_dx_". $empresa;?>" style="border: 1px solid #ccc; width: 900px; height: 500px;">></div></td>
				<td style="width:15%"></td>
			</tr>
			<tr>
				<td></td>		
				<td><br><br><br></td>
				<td></td>
			</tr>	
			<tr>
				<td style="width: 15%"></td>		
				<td><div id="<?php echo "cheese_3d_alergias_". $empresa;?>" style="border: 1px solid #ccc; width: 900px; height: 500px;">></div></td>
				<td style="width:15%"></td>
			</tr>	
		</table>
		<?php
		}	
		?>
		
	<?php //if ($modo == 'pdf' )
		{	?>	
	<table border = 0 style="width: 100%"> 
		<tr>
			<td class="auto-titular-grande"></td>		
		</tr>								
		<tr>
			<td class="auto-titular-grande">Total de Pacientes</td>		
		</tr>
	</table>	
	
				<table border = 0 style="width: 100%"> 								
					<tr>
						<td class="auto-celda-grande" style="width: 15%"></td>		
						<td class="auto-titulo-grande" style="width: 35%">Género</td>
						<td class="auto-titulo-grande" style="width: 35%">Cantidad</td>
						<td class="auto-celda-grande"style="width: 15%"></td>
					</tr>


					<?php
					if (($genero == '') || ($genero == 'M'))
					{ ?>						
					<tr>
						<td class="auto-celda-grande" ></td>		
						<td class="auto-celda-grande" >Mujeres</td>
						<td class="auto-celda-grande" ><?php echo $mujeres;?></td>
						<td class="auto-celda-grande" ></td>
					</tr>
					<?php }
					if (($genero == '') || ($genero == 'H'))
					{ ?>				
					<tr>
						<td  class="auto-celda-grande" ></td>		
						<td  class="auto-celda-grande" >Hombres</td>
						<td  class="auto-celda-grande" ><?php echo $hombres;?></td>
						<td  class="auto-celda-grande" ></td>
					</tr>
					<?php } ?>
					
					<tr>
						<td  class="auto-celda-grande" ></td>		
						<td  class="auto-pie-grande" >Total</td>
						<td  class="auto-pie-grande" ><?php echo $indice;?></td>
						<td  class="auto-celda-grande" ></td>
					</tr>
				</table>
				
				<table border = 0 style="width: 100%">
					<tr>
						<td class="auto-titular-grande">&nbsp;</td>		
					</tr> 
					<tr>
						<td class="auto-titular-grande">&nbsp;</td>		
					</tr>								
					<tr>
						<td class="auto-titular-grande">Edad de Pacientes</td>		
					</tr>
				</table>								
				<table border = 0 style="width: 100%"> 								
					<tr>
						<td class="auto-celda-grande" style="width: 15%"></td>		
						<td class="auto-titulo-grande" style="width: 19%">Género</td>
						<td class="auto-titulo-grande" style="width: 17%">Edad Mínima</td>
						<td class="auto-titulo-grande" style="width: 17%">Edad Promedio</td>
						<td class="auto-titulo-grande" style="width: 17%">Edad Máxima</td>
						<td class="auto-celda-grande"style="width: 15%"></td>
					</tr>
					<?php 
					if (($genero == '') || ($genero == 'M'))
					{ ?>					
					<tr>
						<td class="auto-celda-grande" ></td>		
						<td class="auto-celda-grande" >Mujeres</td>
						<td class="auto-celda-grande" ><?php echo $edad_minimo_mujeres;?></td>
						<td class="auto-celda-grande" ><?php echo round($edad_promedio_mujeres/$mujeres,1).' años';?></td>
						<td class="auto-celda-grande" ><?php echo $edad_maximo_mujeres;?></td>
						<td class="auto-celda-grande" ></td>
					</tr>
					<?php }
					if (($genero == '') || ($genero == 'H'))
					{ ?>					
					<tr>
						<td  class="auto-celda-grande" ></td>		
						<td  class="auto-celda-grande" >Hombres</td>
						<td  class="auto-celda-grande" ><?php echo $edad_minimo_hombres;?></td>
						<td  class="auto-celda-grande" ><?php echo round($edad_promedio_hombres/$hombres,1).' años';?></td>
						<td  class="auto-celda-grande" ><?php echo $edad_maximo_hombres;?></td>
						<td  class="auto-celda-grande" ></td>
					</tr>	
				<?php } ?>					
					<tr>
						<td  class="auto-celda-grande" ></td>		
						<td  class="auto-pie-grande">&nbsp;</td>
						<td  class="auto-pie-grande">&nbsp;</td>
						<td  class="auto-pie-chico"> Edad Promedio General</td>
						<td  class="auto-pie-grande"><?php echo round($edad_total/$indice,1).' años';?></td>		
						<td  class="auto-celda-grande" ></td>
					</tr>
				</table>

				<table border = 0 style="width: 100%">
					<tr>
						<td class="auto-titular-grande">&nbsp;</td>		
					</tr> 
					<tr>
						<td class="auto-titular-grande">&nbsp;</td>		
					</tr>								
					<tr>
						<td class="auto-titular-grande">Peso de Pacientes</td>		
					</tr>
				</table>
				<table border = 0 style="width: 100%"> 								
					<tr>
						<td class="auto-celda-grande" style="width: 15%"></td>		
						<td class="auto-titulo-grande" style="width: 19%">Género</td>
						<td class="auto-titulo-grande" style="width: 17%">Peso Mínimo</td>
						<td class="auto-titulo-grande" style="width: 17%">Peso Promedio</td>
						<td class="auto-titulo-grande" style="width: 17%">Peso Máximo</td>
						<td class="auto-celda-grande"style="width: 15%"></td>
					</tr>
					<?php 
					if (($genero == '') || ($genero == 'M'))
					{ ?>					
					<tr>
						<td class="auto-celda-grande" ></td>		
						<td class="auto-celda-grande" >Mujeres</td>
						<td class="auto-celda-grande" ><?php echo round($peso_minimo_mujeres,2).' Kg';?></td>
						<td class="auto-celda-grande" ><?php echo round($peso_promedio_mujeres/$mujeres,2).' Kg';?></td>
						<td class="auto-celda-grande" ><?php echo round($peso_maximo_mujeres,2).' Kg';?></td>
						<td class="auto-celda-grande" ></td>
					</tr>	
					<?php }
					if (($genero == '') || ($genero == 'H'))
					{ ?>					
					<tr>
						<td  class="auto-celda-grande" ></td>		
						<td  class="auto-celda-grande" >Hombres</td>
						<td  class="auto-celda-grande" ><?php echo round($peso_minimo_hombres,2).' Kg';?></td>
						<td  class="auto-celda-grande" ><?php echo round($peso_promedio_hombres/$hombres,2).' Kg';?></td>
						<td  class="auto-celda-grande" ><?php echo round($peso_maximo_hombres,2).' Kg';?></td>
						<td  class="auto-celda-grande" ></td>
					</tr>
					<?php } ?>
					<tr>
						<td  class="auto-celda-grande" ></td>		
						<td  class="auto-pie-grande">&nbsp;</td>
						<td  class="auto-pie-grande">&nbsp;</td>
						<td  class="auto-pie-chico"> Peso Promedio General</td>
						<td  class="auto-pie-grande"><?php echo round($peso_total/$indice,2).' Kg';?></td>		
						<td  class="auto-celda-grande" ></td>
					</tr>
				</table>


				<table border = 0 style="width: 100%">
					<tr>
						<td class="auto-titular-grande">&nbsp;</td>		
					</tr> 
					<tr>
						<td class="auto-titular-grande">&nbsp;</td>		
					</tr>								
					<tr>
						<td class="auto-titular-grande">IMC de Pacientes</td>		
					</tr>
				</table>
												
				<table border = 0 style="width: 100%"> 								
					<tr>
						<td class="auto-celda-grande" style="width: 15%"></td>		
						<td class="auto-titulo-grande" style="width: 19%">Género</td>
						<td class="auto-titulo-grande" style="width: 17%">IMC Mínimo</td>
						<td class="auto-titulo-grande" style="width: 17%">IMC Promedio</td>
						<td class="auto-titulo-grande" style="width: 17%">IMC Máximo</td>
						<td class="auto-celda-grande"style="width: 15%"></td>
					</tr>
					<?php 
					if (($genero == '') || ($genero == 'M'))
					{ ?>					
					<tr>
						<td class="auto-celda-grande" ></td>		
						<td class="auto-celda-grande" >Mujeres</td>
						<td class="auto-celda-grande" ><?php echo round($imc_minimo_mujeres,2).' (Kg/M<sup>2</sup>)';?></td>
						<td class="auto-celda-grande" ><?php echo round($imc_promedio_mujeres/$mujeres,2).' (Kg/M<sup>2</sup>)';?></td>
						<td class="auto-celda-grande" ><?php echo round($imc_maximo_mujeres,2).' (Kg/M<sup>2</sup>)';?></td>
						<td class="auto-celda-grande" ></td>
					</tr>
					<?php }
					if (($genero == '') || ($genero == 'H'))
					{ ?>					
					<tr>
						<td  class="auto-celda-grande" ></td>		
						<td  class="auto-celda-grande" >Hombres</td>
						<td  class="auto-celda-grande" ><?php echo round($imc_minimo_hombres,2).' (Kg/M<sup>2</sup>)';?></td>
						<td  class="auto-celda-grande" ><?php echo round($imc_promedio_hombres/$hombres,2).' (Kg/M<sup>2</sup>)';?></td>
						<td  class="auto-celda-grande" ><?php echo round($imc_maximo_hombres,2).' (Kg/M<sup>2</sup>)';?></td>
						<td  class="auto-celda-grande" ></td>
					</tr>
					<?php } ?>
					<tr>
						<td  class="auto-celda-grande" ></td>		
						<td  class="auto-pie-grande">&nbsp;</td>
						<td  class="auto-pie-grande">&nbsp;</td>
						<td  class="auto-pie-chico"> IMC Promedio General</td>
						<td  class="auto-pie-grande"><?php echo round($imc_total/$indice,2).' (Kg/M<sup>2</sup>)';?></td>		
						<td  class="auto-celda-grande" ></td>
					</tr>
				</table>	
		

				<?php
				if ($modo == 'pdf')
				{
					?>	
					<br pagebreak="true" />
					<?php
					poner_titulo($titulo_reporte);
					?>
					<hr>
					<h4 class="color-gray"><b>Consultorio: <?php echo $titulo_consultorio; ?></b></h4>
					<?php
				}	
				?>
				
				<table border = 0 style="width: 100%">
					<tr>
						<td class="auto-titular-grande">&nbsp;</td>		
					</tr> 
					<tr>
						<td class="auto-titular-grande">&nbsp;</td>		
					</tr>								
					<tr>
						<td class="auto-titular-grande">Diagnósticos</td>		
					</tr>
				</table>								
				<table border = 0 style="width: 100%"> 								
					<tr>
						<td class="auto-celda-grande" style="width: 15%"></td>		
						<td class="auto-titulo-grande" style="width: 50%">Diagnóstico</td>
						<td class="auto-titulo-grande" style="width: 20%">Incidencia</td>
						<td class="auto-celda-grande"style="width: 15%"></td>
					</tr>

					
					<?php	
						$cuenta_lineas=0;
						foreach($dx_stat as $dx)
						{  if ($dx['cat_nombre'] !== '') 
							{
								$cuenta_lineas++;
							?>
								<tr>
									<td  class="auto-celda-grande" ></td>					
									<td  class="auto-celda-mediana" ><?php echo $dx['cat_nombre'].'-'.get_catalogo_by_clave('CIE_10',$dx['cat_nombre']);?></td>
									<td  class="auto-celda-grande" ><?php echo $dx['cuantos'];?></td>				
									<td  class="auto-celda-grande" ></td>
								</tr>
							<?php
							}
							if ($cuenta_lineas == 22)
							{
								$cuenta_lineas=0;
								?>
								</table>
								<br pagebreak="true" />
								<?php
								poner_titulo($titulo_reporte);
								?>
								<hr>
								<h4 class="color-gray"><b>Consultorio: <?php echo $titulo_consultorio; ?></b></h4>
								<table border = 0 style="width: 100%"> 								
									<tr>
										<td class="auto-celda-grande" style="width: 15%"></td>		
										<td class="auto-titulo-grande" style="width: 50%">Diagnóstico</td>
										<td class="auto-titulo-grande" style="width: 20%">Incidencia</td>
										<td class="auto-celda-grande"style="width: 15%"></td>
									</tr>					
								<?php									
							}
						}
					?>
					<tr>
						<td  class="auto-celda-grande" ></td>		
						<td  class="auto-pie-grande">&nbsp;</td>
						<td  class="auto-pie-grande">&nbsp;</td>
						<td  class="auto-celda-grande" ></td>
					</tr>
				</table>	


				<?php
				if ($modo == 'pdf')
				{
					?>	
					<br pagebreak="true" />
					<?php
					poner_titulo($titulo_reporte);
					?>
					<hr>
					<h4 class="color-gray"><b>Consultorio: <?php echo $titulo_consultorio; ?></b></h4>
					<?php
				}	
				?>


				<table border = 0 style="width: 100%">
					<tr>
						<td class="auto-titular-grande">&nbsp;</td>		
					</tr> 
					<tr>
						<td class="auto-titular-grande">&nbsp;</td>		
					</tr>								
					<tr>
						<td class="auto-titular-grande">Alergías</td>		
					</tr>
				</table>								
				<table border = 0 style="width: 100%"> 								
					<tr>
						<td class="auto-celda-grande" style="width: 15%"></td>		
						<td class="auto-titulo-grande" style="width: 50%">Alergía</td>
						<td class="auto-titulo-grande" style="width: 20%">Cantidad</td>
						<td class="auto-celda-grande"style="width: 15%"></td>
					</tr>


					<?php				
						foreach($ale_stat as $dx)
						{  if ($dx['cat_nombre'] !== '') 
							{
							?>
								<tr>
									<td  class="auto-celda-grande" ></td>					
									<td  class="auto-celda-mediana" ><?php echo $dx['cat_nombre'];?></td>
									<td  class="auto-celda-grande" ><?php echo $dx['cuantos'];?></td>				
									<td  class="auto-celda-grande" ></td>
								</tr>
							<?php
							}
						}
					?>
					<tr>
						<td  class="auto-celda-grande" ></td>		
						<td  class="auto-pie-grande">&nbsp;</td>
						<td  class="auto-pie-grande">&nbsp;</td>
						<td  class="auto-celda-grande" ></td>
					</tr>
				</table>
		
				<br pagebreak="true" />
			<?php
			}	
			?>
				
			
				<?php
				
		
        
    }
}
/*****************************************************************************/

