<?php
defined('BASEPATH') OR exit('No direct script access allowed');

if (!function_exists('graph_recetas_gsi'))
{
    function graph_recetas_gsi($indice,
								$hombres,
								$mujeres,
								$edad_total,
								$edad_total_hombres,
								$edad_total_mujeres,
								$edad_minimo_mujeres,
								$edad_minimo_hombres,
								$edad_maximo_mujeres,
								$edad_maximo_hombres,							
								$peso_total,
								$peso_promedio_hombres,
								$peso_minimo_hombres,
								$peso_maximo_hombres,
								$peso_promedio_mujeres,
								$peso_minimo_mujeres,
								$peso_maximo_mujeres,
								$dx_stat,
								$ale_stat,$empresa)
    {
		$azul_solido='#0000ff';
		$rojo_solido='#ff0000';
		$rojo_carmesi='#4d0000';
		$azul_hc='#4B5682';
		$verde_hc='#72B99C';
		$gris_rata='#acacac';
		
	?>
		<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
		<script type="text/javascript">
		google.charts.load('current', {'packages':['corechart']});

		google.charts.load('current', {packages: ['corechart', 'bar']});
		google.charts.setOnLoadCallback(draw_barras_pacientes);

		function draw_barras_pacientes() {
			  var data = google.visualization.arrayToDataTable([
				['Paciente', '',{ role: 'style' }, { role: 'annotation' }],
				['Mujeres', <?php echo $mujeres;?>, <?php echo "'".$verde_hc."'";?>, <?php echo $mujeres;?> ],
				['Hombres', <?php echo $hombres;?>,<?php echo "'".$azul_hc."'";?>, <?php echo $hombres;?> ]
			  ]);

			  var options = {
				title: <?php echo "'"."Total de Pacientes: ".$indice."'";?> ,
				chartArea: {width: '50%'},
				hAxis: {
				  title: 'Cantidad de Pacientes',
				  minValue: 0
				},
				vAxis: {
				  title: 'Pacientes'
				}
			  };
			  
			  var chart = new google.visualization.BarChart(document.getElementById(<?php echo "'chart_pacientes_". $empresa."'";?>));
			  chart.draw(data, options);
			}

      google.charts.load('current', {'packages':['table']});
      google.charts.setOnLoadCallback(drawTablepaciente);

      function drawTablepaciente() {
        var data = new google.visualization.DataTable();
        data.addColumn('string', 'Mujeres');
		data.addColumn('string', 'Hombres');
        data.addRows([
          [<?php echo "'".$mujeres."'";?>, <?php echo "'".$hombres."'";?>]
        ]);
		
        var table = new google.visualization.Table(document.getElementById(<?php echo "'tabla_pacientes_". $empresa."'";?>));

        table.draw(data, {showRowNumber: false, width: '100%', height: '100%'});
      }
			
			

			google.charts.setOnLoadCallback(draw_barras_edad);

			function draw_barras_edad() {
				  var data = google.visualization.arrayToDataTable([
					['Paciente', '',{ role: 'style' }, { role: 'annotation' }],
					['Mujeres', <?php echo round($edad_total_mujeres/$mujeres,1);?>,<?php echo "'".$verde_hc."'";?>, <?php echo "'".round($edad_total_mujeres/$mujeres,1).' años'."'";?> ],
					['Hombres', <?php echo round($edad_total_hombres/$hombres,1);?>,<?php echo "'".$azul_hc."'";?>, <?php echo "'".round($edad_total_hombres/$hombres,1).' años'."'";?> ]
				  ]);



				  var options = {
					title: <?php echo "'"."Edad Promedio de los Pacientes: ".round($edad_total/$indice,1).' años'."'";?> ,
					chartArea: {width: '50%'},
					hAxis: {
					  title: 'Edad de Pacientes',
					  minValue: 0
					},
					vAxis: {
					  title: 'Pacientes'
					}
				  };
				  
				  var chart = new google.visualization.BarChart(document.getElementById(<?php echo "'chart_edad_". $empresa."'";?>));
				  chart.draw(data, options);
				}

      google.charts.load('current', {'packages':['table']});
      google.charts.setOnLoadCallback(drawTableedad);

      function drawTableedad() {
        var data = new google.visualization.DataTable();
        data.addColumn('string', 'Género');
        data.addColumn('string', 'Edad Mínima');
		data.addColumn('string', 'Edad Promedio');
        data.addColumn('string', 'Edad Máxima');
        data.addRows([
          ['Mujer',  <?php echo "'".round($edad_minimo_mujeres,2)." años'";?>, <?php echo "'".round($edad_total_mujeres/$mujeres,1)." años'";?>,<?php echo "'".round($edad_maximo_mujeres,2)." años'";?>],
          ['Hombre', <?php echo "'".round($edad_minimo_hombres,2)." años'";?>, <?php echo "'".round($edad_total_hombres/$hombres,1)." años'";?>,<?php echo "'".round($edad_maximo_hombres,2)." años'";?>]
        ]);

		
        var table = new google.visualization.Table(document.getElementById(<?php echo "'tabla_edad_". $empresa."'";?>));

        table.draw(data, {showRowNumber: false, width: '100%', height: '100%'});
      }





google.charts.setOnLoadCallback(draw_barras_peso);

function draw_barras_peso() {
      var data = google.visualization.arrayToDataTable([
        ['Paciente', '',{ role: 'style' }, { role: 'annotation' }],
        ['Mujeres', <?php echo round($peso_promedio_mujeres/$mujeres,1);?>,<?php echo "'".$verde_hc."'";?>, <?php echo "'".round($peso_promedio_mujeres/$mujeres,1).' Kg'."'";?> ],
        ['Hombres', <?php echo round($peso_promedio_hombres/$hombres,1);?>,<?php echo "'".$azul_hc."'";?>, <?php echo "'".round($peso_promedio_hombres/$hombres,1).' Kg'."'";?> ]
      ]);



      var options = {
        title: <?php echo "'"."Peso Promedio de los Pacientes: ".round($peso_total/$indice,1).' Kg'."'";?> ,
        chartArea: {width: '50%'},
        hAxis: {
          title: 'Peso de Pacientes',
          minValue: 0
        },
        vAxis: {
          title: 'Pacientes'
        }
      };
	  
      var chart = new google.visualization.BarChart(document.getElementById(<?php echo "'chart_peso_". $empresa."'";?>));
      chart.draw(data, options);
    }					  



      google.charts.load('current', {'packages':['table']});
      google.charts.setOnLoadCallback(drawTable);

      function drawTable() {
        var data = new google.visualization.DataTable();
        data.addColumn('string', 'Género');
        data.addColumn('string', 'Peso Mínimo');
		data.addColumn('string', 'Peso Promedio');
        data.addColumn('string', 'Peso Máximo');
        data.addRows([
          ['Mujer',  <?php echo "'".round($peso_minimo_mujeres,2)." Kg'";?>, <?php echo "'".round($peso_promedio_mujeres/$mujeres,1)." Kg'";?>,<?php echo "'".round($peso_maximo_mujeres,2)." Kg'";?>],
          ['Hombre', <?php echo "'".round($peso_minimo_hombres,2)." Kg'";?>, <?php echo "'".round($peso_promedio_hombres/$hombres,1)." Kg'";?>,<?php echo "'".round($peso_maximo_hombres,2)." Kg'";?>]
        ]);

		
        var table = new google.visualization.Table(document.getElementById(<?php echo "'tabla_mm_peso_". $empresa."'";?>));

        table.draw(data, {showRowNumber: false, width: '100%', height: '100%'});
      }


      google.charts.setOnLoadCallback(draw_cheese_dx);
      function draw_cheese_dx() {
        var data = google.visualization.arrayToDataTable([
          ['Diagnostico', 'Detectados'],
		  
		<?php
			$lineas='';
			$retoque=0;
			foreach($dx_stat as $dx)
			{  
				
				if ($dx['cat_nombre'] !== '') 
				{
					if ($retoque==0)
				    {$retoque=1;} else { $lineas.=',';}	
					$lineas.= "['" .$dx['cat_nombre']."-".get_catalogo_by_clave('CIE_10',$dx['cat_nombre'])."',".$dx['cuantos']."]";
				}
			}
			echo $lineas;
		?>		  
     
		  
        ]);

        var options = {
          title: 'Diagnósticos',
          is3D: true,
          slices: {
            0: { color: <?php echo "'".$verde_hc."'";?>},
            1: { color: <?php echo "'".$azul_hc."'";?> }
		  }
        };
																			
        var chart = new google.visualization.PieChart(document.getElementById(<?php echo "'cheese_3d_dx_". $empresa."'";?>));
        chart.draw(data, options);
	  }


      google.charts.setOnLoadCallback(draw_cheese_alergias);
      function draw_cheese_alergias() {
        var data = google.visualization.arrayToDataTable([
          ['Alergias', 'Detectadas'],
			<?php				
				foreach($ale_stat as $dx)
				{
					echo "['" .$dx['cat_nombre']."',". $dx['cuantos']."],";
				}
			?>
        ]);

        var options = {
          title: 'Alergias',
          is3D: true,
          slices: {
            0: { color: <?php echo "'".$verde_hc."'";?>},
            1: { color: <?php echo "'".$azul_hc."'";?> }
          }		  
        };
																				
        var chart = new google.visualization.PieChart(document.getElementById(<?php echo "'cheese_3d_alergias_". $empresa."'";?>));
        chart.draw(data, options);
	  }
		
		  
		</script>
	<?php
    }
}

