<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Clogos_model extends CI_Model {
    
        function __construct()
        {
            parent::__construct();
            $this->load->database();
            $this->load->helper('util');
        }


        function busca($grupo,$subgrupo ,$clave, $estatus, $detalle)
        {            
			$this->db->select('*');            
            $this->db->from('cat_catalogos');
            if($grupo != ''){ $this->db->like('cat_grupo',$grupo ); }
            if($subgrupo != ''){ $this->db->like('cat_grupo_nombre',$subgrupo); }
			if($clave != ''){ $this->db->like('cat_cve',$clave); }
            if($estatus != ''){ $this->db->like('cat_estatus_cve',$estatus); }            
            if($detalle   != ''){ $this->db->like('cat_nombre',$detalle); }            
			
            $this->db->order_by('cat_grupo ASC, cat_grupo_nombre ASC ,cat_nombre  ASC' );
            $result = $this->db->get();
            return $result->result_array();
        }



        function actualiza($fsm_id, $params)
        {
            //$data = array_merge($params, log_insert('Edita empleado'));
            $this->db->where('cat_id',$fsm_id);
            return $this->db->update('cat_catalogos',$params);
        }

		function borra($fsm_id)
		{
			$this->db->where('cat_id', $fsm_id);
			return $this->db->delete('cat_catalogos');
		}
			
        function get($id)
        {
            $this->db->select('*');
            $this->db->from('cat_catalogos');
            $this->db->where('cat_id', $id);
            $result = $this->db->get();
            return $result->row_array();
        }


        function inserta($params)
        {
            $data = $params; //array_merge($params, log_insert('Nuevo empleado'));
            $this->db->insert('cat_catalogos', $data);
            return $this->db->insert_id();
        }
		
		function count_all()
        {
            $this->db->select("count(cat_id) as regs");
            $this->db->from('cat_catalogos');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
			/*
            $this->db->select("count(usr_id) as regs");
            $this->db->from('sis20_usuarios');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];			
			*/
        }


	    function get_allo($rows)
        {			
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('*');
            $this->db->from('cat_catalogos');
			$this->db->order_by('cat_grupo ASC, cat_grupo_nombre ASC ,cat_nombre  ASC' );
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
			/*
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
			$this->db->order_by('usr_username ASC' );
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();			
			*/
        }	


    function busca_asistencia($nombre = '', $paterno='',$materno='', $elempleado = '',$usuario = '',$f_ini = '', $f_fin = '')
		{            
            $this->db->select('*');
            
            $this->db->from('sis25_asistencias_log');
			
			if($nombre != ''){ $this->db->like('usr_nombre',$nombre); }            
            if($paterno != ''){ $this->db->like('usr_paterno',$paterno); }            
			if($materno != ''){ $this->db->like('usr_materno',$materno); }     
			
			if($elempleado != ''){ $this->db->where('usr_id',$elempleado); }
			
            if($usuario != ''){ $this->db->like('usr_username',$usuario); }

			if($f_ini != ''){ $this->db->where('usrlog_ingreso_f >=',$f_ini.' 00:00:00'); } 
			if($f_fin != ''){ $this->db->where('usrlog_salida_f <=', $f_fin.' 11:59:59'); } 

			$this->db->like('usr_estatus_cve',$estatus); 
			
            $this->db->order_by('fsm_id','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }

		

	    function get_allo_asistencias($rows)
        {			
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('*');
            $this->db->from('sis25_asistencias_log');
			$this->db->order_by('fsm_id DESC' );
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }

    function count_all_asistencias()
        {
            $this->db->select("count(fsm_id) as regs");
            $this->db->from('sis25_asistencias_log');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }


        function asistencia($params)
        {
            //$data = array_merge($params, log_insert('Nuevo empleado'));
            $this->db->insert('sis25_asistencias_log', $params);
            return $this->db->insert_id();
        }


        function ultima_asistencia($id)
        {   
            $this->db->select('*');
            $this->db->from('sis25_asistencias_log');
            $this->db->where('usr_id',$id);
			$this->db->order_by('fsm_id DESC');
			$this->db->limit(1);
            $result = $this->db->get();
			return $result->row_array();
        }

        function asistencia_actualiza($fsm_id, $params)
        {            
            $this->db->where('fsm_id',$fsm_id);
            return $this->db->update('sis25_asistencias_log',$params);
        }		


	    function get_all_empleados()
        {			
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
			$this->db->where('emp_id', 31 );
			$this->db->where('usr_id !=', 261 );
			$this->db->like('usr_estatus_cve','Activo' );
			$this->db->order_by('usr_paterno,usr_materno,usr_nombre DESC' );
            $result = $this->db->get();
            return $result->result_array();
        }




        function get_all()
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            if(get_perfil_id() == 4)
            {
                $this->db->where('emp_id', get_emp_id());
            }
			$this->db->order_by('usr_nombre ASC','usr_paterno ASC');
            $result = $this->db->get();
            return $result->result_array();
        }

        function get_all_report()
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            /*if(get_perfil_id() == 4)
            {
                $this->db->where('emp_id', get_emp_id());
            }*/
			$this->db->order_by('perfil_id','usr_nombre','usr_paterno');
            $result = $this->db->get();
            return $result->result_array();
        }

	    function get_allo_hco($rows)
        {
			
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->where('emp_id',31);
			$this->db->order_by('usr_nombre ASC','usr_paterno ASC');
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }		


	    function get_allo_empresa($rows)
        {
			
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->where('perfil_id', 4);
			$this->db->order_by('usr_nombre ASC','usr_paterno ASC');
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }


  
 


    function count_all_empresa()
        {
            $this->db->select("count(usr_id) as regs");
            $this->db->from('sis20_usuarios');
            $this->db->where('perfil_id',4);
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }



    function count_all_hco()
        {
            $this->db->select("count(usr_id) as regs");
            $this->db->from('sis20_usuarios');
            $this->db->where('emp_id', 31);
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }
   
        function get_id($id)
        {   
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);
            $result = $this->db->get();
			return $result->row_array();
        }
        


        function get_medicos_recetas()
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->like('receta','SI' );
			$this->db->order_by('usr_nombre','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }

        function get_medicos_recetas_activos()
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->like('receta','SI' );
			$this->db->like('usr_estatus_cve','Activo' );
			$this->db->order_by('usr_nombre','ASC');
            $result = $this->db->get();
            return $result->result_array();
        }


        function get_in($id)
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);
            $result = $this->db->get();
            return $result->row_array();
        }
		

		
        function get_worker_usuario($id)
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
			$this->db->where('usr_id', $id);
            $result = $this->db->get();
            return $result->row_array();
        }		

        function get_sp($id)
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);
            $result = $this->db->get();
            return $result->row_array();
        }

        function get_usr_username($id)
        {
            $this->db->select('*');
            $this->db->from('sis20_usuarios');
            $this->db->like('usr_username', $id);
            $result = $this->db->get();
            return $result->row_array();
        }		
    

        

		
        function get_roots($id)
        {
            $select = "root1,root2,root3,root4,root5,root6,usr_emp_asig";
            $this->db->select($select);
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);         
            $result = $this->db->get();
            return $result->row_array();
           
        }	


        function get_unidad_reclutador($id)
        {
            $select = "usr_unidad_reclutadora";
            $this->db->select($select);
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);         
            $result = $this->db->get();
            return $result->row_array();
           
        }		


        function get_cei_filtro($id)
        {
            $select = "filtro_cei_id";
            $this->db->select($select);
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);         
            $result = $this->db->get();
			$result->row_array();			
			$row = $result->row_array();
            return $row['filtro_cei_id'];
           
        }	

        function get_filtro($id)
        {
            $select = "filtro_id";
            $this->db->select($select);
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);         
            $result = $this->db->get();
			$result->row_array();			
			$row = $result->row_array();
            return $row['filtro_id'];
           
        }	
		
		function get_so_filtro($id)
        {
            $select = "filtro_so_id";
            $this->db->select($select);
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);         
            $result = $this->db->get();
			$result->row_array();			
			$row = $result->row_array();
            return $row['filtro_so_id'];
           
        }
		
        function get_emp_asig($id)
        {
            $select = "usr_emp_asig";
            $this->db->select($select);
            $this->db->from('sis20_usuarios');
            $this->db->where('usr_id', $id);         
            $result = $this->db->get();
			$result->row_array();			
			$row = $result->row_array();
            return $row['usr_emp_asig'];
           
        }		

/**************************************************************************************/         

/**************************************************************************************/        
	
        function busca_usuario_empresa($nombre = '', $paterno='',$materno='',$empresa = '')
        {            
            $this->db->select('*');
            
            $this->db->from('sis20_usuarios');
            $this->db->where('perfil_id', 4);
            if($empresa != ''){ $this->db->where('emp_id',$empresa); }
            if($nombre != ''){ $this->db->like(usr_nombre,$nombre); }            
            if($paterno != ''){ $this->db->like(usr_paterno,$paterno); }            
			if($materno != ''){ $this->db->like(usr_materno,$materno); }            
            $this->db->order_by('usr_id','DESC');
            $result = $this->db->get();
            return $result->result_array();
        }
		
}