<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Vidia_model extends CI_Model {
    
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    
    function vistasdeldia()
    {
            $sql="select b.clte_id clavec, AES_DECRYPT(b.clte_nombre_crypt,'humancenter') nombre, AES_DECRYPT(b.clte_2_nombre_crypt,'humancenter') nombred, 
                  AES_DECRYPT(b.clte_paterno_crypt, 'humancenter') paterno, AES_DECRYPT(b.clte_materno_crypt, 'humancenter') materno, 
                  GROUP_CONCAT(CONCAT(a.tipo,'|',a.fsm_id)) as examenes, emp_razon_social,a.serv_id norden, b.c_toxicologico ctox, b.c_toxicologicos ctoxs,
                  b.c_toxicologicon ctoxn, b.c_historia_clinica chiscli, b.c_medico_fisico cmedfis, b.c_socioeconomico csoceco, b.c_estudio_socioeconomico cestsoc, b.c_entorno_social centsoc,
                  b.c_psicologico cpsico, b.c_cedulas ccedu, b.c_poligrafico cpoli, b.c_laboratorio clabo   
                   from(
                        SELECT b.clte_id,c.serv_id , fsm_id, 'POL' as tipo
                        FROM sis05_clientes as b, fsm_poligrafico as c 
                        where b.clte_id = c.clte_id
                        and b.status = 'activo' 
                        and polig_tipo_cve = 'POLI'
                        and date(b.log_insrt_f) = (select max(date(f.log_insrt_f)) from sis05_clientes as f )
                       
                        union ALL
                        SELECT b.clte_id, c.serv_id, fsm_id, 'CED' as tipo
                        FROM sis05_clientes as b, fsm_poligrafico as c
                        where b.clte_id = c.clte_id 
                        and b.status = 'activo'
                        and polig_tipo_cve = 'CEDULA'
                        and date(b.log_insrt_f) = (select max(date(f.log_insrt_f)) from sis05_clientes as f )
                        
                        union ALL
                        SELECT b.clte_id, c.serv_id, fsm_id, 'MEDFIS' as tipo
                        FROM sis05_clientes as b, fsm_medico_fisico as c
                        where b.clte_id = c.clte_id
                        and b.status = 'activo'
                        and date(b.log_insrt_f) = (select max(date(f.log_insrt_f)) from sis05_clientes as f )
                        
                        union ALL
                        SELECT b.clte_id, c.serv_id, fsm_id, 'PSIC' as tipo
                        FROM sis05_clientes as b, fsm_psicologico as c
                        where b.clte_id = c.clte_id
                        and b.status = 'activo'
                        and date(b.log_insrt_f) = (select max(date(f.log_insrt_f)) from sis05_clientes as f )
                       
                        union ALL
                        SELECT b.clte_id, c.serv_id, fsm_id, 'TOXI' as tipo
                        FROM sis05_clientes as b, fsm_toxicologico as c
                        where b.clte_id = c.clte_id
                        and b.status = 'activo' 
                        and date(b.log_insrt_f) = (select max(date(f.log_insrt_f)) from sis05_clientes as f )
                        union ALL
                        SELECT b.clte_id, c.serv_id, fsm_id, 'TOXIS' as tipo
                        FROM sis05_clientes as b, fsm_toxicologico7 as c
                        where b.clte_id = c.clte_id
                        and b.status = 'activo'
                        and date(b.log_insrt_f) = (select max(date(f.log_insrt_f)) from sis05_clientes as f )
                        union ALL
                        SELECT b.clte_id, c.serv_id, fsm_id, 'TOXIN' as tipo
                        FROM sis05_clientes as b, fsm_toxi as c
                        where b.clte_id = c.clte_id
                        and b.status = 'activo'
                        and date(b.log_insrt_f) = (select max(date(f.log_insrt_f)) from sis05_clientes as f )
                        union ALL
                        SELECT b.clte_id, c.serv_id, fsm_id, 'ACRED' as tipo
                        FROM sis05_clientes as b, fsm_acreditacion as c
                        where b.clte_id = c.clte_id
                        and date(b.log_insrt_f) = (select max(date(f.log_insrt_f)) from sis05_clientes as f )
                        union ALL
                        SELECT b.clte_id, c.serv_id, fsm_id, 'HIST' as tipo
                        FROM sis05_clientes as b, fsm_historia_clinica as c
                        where b.clte_id = c.clte_id
                        and b.status = 'activo'
                        and date(b.log_insrt_f) = (select max(date(f.log_insrt_f)) from sis05_clientes as f )
                        union ALL
                        SELECT b.clte_id, c.serv_id, fsm_id, 'SOCIE' as tipo
                        FROM sis05_clientes as b, socio_eco as c
                        where b.clte_id = c.clte_id
                        and b.status = 'activo'
                        and date(b.log_insrt_f) = (select max(date(f.log_insrt_f)) from sis05_clientes as f )
                        union ALL
                        SELECT b.clte_id, c.serv_id, fsm_id, 'ENTSOC' as tipo
                        FROM sis05_clientes as b, entorno_soc as c
                        where b.clte_id = c.clte_id
                        and b.status = 'activo'
                        and date(b.log_insrt_f) = (select max(date(f.log_insrt_f)) from sis05_clientes as f )
                        ) as a
                        LEFT JOIN sis05_clientes as b ON a.clte_id = b.clte_id
                        LEFT JOIN sis15_empresas as e on e.emp_id = b.emp_id
                        
                        
                        
                        and date(b.log_insrt_f) = (select max(date(f.log_insrt_f)) from sis05_clientes as f )
                        and b.status = 'activo'
                        GROUP BY b.clte_id";
                        $result = $this->db->query($sql);
                        return $result->result_array();
        
    }

    function exarea()
    {
                      $sql="select b.clte_id clavec, AES_DECRYPT(b.clte_nombre_crypt,'humancenter') nombre, c.fsm_id toxi, d.fsm_id psico,g.serv_id, e.fsm_id toxs,
                            GROUP_CONCAT(h.exam_cve) exaser  
                             from  sis05_clientes as b
                    LEFT JOIN fsm_toxicologico as c on b.clte_id = c.clte_id
                     left join fsm_psicologico as d on b.clte_id = d.clte_id
                     LEFT JOIN fsm_toxicologico7 as e on b.clte_id = e.clte_id
                       LEFT join sis30_servicios as g on c.serv_id = g.serv_id or d.serv_id = g.serv_id or e.serv_id = g.serv_id
                        left join sis35_servicios_examenes as h on g.serv_id = h.serv_id
                        where date(b.log_insrt_f) = (select max(date(f.log_insrt_f)) from sis05_clientes as f )
                        GROUP BY b.clte_id";
                        $result = $this->db->query($sql);
                        return $result->result_array();
    }                     


    
    function empresas()
    {
        $sql = "SELECT 
                    count(emp_id) as total, 
                    (SELECT count(emp_id) as total FROM sis15_empresas WHERE emp_alta_f >= date_sub(curdate(), interval DAYOFWEEK(curdate())-1 day) ";
        if(get_perfil_id() == 4)
        {
            $sql .= " AND emp_id = ".get_emp_id();
        }
        $sql .= ") as semana 
                FROM sis15_empresas 
                WHERE 1";
        if(get_perfil_id() == 4)
        {
            $sql .= " AND emp_id = ".get_emp_id()." ;";
        }
        $result = $this->db->query($sql);
        return $result->row_array();
    }
    
    function personas($genero)
    {
        $sql = "SELECT 
                    count(clte_id) as total, 
                    (SELECT count(clte_id) as total FROM sis05_clientes  WHERE clte_genero_cve = '$genero' ";
        if(get_perfil_id() == 4)
        {
            $sql .= " AND emp_id = ".get_emp_id();
        }
        $sql .= " AND log_insrt_f >= date_sub(curdate(), interval DAYOFWEEK(curdate())-1 day)) as semana 
                FROM sis05_clientes 
                WHERE clte_genero_cve = '$genero' ";
        if(get_perfil_id() == 4)
        {
            $sql .= " AND emp_id = ".get_emp_id()." ;";
        }
        $result = $this->db->query($sql);
        return $result->row_array();
    }
    
    function edad()
    {
        $sql = "select ROUND(AVG(datediff(curdate(), clte_f_nac )/365)) as promedio 
                FROM sis05_clientes ";
        if(get_perfil_id() == 4)
        {
            $sql .= " WHERE emp_id = ".get_emp_id()." ;";
        }
        $result = $this->db->query($sql);
        return $result->row_array();
    }
    
    function top_clientes()
    {
        $sql = "SELECT a.emp_razon_social as empresa, count(clte_id) as sis05_clientes 
                FROM sis15_empresas as a LEFT JOIN sis05_clientes as b ON a.emp_id = b.emp_id 
                WHERE 1 
                GROUP BY a.emp_id 
                HAVING sis05_clientes > 0 
                ORDER BY sis05_clientes DESC
                LIMIT 5;";
        $result = $this->db->query($sql);
        return $result->result_array();
    }
    
    function estudios()
    {
        $sql = "select sum(total) as total FROM (
                    select count(*) as total from fsm_poligrafico ";
                    if(get_perfil_id() == 4)
                    {
                        $sql .= " WHERE emp_id = ".get_emp_id()." ";
                    }
                    
                    $sql .="UNION 
                    select count(*) as total from fsm_medico_fisico ";
                    if(get_perfil_id() == 4)
                    {
                        $sql .= " WHERE emp_id = ".get_emp_id()." ";
                    }
                    $sql .="UNION 
                    select count(*) as total from fsm_psicologico ";
                    if(get_perfil_id() == 4)
                    {
                        $sql .= " WHERE emp_id = ".get_emp_id()." ";
                    }
                    $sql .="UNION 
                    select count(*) as total from fsm_toxicologico ";
                    if(get_perfil_id() == 4)
                    {
                        $sql .= " WHERE emp_id = ".get_emp_id()." ";
                    }
                    $sql .="UNION 
                    select count(*) as total from fsm_acreditacion ";
                    if(get_perfil_id() == 4)
                    {
                        $sql .= " WHERE emp_id = ".get_emp_id()." ";
                    }
                    $sql .="UNION 
                    select count(*) as total from fsm_historia_clinica ";
                    if(get_perfil_id() == 4)
                    {
                        $sql .= " WHERE emp_id = ".get_emp_id()." ";
                    }
                    $sql .="UNION 
                    select count(*) as total from socio_eco ";
                    if(get_perfil_id() == 4)
                    {
                        $sql .= " WHERE emp_id = ".get_emp_id()." ";
                    }
                    $sql .="UNION 
                    select count(*) as total from entorno_soc ";
                    if(get_perfil_id() == 4)
                    {
                        $sql .= " WHERE emp_id = ".get_emp_id()." ";
                    }
                    $sql .= ") as x;";
        $result = $this->db->query($sql);
        return $result->row_array();
    }
    
    function estudios_realizados($serv_id)
    {
        $sql = "select sum(IFNULL(total,0)) as total 
            FROM (
                select 1,IFNULL(count(fsm_id),0) as total from fsm_poligrafico where serv_id = $serv_id 
                UNION 
                select 2,IFNULL(count(fsm_id),0) as total from fsm_medico_fisico where serv_id = $serv_id 
                UNION 
                select 3,IFNULL(count(fsm_id),0) as total from fsm_psicologico where serv_id = $serv_id 
                UNION 
                select 4,IFNULL(count(fsm_id),0) as total from fsm_toxicologico where serv_id = $serv_id 
                UNION 
                select 5,IFNULL(count(fsm_id),0) as total from fsm_acreditacion where serv_id = $serv_id 
                UNION 
                select 6,IFNULL(count(fsm_id),0) as total from fsm_historia_clinica where serv_id = $serv_id 
                UNION 
                select 7,IFNULL(count(fsm_id),0) as total from socio_eco where serv_id = $serv_id 
                UNION 
                select 8,IFNULL(count(fsm_id),0) as total from entorno_soc where serv_id = $serv_id 
                ) as x ";
        $result = $this->db->query($sql);
        return $result->row_array();
    }
}