<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Sociolaboral_model extends CI_Model {
    
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    function delete_sociolaboral($fsm_id)
    {
        $this->db->where('fsm_id', $fsm_id);
        return $this->db->delete('fsm_sociolab');
    }

    
    function add($data_insert)
    {
        $this->db->insert('fsm_sociolab', $data_insert);
        return $this->db->insert_id();
    }

    function get($fsm_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('fsm_sociolab');
        $this->db->where('fsm_id', $fsm_id);
        /*if(get_perfil_id() == 4)
        {
            $this->db->where('emp_id', get_emp_id());
        }
        if(get_perfil_id() == 4)
        {
			if ($es_usr_de_un_despacho==0)
			{	
            $this->db->where('emp_id', get_emp_id());
			}
        }*/
        $result = $this->db->get();
        return $result->row_array();
    }

    function get_by_clte($cliente_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('fsm_sociolab');
        $this->db->where('clte_id', $cliente_id);
        /*if(get_perfil_id() == 4)
        {
            $this->db->where('emp_id', get_emp_id());   
        }
        if(get_perfil_id() == 4)
        {
			if ($es_usr_de_un_despacho==0)
			{	
            $this->db->where('emp_id', get_emp_id());
			}
		}*/
		
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }




    function update($id, $params)
    {
        $this->db->where('fsm_id', $id);
        return $this->db->update('fsm_sociolab', $params);
    }



    
    function insert_arreglo($array, $columna_val, $fsm_id, $tabla, $may = true)
    {
        $insert_id = null;

        if(!empty($array))
        {
            foreach($array as $row)
            {
                if(trim($row[$columna_val]) != "")
                {
                    foreach($row as $clave => $asoc)
                    {
                        //si es una columna tipo fecha lo parsea
                        if(strpos($clave,'_f_') !== FALSE)
                        {
                            $row[$clave]= formatea_fecha_mysql($asoc);
                        }
                        
                        //si es una columna tipo telefono lo parsea
                        if(strpos($clave,'telefono') !== FALSE)
                        {
                            $row[$clave]= limpia_telefono($asoc);
                        }

                    }

                    $row['fsm_id'] = $fsm_id;
                    if($may)
                    {
                        $this->db->insert($tabla,  array_to_upper($row));
                    }
                    else
                    {
                        $this->db->insert($tabla,  $row);
                    }
                }
            }
            $insert_id = $this->db->insert_id();
        }
        return $insert_id;
    }
    
    function get_data($tabla, $fsm_id)
    {
        $this->db->select('*');
        $this->db->from($tabla);
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->result_array();
    }

    function delete_tabla($fsm_id,$id,$tabla)
    {
        $key = $this->get_primary_key($tabla);
        $this->db->where('fsm_id', $fsm_id);
        $this->db->where($key, $id);
        return $this->db->delete($tabla);
    }

    function get_primary_key($tabla)
    {
        $column = '';
        $fields = $this->db->field_data($tabla);
        foreach ($fields as $field)
        {
            if($field->primary_key == 1)
            {
                $column = $field->name;
            }
        }
        return $column;
    }

    function update_arreglo($array, $columna_val, $fsm_id, $tabla)
    {
        $insert_id = null;
        if(!empty($array))
        {
            foreach($array as $row)
            {
                $primary_key = $this->get_primary_key($tabla);

                //si existe la llave primaria hay valores y se debe actualizar
                if(isset($row[$primary_key]))
                {
                    if(trim($row[$columna_val]) !== '') {
                        foreach($row as $clave => $asoc){
                            //si es una columna tipo fecha lo parsea
                            if(strpos($clave,'_f_') !== FALSE){
                                $row[$clave]= formatea_fecha_mysql($asoc);
                            }
                            
                            //si es una columna tipo telefono lo parsea
                            if(strpos($clave,'telefono') !== FALSE){
                                $row[$clave]= limpia_telefono($asoc);
                            }
                        }
                        $insert_id = $this->update_tabla($fsm_id,$tabla,$primary_key,$row[$primary_key],array_to_upper($row));
                    }
                }
                else
                {
                    //para insertar comprueba que no este vacia la columna principal para el insert
                    if(trim($row[$columna_val]) !== '') {
                        foreach($row as $clave => $asoc){

                            //si es una columna tipo fecha lo parsea
                            if(strpos($clave,'_f_') !== FALSE){
                                $row[$clave]= formatea_fecha_mysql($asoc);
                            }
                            
                            //si es una columna tipo telefono lo parsea
                            if(strpos($clave,'telefono') !== FALSE){
                                $row[$clave]= limpia_telefono($asoc);
                            }
                        }
                        $row['fsm_id'] = $fsm_id;
                        $this->db->insert($tabla,  array_to_upper($row));
                        $insert_id = $this->db->insert_id();
                    }
                }
            }
            
        }
        return $insert_id;
    }

    function update_tabla($fsm_id, $tabla, $key_id, $val_id, $data)
    {
        $this->db->where($key_id, $val_id);
        $this->db->where('fsm_id', $fsm_id);
        return $this->db->update($tabla, $data);
    }
}