<?php
/* 
 * Generated by CRUDigniter v2.3 Beta 
 * www.crudigniter.com
 */
 
class Escuela_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    
    /*
     * Get all escuelas
     */
    function get_all_escuelas()
    {
        return $this->db->get('entorno_soc_academico')->result_array();
    }
    
    /*
     * Get all escuelas by fsm_id
     */
    function get_escuelas($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('entorno_soc_academico');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->result_array();
    }
    
    /*
     * function to add new escuela
     */
    function inserta($params)
    {
        $this->db->insert('entorno_soc_academico',$params);
        return $this->db->insert_id();
    }
    
    /*
     * function to add new escuelas
     */
    function inserta_escuelas($escuelas, $fsm_id)
    {
        $insert_id = null;
        $this->load->helper('util');

        if(!empty($escuelas)){
            foreach($escuelas as $escuela){
                if(trim($escuela['nivel']) != ""){
                    $escuela['inicio'] = $escuela['inicio'];
                    $escuela['fsm_id'] = $fsm_id;
                    $this->db->insert('entorno_soc_academico',  array_to_upper($escuela));
                }
            }
            $insert_id = $this->db->insert_id();
        }
        return $insert_id;
    }
    
    /*
     * function to add new escuelas
     */
    function actualiza_escuelas($escuelas, $fsm_id)
    {
        $insert_id = null;
        if(!empty($escuelas))
        {
            foreach($escuelas as $escuela)
            {
                if(trim($escuela['nivel']) != "")
                {
                    if(isset($escuela['acad_id']))
                    {
                        $acad_id = $escuela['acad_id'];
                        unset($escuela['acad_id']);
                        $this->db->where('acad_id', $acad_id);
                        $this->db->update('entorno_soc_academico',  array_to_upper($escuela));
                    }
                    else
                    {
                        $escuela['fsm_id'] = $fsm_id;
                        $this->db->reset_query();
                        $this->db->insert('entorno_soc_academico',  array_to_upper($escuela));
                    }
                }
            }
            $insert_id = $this->db->insert_id();
        }
        return $insert_id;
    }
    
    function delete($fsm_id, $id)
    {
        $this->db->where('fsm_id', $fsm_id);
        $this->db->where('acad_id', $id);
        return $this->db->delete('entorno_soc_academico');
    }
}