<?php
/* 
 * Generated by CRUDigniter v2.3 Beta 
 * www.crudigniter.com
 */
 
class Auto_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    
    /*
     * Get all referencias auto
     */
    function get_all_autos()
    {
        return $this->db->get('socio_eco_auto')->result_array();
    }
    
    /*
     * Get all autos by fsm_id
     */
    function get_autos($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('socio_eco_auto');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->result_array();
    }
    
    /*
     * function to add new auto
     */
    function inserta($params)
    {
        $this->db->insert('socio_eco_auto',$params);
        return $this->db->insert_id();
    }
    
    /*
     * function to add new auto
     */
    function inserta_autos($autos, $fsm_id)
    {
        $insert_id = null;
        
        if(!empty($autos))
        {
            foreach($autos as $auto)
            {
                if(trim($auto['tipo']) != "")
                {
                    $auto['fsm_id'] = $fsm_id;
                    $this->db->insert('socio_eco_auto', array_to_upper($auto));
                }
            }
        
            $insert_id = $this->db->insert_id();
        }
        
        return $insert_id;
    }
	
    function actualiza_autos($autos, $fsm_id)
    {
        $insert_id = null;
        if(!empty($autos))
        {
            foreach($autos as $auto)
            {
                    if(isset($auto['autos_id']))
                    {
                        $autos_id = $auto['autos_id'];
                        unset($auto['autos_id']);
                        $this->db->where('autos_id', $autos_id);
                        $this->db->update('socio_eco_auto',  array_to_upper($auto));
                    }
                    else
                    {
                        $auto['fsm_id'] = $fsm_id;
                        $this->db->reset_query();
                        $this->db->insert('socio_eco_auto',  array_to_upper($auto));
                    }
            }
            $insert_id = $this->db->insert_id();
        }
        return $insert_id;
    }	
	
    
    function delete($fsm_id, $id)
    {
        $this->db->where('fsm_id', $fsm_id);
        $this->db->where('autos_id', $id);
        return $this->db->delete('socio_eco_auto');
    }
}
