<?php
defined('BASEPATH') OR exit('No direct script access allowed');
 
class Servicio_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->helper('util');
    }


function conteo_exa_evaluado_by_serv($clte_id,$serv_id,$tabla)
    {
        $sql = 'select count(*) as total from '.$tabla.' where serv_id = '.$serv_id.' and '.'clte_id='.$clte_id; 
        $result = $this->db->query($sql);		
        $total = $result->result_array();
		//echo $sql;
		return $total[0]['total'];
    }	
    
	function get_regiones_sgmty()
	{
	
		$this->db->select('*');
		$this->db->from('cat_catalogos');
		$this->db->like('cat_grupo', 'REGION_SGMTY'); 
		$this->db->like('cat_estatus_cve', 'ACTIVO'); 
		$this->db->order_by('cat_grupo_nombre','cat_nombre','DESC');
		$result = $this->db->get();
		return $result->result_array();
	}

	function get_cei_regiones_sgmty($cei)
	{
	
		$this->db->select('*');
		$this->db->from('cat_catalogos');
		$this->db->like('cat_grupo', 'REGION_SGMTY'); 
		$this->db->like('cat_grupo_nombre', $cei);
		$this->db->like('cat_estatus_cve', 'ACTIVO'); 
		$this->db->order_by('cat_grupo_nombre','cat_nombre','DESC');
		$result = $this->db->get();
		return $result->result_array();
	}

    function delete_servicio($serv_id)
    {
        return $this->db->delete('sis30_servicios',array('serv_id'=>$serv_id));
    }

    function get_simple($serv_id)
    {
        $this->db->select('*');
        $this->db->from('sis30_servicios');
        $this->db->where('serv_id',$serv_id);
		$this->db->where('serv_tipo','SERVICIOS' );
        return $this->db->get()->row_array();
    }

    function get($serv_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('sis30_servicios');
        $this->db->where('serv_id',$serv_id);
		$this->db->where_in('serv_tipo',array('SERVICIOS','ESPECIALES'));
        $this->db->group_by('serv_id');
        return $this->db->get()->row_array();
    }
 
 
     function get_my_service($serv_id)
    {
        $this->db->select('*');
        $this->db->from('sis30_servicios');
        $this->db->where('serv_id',$serv_id);
		$this->db->where('serv_tipo','SERVICIOS' );
        $this->db->group_by('serv_id');
        return $this->db->get()->row_array();
    }
 
 
 

    function get_serv_emp($serv_id)
    {
        $this->db->select('*');
        $this->db->from('sis30_servicios');
        $this->db->where('serv_id',$serv_id);
		$this->db->where_in('serv_tipo',array('SERVICIOS','ESPECIALES'));
        return $this->db->get()->row_array();
    }

    function get_evaluado($serv_id,$emp_id)
    {
        $this->db->select('*');
        $this->db->from('sis30_servicios');
        $this->db->where('serv_id',$serv_id);
		$this->db->where('serv_estatus_cve','PROCESO');
	    $this->db->where('emp_id', $emp_id);
		$this->db->where_in('serv_tipo',array('SERVICIOS','ESPECIALES'));
        return $this->db->get()->row_array();
    }


    function get_servicio_evaluado_allianza($clte_id,$emp_id)
    {
        $this->db->select('*');
        $this->db->from('sis12_sgmty_doc');
        $this->db->where('clte_id', $clte_id);
        return $this->db->get()->row_array();
    }


    function get_servicio_evaluado_allianza_g($clte_id,$emp_id)
    {
        $this->db->select('*');
        $this->db->from('sis12_sgmty_doc');
        $this->db->where('clte_id', $clte_id);
        return $this->db->get()->result_array();
    }



    function get_ultimo_servicio_by_evaluado($clte_id,$emp_id)
    {
        $this->db->select('*');
        $this->db->from('sis30_servicios');
        $this->db->where('clte_id',$clte_id);
	    $this->db->where('emp_id', $emp_id);
		$this->db->where('serv_tipo','SERVICIOS' );
        return $this->db->get()->row_array();
    }


    function get_estatus($serv_id)
    {
        $this->db->select('serv_estatus_cve');
        $this->db->from('sis30_servicios');
        $this->db->where('serv_id',$serv_id);
		$this->db->where('serv_tipo','SERVICIOS' );
        return $this->db->get()->row_array();
    }

 
	function get_cei($cei_id)
    {
        return $this->db->get_where('sis80_ceis',array('cei_id'=>$cei_id))->row_array();
    }
	
	
	
    function get_by_empresa($emp_id)
    {
        $this->db->select('*');
        $this->db->from('sis30_servicios');
        $this->db->where('emp_id',$emp_id);
        $this->db->where_in('serv_estatus_cve',array('PROCESO','CONCLUIDO'));
		$this->db->where('serv_tipo','SERVICIOS' );
        return $this->db->get()->result_array();
    }
  
    function get_by_empresa_l($emp_id)
    {
		if ($emp_id == 31)
		{
			$this->db->select('*');
			$this->db->from('sis30_servicios');
			$this->db->where('emp_id',$emp_id);
			$this->db->where_in('serv_estatus_cve',array('PROCESO','PREPAGADO'));
			$this->db->where('serv_tipo','SERVICIOS' );
			return $this->db->get()->result_array();	
		}
		else
		{
			$sql="SELECT * FROM `sis30_servicios` WHERE ";
			$sql=$sql."`emp_id` = ".$emp_id." and DATEDIFF(CURRENT_DATE(),`serv_f_fin`) < 31";
			$sql=$sql." and `serv_estatus_cve` in ('PROCESO','PREPAGADO') ";
			$sql=$sql." and `serv_tipo` =  'SERVICIOS'  ";
			//echo $sql;
			$result = $this->db->query($sql);
			return $result->result_array();
		}
    }

     function get_servicios_a_empresa($emp_id)
    {
		if ($emp_id == 31)
		{
			$this->db->select('*');
			$this->db->from('sis30_servicios');
			$this->db->where_in('serv_estatus_cve',array('PROCESO'));
			$this->db->order_by('serv_id','desc');
			//$this->db->where_in('serv_estatus_cve',array('PROCESO','CONCLUIDO'));
			return $this->db->get()->result_array();	
		}
		else
		{
			$sql="SELECT * FROM `sis30_servicios` WHERE ";
			$sql=$sql."`emp_id` = ".$emp_id." and DATEDIFF(CURRENT_DATE(),`serv_f_fin`) < 31";
			$sql=$sql." and `serv_estatus_cve` = 'PROCESO' ";
			$sql=$sql." and `serv_tipo` =  'SERVICIOS'  ";
			//echo $sql;
			$result = $this->db->query($sql);
			return $result->result_array();
		}
    }
 
    function get_mis_ordenes_servicios_a_empresa($emp_id)
    {
			$this->db->select('*');
			$this->db->from('sis30_servicios');
			$this->db->where('emp_id', $emp_id);
			$this->db->where_in('serv_estatus_cve',array('PROCESO','PREPAGADO'));
			$this->db->order_by('serv_id','desc');
			$this->db->where('serv_tipo','SERVICIOS' );
			return $this->db->get()->result_array();	
    }
 
 

	 
    function get_all($emp_id = '', $estatus = '', $rows = 30,$es_usr_de_un_despacho=0,$orden_servicio=0,$orden_venta='',$orden_cei='')
    {
		$user = $this->session->user;
		$user_root4=get_my_user_root4();
        $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;

        /*$sql = "SELECT a.*,b.*,SUM(c.exam_cantidad) as examenes FROM sis30_servicios as a LEFT JOIN sis15_empresas as b ON a.emp_id = b.emp_id LEFT JOIN sis35_servicios_examenes as c ON a.serv_id = c.serv_id ";
        $sql .= " GROUP BY serv_id"*/
        $this->db->select('a.*,b.*,SUM(c.exam_cantidad) as examenes, date_add(serv_f_fin, interval 1 day) as fecha_estimada, TIMESTAMPDIFF(MINUTE,serv_f_inicio,serv_f_fin) as diferencia,TIMESTAMPDIFF(MINUTE,serv_f_inicio,now()) as actual');
        //$this->db->select('a.*,b.*,SUM(c.exam_cantidad) as examenes');
		$this->db->from('sis30_servicios as a');
        $this->db->join('sis15_empresas as b','a.emp_id = b.emp_id','left');
        $this->db->join('sis35_servicios_examenes as c','a.serv_id = c.serv_id','left');
        if($emp_id != '')
        {
            $this->db->where('a.emp_id', $emp_id);
        }
        if($estatus != '')
        {
            $this->db->where('a.serv_estatus_cve', $estatus);
        }

        if (get_perfil_id() == 4)
        {
			if (($user['usr_id'] != 589) && ($user['usr_id'] != 590) && ($user['usr_id'] != 591))
			{				
				if ($user_root4 < 5) 
				{		
					if ( $es_usr_de_un_despacho == 0)
					{	
				
						$this->db->where('a.emp_id', get_emp_id());
						$this->db->where('a.desp_id', $es_usr_de_un_despacho);
					}
					else
					{	
						$this->db->where('a.desp_id', $es_usr_de_un_despacho);
					}	
				}
			}
			
		}
		
		if ( $orden_servicio > 0) { $this->db->where('a.serv_id', $orden_servicio );}
		if ( $orden_venta != '') { $this->db->like('a.serv_orden', $orden_venta  );}
		if ( $orden_cei != '') { $this->db->where('a.cei_control_id', $orden_cei  );}
		$this->db->where('a.serv_tipo','SERVICIOS' );
        $this->db->group_by('a.serv_id');
        $this->db->order_by('a.serv_f_inicio','DESC');
        $this->db->limit($rows, $page);
		
        $result = $this->db->get();
		return $result->result_array();
    }



    function get_all_services_dates($emp_id = '', $estatus = '', $rows = 30,$es_usr_de_un_despacho=0,$orden_servicio=0,$orden_venta='',$orden_cei='',$f_ini,$f_fin)
    {
		$user = $this->session->user;
		$user_root4=get_my_user_root4();
        $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;

        $this->db->select('a.*,SUM(c.exam_cantidad) as examenes, date_add(serv_f_fin, interval 1 day) as fecha_estimada, TIMESTAMPDIFF(MINUTE,serv_f_inicio,serv_f_fin) as diferencia,TIMESTAMPDIFF(MINUTE,serv_f_inicio,now()) as actual');
		$this->db->from('sis30_servicios as a');

        $this->db->join('sis35_servicios_examenes as c','a.serv_id = c.serv_id','left');
        if($emp_id != '')
        {
            $this->db->where('a.emp_id', $emp_id);
        }
        if($estatus != '')
        {
            $this->db->where('a.serv_estatus_cve', $estatus);
        }
		
		
		$this->db->where('serv_f_inicio >=', $f_ini.' 00:00:00');
		$this->db->where('serv_f_inicio <=', $f_fin.' 11:59:59');

     /*   if (get_perfil_id() == 4)
        {
			if (($user['usr_id'] != 589) && ($user['usr_id'] != 590) && ($user['usr_id'] != 591))
			{				
				if ($user_root4 < 5) 
				{		
					if ( $es_usr_de_un_despacho == 0)
					{	
				
						$this->db->where('a.emp_id', get_emp_id());
						$this->db->where('a.desp_id', $es_usr_de_un_despacho);
					}
					else
					{	
						$this->db->where('a.desp_id', $es_usr_de_un_despacho);
					}	
				}
			}
			
		}
		*/
		if ( $orden_servicio > 0) { $this->db->where('a.serv_id', $orden_servicio );}
		if ( $orden_venta != '') { $this->db->like('a.serv_orden', $orden_venta  );}
		if ( $orden_cei != '') { $this->db->where('a.cei_control_id', $orden_cei  );}
		$this->db->where_in('a.serv_tipo',array('SERVICIOS','ESPECIALES'));
        $this->db->group_by('a.serv_id');
        $this->db->order_by('a.serv_f_inicio','DESC');
        $this->db->limit($rows, $page);
		
        $result = $this->db->get();
		return $result->result_array();
    }


    function get_all_services($emp_id = '', $estatus = '', $rows = 30,$es_usr_de_un_despacho=0,$orden_servicio=0,$orden_venta='',$orden_cei='')
    {
		$user = $this->session->user;
		$user_root4=get_my_user_root4();
        $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;

        $this->db->select('a.*,SUM(c.exam_cantidad) as examenes, date_add(serv_f_fin, interval 1 day) as fecha_estimada, TIMESTAMPDIFF(MINUTE,serv_f_inicio,serv_f_fin) as diferencia,TIMESTAMPDIFF(MINUTE,serv_f_inicio,now()) as actual');
		$this->db->from('sis30_servicios as a');
       // $this->db->join('sis15_empresas as b','a.emp_id = b.emp_id','left');
        $this->db->join('sis35_servicios_examenes as c','a.serv_id = c.serv_id','left');
        if($emp_id != '')
        {
            $this->db->where('a.emp_id', $emp_id);
        }
        if($estatus != '')
        {
            $this->db->where('a.serv_estatus_cve', $estatus);
        }

        if (get_perfil_id() == 4)
        {
			if (($user['usr_id'] != 589) && ($user['usr_id'] != 590) && ($user['usr_id'] != 591))
			{				
				if ($user_root4 < 5) 
				{		
					if ( $es_usr_de_un_despacho == 0)
					{	
				
						$this->db->where('a.emp_id', get_emp_id());
						$this->db->where('a.desp_id', $es_usr_de_un_despacho);
					}
					else
					{	
						$this->db->where('a.desp_id', $es_usr_de_un_despacho);
					}	
				}
			}
			
		}
		
		if ( $orden_servicio > 0) { $this->db->where('a.serv_id', $orden_servicio );}
		if ( $orden_venta != '') { $this->db->like('a.serv_orden', $orden_venta  );}
		if ( $orden_cei != '') { $this->db->where('a.cei_control_id', $orden_cei  );}
		$this->db->where_in('a.serv_tipo',array('SERVICIOS','ESPECIALES'));
        $this->db->group_by('a.serv_id');
        $this->db->order_by('a.serv_f_inicio','DESC');
        $this->db->limit($rows, $page);
		
        $result = $this->db->get();
		return $result->result_array();
    }




    function get_empresa_especifica($emp_id = '', $estatus = '', $rows = 30)
    {
        $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
        $this->db->select('a.*, date_add(serv_f_fin, interval 1 day) as fecha_estimada, TIMESTAMPDIFF(MINUTE,serv_f_inicio,serv_f_fin) as diferencia,TIMESTAMPDIFF(MINUTE,serv_f_inicio,now()) as actual');
		$this->db->from('sis30_servicios as a');

        if($emp_id != '')
        {
            $this->db->where('a.emp_id', $emp_id);
        }
		
        if($estatus != '')
        {
            $this->db->where('a.serv_estatus_cve', $estatus);
        }	
		$this->db->where_in('a.serv_tipo',array('SERVICIOS','ESPECIALES'));
	   $this->db->order_by('a.serv_id','DESC');	   
       $this->db->limit($rows, $page);		
       $result = $this->db->get();
	   return $result->result_array();
    }



    function get_todas_empresas($estatus = '', $rows = 30)
    {
        $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
        $this->db->select('a.*, date_add(serv_f_fin, interval 1 day) as fecha_estimada, TIMESTAMPDIFF(MINUTE,serv_f_inicio,serv_f_fin) as diferencia,TIMESTAMPDIFF(MINUTE,serv_f_inicio,now()) as actual');
		$this->db->from('sis30_servicios as a');
        if($estatus != '')
        {
            $this->db->where('a.serv_estatus_cve', $estatus);
        }		
       $this->db->where_in('a.serv_tipo',array('SERVICIOS','ESPECIALES'));
	   $this->db->order_by('a.serv_id','DESC');	   
       $this->db->limit($rows, $page);		
        $result = $this->db->get();
		return $result->result_array();
    }

	 
    function get_all_ac($emp_id = '', $estatus = '', $rows = 30,$es_usr_de_un_despacho=0)
    {
        $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;
        $this->db->select('a.*, date_add(serv_f_fin, interval 1 day) as fecha_estimada, TIMESTAMPDIFF(MINUTE,serv_f_inicio,serv_f_fin) as diferencia,TIMESTAMPDIFF(MINUTE,serv_f_inicio,now()) as actual');
		$this->db->from('sis30_servicios as a');

        if($emp_id != '')
        {
            $this->db->where('a.emp_id', $emp_id);
        }
        if($estatus != '')
        {
            $this->db->where('a.serv_estatus_cve', $estatus);
        }		
        if (get_perfil_id() == 4)
        {
			if ( $es_usr_de_un_despacho == 0)
			{	
		
				$this->db->where('a.emp_id', get_emp_id());
				$this->db->where('a.desp_id', $es_usr_de_un_despacho);
			}
			else
			{	
				$this->db->where('a.desp_id', $es_usr_de_un_despacho);
			}	
        }	
		
       $this->db->where_in('a.serv_tipo',array('SERVICIOS','ESPECIALES'));
	   $this->db->order_by('a.serv_id','DESC');	   
       $this->db->limit($rows, $page);		
        $result = $this->db->get();
		return $result->result_array();
    }


    function get_all_ac_gsi($estatus = '', $rows = 30,$es_usr_de_un_despacho=0)
    {
        $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;

        $this->db->select('a.*,b.*, date_add(serv_f_fin, interval 1 day) as fecha_estimada, TIMESTAMPDIFF(MINUTE,serv_f_inicio,serv_f_fin) as diferencia,TIMESTAMPDIFF(MINUTE,serv_f_inicio,now()) as actual');
		$this->db->from('sis30_servicios as a');
        $this->db->join('sis15_empresas as b','a.emp_id = b.emp_id','left');

        $this->db->where('b.emp_corp', 'GSI');

        if($estatus != '')
        {
            $this->db->where('a.serv_estatus_cve', $estatus);
        }

		
        if (get_perfil_id() == 4)
        {
			if ( $es_usr_de_un_despacho == 0)
			{	
		
				$this->db->where('a.emp_id', get_emp_id());
				$this->db->where('a.desp_id', $es_usr_de_un_despacho);
			}
			else
			{	
				$this->db->where('a.desp_id', $es_usr_de_un_despacho);
			}	
        }

		
       $this->db->where_in('a.serv_tipo',array('SERVICIOS','ESPECIALES'));
	   $this->db->order_by('a.serv_id','DESC');
        $this->db->limit($rows, $page);
		
        $result = $this->db->get();
		return $result->result_array();
    }


    function count_all_empresas_asig($empresas_id)
	{
		$this->db->select("count(serv_id) as regs");
		$this->db->from('sis30_servicios');		
		$this->db->where_in('emp_id', $empresas_id);
		$this->db->where_in('serv_tipo',array('SERVICIOS','ESPECIALES'));
		
		$result = $this->db->get();
		$row = $result->row_array();
		return $row['regs'];
	}


    function get_all_ac_gsi_gss_2($estatus = '', $rows = 30,$empresas_id ,$es_usr_de_un_despacho=0)
    {
        $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;

        $this->db->select('a.*,b.*, date_add(serv_f_fin, interval 1 day) as fecha_estimada, TIMESTAMPDIFF(MINUTE,serv_f_inicio,serv_f_fin) as diferencia,TIMESTAMPDIFF(MINUTE,serv_f_inicio,now()) as actual');
		$this->db->from('sis30_servicios as a');
        $this->db->join('sis15_empresas as b','a.emp_id = b.emp_id','left');
		$this->db->where_in('a.emp_id', $empresas_id);
        if($estatus != '')
        {
            $this->db->where('a.serv_estatus_cve', $estatus);
        }
		$this->db->where_in('a.serv_tipo',array('SERVICIOS','ESPECIALES'));
		$this->db->order_by('a.serv_id','DESC');
        $this->db->limit($rows, $page);		
        $result = $this->db->get();
		return $result->result_array();
    }





    function get_all_ac_gsi_gss($estatus = '', $rows = 30,$es_usr_de_un_despacho=0)
    {
        $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;

        $this->db->select('a.*,b.*, date_add(serv_f_fin, interval 1 day) as fecha_estimada, TIMESTAMPDIFF(MINUTE,serv_f_inicio,serv_f_fin) as diferencia,TIMESTAMPDIFF(MINUTE,serv_f_inicio,now()) as actual');
		$this->db->from('sis30_servicios as a');
        $this->db->join('sis15_empresas as b','a.emp_id = b.emp_id','left');

        $this->db->where('b.emp_corp', 'GSI');
		$this->db->where('b.emp_subcorp', 'GSS');
	    $this->db->where_in('a.serv_tipo',array('SERVICIOS','ESPECIALES'));
        if($estatus != '')
        {
            $this->db->where('a.serv_estatus_cve', $estatus);
        }
	   $this->db->order_by('a.serv_id','DESC');
        $this->db->limit($rows, $page);
		
        $result = $this->db->get();
		return $result->result_array();
    }



    function get_all_ac_gsi_cometra($estatus = '', $rows = 30,$es_usr_de_un_despacho=0)
    {
        $page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*30:0;

        $this->db->select('a.*,b.*, date_add(serv_f_fin, interval 1 day) as fecha_estimada, TIMESTAMPDIFF(MINUTE,serv_f_inicio,serv_f_fin) as diferencia,TIMESTAMPDIFF(MINUTE,serv_f_inicio,now()) as actual');
		$this->db->from('sis30_servicios as a');
        $this->db->join('sis15_empresas as b','a.emp_id = b.emp_id','left');

        $this->db->where('b.emp_corp', 'GSI');
		$this->db->where('b.emp_subcorp', 'COMETRA');

        if($estatus != '')
        {
            $this->db->where('a.serv_estatus_cve', $estatus);
        }

		
        if (get_perfil_id() == 4)
        {
			if ( $es_usr_de_un_despacho == 0)
			{	
		
				$this->db->where('a.emp_id', get_emp_id());
				$this->db->where('a.desp_id', $es_usr_de_un_despacho);
			}
			else
			{	
				$this->db->where('a.desp_id', $es_usr_de_un_despacho);
			}	
        }

		
       $this->db->where_in('a.serv_tipo',array('SERVICIOS','ESPECIALES'));
	   $this->db->order_by('a.serv_id','DESC');
        $this->db->limit($rows, $page);
		
        $result = $this->db->get();
		return $result->result_array();
    }



    function count_all_empresa()
        {
            $this->db->select("count(serv_id) as regs");
            $this->db->from('sis30_servicios');            
			$this->db->where_in('serv_tipo',array('SERVICIOS','ESPECIALES'));
			$result = $this->db->get();
			$row = $result->row_array();
			return $row['regs'];
		}


    function count_all($es_usr_de_un_despacho=0)
        {
            $this->db->select("count(serv_id) as regs");
            $this->db->from('sis30_servicios');
            
			$this->db->where_in('serv_tipo',array('SERVICIOS','ESPECIALES'));
			if (get_perfil_id() == 4)
			{
				if ( $es_usr_de_un_despacho == 0)
				{	
			
					$this->db->where('emp_id', get_emp_id());
					$this->db->where('desp_id', $es_usr_de_un_despacho);
				}
				else
				{	
					$this->db->where('desp_id', $es_usr_de_un_despacho);
				}	
			}			
				$result = $this->db->get();
				$row = $result->row_array();
				return $row['regs'];
		}
		


    function count_all_emp_asignada($emp_id)
        {
            $this->db->select("count(serv_id) as regs");
            $this->db->from('sis30_servicios');            
			$this->db->where_in('serv_tipo',array('SERVICIOS','ESPECIALES'));
			$this->db->where('emp_id', $emp_id);
				$result = $this->db->get();
				$row = $result->row_array();
				return $row['regs'];
		}
		
    function count_all_emp_asig($emp_id,$es_usr_de_un_despacho=0)
        {
            $this->db->select("count(serv_id) as regs");
            $this->db->from('sis30_servicios');
            
			$this->db->where_in('serv_tipo',array('SERVICIOS','ESPECIALES'));
			$this->db->where('emp_id', $emp_id);
			if (get_perfil_id() == 4)
			{
				if ( $es_usr_de_un_despacho == 0)
				{	
			
					
					$this->db->where('desp_id', $es_usr_de_un_despacho);
				}
				else
				{	
					$this->db->where('desp_id', $es_usr_de_un_despacho);
				}	
			}			
				
				$result = $this->db->get();
				$row = $result->row_array();
				return $row['regs'];
		}

    function count_all_empresas_gsi()
	{
		$this->db->select("count(serv_id) as regs");
		$this->db->from('sis30_servicios');		
		$this->db->where_in('emp_id', "select emp_id from sis15_empresas where emp_corp like 'GSI'" );
		$this->db->where_in('serv_tipo',array('SERVICIOS','ESPECIALES'));
		$result = $this->db->get();
		$row = $result->row_array();
		return $row['regs'];
	}	
  
    function count_all_pro($es_usr_de_un_despacho=0)
        {
            $this->db->select("count(serv_id) as regs");
            $this->db->from('sis30_servicios');
			$this->db->where('serv_tipo','SERVICIOS' );
			$this->db->where('serv_estatus_cve','PROCESO');
			if (get_perfil_id() == 4)
			{
				if ( $es_usr_de_un_despacho == 0)
				{	
			
					$this->db->where('emp_id', get_emp_id());
					$this->db->where('desp_id', $es_usr_de_un_despacho);
				}
				else
				{	
					$this->db->where('desp_id', $es_usr_de_un_despacho);
				}	
			}			
				
				$result = $this->db->get();
				$row = $result->row_array();
				return $row['regs'];
		}

	
    /*
     * function to add new servicio
     */
    function inserta($params)
    {
        $data = array_merge($params,log_insert('ADD_SERV'));
        $this->db->insert('sis30_servicios',$data);
        return $this->db->insert_id();
    }
	
    function inserta_reclutamiento($params)
    {
        $data = array_merge($params,log_insert('ADD_RECLU'));
        $this->db->insert('sis33_servicios_reclu',$data);
        return $this->db->insert_id();
    }	
    
    function inserta_nota($params)
    {
        $data = array_merge($params,log_insert('ADD_SERV_NOTA'));
        $this->db->insert('sis45_servicios_notas',$data);
        return $this->db->insert_id();
    }
    
    function inserta_anexos($array)
    {
        $this->db->insert_batch('sis40_servicios_anexos', $array);
    }
    
    /*inserta los examenes a realizar*/
    function inserta_examenes($examenes, $serv_id)
    {
        $insert_id = null;
        if( ! empty($examenes))
        {
            foreach($examenes as $examen)
            {
                if(trim($examen['cve']) != "")
                {
                    $examen_ins['serv_id'] = $serv_id;
                    $examen_ins['exam_cve'] = $examen['cve'];
                    $examen_ins['exam_cantidad'] = $examen['cantidad'];
                    $examen_ins['exam_estatus_cve'] = 'PEND';
                    $this->inserta_examen($examen_ins, $serv_id);
                }
            }
        }
        return $insert_id;
    }
    
    function inserta_examen($params)
    {
        $data = array_merge($params,log_insert('ADD_SERV_EXAM'));
		$this->db->insert('sis35_servicios_examenes',$data);
        return $this->db->insert_id();
    }
 
    function actualiza_examenes($exam_id,$params)
    {
        $this->db->where('exam_id',$exam_id);
        return $this->db->update('sis35_servicios_examenes',$params);
    }

 
    /*
     * function to update servicio
     */
    function update($serv_id,$params)
    {
        $data = array_merge($params, log_update('UPD_SERV_EXAM'));
        $this->db->where('serv_id',$serv_id);
        return $this->db->update('sis30_servicios',$data);
    }
    
	
    /*
     * function to update_cal_id en un servicio
     */
    function update_cal_id($serv_id,$cal_id)
    {
	$data = array(
        'cal_id' => $cal_id
		);
        
        $this->db->where('serv_id',$serv_id);
        return $this->db->update('sis30_servicios',$data);
    }	
	
	
    /*
     * function to delete servicio 
     */
    function delete_empresa($serv_id)
    {
        return $this->db->delete('sis30_servicios',array('serv_id'=>$serv_id));
    }
  

    function get_examenes($serv_id)
    {
	    $this->db->select('*');
        $this->db->from('sis35_servicios_examenes');
        $this->db->where('serv_id',$serv_id);
        $this->db->order_by('exam_id','ASC');
        return $this->db->get()->result_array();
		
    }

  
    function get_examenes_order_by($serv_id)
    {
	    $this->db->select('*');
        $this->db->from('sis35_servicios_examenes');
        $this->db->where('serv_id',$serv_id);
		$this->db->where('log_updt_usr_cve !=','00');
		$this->db->order_by('log_updt_usr_cve','asc');
        return $this->db->get()->result_array();
		
    }

    function get_archivos_examenes($serv_id)
    {
        $this->db->select('*');
        $this->db->from('sis10_clientes_doc');
        $this->db->where('serv_id',$serv_id);
        $this->db->order_by('doc_id','ASC');
        return $this->db->get()->result_array();
    }

	
	function get_paquete_desde_serv($serv_id,$pakt)
    {
        $this->db->select('*');
        $this->db->from('sis35_servicios_examenes');
        $this->db->where('serv_id',$serv_id);
		$this->db->where('exam_nombre_pkt',$pakt);
        $this->db->order_by('exam_id','ASC');
        return $this->db->get()->result_array();
    }


	function get_paquetes_cliente_desde_serv($clte_id,$serv_id)
    {
        $this->db->select('*');
        $this->db->from('sis12_sgmty_doc');
        $this->db->where('serv_id',$serv_id);
		$this->db->where('clte_id',$clte_id);
        return $this->db->get()->row_array();
    }
	
    
    function get_notas($serv_id)
    {
        $this->db->select('a.*,b.*');
        $this->db->from('sis45_servicios_notas as a');
        $this->db->join('sis20_usuarios as b','a.usr_id = b.usr_id','left');
        $this->db->where('a.serv_id',$serv_id);
        $this->db->order_by('a.nota_f','DESC');
        return $this->db->get()->result_array();
    }
    
    function get_anexos($serv_id)
    {
        $this->db->select('*');
        $this->db->from('sis40_servicios_anexos');
        $this->db->where('serv_id',$serv_id);
        $this->db->order_by('anexo_id','ASC');
        return $this->db->get()->result_array();
    }
 


 
    function delete_examen($serv_id, $exam_id)
    {
        return $this->db->delete('sis35_servicios_examenes',array('serv_id'=>$serv_id, 'exam_id' => $exam_id));
    }
	
	function delete_examenes($serv_id)
    {
        return $this->db->delete('sis35_servicios_examenes',array('serv_id'=>$serv_id));
    }
    
    function delete_anexo($serv_id, $anexo_id)
    {
        return $this->db->delete('sis40_servicios_anexos',array('serv_id'=>$serv_id, 'anexo_id' => $anexo_id));
    }

    function get_examenes_serv($serv_id,$modo=0,$emp_id,$ini='',$fin ='')
    {
		if ($modo == 8)
		{	
			$select = "SELECT max(b.log_updt_f) as maximo";
			$sql = parsea_select($select, 'humancenter');
		}
		elseif ($modo == 6)
		{	
			$select = "SELECT min(b.log_updt_f) as minimo";
			$sql = parsea_select($select, 'humancenter');
		}
		else
			if ($modo == 4)
		{	
			$select = "SELECT a.clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_rfc_crypt,cei_id, desp_id,clte_genero_cve,clte_region,clte_webflow,clte_zona,emp_id,log_updt_f , GROUP_CONCAT( CONCAT(a.tipo,'|',a.fsm_id) ORDER BY a.tipo DESC ) as examenes ";
			$sql = parsea_select($select, 'humancenter');
		}
		elseif ($modo == 0)
		{	
			$select = "SELECT a.clte_id, clte_nombre_crypt, clte_2_nombre_crypt, clte_paterno_crypt, clte_materno_crypt, clte_rfc_crypt,cei_id, desp_id,clte_genero_cve,clte_region,clte_webflow,clte_zona,emp_id,log_updt_f ,GROUP_CONCAT( CONCAT(a.tipo,'|',a.fsm_id) ORDER BY a.tipo DESC ) as examenes ";
			$sql = parsea_select($select, 'humancenter');
		}
		else
		{
			$sql = "SELECT count(DISTINCT a.clte_id) as total ";
		}	
		
        $sql .= " FROM (
				select clte_id, fsm_id, 'PH3P4TIC0' as tipo  from fsm_perfil_hepatico  where serv_id in ($serv_id) 
				UNION
				select clte_id, fsm_id, 'QS38' as tipo  from fsm_quimica_sanguinea38  where serv_id in ($serv_id) 
				UNION
				select clte_id, fsm_id, 'QS33' as tipo  from fsm_quimica_sanguinea38  where serv_id in ($serv_id) 
                UNION
				select clte_id, fsm_id, 'QS6' as tipo  from fsm_quimica_sanguinea6  where serv_id in ($serv_id) 
                UNION
				select clte_id, fsm_id, 'HCSYNGENTA' as tipo  from fsm_hcsyngenta where serv_id in ($serv_id) 
                UNION
                select clte_id, fsm_id, 'SOCIO_SERV' as tipo  from socioeconomico where serv_id in ($serv_id) 
                UNION
                select clte_id, fsm_id, 'SOCIO_RES' as tipo  from socio_resultado where serv_id in ($serv_id) 
                UNION
				select clte_id, fsm_id, 'EXMEPER' as tipo  from fsm_exmeper where serv_id in ($serv_id) 
                UNION
				select clte_id, fsm_id, 'PFIIBX+' as tipo  from fsm_quimica_sanguinea_bx_pfii where serv_id in ($serv_id)
				UNION
 				select clte_id, fsm_id, 'QSBX+' as tipo  from fsm_quimica_sanguinea_bx  where serv_id in ($serv_id)
                UNION
				select clte_id, fsm_id, 'NOM0353' as tipo  from fsm_nom035iii where serv_id in ($serv_id)
                UNION
				select clte_id, fsm_id, 'NOM0352' as tipo  from fsm_nom035ii  where serv_id in ($serv_id)
                UNION
				select clte_id, fsm_id, 'NOM0351' as tipo  from fsm_nom035 where serv_id in ($serv_id)
                UNION
				select clte_id, fsm_id, '3L35ER1C0S' as tipo  from fsm_electrolitos_sericos where serv_id in ($serv_id)
                UNION
				select clte_id, fsm_id, 'NUNIMEDICA' as tipo  from fsm_nota_uni_medica where serv_id in ($serv_id)
                UNION
				select clte_id, fsm_id, 'NUNIPSICO' as tipo  from fsm_nota_uni_psicologica where serv_id in ($serv_id)
                UNION
				select clte_id, fsm_id, 'H0N3' as tipo  from fsm_hone_aicm where serv_id in ($serv_id)
                UNION
				select clte_id, fsm_id, 'ARVP' as tipo  from fsm_arvp where serv_id in ($serv_id)
                UNION
				select clte_id, fsm_id, 'FLOTILLA' as tipo  from fsm_flotilla where serv_id in ($serv_id)
                UNION
				select clte_id, fsm_id, 'QS6' as tipo  from fsm_quimica_sanguinea6 where serv_id in ($serv_id)
                UNION
				select clte_id, fsm_id, 'COLISER' as tipo  from fsm_colinesterasa_serica where serv_id in ($serv_id)
                UNION
                select clte_id, fsm_id, 'INSU_BASAL' as tipo  from fsm_insulina_basal where serv_id in ($serv_id)
                UNION
				select clte_id, fsm_id, 'NPSICO' as tipo  from fsm_nota_psicologica where serv_id in ($serv_id)
                UNION
				select clte_id, fsm_id, 'CERTMED' as tipo  from fsm_certificado_medico where serv_id in ($serv_id)
                UNION				
				select clte_id, fsm_id, 'CURSOHC' as tipo  from fsm_curso where serv_id in ($serv_id)
                UNION				
				select clte_id, fsm_id, 'VPPRO02' as tipo  from fsm_venta_producto02 where serv_id in ($serv_id)
                UNION				
				select clte_id, fsm_id, 'HICL030' as tipo  from fsm_hicl030 where serv_id in ($serv_id)
                UNION

				select clte_id, fsm_id, 'HICLOEO' as tipo  from fsm_hicloeo where serv_id in ($serv_id)
                UNION
				
				select clte_id, fsm_id, 'VPPRO01' as tipo  from fsm_venta_producto where serv_id in ($serv_id)
                UNION		
		
				select clte_id, fsm_id, 'HMEDXFIS' as tipo  from fsm_medico_fisico_ext where serv_id in ($serv_id)
                UNION
				select clte_id, fsm_id, 'ODON' as tipo  from fsm_odon where serv_id in ($serv_id)
                UNION		
				select clte_id, fsm_id, 'PIE' as tipo  from fsm_pie where serv_id in ($serv_id)
                UNION
                select clte_id, fsm_id, 'GPOSAN' as tipo  from fsm_grupo_sanguineo where serv_id in ($serv_id)
                UNION			
                select clte_id, fsm_id, 'BIOHEM' as tipo  from fsm_biometria_hematica where serv_id in ($serv_id)
                UNION		
                select clte_id, fsm_id, 'ORINA' as tipo  from fsm_orina where serv_id in ($serv_id)
                UNION		
                select clte_id, fsm_id, 'COV19R' as tipo  from fsm_covid where serv_id in ($serv_id)
                UNION 		
                select clte_id, fsm_id, 'POL' as tipo from fsm_poligrafico where serv_id in ($serv_id)and polig_tipo_cve = 'POLI'
                UNION 
                select clte_id, fsm_id, 'CED' as tipo from fsm_poligrafico where serv_id in ($serv_id) and polig_tipo_cve = 'CEDULA' 
                UNION 
                select clte_id, fsm_id, 'MEDFIS' as tipo  from fsm_medico_fisico where serv_id in ($serv_id)
                UNION 
                select clte_id, fsm_id, 'PSIC' as tipo  from fsm_psicologico where serv_id in ($serv_id)
                UNION 
                select clte_id, fsm_id, 'PSSIM' as tipo  from fsm_psicologico_4 where serv_id in ($serv_id)
				UNION 
                select clte_id, doc_id, 'HONE' as tipo  from sis12_honestidad_doc where serv_id in ($serv_id)
				UNION 
                select clte_id, doc_id, 'COMPO' as tipo  from sis13_comportamiento_doc where serv_id in ($serv_id)
				UNION 
				select clte_id, fsm_id, 'TOXIT' as tipo from fsm_toxicologico3 where serv_id in ($serv_id)
                UNION
                select clte_id, fsm_id, 'TOXI' as tipo from fsm_toxicologico where serv_id in ($serv_id)
                UNION
                select clte_id, fsm_id, 'EYED' as tipo from fsm_eye_detect where serv_id in ($serv_id)
				UNION				
                select clte_id, fsm_id, 'TOXIX' as tipo from fsm_toxicologico6 where serv_id in ($serv_id)				
				UNION				
                select clte_id, fsm_id, 'TOXIS' as tipo from fsm_toxicologico7 where serv_id in ($serv_id)                
				UNION
                select clte_id, fsm_id, 'TOXIN' as tipo from fsm_toxi where serv_id in ($serv_id)
                UNION     
                select clte_id, fsm_id, 'ACRED' as tipo  from fsm_acreditacion where serv_id in ($serv_id)
                UNION                
                select clte_id, fsm_id, 'HIST' as tipo  from fsm_historia_clinica where serv_id in ($serv_id)
                UNION 
                select clte_id, fsm_id, 'SOCIE' as tipo  from socio_eco where serv_id in ($serv_id)
                UNION 
                select clte_id, fsm_id, 'ENTSOC' as tipo  from entorno_soc where serv_id in ($serv_id)
				UNION 
                select clte_id, doc_id, 'SGMTY' as tipo  from sis12_sgmty_doc where serv_id in ($serv_id)
				UNION 
                select clte_id, doc_id, 'PUESIC' as tipo  from sis12_pruebas_psico_doc where serv_id in ($serv_id)
				UNION 
                select clte_id, fsm_id, 'SOCIOL' as tipo  from fsm_sociolab where serv_id in ($serv_id)
				UNION 
                select clte_id, fsm_id, 'ALCOHOL' as tipo  from fsm_alcohol where serv_id in ($serv_id)
				UNION 
                select clte_id, fsm_id, 'VDRL' as tipo  from fsm_vdrl where serv_id in ($serv_id)				
				UNION 
                select clte_id, doc_id, 'CAMA000' as tipo  from sis12_cama000_doc where serv_id in ($serv_id)				
				UNION 
                select clte_id, doc_id, 'EVADIATM' as tipo  from sis12_evaluacion_diagnostica_doc where serv_id in ($serv_id)				
				UNION 
                select clte_id, doc_id, 'EVAFINATM' as tipo  from sis12_evaluacion_final_doc where serv_id in ($serv_id)				
				UNION 
                select clte_id, doc_id, 'WNTPZI' as tipo  from sis12_entrevista_doc where serv_id in ($serv_id)
				UNION 
                select clte_id, doc_id, 'PRPRO' as tipo  from sis12_proyectivas_doc where serv_id in ($serv_id)
				UNION 
                select clte_id, doc_id, 'SPIRO' as tipo  from sis12_spiro_doc where serv_id in ($serv_id)
				UNION 
                select clte_id, doc_id, 'EVACOM' as tipo  from sis12_evacom_doc where serv_id in ($serv_id)		
				UNION 
                select clte_id, doc_id, 'EXMEDDS' as tipo  from sis12_examm_ds_doc where serv_id in ($serv_id)
				UNION 
                select clte_id, doc_id, 'VALPROF' as tipo  from sis12_valprof_doc where serv_id in ($serv_id)
				UNION 
                select clte_id, doc_id, 'KOHU' as tipo  from sis12_koh_doc where serv_id in ($serv_id)				
				UNION 
                select clte_id, doc_id, 'PENSA' as tipo  from sis12_pensa_doc where serv_id in ($serv_id)
				UNION 
                select clte_id, doc_id, 'CLEAVER' as tipo  from sis12_cleaver_doc where serv_id in ($serv_id)

				UNION 
                select clte_id, doc_id, 'SOCDIGLAB' as tipo  from sis12_generico_doc where serv_id in ($serv_id) and doc_clave = 'SOCDIGLAB;'
				
				UNION 
                select clte_id, doc_id, 'INREFLA' as tipo  from sis12_generico_doc where serv_id in ($serv_id) and doc_clave = 'INREFLA;'
				
				UNION 
                select clte_id, doc_id, 'BENDER' as tipo  from sis12_generico_doc where serv_id in ($serv_id) and doc_clave = 'BENDER;'
				
				UNION 
                select clte_id, doc_id, 'ENTFIN' as tipo  from sis12_generico_doc where serv_id in ($serv_id) and doc_clave = 'ENTFIN;'
				
				UNION 
                select clte_id, doc_id, 'BURO' as tipo  from sis12_buro_doc where serv_id in ($serv_id)
				UNION 
                select clte_id, doc_id, 'LEGAL' as tipo  from sis12_legal_doc where serv_id in ($serv_id)				
				UNION 
                select clte_id, doc_id, 'EXAMM' as tipo  from sis12_examm_doc where serv_id in ($serv_id)				
				UNION
				select clte_id, doc_id, 'ANTICUA' as tipo  from sis12_anticua_doc where serv_id in ($serv_id)               
			    UNION
				select clte_id, doc_id, 'ALCOSA' as tipo  from sis12_alcosa_doc where serv_id in ($serv_id)               
				UNION
				select clte_id, doc_id, 'PCR' as tipo  from sis12_pcr_doc where serv_id in ($serv_id)               
			   	UNION
				select clte_id, doc_id, 'TORAX' as tipo  from sis12_torax_doc where serv_id in ($serv_id)               
				UNION
				select clte_id, doc_id, 'RADIOT' as tipo  from sis12_radiot_doc where serv_id in ($serv_id)                
				UNION
				select clte_id, doc_id, 'RADIOM' as tipo  from sis12_radiom_doc where serv_id in ($serv_id) 							   
				UNION
				select clte_id, doc_id, 'RADIOL' as tipo  from sis12_radiol_doc where serv_id in ($serv_id)
				UNION
                select clte_id, doc_id, 'RADIO_SAP' as tipo  from sis12_radio_sap_doc where serv_id in ($serv_id)
				UNION
                select clte_id, doc_id, 'RADIO_LAT' as tipo  from sis12_radio_lat_doc where serv_id in ($serv_id)
				UNION
				select clte_id, doc_id, 'CMCARGA' as tipo  from sis12_certificado_doc where serv_id in ($serv_id)
				UNION
				select clte_id, doc_id, 'R3NP3RF' as tipo  from sis13_renperfiles where serv_id in ($serv_id)
				UNION
				select clte_id, doc_id, 'R3N3NTS0C' as tipo  from sis13_renentsol where serv_id in ($serv_id)
				UNION
				select clte_id, doc_id, 'R3N3X4M3D' as tipo  from sis13_renexamed where serv_id in ($serv_id)
				UNION
				select clte_id, doc_id, 'R3N00D' as tipo  from sis13_renodo where serv_id in ($serv_id)
				UNION
				select clte_id, doc_id, 'R3NP52' as tipo  from sis13_renpsico where serv_id in ($serv_id)
				UNION
				select clte_id, doc_id, 'R3NT00X' as tipo  from sis13_rentoxi where serv_id in ($serv_id)
				UNION 
				select clte_id, fsm_id, 'FEBRILES' as tipo  from fsm_reacciones where serv_id in ($serv_id)
				UNION 
				select clte_id, fsm_id, 'PROST' as tipo  from fsm_prost where serv_id in ($serv_id)
				UNION 
				select clte_id, fsm_id, 'HBSAG' as tipo  from fsm_hbsag where serv_id in ($serv_id)
				UNION 
				select clte_id, fsm_id, 'HCAP' as tipo  from fsm_hcap where serv_id in ($serv_id)
				UNION 
				select clte_id, fsm_id, 'HBA1C' as tipo  from fsm_hba1c where serv_id in ($serv_id)
				UNION 
				select clte_id, fsm_id, 'CONTIN' as tipo  from fsm_cotinina where serv_id in ($serv_id)
				UNION 
				select clte_id, fsm_id, 'EXUF' as tipo  from fsm_exudado where serv_id in ($serv_id)
				UNION 
				select clte_id, fsm_id, 'VIH' as tipo  from fsm_vih where serv_id in ($serv_id)
				UNION 
                select clte_id, fsm_id, 'IMUNO' as tipo  from fsm_imuno where serv_id in ($serv_id)
				UNION 
                select clte_id, fsm_id, 'CSVIVA' as tipo  from fsm_csvivo where serv_id in ($serv_id)
				UNION 
                select clte_id, fsm_id, 'CSINERTE' as tipo  from fsm_csinerte where serv_id in ($serv_id)
				UNION 
                select clte_id, fsm_id, 'CACRUDO' as tipo  from fsm_cacrudo where serv_id in ($serv_id)		
				UNION 
                select clte_id, fsm_id, 'CACOCIDO' as tipo  from fsm_cacocido where serv_id in ($serv_id)
				UNION 
                select clte_id, fsm_id, 'ABA' as tipo  from fsm_aba where serv_id in ($serv_id)		
				UNION 
                select clte_id, fsm_id, 'ABH' as tipo  from fsm_abh where serv_id in ($serv_id)	
				UNION 
                select clte_id, fsm_id, 'HIV' as tipo  from fsm_hiv where serv_id in ($serv_id)	
				UNION 
                select clte_id, fsm_id, 'CPROPA' as tipo  from fsm_cps where serv_id in ($serv_id)	
				UNION 
                select clte_id, fsm_id, 'CPROCU' as tipo  from fsm_cprocu where serv_id in ($serv_id)
				UNION 
                select clte_id, fsm_id, 'CULTUN' as tipo  from fsm_cultun where serv_id in ($serv_id)	
				UNION 
                select clte_id, doc_id, 'OPTOM' as tipo  from sis12_optom_doc where serv_id in ($serv_id)
				UNION 
                select clte_id, doc_id, 'AUDIO' as tipo  from sis12_audio_doc where serv_id in ($serv_id)	
				UNION
				select clte_id, doc_id, 'EGEREN' as tipo  from sis12_egeren_doc where serv_id in ($serv_id)
                UNION
				select clte_id, doc_id, 'R4V3N' as tipo  from sis12_raven_doc where serv_id in ($serv_id)
                UNION
				select clte_id, doc_id, 'V3ND3D0R ' as tipo  from sis13_vendedor_doc where serv_id in ($serv_id)				
				
				) as a 
                LEFT JOIN sis05_clientes as b ON a.clte_id = b.clte_id ";
				
				

				if (($ini != '') && ($fin != ''))
				{
					$sql.="  and log_insrt_f >= '".$ini." 00:00:00' and log_insrt_f <= '".$fin." 23:59:59' ";
					
				}
				
				if ($modo == 0)
				{	
			
					if ($emp_id == 360)
					{	
					 $sql.=" GROUP BY a.clte_id ORDER BY clte_paterno ASC,clte_materno ASC, clte_nombre ASC, clte_2_nombre ASC;"; 
					} 
					else
					{		
					 $sql.=" GROUP BY a.clte_id ORDER BY log_insrt_f ASC,clte_paterno ASC,clte_materno ASC, clte_nombre ASC, clte_2_nombre ASC;";
					}
				}				
				
				//echo $sql;
			
				$result = $this->db->query($sql);
				if ($modo == 0)
				{	
					 return $result->result_array();
				}
				elseif ($modo == 6)
				{	$res=$result->result_array();
					return $res['0']['minimo'];
					
				}
				elseif ($modo == 8)
				{	
					 $res=$result->result_array();
					return $res['0']['maximo'];
				}				
				else
				{
					$res=$result->result_array();
					return $res[0]['total'];
					// return $sql;
				}		
       
    }


function get_examenes_servicio_ampliado($serv_id)
    {
        $sql = "select clte_id from sis10_clientes_doc where serv_id = 2029 		
                ORDER BY clte_id;"; 
        $result = $this->db->query($sql);		
        return $result->result_array();
    }
}
