<?php
 
class Despacho_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    
    function get($emp_id)
    {
        $this->db->select('b.*');
        $this->db->from('sis75_despachos as a');
        $this->db->join('sis15_empresas as b','a.desp_id = b.emp_id');
        $this->db->where('a.emp_id',$emp_id);
        return $this->db->get()->result_array();
    }
    
    function insert($params)
    {
        return $this->db->insert('sis75_despachos',$params);
    }
    
    function update($emp_id,$params)
    {
        $this->db->where('emp_id',$emp_id);
        return $this->db->update('sis75_despachos',$params);
    }
    
    function delete($emp_id, $desp_id)
    {
        return $this->db->delete('sis75_despachos',array('emp_id' => $emp_id, 'desp_id' => $desp_id ));
    }
}