<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Nom035_model extends CI_Model {
    
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
 
		function update($fsm_id,$data)
		{
			$this->db->where('fsm_id',$fsm_id);
			return $this->db->update('fsm_nom035',$data);
		}


 
    function borra_cuestionario($fsm_id)
    {
        $this->db->where('fsm_id', $fsm_id);
        return $this->db->delete('fsm_nom035');
    }	
  
    function get_by_clte($cliente_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('fsm_nom035');
        $this->db->where('clte_id', $cliente_id);
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }

    function get_questions_by_name($emp_id,$f_ini,$f_fin)
    {
        $this->db->select('*');
        $this->db->from('fsm_nom035');
        $this->db->where('emp_id', $emp_id);
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
		$this->db->where('fsm_f <=', $f_fin.' 11:59:59');
        $this->db->order_by('clte_paterno','ASC');
		$this->db->order_by('clte_materno','ASC');
		$this->db->order_by('clte_nombre','ASC');
        $result = $this->db->get();
        return $result->result_array();
    }
	
    function get_questions_by_dates($emp_id,$f_ini,$f_fin)
    {
        $this->db->select('*');
        $this->db->from('fsm_nom035');
        $this->db->where('emp_id', $emp_id);
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
		$this->db->where('fsm_f <=', $f_fin.' 11:59:59');
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }

    function get_by_clte_ext($cliente_id,$emp_id,$f_ini,$f_fin)
    {
        $this->db->select('*');
        $this->db->from('fsm_nom035');
		$this->db->where('clte_id', $cliente_id);
        $this->db->where('emp_id', $emp_id);
		
		if ($emp_id != 429)
		{	
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
		$this->db->where('fsm_f <=', $f_fin.' 11:59:59');
		}
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }


    function insert($data_insert)
    {
        $this->db->insert('fsm_nom035', $data_insert);
        return $this->db->insert_id();
    }

    function get($fsm_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('fsm_nom035');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->row_array();
    }

	function get_calificacion($calificacion)
    {
        $this->db->select('*');
        $this->db->from('fsm_nom035iv');
        $this->db->where('fsm_calificacion', $calificacion);	
        $result = $this->db->get();
        return $result->row_array();
    }
		
	function insert_update_resultados($clte_id,$emp_id,$data)
	{

        $this->db->select('fsm_id');
        $this->db->from('fsm_nom035i');
        $this->db->where('clte_id',$clte_id);
		$this->db->where('emp_id',$emp_id);	
        $result = $this->db->get()->result_array();
        if ($result)
		{
			$this->db->where('clte_id',$clte_id);
			$this->db->where('emp_id',$emp_id);
			return $this->db->update('fsm_nom035i',$data);			
		}
		else
		{	
			$this->db->insert('fsm_nom035i',$data);
			return $this->db->insert_id();
		}
	}
	
	
	
		function insert_update_nom_i_resultados($fsm_id,$clte_id,$emp_id,$data)
		{
			$this->db->where('fsm_id',$fsm_id);
			//$this->db->where('clte_id',$clte_id);
			//$this->db->where('emp_id',$emp_id);
			return $this->db->update('fsm_nom035',$data);
		}
		
		function insert_update_nom_ii_resultados($fsm_id,$clte_id,$emp_id,$data)
		{
			$this->db->where('fsm_id',$fsm_id);
			//$this->db->where('clte_id',$clte_id);
			//$this->db->where('emp_id',$emp_id);
			return $this->db->update('fsm_nom035ii',$data);
		}



		function insert_update_nom_iii_resultados($fsm_id,$clte_id,$emp_id,$data)
		{
			$this->db->where('fsm_id',$fsm_id);
			//$this->db->where('clte_id',$clte_id);
			//$this->db->where('emp_id',$emp_id);
			return $this->db->update('fsm_nom035iii',$data);
		}
	
	function get_res_by_id($clte_id,$emp_id)
	{
        $this->db->select('*');
        $this->db->from('fsm_nom035i');
        $this->db->where('clte_id',$clte_id);
		$this->db->where('emp_id',$emp_id);	
        $result = $this->db->get();
        return $result->row_array();
	}	


	function get_count_nomiii_malto($emp_id)
	{
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);}elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		} else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		

		//$this->db->where_in('clte_id',$empleados);			
		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035i');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);	
		$this->db->where('fsm_03_total >=','140');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}
/********************************************************************/
	function get_count_nomii_alto_ext($emp_id,$f_ini,$f_fin)
	{
		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035ii');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);	
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
	    $this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
		$this->db->where('fsm_resultado_general','ALTO');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}

	function get_count_nomii_malto_ext($emp_id,$f_ini,$f_fin)
	{
		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035ii');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);	
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
	    $this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
		$this->db->where('fsm_resultado_general','MALTO');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}


	function get_count_nomii_medio_ext($emp_id,$f_ini,$f_fin)
	{
		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035ii');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);	
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
	    $this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
		$this->db->where('fsm_resultado_general','MEDIO');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}


	function get_count_nomii_bajo_ext($emp_id,$f_ini,$f_fin)
	{
		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035ii');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);	
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
	    $this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
		$this->db->where('fsm_resultado_general','BAJO');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}
	
	
	function get_count_nomii_mbajo_ext($emp_id,$f_ini,$f_fin)
	{
		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035ii');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);	
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
	    $this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
		$this->db->where('fsm_resultado_general','MBAJO');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}	

/*
	function get_count_nomiii_malto_ext($emp_id,$f_ini,$f_fin)
	{
		$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);} else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		

		//$this->db->where_in('clte_id',$empleados);			
		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035iii');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);	
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
	    $this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
		$this->db->where('fsm_03_total >=','140');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}

	function get_count_nomiii_alto_ext($emp_id,$f_ini,$f_fin)
	{		
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);}elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		} else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		

		//$this->db->where_in('clte_id',$empleados);			
		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035iii');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
	    $this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
		$this->db->where('fsm_03_total <','140');
		$this->db->where('fsm_03_total >=','99');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}

	function get_count_nomiii_medio_ext($emp_id,$f_ini,$f_fin)
	{
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);}elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		} else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		

		//$this->db->where_in('clte_id',$empleados);		
		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035iii');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
	    $this->db->where('fsm_f <=', $f_fin.' 11:59:59');			
		$this->db->where('fsm_03_total <','99');
		$this->db->where('fsm_03_total >=','75');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}

	function get_count_nomiii_bajo_ext($emp_id,$f_ini,$f_fin)
	{
			$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);	
		
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);}elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		} else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		

		//$this->db->where_in('clte_id',$empleados);		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035iii');
		$this->db->where('emp_id',$emp_id);
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
	    $this->db->where('fsm_f <=', $f_fin.' 11:59:59');			
		$this->db->where('fsm_03_total <','75');
		$this->db->where('fsm_03_total >=','50');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}
	
	function get_count_nomiii_mbajo_ext($emp_id,$f_ini,$f_fin)
	{
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);	
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);}elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		} else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		

		//$this->db->where_in('clte_id',$empleados);		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035iii');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
	    $this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
		$this->db->where('fsm_03_total <','50');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}	
	

	function get_res_by_emp_nomiii_ext($emp_id,$f_ini,$f_fin)
	{
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);}elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		} else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}
		
		
		$this->db->select('*');
        $this->db->from('fsm_nom035iii');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
	    $this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
        $this->db->order_by('fsm_03_total','DESC');
		$this->db->order_by('fsm_03_01','DESC');
		$this->db->order_by('fsm_03_02','DESC');
		$this->db->order_by('fsm_03_03','DESC');
		$this->db->order_by('fsm_03_04','DESC');
		$this->db->order_by('fsm_03_05','DESC');
		$this->db->order_by('fsm_03_06','DESC');
		$this->db->order_by('fsm_03_07','DESC');
		$this->db->order_by('fsm_03_08','DESC');
		$this->db->order_by('fsm_03_09','DESC');
		$this->db->order_by('fsm_03_10','DESC');		
		
        return $this->db->get()->result_array();;
	}	
	
*/



function get_res_by_emp_nomiii_ext($emp_id,$f_ini,$f_fin)
	{
		
		$this->db->select('*');
        $this->db->from('fsm_nom035iii');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
	    $this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
        $this->db->order_by('fsm_03_total','DESC');
		$this->db->order_by('fsm_03_01','DESC');
		$this->db->order_by('fsm_03_02','DESC');
		$this->db->order_by('fsm_03_03','DESC');
		$this->db->order_by('fsm_03_04','DESC');
		$this->db->order_by('fsm_03_05','DESC');
		$this->db->order_by('fsm_03_06','DESC');
		$this->db->order_by('fsm_03_07','DESC');
		$this->db->order_by('fsm_03_08','DESC');
		$this->db->order_by('fsm_03_09','DESC');
		$this->db->order_by('fsm_03_10','DESC');		
		
        return $this->db->get()->result_array();;
	}	
	
	function get_count_nomiii_alto_ext($emp_id,$f_ini,$f_fin)
	{
		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035iii');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);	
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
	    $this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
		$this->db->where('fsm_resultado_general','ALTO');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}

	function get_count_nomiii_malto_ext($emp_id,$f_ini,$f_fin)
	{
		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035iii');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);	
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
	    $this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
		$this->db->where('fsm_resultado_general','MALTO');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}


	function get_count_nomiii_medio_ext($emp_id,$f_ini,$f_fin)
	{
		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035iii');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);	
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
	    $this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
		$this->db->where('fsm_resultado_general','MEDIO');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}


	function get_count_nomiii_bajo_ext($emp_id,$f_ini,$f_fin)
	{
		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035iii');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);	
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
	    $this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
		$this->db->where('fsm_resultado_general','BAJO');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}
	
	
	function get_count_nomiii_mbajo_ext($emp_id,$f_ini,$f_fin)
	{
		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035iii');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);	
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
	    $this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
		$this->db->where('fsm_resultado_general','MBAJO');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}	

	function get_count_nomiii_alto($emp_id)
	{	
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);}elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		} else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		

		//$this->db->where_in('clte_id',$empleados);			
		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035i');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_03_total <','140');
		$this->db->where('fsm_03_total >=','99');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}




	function get_count_nomiii_medio($emp_id)
	{
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);}elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		} else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		

		//$this->db->where_in('clte_id',$empleados);		
		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035i');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_03_total <','99');
		$this->db->where('fsm_03_total >=','75');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}




	function get_count_nomiii_bajo($emp_id)
	{
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);}elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		} else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		

		//$this->db->where_in('clte_id',$empleados);		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035i');
		$this->db->where('emp_id',$emp_id);
		$this->db->where_in('clte_id',$empleados);	
		$this->db->where('fsm_03_total <','75');
		$this->db->where('fsm_03_total >=','50');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}




	


	function get_count_nomiii_mbajo($emp_id)
	{
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);}elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		} else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		

		//$this->db->where_in('clte_id',$empleados);		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035i');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_03_total <','50');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}	
/************* NOM035 II ***********************/
	function get_res_by_emp_nomii($emp_id)	
	{
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);}elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		} else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}
		
		
		$this->db->select('*');
        $this->db->from('fsm_nom035i');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);		
        $this->db->order_by('fsm_02_total','DESC');
		$this->db->order_by('fsm_02_01','DESC');
		$this->db->order_by('fsm_02_02','DESC');
		$this->db->order_by('fsm_02_03','DESC');
		$this->db->order_by('fsm_02_04','DESC');
		$this->db->order_by('fsm_02_05','DESC');
		$this->db->order_by('fsm_02_06','DESC');
		$this->db->order_by('fsm_02_07','DESC');
		$this->db->order_by('fsm_02_08','DESC');
        return $this->db->get()->result_array();;
	}


	function get_res_by_emp_nomii_ext($emp_id,$f_ini,$f_fin)	
	{
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);}elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		} else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		
		
		$this->db->select('*');
        $this->db->from('fsm_nom035ii');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);	
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
	    $this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
        $this->db->order_by('fsm_02_total','DESC');
		$this->db->order_by('fsm_02_01','DESC');
		$this->db->order_by('fsm_02_02','DESC');
		$this->db->order_by('fsm_02_03','DESC');
		$this->db->order_by('fsm_02_04','DESC');
		$this->db->order_by('fsm_02_05','DESC');
		$this->db->order_by('fsm_02_06','DESC');
		$this->db->order_by('fsm_02_07','DESC');
		$this->db->order_by('fsm_02_08','DESC');
        return $this->db->get()->result_array();;
	}




	function get_count_nomii_malto($emp_id)
	{
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);}elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		} else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		

		//$this->db->where_in('clte_id',$empleados);		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035i');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_02_total >=','90');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}

/*
	function get_count_nomii_malto_ext($emp_id,$f_ini,$f_fin)
	{
		$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);}elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		} else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		
		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035ii');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
	    $this->db->where('fsm_f <=', $f_fin.' 11:59:59');
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_02_total >=','90');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}
*/

	


	function get_count_nomii_alto($emp_id)
	{
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);}elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		} else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		

        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035i');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_02_total <','90');
		$this->db->where('fsm_02_total >=','70');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}

/*
	function get_count_nomii_alto_ext($emp_id,$f_ini,$f_fin)
	{
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);}elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		} else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		

        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035ii');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
	    $this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
		$this->db->where('fsm_02_total <','90');
		$this->db->where('fsm_02_total >=','70');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}
*/



	function get_count_nomii_medio($emp_id)
	{
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);}elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		} else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		

		//$this->db->where_in('clte_id',$empleados);		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035i');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_02_total <','70');
		$this->db->where('fsm_02_total >=','45');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}

/*
	function get_count_nomii_medio_ext($emp_id,$f_ini,$f_fin)
	{
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);}elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		} else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		

		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035ii');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
	    $this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
		$this->db->where('fsm_02_total <','70');
		$this->db->where('fsm_02_total >=','45');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}

*/	


	function get_count_nomii_bajo($emp_id)
	{
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);}elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		} else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		

		//$this->db->where_in('clte_id',$empleados);		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035i');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_02_total <','45');
		$this->db->where('fsm_02_total >=','20');		
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}
	
/*	
	function get_count_nomii_bajo_ext($emp_id,$f_ini,$f_fin)
	{
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);}elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		} else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		

	
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035ii');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_02_total <','45');
		$this->db->where('fsm_02_total >=','20');
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
	    $this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}	
*/	
	

/************* NOM035 I ***********************/
	function get_res_by_emp_nomi($emp_id)
	{
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);
		if ($emp_id == 31)
		{$this->db->where('hc',1);}elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		} else {$this->db->where('empleado',1);	}	
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}
		
		
		$this->db->select('*');
        $this->db->from('fsm_nom035i');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);	
        $this->db->order_by('fsm_01_total','DESC');
		$this->db->order_by('fsm_01_1_1','DESC');
		$this->db->order_by('fsm_01_1_2','DESC');
		$this->db->order_by('fsm_01_1_3','DESC');
		$this->db->order_by('fsm_01_1_4','DESC');
		$this->db->order_by('fsm_01_1_5','DESC');
		$this->db->order_by('fsm_01_1_6','DESC');
		$this->db->order_by('fsm_01_2_1','DESC');
		$this->db->order_by('fsm_01_2_2','DESC');
		
		$this->db->order_by('fsm_01_3_1','DESC');
		$this->db->order_by('fsm_01_3_2','DESC');
		$this->db->order_by('fsm_01_3_3','DESC');
		$this->db->order_by('fsm_01_3_4','DESC');
		$this->db->order_by('fsm_01_3_5','DESC');
		$this->db->order_by('fsm_01_3_6','DESC');
		$this->db->order_by('fsm_01_3_7','DESC');
		
		$this->db->order_by('fsm_01_4_1','DESC');
		$this->db->order_by('fsm_01_4_2','DESC');
		$this->db->order_by('fsm_01_4_3','DESC');
		$this->db->order_by('fsm_01_4_4','DESC');
		$this->db->order_by('fsm_01_4_5','DESC');

        return $this->db->get()->result_array();
	}
	
	
	function get_res_by_emp_nom_i_ext($emp_id,$f_ini,$f_fin)
	{
		$this->db->select('*');
        $this->db->from('fsm_nom035');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
		$this->db->where('fsm_f <=', $f_fin.' 11:59:59');	
		$this->db->order_by('fsm_01_total','DESC');
        $this->db->order_by('clte_paterno','ASC');
		$this->db->order_by('clte_materno','ASC');
		$this->db->order_by('clte_nombre','ASC');		
        
		$this->db->order_by('fsm_01_1_1','DESC');
		$this->db->order_by('fsm_01_1_2','DESC');
		$this->db->order_by('fsm_01_1_3','DESC');
		$this->db->order_by('fsm_01_1_4','DESC');
		$this->db->order_by('fsm_01_1_5','DESC');
		$this->db->order_by('fsm_01_1_6','DESC');
		$this->db->order_by('fsm_01_2_1','DESC');
		$this->db->order_by('fsm_01_2_2','DESC');
		
		$this->db->order_by('fsm_01_3_1','DESC');
		$this->db->order_by('fsm_01_3_2','DESC');
		$this->db->order_by('fsm_01_3_3','DESC');
		$this->db->order_by('fsm_01_3_4','DESC');
		$this->db->order_by('fsm_01_3_5','DESC');
		$this->db->order_by('fsm_01_3_6','DESC');
		$this->db->order_by('fsm_01_3_7','DESC');
		
		$this->db->order_by('fsm_01_4_1','DESC');
		$this->db->order_by('fsm_01_4_2','DESC');
		$this->db->order_by('fsm_01_4_3','DESC');
		$this->db->order_by('fsm_01_4_4','DESC');
		$this->db->order_by('fsm_01_4_5','DESC');

        return $this->db->get()->result_array();
	}	
	
/*
	function get_res_by_emp_nom_i_ext($emp_id,$f_ini,$f_fin)
	{
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);
		if ($emp_id == 31)
		{$this->db->where('hc',1);} 
	
	
		else {$this->db->where('empleado',1);	}	
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}
		
		
		$this->db->select('*');
        $this->db->from('fsm_nom035');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
		$this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
        $this->db->order_by('fsm_01_total','DESC');
		$this->db->order_by('fsm_01_1_1','DESC');
		$this->db->order_by('fsm_01_1_2','DESC');
		$this->db->order_by('fsm_01_1_3','DESC');
		$this->db->order_by('fsm_01_1_4','DESC');
		$this->db->order_by('fsm_01_1_5','DESC');
		$this->db->order_by('fsm_01_1_6','DESC');
		$this->db->order_by('fsm_01_2_1','DESC');
		$this->db->order_by('fsm_01_2_2','DESC');
		
		$this->db->order_by('fsm_01_3_1','DESC');
		$this->db->order_by('fsm_01_3_2','DESC');
		$this->db->order_by('fsm_01_3_3','DESC');
		$this->db->order_by('fsm_01_3_4','DESC');
		$this->db->order_by('fsm_01_3_5','DESC');
		$this->db->order_by('fsm_01_3_6','DESC');
		$this->db->order_by('fsm_01_3_7','DESC');
		
		$this->db->order_by('fsm_01_4_1','DESC');
		$this->db->order_by('fsm_01_4_2','DESC');
		$this->db->order_by('fsm_01_4_3','DESC');
		$this->db->order_by('fsm_01_4_4','DESC');
		$this->db->order_by('fsm_01_4_5','DESC');

        return $this->db->get()->result_array();
	}
*/
/*
	function get_count_nomii_mbajo_ext($emp_id,$f_ini,$f_fin)
	{
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);}elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		} else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		
	
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035ii');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
		$this->db->where('fsm_f <=', $f_fin.' 11:59:59');	
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_02_total <','20');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}

*/

	function get_count_nomii_mbajo($emp_id)
	{
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);}elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		} else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		

		//$this->db->where_in('clte_id',$empleados);		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035i');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_02_total <','20');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}	


	function get_count_nomi_si($emp_id)
	{
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);}
		elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		}else {$this->db->where('empleado',1);	}	
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		

		//$this->db->where_in('clte_id',$empleados);		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035i');
		$this->db->where('emp_id',$emp_id);
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_01_total >',0);
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}	

	function get_count_nomi_si_ext($emp_id,$f_ini,$f_fin )
	{
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035');
		$this->db->where('emp_id',$emp_id);
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
		$this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
		$this->db->where('fsm_resultado_general','NO REQUIERE VALORACIÓN CLÍNICA');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}


	function get_count_nomi_no_ext($emp_id,$f_ini,$f_fin )
	{
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035');
		$this->db->where('emp_id',$emp_id);
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
		$this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
		$this->db->where('fsm_resultado_general','REQUIERE VALORACIÓN CLÍNICA');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}

/*
	function get_count_nomi_si_ext($emp_id,$f_ini,$f_fin )
	{
		$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);

		
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		
		if ($emp_id == 31)
			{$this->db->where('hc',1);} 
		elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		}
		else 
			{$this->db->where('empleado',1);}	
		
		
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		
		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035');
		$this->db->where('emp_id',$emp_id);
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
		$this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
		//$this->db->where('fsm_01_total >',0);
		$this->db->not_like('fsm_resultado_general','NO REQUIERE VALORACIÓN CLÍNICA');
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}


	function get_count_nomi_no_ext($emp_id,$f_ini,$f_fin )
	{
		
		$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		$this->db->where('emp_id',$emp_id);	
		if ($emp_id == 31)
		{$this->db->where('hc',1);} 
		elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		}	
		else {$this->db->where('empleado',1);	}	
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		
		
		
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035');
		$this->db->where('emp_id',$emp_id);
		$this->db->where_in('clte_id',$empleados);
		$this->db->where('fsm_f >=', $f_ini.' 00:00:00');
		$this->db->where('fsm_f <=', $f_fin.' 11:59:59');		
		$this->db->where('fsm_01_total =',0);
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}

*/	
	
		function get_count_nomi_no($emp_id)
	{
				$CIs =& get_instance();
		$CIs->load->model('empleado/Empleado_model','empleado');
		$user = $this->session->user;
		$usuario = $CIs->empleado->get($user['usr_id']);
		$this->db->select('clte_id');
		$this->db->from('sis05_clientes');
		if ($emp_id == 31)
		{$this->db->where('hc',1);}
		elseif ( strstr($usuario['portal'],'CORPO') )
		{
			
		}else {$this->db->where('empleado',1);	}
		$this->db->not_like('status','NOACTIVO');	
		$rows=$this->db->get()->result_array();;
		
		$i=0;
		foreach($rows as $row)
		{
			$empleados[$i]=$row['clte_id'];
			$i++;
		}		

		//$this->db->where_in('clte_id',$empleados);			
        $this->db->select('count(*) as cuantos');
        $this->db->from('fsm_nom035i');
		$this->db->where('emp_id',$emp_id);	
		$this->db->where_in('clte_id',$empleados);	
		$this->db->where('fsm_01_total =',0);
        $result = $this->db->get();
        $row=$result->row_array();
		return $row['cuantos'];
	}	



}