<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Perfil_psicologico_model extends CI_Model {
    
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    
    function  borra($fsm_id)
    {
        $this->db->where('fsm_id', $fsm_id);
        return $this->db->delete('fsm_psicologico_perfil');
    }	


    
    function get_by_clte($cliente_id,$es_usr_de_un_despacho=0)
    {	$user = $this->session->user;
        $this->db->select('*');
        $this->db->from('fsm_psicologico_perfil');
        $this->db->where('clte_id', $cliente_id);

        if(get_perfil_id() == 4) 
        {
				if ($es_usr_de_un_despacho==0)
				{	
				$this->db->where('emp_id', get_emp_id());
				}
        }		
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }

    function insert($data_insert)
    {
        $this->db->insert('fsm_psicologico_perfil', $data_insert);
        return $this->db->insert_id();
    }

    function get_by_clte_PERFPSC($cliente_id,$es_usr_de_un_despacho=0) 
    {
        $this->db->select('*');
        $this->db->from('fsm_psicologico_perfil');
        $this->db->where('clte_id', $cliente_id);
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }

    function get_PERFPSC($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('fsm_psicologico_perfil');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->row_array();
    }



    
    function actualizar($fsm_id, $params)
    {
		$this->db->where('fsm_id', $fsm_id);
        return $this->db->update('fsm_psicologico_perfil', $params);
    }




    function get($fsm_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('fsm_psicologico_perfil');
        $this->db->where('fsm_id', $fsm_id);
        if(get_perfil_id() == 4)
        {
			if ($es_usr_de_un_despacho==0)
			{	
            $this->db->where('emp_id', get_emp_id());
			}
        }		
        $result = $this->db->get();
        return $result->row_array();
    }

    function get_by_clte_servicio($cliente_id,$serv_id,$es_usr_de_un_despacho=0)
    {

		$this->db->select('*');
        $this->db->from('fsm_psicologico_perfil');
        $this->db->where('clte_id', $cliente_id);
		$this->db->where('serv_id', $serv_id);
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }
	
    function delete_psicologico_perfil($fsm_id)
    {
        $this->db->where('fsm_id', $fsm_id);
        return $this->db->delete('fsm_psicologico_perfil');
    }	

	
}