<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Exmeper_model extends CI_Model {
    
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
 
    function borra($fsm_id)
    {
        $this->db->where('fsm_id', $fsm_id);
        return $this->db->delete('fsm_exmeper');
    }
 
    function add($data_insert)
    {
        $this->db->insert('fsm_exmeper', $data_insert);
        return $this->db->insert_id();
    }

    function get($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('fsm_exmeper');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->row_array();
    }

    function update($id, $params)
    {
        $this->db->where('fsm_id', $id);
        return $this->db->update('fsm_exmeper', $params);
    }

    function get_by_clte($cliente_id)
    {   
	//echo "$cliente_id";
        $this->db->select('*');
        $this->db->from('fsm_exmeper');
        $this->db->where('clte_id', $cliente_id);
        if(get_perfil_id() == 4)
        {
            $this->db->where('emp_id', get_emp_id());
        }
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }

    
    function insert_arreglo($array, $columna_val, $fsm_id, $tabla, $may = true)
    {
        $insert_id = null;

        if(!empty($array))
        {
            foreach($array as $row)
            {
                if(trim($row[$columna_val]) != "")
                {
                    $row['fsm_id'] = $fsm_id;
                    if($may)
                    {
                        $this->db->insert($tabla,  array_to_upper($row));
                    }
                    else
                    {
                        $this->db->insert($tabla,  $row);
                    }
                }
            }
            $insert_id = $this->db->insert_id();
        }
        return $insert_id;
    }
    
    function get_docpres($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('esc_dopre');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->result_array();
    }
    
    function get_data($tabla, $fsm_id)
    {
        $this->db->select('*');
        $this->db->from($tabla);
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->result_array();
    }

    function insert_image($data_insert)
    {
        $this->db->insert('fpfh-01-05_imagenes', $data_insert);
        return $this->db->insert_id();
    }

    function get_images($id)
    {
        $this->db->select('*');
        $this->db->from('fpfh-01-05_imagenes');
        $this->db->where('fsm_id', $id);
        $result = $this->db->get();
        return $result->result_array();
    }


    
    function inserta_egresos($egresos, $fsm_id)
    {
        if(!empty($egresos))
        {
            foreach($egresos as $egreso)
            {
                if($egreso['tipo_cve'] != '' && $egreso['mensual'] != '')
                {
                    if(isset($egreso['egreso_id']))
                    {
                        $egreso_id = $egreso['egreso_id'];
                        unset($egreso['egreso_id']);
                        $this->db->where('egreso_id', $egreso_id);
                        $this->db->update('esc_egresos',  array_to_upper($egreso));
                    }
                    else
                    {
                        $egreso['fsm_id'] = $fsm_id;
                        $this->db->reset_query();
                        $this->db->insert('esc_egresos',array_to_upper($egreso));
                    }
                }
            }
        }
        return $this->db->insert_id();
    }

    function delete_tabla($fsm_id,$id,$tabla)
    {
        $key = $this->get_primary_key($tabla);
        $this->db->where('fsm_id', $fsm_id);
        $this->db->where($key, $id);
        return $this->db->delete($tabla);
    }

    function get_primary_key($tabla)
    {
        $column = '';
        $fields = $this->db->field_data($tabla);
        foreach ($fields as $field)
        {
            if($field->primary_key == 1)
            {
                $column = $field->name;
            }
        }
        return $column;
    }

    function update_arreglo($array, $columna_val, $fsm_id, $tabla)
    {
        $insert_id = null;
        if(!empty($array))
        {
            
            foreach($array as $row)
            {
                $primary_key = $this->get_primary_key($tabla);

                //si existe la llave primaria hay valores y se debe actualizar
                if(isset($row[$primary_key]))
                {
                    $insert_id = $this->update_tabla($fsm_id,$tabla,$primary_key,$row[$primary_key],$row);
                }
                else
                {
                    //para insertar comprueba que no este vacia la columna principal para el insert
                    if(trim($row[$columna_val]) !== '') 
                    {
                        $row['fsm_id'] = $fsm_id;
                        $this->db->insert($tabla,  array_to_upper($row));
                        $insert_id = $this->db->insert_id();
                    }
                }
            }
            
        }
        return $insert_id;
    }

    function update_tabla($fsm_id, $tabla, $key_id, $val_id, $data)
    {
        $this->db->where($key_id, $val_id);
        $this->db->where('fsm_id', $fsm_id);
        return $this->db->update($tabla, $data);
    }

}
