<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Historia_clinica_model extends CI_Model {
    
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
  

    function delete_odo($fsm_id)
    {
        $this->db->where('fsm_id', $fsm_id);
        return $this->db->delete('fsm_odon');
    }
 
  
    function get_by_clte_referencia_fpfh($cliente_id,$referencia_id)
    {
		$referencia_id.=$cliente_id.'_';
		$evaluados_array = explode("_", $referencia_id);
        $this->db->select('*');
        $this->db->from('fpfh_01_05');
        $this->db->where_in('clte_id', $evaluados_array);
        $this->db->order_by('log_insrt_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    } 

    function get_by_clte_referencia_odon($cliente_id,$referencia_id)
    {
		$referencia_id.=$cliente_id.'_';
		$evaluados_array = explode("_", $referencia_id);
        $this->db->select('*');
        $this->db->from('fsm_odon');
        $this->db->where_in('clte_id', $evaluados_array);
        $this->db->order_by('log_insrt_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }
  
    function get_by_clte($cliente_id, $who='',$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
		
		if ($who == 'fpfh')
		{
			$this->db->from('fpfh_01_05');
		}
		elseif ($who == 'fsm_odon')
		{
			$this->db->from('fsm_odon');
		}
		else
		{	
			$this->db->from('fsm_historia_clinica');
		}
        $this->db->where('clte_id', $cliente_id);
        
		if ($who == 'fpfh')
		{
			$this->db->order_by('log_insrt_f','DESC');
		}
		elseif ($who == 'fsm_odon')
		{
			$this->db->order_by('fodon_f','DESC');
		}		
		else
		{	
        $this->db->order_by('fsm_f','DESC');
		}
        $result = $this->db->get();
        return $result->result_array();
    }
	
    function get_by_clte_servicio_odon($cliente_id,$serv_id,$es_usr_de_un_despacho=0)
    {

		$this->db->select('*');
        $this->db->from('fsm_odon');
        $this->db->where('clte_id', $cliente_id);
		$this->db->where('serv_id', $serv_id);
        $this->db->order_by('fodon_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }	
	
    function get_by_clte_servicio_fpfh($cliente_id,$serv_id,$es_usr_de_un_despacho=0)
    {

		$this->db->select('*');
        $this->db->from('fpfh_01_05');
        $this->db->where('clte_id', $cliente_id);
		$this->db->where('serv_id', $serv_id);
        $this->db->order_by('fpfh_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }		


    function delete_hc($fsm_id)
    {
        $this->db->where('fsm_id', $fsm_id);
        return $this->db->delete('fsm_historia_clinica');
    }	

    function insert($data_insert)
    {
        $this->db->insert('fsm_historia_clinica', $data_insert);
        return $this->db->insert_id();
    }



    function get_fpfh0105($fsm_id,$es_usr_de_un_despacho=0) 
    {
        $this->db->select('*');
        $this->db->from('fpfh_01_05');
        $this->db->where('fsm_id', $fsm_id);
        
		/*if(get_perfil_id() == 4)
        {
            $this->db->where('emp_id', get_emp_id());  
        }
		
        if(get_perfil_id() == 4)
        {
			if ($es_usr_de_un_despacho==0)
			{	
            $this->db->where('emp_id', get_emp_id());
			}
        }*/			
        $result = $this->db->get();
        return $result->row_array();
    }

    function get($fsm_id,$es_usr_de_un_despacho=0) 
    {
        $this->db->select('*');
        $this->db->from('fsm_historia_clinica');
        $this->db->where('fsm_id', $fsm_id);
        
		/*if(get_perfil_id() == 4)
        {
            $this->db->where('emp_id', get_emp_id());  
        }
		
        if(get_perfil_id() == 4)
        {
			if ($es_usr_de_un_despacho==0)
			{	
            $this->db->where('emp_id', get_emp_id());
			}
        }	*/		
        $result = $this->db->get();
        return $result->row_array();
    }


    function update($id, $params)
    {
        $this->db->where('fsm_id', $id);
        return $this->db->update('fsm_historia_clinica', $params);
    }
	
	
	
	/**********************************************************************************/
	 public function get_by_clte_fpfh($cliente_id)
    {
        $this->db->select('*');
        $this->db->from('fpfh_01_05');
        $this->db->where('clte_id', $cliente_id);
      /*  if(get_perfil_id() == 4)
        {
            $this->db->where('emp_id', get_emp_id());
        }*/
        $this->db->order_by('fpfh_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }


    function insert_fpfh($data_insert)
    {
        $this->db->insert('fpfh_01_05', $data_insert);
        return $this->db->insert_id();
    }

    function add($data_insert)
    {
        $this->db->insert('fpfh_01_05', $data_insert);
        return $this->db->insert_id();
    }
	
	function add_odon($data_insert)
    {
        $this->db->insert('fsm_odon', $data_insert);
        return $this->db->insert_id();
    }

    function get_fpfh($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('fpfh_01_05');
        $this->db->where('fsm_id', $fsm_id);
     /*   if(get_perfil_id() == 4)
        {
            $this->db->where('emp_id', get_emp_id());
        }*/
        $result = $this->db->get();
        return $result->row_array();
    }



    function update_fpfh($id, $params)
    {
        $this->db->where('fsm_id', $id);
        return $this->db->update('fpfh_01_05', $params);
    }
	
	    function insert_arreglo($array, $columna_val, $fsm_id, $tabla, $may = true)
    {
        $insert_id = null;

        if(!empty($array))
        {
            foreach($array as $row)
            {
                if(trim($row[$columna_val]) != "")
                {
                    $row['fsm_id'] = $fsm_id;
                    if($may)
                    {
                        $this->db->insert($tabla,  array_to_upper($row));
                    }
                    else
                    {
                        $this->db->insert($tabla,  $row);
                    }
                }
            }
            $insert_id = $this->db->insert_id();
        }
        return $insert_id;
    }
    
	    function get_data($tabla, $fsm_id)
    {
        $this->db->select('*');
        $this->db->from($tabla);
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->result_array();
    }
	
}