<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Psicologico_model extends CI_Model {
    
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    
	function delete_psicologico($fsm_id)
    {
        $this->db->where('fsm_id', $fsm_id);
        return $this->db->delete('fsm_psicologico');
    }  

  
    function insert($data_insert)
    {
        $this->db->insert('fsm_psicologico', $data_insert);
        return $this->db->insert_id();
    }
   
    function get_by_clte_servicio($cliente_id,$serv_id,$es_usr_de_un_despacho=0)
    {

		$this->db->select('*');
        $this->db->from('fsm_psicologico');
        $this->db->where('clte_id', $cliente_id);
		$this->db->where('serv_id', $serv_id);
       $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }
    
    function update($id, $params)
    {
		$this->db->where('fsm_id', $id);
        return $this->db->update('fsm_psicologico', $params);
    }	

    function insert_simple($data_insert)
    {
        $this->db->insert('fsm_psicologico_3', $data_insert);
        return $this->db->insert_id();
    }


    function insert_r($data_insert)
    {
        $this->db->insert('fsm_psicologico_2', $data_insert);
        return $this->db->insert_id();
    }
	
    function update_r($id, $params)
    {
        $this->db->where('fsm_id', $id);
        return $this->db->update('fsm_psicologico_2', $params);
    }
	
	function insert_r_simple($data_insert)
    {
        $this->db->insert('fsm_psicologico_4', $data_insert);
        return $this->db->insert_id();
    }
	
    function update_r_simple($id, $params)
    {
        $this->db->where('fsm_id', $id);
        return $this->db->update('fsm_psicologico_4', $params);
    }

	function delete_psicologico_simple($fsm_id)
    {
        $this->db->where('fsm_id', $fsm_id);
        return $this->db->delete('fsm_psicologico_4');
    } 

	
	
    function get($fsm_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('fsm_psicologico');
        $this->db->where('fsm_id', $fsm_id);

        $result = $this->db->get();
        return $result->row_array();
    }


    function get_r($fsm_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('fsm_psicologico_2');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->row_array();
    }



	
	function get_simple($fsm_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('fsm_psicologico_3');
        $this->db->where('fsm_id', $fsm_id);		
        $result = $this->db->get();
        return $result->row_array();
    }


    function get_r_simple($fsm_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('fsm_psicologico_4');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->row_array();
    }

    function get_by_clte($cliente_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('fsm_psicologico');
        $this->db->where('clte_id', $cliente_id);
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }
	
	
    function get_by_clte_r($cliente_id,$es_usr_de_un_despacho=0) 
    {
        $this->db->select('*');
        $this->db->from('fsm_psicologico_2');
        $this->db->where('clte_id', $cliente_id);

        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }

    function get_by_clte_simple($cliente_id,$es_usr_de_un_despacho=0)
    {
        $this->db->select('*');
        $this->db->from('fsm_psicologico_3');
        $this->db->where('clte_id', $cliente_id);
		
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }
	
	
    function get_by_clte_r_simple($cliente_id,$es_usr_de_un_despacho=0) 
    {
        $this->db->select('*');
        $this->db->from('fsm_psicologico_4');
        $this->db->where('clte_id', $cliente_id);
        $this->db->order_by('fsm_f','DESC');
        $result = $this->db->get();
        return $result->result_array();
    }	
	
}