<?php
/* 
 * Generated by CRUDigniter v2.3 Beta 
 * www.crudigniter.com
 */
 
class Empleo_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    
    /*
     * Get all escuelas
     */
    function get_all_empleo()
    {
        return $this->db->get('socio_eco_empleo')->result_array();
    }
    
    /*
     * Get all empleos by fsm_id
     */
    function get_empleos($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('socio_eco_empleo');
        $this->db->where('fsm_id', $fsm_id);
        $result = $this->db->get();
        return $result->result_array();
    }
	
    function get_empleos_actual($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('socio_eco_empleo');
        $this->db->where('fsm_id', $fsm_id);
		 $this->db->like('tipo_cve', 'ACTUAL');
        $result = $this->db->get();
        return $result->result_array();
    }	
	
    function get_empleos_anteriores($fsm_id)
    {
        $this->db->select('*');
        $this->db->from('socio_eco_empleo');
        $this->db->where('fsm_id', $fsm_id);
		 $this->db->like('tipo_cve', 'ANTERIOR');
		 $this->db->order_by('f_ingreso', 'DESC');
        $result = $this->db->get();
        return $result->result_array();
    }
	
    
    /*
     * function to add new empleo
     */
    function inserta($params)
    {
        $this->db->insert('socio_eco_empleo',$params);
        return $this->db->insert_id();
    }
    
    /*
     * function to add new empleos
     */
    function inserta_empleos($empleos, $fsm_id)
    {
        $insert_id = null;
        $this->load->helper('util');

        if(!empty($empleos)){
            foreach($empleos as $empleo){
                if(trim($empleo['empresa']) != "")
                {
                   /* $empleo['f_ingreso'] = formatea_fecha_mysql($empleo['f_ingreso']);

                    if(isset($empleo['f_salida'])){
                        $empleo['f_salida'] = formatea_fecha_mysql($empleo['f_salida']);
                    }*/

                    $empleo['fsm_id'] = $fsm_id;
                    $this->db->insert('socio_eco_empleo', array_to_upper($empleo));
                }
            }
            $insert_id = $this->db->insert_id();
        }
        
        return $insert_id;
    }
    
	
    function inserta_empleo_actual($empleos, $fsm_id)
    {
        $insert_id = null;
        $this->load->helper('util');

        if(!empty($empleos)){
            foreach($empleos as $empleo){
                if(trim($empleo['empresa']) != "")
                {
                    $empleo['fsm_id'] = $fsm_id;
                    $this->db->insert('socio_eco_empleo', array_to_upper($empleo));
                }
            }
            $insert_id = $this->db->insert_id();
        }
        
        return $insert_id;
    }	
	
	
	
    function actualiza_empleos($empleos, $fsm_id)
    {
        $insert_id = null;
		$k=1;
        if(!empty($empleos))
        {
            foreach($empleos as $empleo)
            {
                if(trim($empleo['empresa']) != "")
                {
                   /* $empleo['f_ingreso'] = formatea_fecha_mysql($empleo['f_ingreso']);
                    
					if(isset($empleo['f_salida']))
					{
                        $empleo['f_salida'] = formatea_fecha_mysql($empleo['f_salida']);
                    
					}*/
                    
                     if($empleo['empleo_id'] > 0)//if(isset($empleo['empleo_id']))
                    {
                        $empleo_id = $empleo['empleo_id'];
                        unset($empleo['empleo_id']);
						$this->db->where('empleo_id', $empleo_id);
                        $this->db->update('socio_eco_empleo',  array_to_upper($empleo));
						$k++;
					}
                    else 
                    {
                        $empleo['fsm_id'] = $fsm_id;
                        $this->db->reset_query();
                        $this->db->insert('socio_eco_empleo',  array_to_upper($empleo));
                    }
                }
            }
            $insert_id = $this->db->insert_id();
        }
        return $insert_id;
    }
	
    function delete($fsm_id, $id)
    {
        $this->db->where('fsm_id', $fsm_id);
        $this->db->where('empleo_id', $id);
        return $this->db->delete('socio_eco_empleo');
    }	
	
}
