<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Ssiniestros_model extends CI_Model {
    
        function __construct()
        {
            parent::__construct();
            $this->load->database();
            $this->load->helper('util');
        }


	    function get_allo_siniestros($rows)
        {			
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('*');
            $this->db->from('sis05_ssiniestros');		
			$this->db->where('fsm_folio !=', '');			
			$this->db->order_by('sin_id DESC' );
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }

	    function get_allo($rows)
        {			
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('*');
            $this->db->from('sis01_sura_comercial');		
			$this->db->where('fsm_folio !=', '');			
			$this->db->order_by('fsm_f DESC','fsm_folio DESC' );
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }

		function count_all_siniestros()
        {
            $this->db->select("count(sin_id) as regs");
            $this->db->from('sis05_ssiniestros');
			$this->db->where('fsm_folio !=', '');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }
		
		
		function get_siniestro($id)
        {
            $this->db->select("*");
            $this->db->from('sis05_ssiniestros');
			$this->db->where('sin_id',$id );
            $result = $this->db->get();          
            return  $result->row_array();
        }		
		
		
		function get_siniestro_by_folio($folio)
        {
            $this->db->select("*");
            $this->db->from('sis05_ssiniestros');
			$this->db->where('fsm_folio',$folio );
			$this->db->where('sin_estatus','ACTIVO');
			$this->db->limit(1);
            $result = $this->db->get();          
            return  $result->row_array();
        }		
		
		

		function count_all()
        {
            $this->db->select("count(sura_id) as regs");
            $this->db->from('sis01_sura_comercial');
			$this->db->where('fsm_folio !=', '');
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }

        function inserta_siniestro($params)
        {
            $this->db->insert('sis05_ssiniestros', $params);
            return $this->db->insert_id();
        }


        function actualiza_siniestro($sin_id, $params)
        {
            $this->db->where('sin_id',$sin_id);
            return $this->db->update('sis05_ssiniestros',$params);
        }


		function borra_reg_siniestro($id)
		{
			$this->db->where('sin_id', $id);
			return $this->db->delete('sis05_ssiniestros');
		}



/*************************************************************************/
		function borra_lote_fotografico($fsm_id)
		{
			$this->db->where('sura_id', $fsm_id);
			return $this->db->delete('sis01_sura_comercial');
		}



    function valida_poliza($poliza)
    {		
		    $fecha= date('Y-m-d');
            $this->db->select("count(pol_id) as regs");
            $this->db->from('sis04_sura_polizas');
			//$this->db->where('pol_poliza',$poliza);
			$this->db->where('pol_nota',$poliza);
			$this->db->where('pol_f >=',$fecha);
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
    }



    function get_comentarios($folio, $descripcion)
    {
			$this->db->select('*');            
            $this->db->from('sis01_sura_comercial_com');
            $this->db->like('com_folio',$folio); 
			$this->db->like('com_descripcion',$descripcion); 
            $this->db->order_by('com_id DESC');
            $result = $this->db->get();
            return $result->result_array();
    }


    function insert_comentarios($data_insert)
    {
        $this->db->insert('sis01_sura_comercial_com', $data_insert);
        return $this->db->insert_id();
    }


        function busca_old($folio,$f_registro)
        {            
			$this->db->select('*');            
            $this->db->from('sis01_sura_comercial');
            if($folio != ''){  $this->db->like('fsm_folio',$folio); }
            if ($f_registro != ''){ $this->db->where('fsm_f >=',$f_registro); }	
			$this->db->limit(1); 
            $this->db->order_by('fsm_f DESC','fsm_folio DESC' );
            $result = $this->db->get();
            return $result->result_array();
        }


        function busca($folio,$f_registro)
        {      
			$this->db->distinct('fsm_folio');   
			$this->db->select('*');            
            $this->db->from('sis01_sura_comercial');
            if($folio != ''){  $this->db->like('fsm_folio',$folio); }
            if ($f_registro != ''){ $this->db->where('fsm_f >=',$f_registro); }	
			//$this->db->limit(1); 
            $this->db->order_by('fsm_f DESC','fsm_folio DESC' );
			$this->db->group_by('fsm_folio' );
            $result = $this->db->get();
            return $result->result_array();
        }


	    function get_photo($id_folio)
        {			
			$this->db->select('*');
		    $this->db->from('fsm_sura_comercial');
		    $this->db->like('fsm_folio',$id_folio);	
			$this->db->order_by('fsm_foto ASC' );
            $result = $this->db->get();
            return $result->result_array();
        }


       function borra_lote_fotografico_by_folio($fsm_id)
		{
			//$this->db->like('fsm_folio', $fsm_id);
			$this->db->where('fsm_folio', $fsm_id);
			return $this->db->delete('sis01_sura_comercial');
		}


       function borra_lote_fotografico_by_folio_ori($fsm_id)
		{
			//$this->db->like('fsm_folio', $fsm_id);
			$this->db->where('fsm_folio', $fsm_id);
			return $this->db->delete('fsm_sura_comercial');
		}


	    function get_alot($id_folio)
        {			
			$this->db->select('*');
		    $this->db->from('sis01_sura_comercial');
		    $this->db->like('fsm_folio',$id_folio);		   
            $result = $this->db->get();
            return $result->result_array();
        }








	    function obtenLoteFotograficoFolio($fsm_folio)
        {			
            $this->db->select('*');
            $this->db->from('sis01_sura_comercial');
			$this->db->where('fsm_folio', $fsm_folio);
			$this->db->order_by('fsm_f DESC','fsm_folio DESC' );
			$this->db->limit(1); 
            $result = $this->db->get();
            $row=$result->result_array();
			return $row[0];
        }



	    function obtenLogFolio($fsm_folio)
        {			
            $this->db->select('*');
            $this->db->from('sis02_sura_comercial_log');
			$this->db->where('log_id', $fsm_folio);
			$this->db->order_by('log_id DESC' );
			$this->db->limit(1); 
            $result = $this->db->get();
            $row=$result->result_array();
			return $row[0];
        }


	    function obtenEfectivoLoteFotografia($rows)
        {			
			$page = ($this->uri->segment(3) != '')?($this->uri->segment(3)-1)*$rows:0;
            $this->db->select('DISTINCT(fsm_folio) as fsm_folio');
            $this->db->from('sis01_sura_comercial');
			$this->db->where('fsm_folio !=', '');
			$this->db->order_by('fsm_f DESC','fsm_folio DESC' );
			$this->db->limit($rows, $page);
            $result = $this->db->get();
            return $result->result_array();
        }






		function  get_all_reg_by_fecha($f_ini,$f_fin)
        {
            $this->db->select('DISTINCT(fsm_folio) as fsm_folio,fsm_f,sura_id');
            $this->db->from('sis01_sura_comercial');
			$this->db->where('fsm_f >=', $f_ini);
			$this->db->where('fsm_f <=', $f_fin);
			$this->db->where('fsm_folio !=', '');
			$this->db->order_by('sura_id DESC');
            $result = $this->db->get();
            return $result->result_array();
        }


		function cuentaEfectivaLoteFotografia()
        {
            $this->db->select("count(DISTINCT fsm_folio) as regs");
            $this->db->from('sis01_sura_comercial');
			$this->db->where('fsm_folio !=', '');			
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }







		function count_eventos_sasegurados($poliza_id)
        {
            $this->db->select("count(*) as regs");
            $this->db->from('sis04_sasegurados');
            $this->db->like('aseg_poliza',$poliza_id);
			/* SOLO SE CONDSIDERAN SERVICIOS CONCLUIDOS */
			$this->db->like('aseg_estatus','CONCLUÍDO');
			/*******************************************/	
            $result = $this->db->get();
            $row = $result->row_array();
            return $row['regs'];
        }

        function buscalo($poliza_id)
        {            
			$this->db->select('*');            
            $this->db->from('sis04_sasegurados');
            $this->db->like('aseg_poliza',$poliza_id);			
			$this->db->order_by('aseg_f','DESC');
			$this->db->limit(1); 
			$result=$this->db->get()->row_array();			
            return $result;
        }


        function actualiza($fsm_id, $params)
        {
            $this->db->where('aseg_id',$fsm_id);
            return $this->db->update('sis04_sasegurados',$params);
        }

		function borra($fsm_id)
		{
			$this->db->where('aseg_id', $fsm_id);
			return $this->db->delete('sis04_sasegurados');
		}
			
        function get($id)
        {
            $this->db->select('*');
            $this->db->from('sis04_sasegurados');
            $this->db->where('aseg_id', $id);
            $result = $this->db->get();
            return $result->row_array();
        }


	    function get_cond($id)
        {			
            $this->db->select('*');
            $this->db->from('sis04_sasegurados');
            $this->db->where('cond_id', $id);
            $result = $this->db->get();
            return $result->row_array();
        }


        function inserta($params)
        {
            $this->db->insert('sis04_sasegurados', $params);
            return $this->db->insert_id();
        }
		

		
}