<?php
/* 
 * Generated by CRUDigniter v2.3 Beta 
 * www.crudigniter.com
 */
 
class Empresa_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    
    /*
     * Get empresa by emp_id
     */
    function get_empresa($emp_id)
    {
        return $this->db->get_where('sis15_empresas',array('emp_id'=>$emp_id))->row_array();
    }
    
    function get_cei($cei_id)
    {
        return $this->db->get_where('sis80_ceis',array('cei_id'=>$cei_id))->row_array();
    }

	
	function get_una_sucursal($suc_id)
    {
        return $this->db->get_where('sis65_sucursales',array('suc_id'=>$suc_id))->row_array();
    }
	
	function get_una_cotizacion($emp_id)
    {
        return $this->db->get_where('sis_cotizaciones',array('emp_id'=>$emp_id))->row_array();
    }
	
	
    function find_empresa($emp)
    {
        $this->db->like('emp_razon_social', $emp);
        $this->db->where('emp_estatus_cve', 'ACTIVO');
        return $this->db->get('sis15_empresas')->result_array();
    }
    
    
    /*
     * Get all sis15_empresas
     */
    function get_all_empresas()
    {
        $this->db->select('a.*, ifnull(count(clte_id),0) as empleados');
        $this->db->from('sis15_empresas as a');
        $this->db->join('sis05_clientes as b','a.emp_id = b.emp_id','LEFT');
        if(get_perfil_id() == 4)
        {
            $this->db->where('a.emp_id', get_emp_id());
        }
        //$this->db->where('emp_estatus_cve', 'ACTIVO');
        $this->db->group_by('a.emp_id');
        $this->db->order_by('a.emp_razon_social ASC');
        return $this->db->get()->result_array();
    }
    
	function get_all_sucursales()
    {
        //$this->db->select('*');
        //$this->db->from('sis65_sucursales');
        //$this->db->join('sis05_clientes as b','a.emp_id = b.emp_id','LEFT');
        //$this->db->group_by('a.emp_id');
        //$this->db->order_by('emp_razon_social ASC', 'suc_alias ASC');
        //return $this->db->get()->result_array();
		$sql= "SELECT * FROM sis65_sucursales order by emp_razon_social ASC, suc_alias ASC";
		$result = $this->db->query($sql);
        return $result->result_array();
    }
	

    /*
     * function to add new empresa
     */
    function inserta($params)
    {
        $this->db->insert('sis15_empresas',$params);
        return $this->db->insert_id();
    }
    
    /*
     * function to update empresa
     */
    function actualiza($emp_id,$params)
    {
        $this->db->where('emp_id',$emp_id);
        return $this->db->update('sis15_empresas',$params);
    }
    
    /*
     * function to delete empresa
     */
    function delete_empresa($emp_id)
    {
        return $this->db->delete('sis15_empresas',array('emp_id'=>$emp_id));
    }
    
    function get_empresa_busca( $busca ){
                
        return $result;
    }
    function inserta_sucursal($params)
    {
        $this->db->insert('sis65_sucursales',$params);
        return $this->db->insert_id();
    }
   
    function get_sucursales($emp_id)
    {
        return $this->db->get_where('sis65_sucursales',array('emp_id'=>$emp_id))->result_array();
    }



    function get_sucursal($suc_id)
    {
        return $this->db->get_where('sis65_sucursales',array('suc_id'=>$suc_id))->row_array();
    }



    function get_empresa_by_id($emp_id)
    {
        $this->db->select('*');
        $this->db->from('sis15_empresas');
        $this->db->where('emp_id', $emp_id);
        $result = $this->db->get();
        return $result->row_array();
    }
	


    function actualiza_sucursal($suc_id,$params)
    {
        $this->db->where('suc_id',$suc_id);
        return $this->db->update('sis65_sucursales',$params);
    }
    
    function delete_sucursal($suc_id)
    {
        $this->db->where('suc_id',$suc_id);
        return $this->db->delete('sis65_sucursales');
    }

    function get_examenes($emp_id)
    {
        return $this->db->get_where('sis16_empresas_costos',array('emp_id'=>$emp_id))->result_array();
    }

    function inserta_examen($params)
    {
        $this->db->insert('sis16_empresas_costos',$params);
        return $this->db->insert_id();
    }

    function get_realizados($examen, $emp_id, $ini = '', $fin = '')
    {
        $mapeo = array(
            'TOXI'  => array('tabla' => 'fsm_toxicologico', 'fecha' => 'fsm_f'),
            'TOXIS' => array('tabla' => 'fsm_toxicologico7', 'fecha' => 'fsm_f'),
            'PSIC'  => array('tabla' => 'fsm_psicologico', 'fecha' => 'fsm_f'),
            'ACRED' => array('tabla' => 'fsm_acreditacion', 'fecha' => 'fsm_f'),
            'MEDFIS' => array('tabla' => 'fsm_medico_fisico', 'fecha' => 'fsm_f'),
            'SOCIE' => array('tabla' => 'socio_eco', 'fecha' => 'fecha_eval'),
            'ENTSOC' => array('tabla' => 'entorno_soc', 'fecha' => 'fecha_eval'),
            'CED' => array('tabla' => 'fsm_poligrafico', 'fecha' => 'polig_fecha_eval','where' => array('campo' => 'polig_tipo_cve','valor' => 'CEDULA')),
            'POL' => array('tabla' => 'fsm_poligrafico', 'fecha' => 'polig_fecha_eval','where' => array('campo' => 'polig_tipo_cve','valor' => 'POLI')),
            'HIST' => array('tabla' => 'fsm_historia_clinica', 'fecha' => 'fsm_f'),
            'TOXIN' => array('tabla' => 'fsm_toxi', 'fecha' => 'fsm_f'),
            'ESTSOC' => array('tabla' => 'esc', 'fecha' => 'esc_f'),
            'QUISAN' => array('tabla' => 'fsm_quimica_sanguinea', 'fecha' => 'qui_f_recibido'),
            'ORINA' => array('tabla' => 'fsm_orina', 'fecha' => 'ori_f_recibido'),
            'BIOHEM' => array('tabla' => 'fsm_biometria_hematica', 'fecha' => 'bio_f_recibido'),
            'GPOSAN' => array('tabla' => 'fsm_grupo_sanguineo', 'fecha' => 'gs_f_recibido'),
            'REPSIC' => array('tabla' => 'fsm_psicologico_2', 'fecha' => 'fsm_f'),
            'EYED' => array('tabla' => 'fsm_eye_detect', 'fecha' => 'fsm_f'),
            'SOCLAB' => array('tabla' => 'fsm_sociolab', 'fecha' => 'fsm_f'),
			'PIE'       => array('tabla' => 'fsm_pie', 'fecha' => 'pie_f_recibido'),
			'ODO'       => array('tabla' => 'fsm_odon', 'fecha' => 'fodon_fechaeva'),
			'FSM0105'   => array('tabla' => 'fpfh_01_05', 'fecha' => 'fpfh_fechaeva')
			
			
        );

        $this->db->select('count(*) as realizados');
        $this->db->from($mapeo[$examen]['tabla']);
        $this->db->where('emp_id', $emp_id);
        if($ini != '')
        {
            $this->db->where($mapeo[$examen]['fecha'].'>= ',$ini);
        }
        if($fin != '')
        {
            $this->db->where($mapeo[$examen]['fecha'].'<= ',$fin);
        }
        if(isset($mapeo[$examen]['where']))
        {
            $this->db->where($mapeo[$examen]['where']['campo'],$mapeo[$examen]['where']['valor']);
        }
        $result = $this->db->get();
        return $result->row_array();
    }

    function delete_costos($emp_id)
    {
        $this->db->where('emp_id',$emp_id);
        return $this->db->delete('sis16_empresas_costos');
    }

    function insert_costos($params)
    {
        return $this->db->insert_batch('sis16_empresas_costos',$params);
    }
}