<style>
    .header-table-secondary{
        background-color: #999;
        color: #fff;
    }
    *{
        font-size: 10px;
    }
</style>
<div class="panel-body">
        <img src="<?php echo base_url('../dist/images/logo_2.png'); ?>" width="300px" />
        <h3 align="center">ESTUDIO SOCIOECONÓMICO</h3>
        <table cellpadding="3" border="0" class="table table-sinborde">
            <tr>
                <td width="20%" align="right">
                    <?php if($persona['clte_path_foto'] ==! NULL): ?> 
                    <img src="<?php echo base_url('../fotos/'.strtolower($persona['clte_path_foto'])); ?>" width="100px" height="120px">
                    <?php else: ?>
                        <img src="<?php echo base_url('../dist/images/persona.png'); ?>"  width="100px" height="120px">
                    <?php endif; ?>
                </td>
                <td width="80%" align="left">
                    <table width="100%">
                        <tr>
                            <td align="right" width="40%">
                                <label><b>Puesto a cubrir:</b></label>
                            </td>
                            <td align="left" width="60%">
                                <label><?php echo $persona['clte_puesto']; ?></label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right">
                                <label><b>Motivo de evaluación:</b></label>
                            </td>
                            <td align="left">
                                <label><?php echo $fsm['motivo']; ?></label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right">
                                <label><b>Fecha de evaluación:</b></label>
                            </td>
                            <td align="left">
                                <label><?php echo formatea_fecha($fsm['fecha_eval']); ?></label>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
         <p>&nbsp;</p>
        <table cellpadding="3" border="1" class="table">
            <tr>
                <td colspan="3" style="background-color: #00004d;">
                    <b style="color: #fff;">1. INFORMACIÓN GENERAL</b>
                </td>
            </tr>
            <tr>
                <td>
                    <b>NOMBRE(S)</b><br>
                    <?php echo $persona['clte_nombre']; ?> <?php echo $persona['clte_2_nombre']; ?>
                </td>
                <td>
                    <b>APELLIDO PATERNO</b><br>
                    <?php echo $persona['clte_paterno']; ?>
                </td>
                <td>
                    <b>APELLIDO MATERNO</b><br>
                    <?php echo $persona['clte_materno']; ?>
                </td>
            </tr>
            <tr>
                <td>
                    <b>FECHA DE NACIMIENTO</b><br>
                    <?php echo formatea_fecha($persona['clte_f_nac']); ?>
                </td>
                <td>
                    <b>EDAD</b><br>
                    <?php echo get_edad($persona['clte_f_nac']); ?>
                </td>
                <td>
                    <b>LUGAR DE NACIMIENTO</b><br>
                    <?php echo get_cat_nombre('EDO',$persona['clte_nac_cve']); ?>
                </td>
            </tr>
            <tr>
                <td>
                    <b>LUGAR DE RESIDENCIA</b><br>
                    <?php echo get_cat_nombre('EDO',$persona['clte_mex_resid_cve']); ?>
                </td>
                <td>
                    <b>ESTADO CIVIL</b><br>
                    <?php echo get_cat_nombre('EDO_CIV',$persona['clte_edo_civ_cve']); ?>
                </td>
                <td>
                    <b>SEXO</b><br>
                    <?php echo get_cat_nombre('GENERO',$persona['clte_genero_cve']); ?>
                </td>
            </tr>
            <tr>
                <td>
                    <b>TELÉFONO DE CASA</b><br>
                    <?php echo formatea_tel($persona['clte_tel_casa']); ?>
                </td>
                <td>
                    <b>TELÉFONO CELULAR</b><br>
                    <?php echo formatea_tel($persona['clte_cel']); ?>
                </td>
                <td>
                    <b>CORREO ELECTRÓNICO</b><br>
                    <?php echo $persona['clte_email']; ?>
                </td>
            </tr>
        </table>
        <table cellpadding="3" border="1" class="table">
            <tr>
                <th colspan="4" align="center" class="header-table-secondary" >DOMICILIO ACTUAL</th>
            </tr>
            <tr>
                <td colspan="2">
                    <b>CALLE</b><br>
                    <?php echo $persona['clte_env_calle']; ?>
                </td>
                <td>
                    <b>NÚMERO EXTERIOR</b><br>
                    <?php echo $persona['clte_env_num_ext']; ?>
                </td>
                <td>
                    <b>NÚMERO INTERIOR</b><br>
                    <?php echo $persona['clte_env_num_int']; ?>
                </td>
            </tr>
            <tr>
                <td>
                    <b>COLONIA</b><br>
                    <?php echo $persona['clte_env_colonia']; ?>
                </td>
                <td>
                    <b>DELEGACIÓN O MUNICIPIO</b><br>
                    <?php echo $persona['clte_env_municipio']; ?>
                </td>
                <td>
                    <b>ESTADO</b><br>
                    <?php echo $persona['clte_env_localidad']; ?>
                </td>
                <td>
                    <b>C.P.</b><br>
                    <?php echo $persona['clte_env_cp']; ?>
                </td>
            </tr>
        </table>
         <p>&nbsp;</p>
        <table cellpadding="3" border="1" class="table table-striped">
            <tr>
                <td colspan="5" style="background-color: #00004d;">
                    <b style="color: #fff;">2. INFORMACIÓN ACADÉMICA</b>
                </td>
            </tr>
            <tr class="header-table-secondary">
                <th align="center">NIVEL ESCOLAR</th>
                <th align="right">AÑOS</th>
                <th align="center">NOMBRE DE LA ESCUELA</th>
                <th align="center">POBLACIÓN</th>
                <th align="center">DOCUMENTO</th>
            </tr>
            <?php 
                if($fsm['escuelas']): 
                    foreach ($fsm['escuelas'] as $escuela): 
            ?>
                    <tr>
                        <td>
                            <?php echo get_cat_nombre('GRADOACAD', $escuela['nivel']); ?>
                        </td>
                        <td align="right">
                            <?php echo $escuela['inicio']; ?>
                        </td>
                        <td>
                            <?php echo $escuela['nombre']; ?>
                        </td>
                        <td>
                            <?php echo $escuela['poblacion']; ?>
                        </td>
                        <td>
                            <?php echo $escuela['doc']; ?>
                        </td>
                    </tr>
            <?php
                    endforeach;
                endif; 
            ?>
        </table>
          <p>&nbsp;</p>
        <table cellpadding="3" border="1" class="table table-striped">
            <tr>
                <td colspan="8" style="background-color: #00004d;">
                    <b style="color: #fff;">
                        3. ESTRUCTURA FAMILIAR
                    </b>
                </td>
            </tr>
            <tr class="header-table-secondary">
                <th align="center">NOMBRE</th>
                <th align="right">EDAD</th>
                <th align="center">EDO. CIVIL</th>
                <th align="center">ESCOLARIDAD</th>
                <th align="center">OCUPACIÓN</th>
                <th align="center">VIVE CON EL EVALUADO</th>
                <th align="right">DESDE CUÁNDO</th>
                <th align="center">DEPENDIENTE ECONÓMICO</th>
            </tr>
            <?php 
                if($fsm['familiares']): 
                    foreach ($fsm['familiares'] as $fam): 
            ?>
                    <tr>
                        <td>
                            <?php echo $fam['nombre']; ?>
                        </td>
                        <td align="right">
                            <?php echo $fam['edad']; ?>
                        </td>
                        <td>
                            <?php echo get_cat_nombre('EDO_CIV', $fam['edo_civil']); ?>
                        </td>
                        <td>
                            <?php echo get_cat_nombre('GRADOACAD', $fam['escolaridad']); ?>
                        </td>
                        <td>
                            <?php echo $fam['ocupacion']; ?>
                        </td>
                        <td>
                            <?php echo $fam['vive_eval']; ?>
                        </td>
                        <td align="right">
                            <?php echo $fam['tiempo']; ?>
                        </td>
                        <td>
                            <?php echo $fam['dependiente']; ?>
                        </td>
                    </tr>
            <?php
                    endforeach;
                endif; 
            ?>
            <tr>
                <td colspan="4">
                    <label>Número de matrimonios: </label>
                    <label><?php echo $fsm['matrimonios']; ?></label>
                </td>
                <td colspan="4">
                    <label>Cantidad de veces que ha vivido en unión libre: </label>
                    <label><?php echo $fsm['uniones']; ?></label>
                </td>
            </tr>
        </table>
        <?php 
            $empleo_actual = array();
            if($fsm['empleos'])
            {
                foreach ($fsm['empleos'] as $empleo)
                {
                    if($empleo['tipo_cve'] == 'ACTUAL')
                    {
                        $empleo_actual = $empleo;
                    }
                }
            }
        ?>
           <p>&nbsp;</p>
        <table cellpadding="3" border="0" class="table table-sinborde">
            <tr>
                <td style="background-color: #00004d;" colspan="4">
                    <b style="color: #fff;">4. INVESTIGACIÓN LABORAL</b>
                </td>
            </tr>
            <tr>
                <th colspan="4" align="center" class="header-table-secondary" >EMPLEO ACTUAL</th>
            </tr>
            <tr>
                <td width="20%" align="right">Empresa:</td>
                <td colspan="3">
                    <label>ACTUAL</label>
                    <label><?php echo (isset($empleo_actual['empleo_id']))?$empleo_actual['empleo_id']:''; ?></label>
                    <label><?php echo (isset($empleo_actual['empresa']))?$empleo_actual['empresa']:''; ?></label>
                </td>
            </tr>
            <tr>
                <td align="right">Fecha de ingreso:</td>
                <td colspan="3">
                    <label><?php echo (isset($empleo_actual['tipo_cve']))?formatea_fecha($empleo_actual['f_ingreso']):''; ?></label>
                </td>
            </tr>
            <tr>
                <td align="right">Tiempo que lleva laborando:</td>
                <td colspan="3">
                    <label><?php echo (isset($empleo_actual['tiempo_lab']))?$empleo_actual['tiempo_lab']:''; ?></label>
                </td>
            </tr>
            <tr>
                <td align="right">Dirección:</td>
                <td colspan="3">
                    <label><?php echo (isset($empleo_actual['direccion']))?$empleo_actual['direccion']:''; ?></label>
                </td>
            </tr>
            <tr>
                <td align="right">Teléfono:</td>
                <td colspan="3">
                    <label><?php echo (isset($empleo_actual['telefono']))?$empleo_actual['telefono']:''; ?></label> 
                </td>
            </tr>
            <tr>
                <td align="right">Puesto inicial:</td>
                <td>
                    <label><?php echo (isset($empleo_actual['puesto_i']))?$empleo_actual['puesto_i']:''; ?></label>
                </td>
                <td align="right">Sueldo mensual inicial:</td>
                <td>
                    <label>$<?php echo (isset($empleo_actual['sueldo_i']))?number_format($empleo_actual['sueldo_i'],2):''; ?></label>
                </td>
            </tr>
            <tr>
                <td align="right">Puesto final:</td>
                <td>
                    <label><?php echo (isset($empleo_actual['puesto_f']))?$empleo_actual['puesto_f']:''; ?></label>
                </td>
                <td align="right">Sueldo mensual final:</td>
                <td>
                    <label>$<?php echo (isset($empleo_actual['sueldo_f']))?number_format($empleo_actual['sueldo_f'],2):''; ?></label>
                </td>
            </tr>
            <tr>
                <td align="right">Horario de labores:</td>
                <td colspan="3">
                    <label><?php echo (isset($empleo_actual['horario']))?$empleo_actual['horario']:''; ?></label>
                </td>
            </tr>
            <tr>
                <td align="right">Jefe Inmediato:</td>
                <td colspan="3">
                    <label><?php echo (isset($empleo_actual['jefe']))?$empleo_actual['jefe']:''; ?></label>
                </td>
            </tr>
            <tr>
                <td align="right">¿Por qué desea cambiar de trabajo?</td>
                <td colspan="3">
                    <label><?php echo (isset($empleo_actual['motivo']))?$empleo_actual['motivo']:''; ?></label>
                </td>
            </tr>
            <tr colspan="4">
                <th align="left" colspan="4" class="">EVALUACIÓN DEL DESEMPEÑO:</th>
            </tr>
            <tr>
                <td colspan="4">
                    <label><?php echo (isset($empleo_actual['evaluacion']))?$empleo_actual['evaluacion']:''; ?></label>
                </td>
            </tr>
            <tr>
                <td width="15%" align="left">Nombre del informante:</td>
                <td width="35%">
                    <label><?php echo (isset($empleo_actual['informante']))?$empleo_actual['informante']:''; ?></label>
                </td>
                <td width="15%" align="left">Puesto:</td>
                <td width="35%">
                    <label><?php echo (isset($empleo_actual['puesto_infor']))?$empleo_actual['puesto_infor']:''; ?></label>
                </td>
            </tr>
            <tr>
                <td align="left">Recontratable:</td>
                <td>
                    <?php echo get_cat_nombre('AFIRMA', (isset($empleo_actual['recontratable']))?$empleo_actual['recontratable']:''); ?>
                </td>
                <td align="left">Recomendable:</td>
                <td>
                    <?php echo get_cat_nombre('AFIRMA', (isset($empleo_actual['recomendable']))?$empleo_actual['recomendable']:''); ?>
                </td>
            </tr>
        </table>
            <p>&nbsp;</p>
        <table cellpadding="3" border="0" class="table table-sinborde">
            <tr>
                <th align="center" colspan="4" class="header-table-secondary" >
                    EMPLEO ANTERIOR
                </th>
            </tr>
            <?php 
            $empleo_actual = array();
            if($fsm['empleos']): 
                foreach ($fsm['empleos'] as $empleo):
                    if($empleo['tipo_cve'] != 'ACTUAL'):
            ?>
            <tr>
                <td colspan="4">
                    <table cellpadding="3" border="0" class="table table-sinborde">
                        <tr>
                            <td width="20%" align="right">Empresa:</td>
                            <td colspan="3">
                                <label><?php echo $empleo['empleo_id']; ?></label>
                                <label><?php echo $empleo['empresa']; ?></label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right">Dirección:</td>
                            <td colspan="3">
                                <label><?php echo $empleo['direccion']; ?></label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right">Teléfono:</td>
                            <td colspan="3">
                                <label><?php echo $empleo['telefono']; ?></label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right">Tiempo que laboró:</td>
                            <td colspan="3">
                                <label><?php echo $empleo['tiempo_lab']; ?></label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right">Fecha de ingreso:</td>
                            <td>
                                <label><?php echo formatea_fecha($empleo['f_ingreso']); ?></label>
                            </td>
                            <td align="right">Fecha de salida:</td>
                            <td>
                                <label><?php echo formatea_fecha($empleo['f_salida']); ?></label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right">Puesto inicial:</td>
                            <td>
                                <label><?php echo $empleo['puesto_i']; ?></label>
                            </td>
                            <td align="right">Sueldo mensual inicial:</td>
                            <td>
                                <label>$<?php echo (is_numeric($empleo['sueldo_i']))?number_format($empleo['sueldo_i'],2):''; ?></label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right">Puesto final:</td>
                            <td>
                                <label><?php echo $empleo['puesto_f']; ?></label>
                            </td>
                            <td align="right">Sueldo mensual final:</td>
                            <td>
                                <label>$<?php echo (is_numeric($empleo['sueldo_f']))?number_format($empleo['sueldo_f'],2):''; ?></label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right">Principales actividades:</td>
                            <td colspan="3">
                                <label><?php echo $empleo['actividades']; ?></label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right">Horario de labores:</td>
                            <td colspan="3">
                                <label><?php echo $empleo['horario']; ?></label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right">Jefe Inmediato:</td>
                            <td colspan="3">
                                <label><?php echo $empleo['jefe']; ?></label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right">Motivo de salida (especifique):</td>
                            <td colspan="3">
                                <label><?php echo $empleo['motivo']; ?></label>
                            </td>
                        </tr>
                        <tr>
                            <td align="right">¿Cuenta con carta de recomendación?</td>
                            <td colspan="3">
                                <?php echo get_cat_nombre('AFIRMA',$empleo['recomendacion']); ?>
                            </td>
                        </tr>
                        <tr colspan="4">
                            <th align="left" colspan="4" class="">EVALUACIÓN DEL DESEMPEÑO:</th>
                        </tr>
                        <tr>
                            <td colspan="4">
                                <label><?php echo $empleo['evaluacion']; ?></label>
                            </td>
                        </tr>
                        <tr>
                            <td width="15%" align="left">Nombre del informante:</td>
                            <td width="35%">
                                <label><?php echo $empleo['informante']; ?></label>
                            </td>
                            <td width="15%" align="left">Puesto:</td>
                            <td width="35%">
                                <label><?php echo $empleo['puesto_infor']; ?></label>
                            </td>
                        </tr>
                        <tr>
                            <td align="left">Recontratable:</td>
                            <td>
                                <?php echo get_cat_nombre('AFIRMA', $empleo['recontratable']); ?>
                            </td>
                            <td align="left">Recomendable:</td>
                            <td>
                                <?php echo get_cat_nombre('AFIRMA', $empleo['recomendable']); ?>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <?php
            endif; endforeach; endif;
            ?>
        </table>
             <p>&nbsp;</p>
        <table cellpadding="3" border="1" class="table">
            <tr>
                <td colspan="6" style="background-color: #00004d;">
                    <b style="color: #fff;">5. REFERENCIAS PERSONALES Y VECINALES</b>
                </td>
            </tr>
            <tr class="header-table-secondary">
                <th align="center">NOMBRE</th>
                <th align="center">TELÉFONO</th>
                <th align="center">DIRECCIÓN</th>
                <th align="center">TIPO DE RELACIÓN</th>
                <th align="right">TIEMPO DE CONOCERLO</th>
                <th align="center">OCUPACIÓN</th>
            </tr>
            <?php 
                if($fsm['referencias']): 
                    foreach ($fsm['referencias'] as $ref): 
            ?>
                    <tr>
                        <td>
                            <?php echo $ref['nombre']; ?>
                        </td>
                        <td>
                            <?php echo formatea_tel($ref['telefono']); ?>
                        </td>
                        <td>
                            <?php echo $ref['direccion']; ?>
                        </td>
                        <td>
                            <?php echo $ref['relacion']; ?>
                        </td>
                        <td align="right">
                            <?php echo $ref['tiempo']; ?>
                        </td>
                        <td>
                            <?php echo $ref['ocupacion']; ?>
                        </td>
                    </tr>
            <?php
                    endforeach;
                endif; 
            ?>
        </table>
         <p>&nbsp;</p>
        <table cellpadding="3" border="1" class="table">
            <tr>
                <td colspan="3" style="background-color: #00004d;">
                    <b style="color: #fff;">6. REFERENCIAS BANCARIAS</b>
                </td>
                
            </tr>
            <tr class="header-table-secondary">
                <th align="center" >BANCO</th>
                <th align="center" >TIPO DE CUENTA</th>
                <th align="right" >LÍMITE DE CRÉDITO OTORGADO</th>
            </tr>
            <?php 
                if($fsm['bancos']): 
                    foreach ($fsm['bancos'] as $banco): 
            ?>
                    <tr>
                        <td>
                            <?php echo $banco['banco']; ?>
                        </td>
                        <td>
                            <?php echo $banco['cuenta']; ?>
                        </td>
                        <td align="right">
                            $<?php echo (is_numeric($banco['limite']))?number_format($banco['limite'],2):''; ?>
                        </td>
                    </tr>
            <?php
                    endforeach;
                endif; 
            ?>
        </table>
         <p>&nbsp;</p>
        <table cellpadding="3" border="1" class="table">
            <tr>
                <td style="background-color: #00004d;" colspan="4">
                    <b style="color: #fff;">7. SITUACIÓN ECONÓMICA</b>
                </td>
            </tr>
            <tr>
                <th colspan="4" align="center" class="header-table-secondary">PROPIEDADES</th>
            </tr>
            <tr>
                <td>La casa que habita es:</td>
                <td colspan="4">
                    <?php echo get_cat_nombre('CASA', $fsm['tipo_casa']); ?>
                </td>
            </tr>
            <tr>
                <td>
                    Valor aproximado: $<label><?php echo ($fsm['tipo_casa'] == 'PROPIA')?number_format($fsm['valor_casa'],2):''; ?></label>
                </td>
                <td>
                    Renta mensual: $<label><?php echo ($fsm['tipo_casa'] == 'RENTA')?number_format($fsm['valor_casa'],2):''; ?></label>
                </td>
                <td>
                    Valor de adeudo: $<label><?php echo ($fsm['tipo_casa'] == 'BANCO')?number_format($fsm['valor_casa'],2):''; ?></label>
                </td>
                <td>
                    Aportación mensual: $<label><?php echo (is_numeric($fsm['aportacion_casa']))?number_format($fsm['aportacion_casa'],2):''; ?></label>
                </td>
            </tr>
        </table>
          <p>&nbsp;</p>
        <table cellpadding="3" border="1" class="table">
            <tr>
                <th colspan="4" align="center" class="header-table-secondary">
                    AUTOMÓVILES
                </th>
            </tr>
            <tr>
                <th>TIPO</th>
                <th>PROPIO</th>
                <th>MARCA</th>
                <th>MODELO</th>
            </tr>
            <?php 
                if($fsm['autos']): 
                    foreach ($fsm['autos'] as $auto): 
            ?>
                    <tr>
                        <td>
                            <?php echo $auto['tipo']; ?>
                        </td>
                        <td>
                            <?php echo $auto['propio']; ?>
                        </td>
                        <td>
                            <?php echo $auto['marca']; ?>
                        </td>
                        <td>
                            <?php echo $auto['modelo']; ?>
                        </td>
                    </tr>
            <?php
                    endforeach;
                endif; 
            ?>
            <tr>
                <td>
                    ¿Están totalmente liquidados?
                </td>
                <td>
                    <?php echo get_cat_nombre('AFIRMA', $fsm['autos_liquidados']); ?>
                </td>
                <td>
                    ¿Cuánto adeuda?
                </td>
                <td align="right">
                    <label>$<?php echo (is_numeric($fsm['autos_adeudo']))?number_format($fsm['autos_adeudo'],2):''; ?></label>
                </td>
            </tr>
        </table>
         <p>&nbsp;</p>
        <table cellpadding="3" border="1" class="table">
            <tr>
                <th colspan="5" align="center" class="header-table-secondary" >
                    CRÉDITOS
                </th>
            </tr>
            <tr>
                <th align="center" >Con quién</th>
                <th align="right" >Monto del crédito</th>
                <th align="right" >Mensualidad</th>
                <th align="right" >Plazo</th>
                <th align="right" >Saldo</th>
            </tr>
            <?php 
                if($fsm['creditos']): 
                    foreach ($fsm['creditos'] as $cred): 
            ?>
                    <tr>
                        <td>
                            <?php echo $cred['quien']; ?>
                        </td>
                        <td align="right">
                            $<?php echo (is_numeric($cred['monto']))?number_format($cred['monto'],2):''; ?>
                        </td>
                        <td align="right">
                            $<?php echo (is_numeric($cred['mensualidad']))?number_format($cred['mensualidad'],2):''; ?>
                        </td>
                        <td align="right">
                            <?php echo $cred['plazo']; ?>
                        </td>
                        <td align="right">
                            $<?php echo (is_numeric($cred['saldo']))?number_format($cred['saldo'],2):''; ?>
                        </td>
                    </tr>
            <?php
                    endforeach;
                endif; 
            ?>
        </table>
          <p>&nbsp;</p>
        <table cellpadding="3" border="1" class="table">
            <tr>
                <th colspan="3" align="center" class="header-table-secondary" >
                    SEGUROS
                </th>
            </tr>
            <tr>
                <th align="center" >Tipo</th>
                <th align="center" >Aseguradora</th>
                <th align="right" >Monto Mensual</th>
            </tr>
            <?php 
                if($fsm['seguros']): 
                    foreach ($fsm['seguros'] as $seg): 
            ?>
                    <tr>
                        <td>
                            <?php echo get_cat_nombre('SEGURO', $seg['tipo']); ?>
                        </td>
                        <td>
                            <?php echo $seg['aseguradora']; ?>
                        </td>
                        <td align="right">
                            $<?php echo (is_numeric($seg['monto']))?number_format($seg['monto'],2):''; ?>
                        </td>
                    </tr>
            <?php
                    endforeach;
                endif; 
            ?>
        </table>
           <p>&nbsp;</p>
        <table cellpadding="3" border="0" class="table">
            <tr>
                <th colspan="4" align="center" class="header-table-secondary" >INGRESOS</th>
                <th colspan="2" align="center" class="header-table-secondary">EGRESOS</th>
            </tr>
            <tr>
                <th align="center" >PERSONAS QUE APORTAN AL GASTO FAMILIAR</th>
                <th align="right" >INGRESO MENSUAL</th>
                <th align="right" >APORTACIÓN MENSUAL</th>
                <th align="center" >VIVE CON EL EVALUADO</th>
                <th align="center" >CONCEPTO</th>
                <th align="right" >EGRESOS MENSUALES</th>
            </tr>
            <?php 
                $ingresos_cat = get_radio_options_var('INGRESO');
                $egresos_cat = get_radio_options_var('EGRESO');
                
                $limite = (count($ingresos_cat) >= count($egresos_cat))?count($ingresos_cat):count($egresos_cat);
                
                $suma_ingreso_mensual = 0;
                $suma_ingreso_aporta = 0;
                $suma_egreso_mensual = 0;
                
                for($i = 0; $i < $limite; $i++)
                {
                    $indice = '';
                    $indice_egreso = '';
                ?>
            <tr>
                <td>
                    <?php if(isset($ingresos_cat[$i])): ?>
                        <?php echo $ingresos_cat[$i]['cat_nombre']; ?>
                        <?php if($ingresos_cat[$i]['cat_cve'] == 'OTRO'): ?>
                            <?php echo $fsm['ingreso_otro']; ?>
                        <?php endif; ?>
                        <?php $indice = busca_ingreso($ingresos_cat[$i]['cat_cve'], $fsm['ingresos']); ?>
                    <?php endif; ?>
                </td>
                <td align="right">
                    <?php if(isset($ingresos_cat[$i])):
                        $ingreso_mensual = get_ingreso($indice,$fsm['ingresos'],'mensual'); 
                        $suma_ingreso_mensual = $suma_ingreso_mensual + $ingreso_mensual;
                    ?>
                    <label>$<?php echo (is_numeric($ingreso_mensual))?number_format($ingreso_mensual,2):''; ?></label>
                    <?php endif; ?>
                </td>
                <td align="right">
                    <?php if(isset($ingresos_cat[$i])):  
                        $aportacion_mensual = get_ingreso($indice,$fsm['ingresos'],'aportacion'); 
                        $suma_ingreso_aporta = $suma_ingreso_aporta + $aportacion_mensual;
                    ?>
                    <label>$<?php echo (is_numeric($aportacion_mensual))?number_format($aportacion_mensual,2):''; ?></label>
                    <?php endif; ?>
                </td>
                <td>
                    <?php if(isset($ingresos_cat[$i])): ?>
                        <?php if($ingresos_cat[$i]['cat_cve'] != 'EVAL'): ?>
                            <?php echo get_cat_nombre('AFIRMA', get_ingreso($indice,$fsm['ingresos'],'vive_con')); ?>
                        <?php endif; ?>
                    <?php endif; ?>
                </td>
                <td>
                    <?php if(isset($egresos_cat[$i])): ?>
                        <?php echo $egresos_cat[$i]['cat_nombre']; ?>
                        <?php if($egresos_cat[$i]['cat_cve'] == 'OTRO'): ?>
                            <label><?php echo $fsm['egreso_otro']; ?></label>
                        <?php endif; ?>
                    <?php endif; ?>
                </td>
                <td align="right">
                    <?php if(isset($egresos_cat[$i])): ?>
                        <?php $indice_egreso = busca_ingreso($egresos_cat[$i]['cat_cve'], $fsm['egresos']); ?>
                        <?php 
                            $egreso_mensual = get_ingreso($indice_egreso,$fsm['egresos'],'mensual');
                            $suma_egreso_mensual = $suma_egreso_mensual + $egreso_mensual;
                        ?>
                    <label>$<?php echo (is_numeric($egreso_mensual))?number_format($egreso_mensual,2):''; ?></label>
                    <?php endif; ?>
                </td>
            </tr>
        <?php } ?>
            <tr>
                <th align="center" class="header-table-secondary" >TOTAL</th>
                <th align="right" class="header-table-secondary" >
                    <label>$<?php echo (is_numeric($suma_ingreso_mensual))?number_format($suma_ingreso_mensual,2):''; ?></label>
                </th>
                <th align="right" class="header-table-secondary" >
                    <label>$<?php echo (is_numeric($suma_ingreso_aporta))?number_format($suma_ingreso_aporta,2):''; ?></label>
                </th>
                <th align="center" class="header-table-secondary" ></th>
                <th align="center" class="header-table-secondary" >TOTAL</th>
                <th align="right" class="header-table-secondary" >
                    <label>$<?php echo (is_numeric($suma_egreso_mensual))?number_format($suma_egreso_mensual,2):''; ?></label>
                </th>
            </tr>
        </table>
            <p>&nbsp;</p>
        <table cellpadding="3" border="1" class="table">
            <tr>
                <td width="30%">Diferencia entre los ingresos y los egresos:</td>
                <td align="right">
                    <label>$<?php echo (is_numeric($suma_ingreso_aporta - $suma_egreso_mensual))?number_format($suma_ingreso_aporta - $suma_egreso_mensual,2):''; ?></label>
                </td>
            </tr>
            <tr>
                <td>¿Cómo se solventa el déficit?</td>
                <td>
                    <label><?php echo $fsm['deficit']; ?></label>
                </td>
            </tr>
            <tr>
                <td>¿Qué se hace con el excedente?</td>
                <td>
                    <label><?php echo $fsm['excedente']; ?></label>
                </td>
            </tr>
        </table>
        <p>&nbsp;</p>
        <table cellpadding="3" border="1" class="table">
            <tr>
                <td colspan="4" style="background-color: #00004d;">
                    <b style="color: #fff;">8. ASPECTO SOCIO - CULTURALES</b>
                </td>
            </tr>
            <tr>
                <td>Religión:</td>
                <td>
                        <?php echo get_options_relig_nombre($fsm['religion']); ?>
                </td>
                <td>Partido político al que pertenece:</td>
                <td>
                    <label><?php echo $fsm['partido_pol']; ?></label>
                </td>
            </tr>
            <tr>
                <td>Deporte que practica:</td>
                <td>
                    <label><?php echo $fsm['deporte']; ?></label>
                </td>
                <td>Frecuencia:</td>
                <td>
                    <label><?php echo $fsm['frecuencia']; ?></label>
                </td>
            </tr>
            <tr>
                <td>¿Pertenece a algún club social o deportivo?</td>
                <td>
                    <?php echo get_cat_nombre('AFIRMA',$fsm['club_dep']); ?>
                </td>
                <td>¿Cuál?</td>
                <td>
                    <label><?php echo $fsm['nombre_club']; ?></label>
                </td>
            </tr>
            <tr>
                <td>Actividades que realiza en su tiempo libre:</td>
                <td colspan="3">
                    <label><?php echo $fsm['act_libre']; ?></label>
                </td>
            </tr>
            <tr>
                <td>METAS A CORTO PLAZO (menos de un año)</td>
                <td colspan="3">
                    <label><?php echo $fsm['metas_cortas']; ?></label>
                </td>
            </tr>
            <tr>
                <td>METAS A MEDIANO PLAZO (más de un año, menos de cinco)</td>
                <td colspan="3">
                    <label><?php echo $fsm['metas_mediano']; ?></label>
                </td>
            </tr>
        </table>
         <p>&nbsp;</p>
        <table cellpadding="3" border="1" class="table">
            <tr>
                <td colspan="5" style="background-color: #00004d;">
                    <b style="color: #fff;">9. VISITA DOMICILIARIA</b>
                </td>
            </tr>
            <tr>
                <td colspan="5" class="header-table-secondary">
                    <b>9.1 Características de la vivienda</b>
                </td>
            </tr>
            <tr>
                <th colspan="5">La vivienda es:</th>
            </tr>
            <tr>
                <td colspan="4">
                    <?php echo get_cat_nombre('TCASA',$fsm['tipo_vivienda']); ?>
                </td>
                <td>
                    <label><?php echo ($fsm['tipo_vivienda'] == 'OTRO')?$fsm['tipo_vivienda_otro']:''; ?></label>
                </td>
            </tr>
            <tr>
                <th colspan="5">Estructura de la vivienda:</th>
            </tr>
            <tr>
                <td colspan="5">
                    <?php echo get_cat_nombre('ECASA',$fsm['est_vivienda']); ?>
                </td>
            </tr>
            <tr>
                <th colspan="5">Tipo de construcción:</th>
            </tr>
            <tr>
                <td>
                    Paredes:
                </td>
                <td colspan="3">
                    <?php echo get_cat_nombre('TMATERIAL',$fsm['paredes']); ?>
                </td>
                <td>
                    <label><?php echo ($fsm['paredes'] == 'OTRO')?$fsm['paredes_otro']:''; ?></label>
                </td>
            </tr>
            <tr>
                <td>
                    Techos:
                </td>
                <td colspan="3">
                    <?php echo get_cat_nombre('TMATERIAL',$fsm['techos']); ?>
                </td>
                <td>
                    <label><?php echo ($fsm['techos'] == 'OTRO')?$fsm['techos_otro']:''; ?></label>
                </td>
            </tr>
            <tr>
                <td>
                    Pisos:
                </td>
                <td colspan="3">
                    <?php echo get_cat_nombre('TPISO',$fsm['pisos']); ?>
                </td>
                <td>
                    <label><?php echo ($fsm['pisos'] == 'OTRO')?$fsm['pisos_otro']:''; ?></label>
                </td>
            </tr>
        </table>
          <p>&nbsp;</p>
        <table cellpadding="3" border="1" class="table">
            <tr class="header-table-secondary">
                <th colspan="4">Distribución de la vivienda:</th>
            </tr>
            <tr>
                <th align="center"  ></th>
                <th align="right"  >CANTIDAD</th>
                <th align="center"  ></th>
                <th align="right"  >CANTIDAD</th>
            </tr>
            <tr>
                <td>Sala</td>
                <td align="right">
                    <label><?php echo $fsm['sala']; ?></label>
                </td>
                <td>Número de dormitorios</td>
                <td align="right">
                    <label><?php echo $fsm['dormitorios']; ?></label>
                </td>
            </tr>
            <tr>
                <td>Comedor</td>
                <td align="right">
                    <label><?php echo $fsm['comedor']; ?></label>
                </td>
                <td>Zotehuela</td>
                <td align="right">
                    <label><?php echo $fsm['zotehuela']; ?></label>
                </td>
            </tr>
            <tr>
                <td>Cocina</td>
                <td align="right">
                    <label><?php echo $fsm['cocina']; ?></label>
                </td>
                <td>Jardín</td>
                <td align="right">
                    <label><?php echo $fsm['jardin']; ?></label>
                </td>
            </tr>
            <tr>
                <td>Baños completos</td>
                <td align="right">
                    <label><?php echo $fsm['completos_b']; ?></label>
                </td>
                <td>Cochera o estacionamiento</td>
                <td align="right">
                    <label><?php echo $fsm['cochera']; ?></label>
                </td>
            </tr>
            <tr>
                <td>Medios baños</td>
                <td align="right">
                    <label><?php echo $fsm['medios_b']; ?></label>
                </td>
                <td>Número de focos</td>
                <td align="right">
                    <label><?php echo $fsm['focos']; ?></label>
                </td>
            </tr>
            <tr>
                <td>Baños compartidos</td>
                <td align="right">
                    <label><?php echo $fsm['compartidos_b']; ?></label>
                </td>
                <td>Otros, cuáles:
                    <?php echo $fsm['otros_dist']; ?>
                </td>
                <td align="right">
                    <label><?php echo $fsm['otros_dist_n']; ?></label>
                </td>
            </tr>
            <tr>
                <td>¿Cómo comparten los dormitorios?</td>
                <td colspan="3">
                    <label><?php echo $fsm['como_dormitorios']; ?></label>
                </td>
            </tr>
        </table>
          <p>&nbsp;</p>
        <table cellpadding="3" border="1" class="table">
            <tr class="header-table-secondary">
                <th colspan="5">Servicios con que cuenta la vivienda:</th>
            </tr>
            <tr>
                <td colspan="5">
                    <?php echo get_checkbox_nombre('SERVICIOS', explode(',',$fsm['servicios'])); ?>
                </td>
            </tr>
            <tr>
                <td colspan="5">
                    <label><?php echo (in_array('OTRO',explode(',',$fsm['servicios'])))?''.$fsm['servicio_otro']:''; ?></label>
                </td>
            </tr>
        </table>
           <p>&nbsp;</p>
        <table cellpadding="3" border="1" class="table">
            <tr class="header-table-secondary">
                <th colspan="3">Servicios con que cuenta la vivienda:</th>
            </tr>
            <tr>
                <th align="center" class="" >ARTÍCULO</th>
                <th align="right" class="" >CANTIDAD</th>
                <th align="right" class="" >VALOR APROXIMADO</th>
            </tr>           
            
            <?php 
                $mobiliario_cat = get_radio_options_var('INMOBILIARIO');
                $i = 0;
                foreach ($mobiliario_cat as $mobi):
                    $indice = '';
            ?>
            <tr>
                <td>
                    <?php echo $mobi['cat_nombre']; ?>
                    <label><?php echo $mobi['cat_cve']; ?></label>
                    <?php $indice = busca_ingreso($mobi['cat_cve'], $fsm['mobiliarios']); ?>
                </td>
                <td align="right">
                    <label><?php echo get_ingreso($indice,$fsm['mobiliarios'],'cantidad'); ?></label>
                </td>
                <td align="right">
                    <label>$<?php echo (is_numeric(get_ingreso($indice,$fsm['mobiliarios'],'valor')))?number_format(get_ingreso($indice,$fsm['mobiliarios'],'valor'),2):''; ?></label>
                </td>
            </tr>
            <?php $i++;  endforeach; ?>
            <tr>
                <td>
                    OTRO: <label><?php echo $fsm['mobiliario_otro']; ?></label>
                </td>
                <td align="right">
                    <label><?php echo $fsm['mobiliario_cant']; ?></label>
                </td>
                <td align="right">
                    <label>$<?php echo (is_numeric($fsm['mobiliario_valor']))?number_format($fsm['mobiliario_valor'],2):''; ?></label>
                </td>
            </tr>
        </table>
         <p>&nbsp;</p>
        <table cellpadding="3" border="1" class="table">
            <tr>
                <td style="background-color: #00004d;">
                    <b style="color:#fff;">9.2 Vías de acceso</b>
                </td>
            </tr>
            <tr>
                <th>Avenida(s) principal(es):</th>
            </tr>
            <tr>
                <td>
                    <label><?php echo $fsm['avd_principales']; ?></label>
                </td>
            </tr>
            <tr>
                <th>Entre qué calles se localiza el domicilio:</th>
            </tr>
            <tr>
                <td>
                    <label><?php echo $fsm['entre_calles']; ?></label>
                </td>
            </tr>
            <tr>
                <th>Referencias de ubicación:</th>
            </tr>
            <tr>
                <td>
                    <label><?php echo $fsm['referencias_ub']; ?></label>
                </td>
            </tr>
        </table>
          <p>&nbsp;</p>
        <table cellpadding="3" border="1" class="table">
            <tr>
                <td colspan="6"  style="background-color: #00004d;">
                    <b style="color:#fff;">9.3 Transporte cercano</b>
                </td>
            </tr>
            <tr>
                <td colspan="5">
                    <?php echo get_checkbox_nombre('TRANS', explode(',',$fsm['transporte'])); ?>
                </td>
                <td>
                    <label><?php echo (in_array('OTRO',explode(',',$fsm['transporte'])))?$fsm['transp_otro']:''; ?></label>
                </td>
            </tr>
        </table>
         <p>&nbsp;</p>
        <table cellpadding="3" border="1" class="table">
            <tr>
                <td colspan="6" style="background-color: #00004d;">
                    <b style="color:#fff;">9.4 Clase de vivienda</b>
                </td>
            </tr>
            <tr>
                <td colspan="5">
                    <?php echo get_cat_nombre('CCASA', $fsm['clase_v']); ?>
                </td>
                <td>
                    <label><?php echo ($fsm['clase_v'] == 'OTRO')?$fsm['clase_v_otro']:''; ?></label>
                </td>
            </tr>
        </table>
         <p>&nbsp;</p>
        <table cellpadding="3" border="1" class="table">
            <tr>
                <td colspan="4" style="background-color: #00004d;">
                    <b style="color:#fff;">9.5 Zona de ubicación</b>
                </td>
            </tr>
            <tr>
                <td colspan="4">
                    <?php echo get_cat_nombre('ZONAU', $fsm['zona_ub']); ?>
                </td>
            </tr>
        </table>
         <p>&nbsp;</p>
        <table cellpadding="3" border="1" class="table">
            <tr>
                <td colspan="3" style="background-color: #00004d;">
                    <b style="color:#fff;">9.6 Nivel socioeconómico de la vivienda</b>
                </td>
            </tr>
            <tr>
                <td colspan="3">
                    <?php echo get_cat_nombre('NIVESOC', $fsm['nivel_v']); ?>
                </td>
            </tr>
        </table>
        <p>&nbsp;</p>
        <table cellpadding="3" border="1" class="table">
            <tr>
                <td style="background-color: #00004d;">
                    <b style="color: #fff;">10. DICTAMEN</b>
                </td>
            </tr>
            <tr>
                <td>
                    <p><?php echo $fsm['dictamen']; ?></p>
                </td>
            </tr>
        </table>
        <p>&nbsp;</p>
        <table width="100%" border="0" cellpadding="3" >
            <tr>
                <td width="5%">
                    &nbsp;
                </td>
                <td width="35%" align="center">
                  <?php if($fsm['fsm_firma_med'] != 'NULL'): ?>
                    <img class="firma-img" src="<?php echo $fsm['fsm_firma_med']; ?>" width="200px" />
                  <?php endif; ?><br>
                  FIRMA EVALUADOR
                </td>
                <td width="20%">
                    &nbsp;
                </td>
                <td width="35%" align="center">
                  <?php if($fsm['fsm_firma_pac'] != 'NULL'): ?>
                    <img class="firma-img" src="<?php echo $fsm['fsm_firma_pac']; ?>"  width="200px" />
                  <?php endif; ?><br>
                  FIRMA EVALUADO
                </td>
                <td width="5%">
                    &nbsp;
                </td>
            </tr>
        </table>
        <p>&nbsp;</p>
        <p>&nbsp;</p>
        <p>&nbsp;</p>
        <p>&nbsp;</p>
        <p>&nbsp;</p>
        <p>&nbsp;</p>
        <p>&nbsp;</p>
        <p>&nbsp;</p>
        <p>&nbsp;</p>
        <p>&nbsp;</p>
        <p>&nbsp;</p>
        <p>&nbsp;</p>
        <p>&nbsp;</p>
        <table cellpadding="3" border="1" class="table">
            <tr>
                <td colspan="3" style="background-color: #00004d;">
                    <b style="color: #fff;">Fotos</b>
                </td>
            </tr>
            <?php if($fsm['imagenes']): ?>
                <tr>
                    <?php foreach($fsm['imagenes'] as $img): ?>
                    <td><img src="<?php echo base_url('../soc/'.$img['path']); ?>" class="img-responsive socioeconomico" style="width: 250px; height: 250px;" /><br>
                        <label class="control-label"><?php echo $img['nombre']; ?></label>
                        
                    </td>
                    <?php endforeach; ?>
                </tr>
            <?php endif; ?>
        </table> 
        <p>
            FECHA DE REALIZACIÓN: <?php echo formatea_fecha(date('Y-m-d'), strtotime($fsm['fecha_eval'])); ?>
        </p>
</div>