﻿<!-- OP 1 -->
<?php 
	$cei=get_cei_id();
	$root1=get_my_user_root1();
	$user = $this->session->user;
	$CIs =&get_instance();
	
?>
<!-- OP 2 -->

<style>
hr.negro_s { border-top: 1px solid black; }
.incidencia-A { background: #d4edda; }
.incidencia-B { background: #f7b8b8ff; }
.incidencia-D { background: #faf8f8ff; }
.incidencia-E { background: #fff3cd; }
.incidencia-FI { background: #f8d7da; }
.incidencia-FJ { background: #d1ecf1; }
.incidencia-FES { background: #cce5ff; }
.incidencia-INC { background: #e2e3e5; }
.incidencia-NI { background: #e2eafc; }
.incidencia-P { background: #fefefe; }
.incidencia-V { background: #e6ffe6; }
</style>
<div class="col-xs-12">
<div class="panel panel-default">
    <div class="panel-heading">
        <h3>Registro de Incidencias</h3>
    </div>
    <div class="panel-body">
        <form action="<?php echo base_url('persona/nueva_incidencia_nomina/'.$persona['clte_id']); ?>" class="form-horizontal send-form-nomina" method="POST">
            <div class="row form-group">
                <div class="col-xs-12 col-sm-4">
                    <label>Empleado:</label>
                    <select name="empleado_id" class="form-control">
                        <option value="<?php echo htmlspecialchars($persona['clte_id'], ENT_QUOTES, 'UTF-8'); ?>">
                            <?php echo htmlspecialchars($persona['clte_nombre'].' '.$persona['clte_paterno'].' '.$persona['clte_materno'], ENT_QUOTES, 'UTF-8'); ?>
                        </option>
                    </select>
                </div>
                <div class="col-xs-12 col-sm-4">
                    <label>Periodo:</label>
                    <div class="input-group" style="display:flex; align-items:center; gap:8px;">
                        <span class="input-group-addon" style="font-weight:bold; white-space:nowrap; width:auto; min-width:unset; padding:6px 16px 6px 8px; background:#f5f5f5; border:1px solid #ccc; border-radius:4px;">Quincena <?php echo isset($quincena_actual['quin_num']) ? htmlspecialchars($quincena_actual['quin_num'], ENT_QUOTES, 'UTF-8') : ''; ?></span>
                        <input type="date" name="fecha_inicio" id="fecha_inicio" class="form-control" value="<?php echo isset($quincena_actual['quin_f_ini']) ? htmlspecialchars($quincena_actual['quin_f_ini'], ENT_QUOTES, 'UTF-8') : ''; ?>" readonly style="max-width:150px;"/>
                        <span style="font-weight:bold;">a</span>
                        <input type="date" name="fecha_fin" id="fecha_fin" class="form-control" value="<?php echo isset($quincena_actual['quin_f_fin']) ? htmlspecialchars($quincena_actual['quin_f_fin'], ENT_QUOTES, 'UTF-8') : ''; ?>" readonly style="max-width:150px;"/>
                    </div>
                </div>
                <div class="col-xs-12 col-sm-2">
                    <label>&nbsp;</label>
                    <button type="button" class="btn btn-info form-control" onclick="consultarIncidenciasPeriodo()">Ver incidencias del periodo</button>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12">
                    <table class="table table-bordered" id="tabla-incidencias">
                        <thead>
                            <tr>
                                <th>Día</th>
                                <th>Tipo de Incidencia</th>
                                <th>Turnos Extras</th>
                                <th>Horas Extras</th>
                                <th>Observaciones</th>
                                <th>Acción</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><input type="date" name="incidencias[0][fecha]" class="form-control" id="incidencia_fecha_0" /></td>
                                <td>
                                    <select name="incidencias[0][tipo]" class="form-control" onchange="actualizarColorFila(this); mostrarCamposExtras(this)">
                                        <option value="">Selecciona</option>
                                        <option value="A">Asistencia</option>
                                        <option value="B">Baja</option>
                                        <option value="D">Descanso</option>
                                        <option value="E">Tiempo Extra</option>
                                        <option value="FI">Falta Injustificada</option>
                                        <option value="FJ">Falta Justificada</option>
                                        <option value="FES">Festivo Trabajado</option>
                                        <option value="INC">Incapacidad</option>
                                        <option value="NI">Nuevo ingreso</option>
                                        <option value="P">Permiso</option>
                                        <option value="V">Vacaciones</option>
                                    </select>
                                </td>
                                <td>
                                    <input type="number" name="incidencias[0][turnos_extras]" class="form-control campo-turnos-extras" min="0" style="display:none;" placeholder="Turnos extras" />
                                </td>
                                <td>
                                    <input type="number" name="incidencias[0][horas_extras]" class="form-control campo-horas-extras" min="0" style="display:none;" placeholder="Horas extras" />
                                </td>
                                <td><input type="text" name="incidencias[0][observaciones]" class="form-control" /></td>
                                <td><button type="button" class="btn btn-danger btn-sm" onclick="eliminarFila(this)"><span class="glyphicon glyphicon-trash"></span></button></td>
                            </tr>
                        </tbody>
                    </table>
                    <button type="button" class="btn btn-success" onclick="agregarFila()"><span class="glyphicon glyphicon-plus"></span> Agregar Día</button>
                </div>
            </div>
            <div class="row form-group">
                <!-- <div class="col-xs-12" style="display:flex; gap:10px; align-items:center;"> -->
                    <button type="submit" class="btn btn-primary">Guardar Incidencias</button>
                <!-- </div> -->
            </div>
            <div class="row">
                <div class="col-xs-12">
                    <div id="tabla-incidencias-periodo-container"></div>
                </div>
            </div>
        </form>
    </div>
</div>
<script>
    function consultarIncidenciasPeriodo() {
        var empleado_id = document.querySelector('select[name="empleado_id"]').value;
        var fecha_inicio = document.getElementById('fecha_inicio').value;
        var fecha_fin = document.getElementById('fecha_fin').value;
        var container = document.getElementById('tabla-incidencias-periodo-container');
        container.innerHTML = '<div class="text-info">Consultando incidencias...</div>';
        fetch(
            base_url + 'persona/ajax_incidencias_nomina',
            {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: 'empleado_id=' + encodeURIComponent(empleado_id) + '&fecha_inicio=' + encodeURIComponent(fecha_inicio) + '&fecha_fin=' + encodeURIComponent(fecha_fin)
            }
        )
        .then(response => response.json())
        .then(data => {
            if (data.status === 'OK' && data.content && data.content.length > 0) {
                var html = '<table class="table table-bordered table-condensed"><thead><tr>' +
                    '<th>Fecha</th><th>Tipo</th><th>Turnos Extras</th><th>Horas Extras</th><th>Observaciones</th></tr></thead><tbody>';
                data.content.forEach(function(row, idx) {
                    html += '<tr data-id="'+row.nom_id+'" data-idx="'+idx+'">' +
                        '<td>' + (row.nom_fecha ? row.nom_fecha : '') + '</td>' +
                        '<td>' + (row.nom_tipo ? row.nom_tipo : '') + '</td>' +
                        '<td>' + (row.nom_turnos_extras ? row.nom_turnos_extras : '') + '</td>' +
                        '<td>' + (row.nom_horas_extras ? row.nom_horas_extras : '') + '</td>' +
                        '<td>' + (row.nom_observaciones ? row.nom_observaciones : '') + '</td>' +
                        '<td><button type="button" class="btn btn-xs btn-warning btn-editar-incidencia">Editar</button></td>' +
                    '</tr>';
                });
// Edición inline de incidencias consultadas
document.addEventListener('click', function(e) {
    if (e.target.classList.contains('btn-editar-incidencia')) {
        var tr = e.target.closest('tr');
        if (!tr) return;
        // Obtener valores actuales
        var tds = tr.querySelectorAll('td');
        var fecha = tds[0].innerText.trim();
        var tipo = tds[1].innerText.trim();
        var turnos = tds[2].innerText.trim();
        var horas = tds[3].innerText.trim();
        var obs = tds[4].innerText.trim();
        // Reemplazar celdas por inputs
        tds[0].innerHTML = '<input type="date" class="form-control" value="'+fecha+'">';
        tds[1].innerHTML = '<select class="form-control">'+
            '<option value="">Selecciona</option>'+
            '<option value="A">Asistencia</option>'+
            '<option value="B">Baja</option>'+
            '<option value="D">Descanso</option>'+
            '<option value="E">Tiempo Extra</option>'+
            '<option value="FI">Falta Injustificada</option>'+
            '<option value="FJ">Falta Justificada</option>'+
            '<option value="FES">Festivo Trabajado</option>'+
            '<option value="INC">Incapacidad</option>'+
            '<option value="NI">Nuevo ingreso</option>'+
            '<option value="P">Permiso</option>'+
            '<option value="V">Vacaciones</option>'+
        '</select>';
        tds[1].querySelector('select').value = tipo;
        tds[2].innerHTML = '<input type="number" class="form-control" min="0" value="'+turnos+'">';
        tds[3].innerHTML = '<input type="number" class="form-control" min="0" value="'+horas+'">';
        tds[4].innerHTML = '<input type="text" class="form-control" value="'+obs+'">';
        tds[5].innerHTML = '<button type="button" class="btn btn-xs btn-success btn-guardar-incidencia">Guardar</button> <button type="button" class="btn btn-xs btn-default btn-cancelar-incidencia">Cancelar</button>';
    }
});
                html += '</tbody></table>';
                container.innerHTML = html;
            } else {
                container.innerHTML = '<div class="text-warning">No hay incidencias registradas para este periodo.</div>';
            }
        })
        .catch(function() {
            container.innerHTML = '<div class="text-danger">Error al consultar incidencias.</div>';
        });
    }
</script>
<script>
    function agregarFila() {
        var tabla = document.getElementById('tabla-incidencias').getElementsByTagName('tbody')[0];
        var filas = tabla.getElementsByTagName('tr').length;
        var nueva = tabla.rows[0].cloneNode(true);
        var inputs = nueva.querySelectorAll('input, select');
        // Asignar nombres correctos
        inputs[0].name = 'incidencias['+filas+'][fecha]';
        inputs[0].id = 'incidencia_fecha_' + filas;
        inputs[1].name = 'incidencias['+filas+'][tipo]';
        inputs[2].name = 'incidencias['+filas+'][turnos_extras]';
        inputs[3].name = 'incidencias['+filas+'][horas_extras]';
        inputs[4].name = 'incidencias['+filas+'][observaciones]';
        // Limpiar valores
        inputs.forEach(function(input){ input.value = ''; });
        // Ocultar campos extras por defecto
        nueva.querySelector('.campo-turnos-extras').style.display = 'none';
        nueva.querySelector('.campo-horas-extras').style.display = 'none';
        nueva.className = '';
        // Restringir fechas en el nuevo input
        setMinMaxFechaIncidencia(inputs[0]);
        tabla.appendChild(nueva);
    }
    // Restringe el input de fecha de incidencia al periodo seleccionado
    function setMinMaxFechaIncidencia(input) {
        var fechaInicio = document.getElementById('fecha_inicio').value;
        var fechaFin = document.getElementById('fecha_fin').value;
        if (fechaInicio) input.min = fechaInicio;
        if (fechaFin) input.max = fechaFin;
    }

    // Al cargar la página, restringe el primer input de fecha
    document.addEventListener('DOMContentLoaded', function() {
        var primerInputFecha = document.getElementById('incidencia_fecha_0');
        if (primerInputFecha) setMinMaxFechaIncidencia(primerInputFecha);
    });
    function eliminarFila(btn) {
        var tabla = document.getElementById('tabla-incidencias').getElementsByTagName('tbody')[0];
        if(tabla.rows.length > 1) {
            btn.closest('tr').remove();
        }
    }
    // Colorea la fila según el tipo de incidencia
    function actualizarColorFila(select) {
        var tr = select.closest('tr');
        tr.className = '';
        if(select.value) {
            tr.classList.add('incidencia-' + select.value);
        }
    }
    // Muestra/oculta campos extras según tipo
    function mostrarCamposExtras(select) {
        var tr = select.closest('tr');
        var campoTurnos = tr.querySelector('.campo-turnos-extras');
        var campoHoras = tr.querySelector('.campo-horas-extras');
        if(select.value === 'E') {
            campoTurnos.style.display = '';
            campoHoras.style.display = '';
        } else {
            campoTurnos.style.display = 'none';
            campoHoras.style.display = 'none';
            campoTurnos.value = '';
            campoHoras.value = '';
        }
    }
    document.addEventListener('DOMContentLoaded', function() {
        var tabla = document.getElementById('tabla-incidencias');
        tabla.addEventListener('change', function(e) {
            if(e.target.tagName === 'SELECT') {
                actualizarColorFila(e.target);
                mostrarCamposExtras(e.target);
            }
        });
        // Inicializa color y campos extras en la primera fila
        var selects = tabla.querySelectorAll('select');
        selects.forEach(function(sel){ actualizarColorFila(sel); mostrarCamposExtras(sel); });
    });
</script>
