﻿<!-- OP 1 -->
<?php 
	$cei=get_cei_id();
	$root1=get_my_user_root1();
	$user = $this->session->user;
	$CIs =&get_instance();
	
?>
<!-- OP 2 -->

<style>
hr.negro_s { border-top: 1px solid black; }
.incidencia-A { background: #d4edda; }
.incidencia-B { background: #f7b8b8ff; }
.incidencia-D { background: #faf8f8ff; }
.incidencia-E { background: #fff3cd; }
.incidencia-FI { background: #f8d7da; }
.incidencia-FJ { background: #d1ecf1; }
.incidencia-FES { background: #cce5ff; }
.incidencia-INC { background: #e2e3e5; }
.incidencia-NI { background: #e2eafc; }
.incidencia-P { background: #fefefe; }
.incidencia-V { background: #e6ffe6; }
</style>
<div class="col-xs-12">
<div class="panel panel-default">
    <div class="panel-heading">
        <h3>Registro de Incidencias</h3>
    </div>
    <div class="panel-body">
        <form action="<?php echo base_url('persona/nueva_incidencia_nomina/'.$persona['clte_id']); ?>" class="form-horizontal send-form-nomina" method="POST">
            <div class="row form-group">
                <div class="col-xs-12 col-sm-4">
                    <label>Empleado:</label>
                    <select name="empleado_id" class="form-control">
                        <option value="<?php echo $persona['clte_id']; ?>"><?php echo $persona['clte_nombre'].' '.$persona['clte_paterno'].' '.$persona['clte_materno']; ?></option>
                    </select>
                </div>
                <div class="col-xs-12 col-sm-4">
                    <label>Periodo:</label>
                    <input type="date" name="fecha_inicio" id="fecha_inicio" class="form-control" placeholder="Inicio"/>
                    <input type="date" name="fecha_fin" id="fecha_fin" class="form-control" placeholder="Fin"/>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12">
                    <table class="table table-bordered" id="tabla-incidencias">
                        <thead>
                            <tr>
                                <th>Día</th>
                                <th>Tipo de Incidencia</th>
                                <th>Turnos Extras</th>
                                <th>Horas Extras</th>
                                <th>Observaciones</th>
                                <th>Acción</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><input type="date" name="incidencias[0][fecha]" class="form-control" /></td>
                                <td>
                                    <select name="incidencias[0][tipo]" class="form-control" onchange="actualizarColorFila(this); mostrarCamposExtras(this)">
                                        <option value="">Selecciona</option>
                                        <option value="A">Asistencia</option>
                                        <option value="B">Baja</option>
                                        <option value="D">Descanso</option>
                                        <option value="E">Tiempo Extra</option>
                                        <option value="FI">Falta Injustificada</option>
                                        <option value="FJ">Falta Justificada</option>
                                        <option value="FES">Festivo Trabajado</option>
                                        <option value="INC">Incapacidad</option>
                                        <option value="NI">Nuevo ingreso</option>
                                        <option value="P">Permiso</option>
                                        <option value="V">Vacaciones</option>
                                    </select>
                                </td>
                                <td>
                                    <input type="number" name="incidencias[0][turnos_extras]" class="form-control campo-turnos-extras" min="0" style="display:none;" placeholder="Turnos extras" />
                                </td>
                                <td>
                                    <input type="number" name="incidencias[0][horas_extras]" class="form-control campo-horas-extras" min="0" style="display:none;" placeholder="Horas extras" />
                                </td>
                                <td><input type="text" name="incidencias[0][observaciones]" class="form-control" /></td>
                                <td><button type="button" class="btn btn-danger btn-sm" onclick="eliminarFila(this)"><span class="glyphicon glyphicon-trash"></span></button></td>
                            </tr>
                        </tbody>
                    </table>
                    <button type="button" class="btn btn-success" onclick="agregarFila()"><span class="glyphicon glyphicon-plus"></span> Agregar Día</button>
                </div>
            </div>
            <div class="row form-group">
                <div class="col-xs-12">
                    <button type="submit" class="btn btn-primary">Guardar Incidencias</button>
                </div>
            </div>
        </form>
    </div>
</div>
<script>
function agregarFila() {
    var tabla = document.getElementById('tabla-incidencias').getElementsByTagName('tbody')[0];
    var filas = tabla.getElementsByTagName('tr').length;
    var nueva = tabla.rows[0].cloneNode(true);
    var inputs = nueva.querySelectorAll('input, select');
    // Asignar nombres correctos
    inputs[0].name = 'incidencias['+filas+'][fecha]';
    inputs[1].name = 'incidencias['+filas+'][tipo]';
    inputs[2].name = 'incidencias['+filas+'][turnos_extras]';
    inputs[3].name = 'incidencias['+filas+'][horas_extras]';
    inputs[4].name = 'incidencias['+filas+'][observaciones]';
    // Limpiar valores
    inputs.forEach(function(input){ input.value = ''; });
    // Ocultar campos extras por defecto
    nueva.querySelector('.campo-turnos-extras').style.display = 'none';
    nueva.querySelector('.campo-horas-extras').style.display = 'none';
    nueva.className = '';
    tabla.appendChild(nueva);
}
function eliminarFila(btn) {
    var tabla = document.getElementById('tabla-incidencias').getElementsByTagName('tbody')[0];
    if(tabla.rows.length > 1) {
        btn.closest('tr').remove();
    }
}
// Colorea la fila según el tipo de incidencia
function actualizarColorFila(select) {
    var tr = select.closest('tr');
    tr.className = '';
    if(select.value) {
        tr.classList.add('incidencia-' + select.value);
    }
}
// Muestra/oculta campos extras según tipo
function mostrarCamposExtras(select) {
    var tr = select.closest('tr');
    var campoTurnos = tr.querySelector('.campo-turnos-extras');
    var campoHoras = tr.querySelector('.campo-horas-extras');
    if(select.value === 'E') {
        campoTurnos.style.display = '';
        campoHoras.style.display = '';
    } else {
        campoTurnos.style.display = 'none';
        campoHoras.style.display = 'none';
        campoTurnos.value = '';
        campoHoras.value = '';
    }
}
document.addEventListener('DOMContentLoaded', function() {
    var tabla = document.getElementById('tabla-incidencias');
    tabla.addEventListener('change', function(e) {
        if(e.target.tagName === 'SELECT') {
            actualizarColorFila(e.target);
            mostrarCamposExtras(e.target);
        }
    });
    // Inicializa color y campos extras en la primera fila
    var selects = tabla.querySelectorAll('select');
    selects.forEach(function(sel){ actualizarColorFila(sel); mostrarCamposExtras(sel); });
});
</script>
