﻿<!-- OP 1 -->
<?php 
	$cei=get_cei_id();
	$root1=get_my_user_root1();
	$user = $this->session->user;
	$CIs =&get_instance();
	
?>
<!-- OP 2 -->

<style>
hr.negro_s { border-top: 1px solid black; }
.incidencia-A { background: #d4edda; }
.incidencia-B { background: #f7b8b8ff; }
.incidencia-D { background: #faf8f8ff; }
.incidencia-E { background: #fff3cd; }
.incidencia-FI { background: #f8d7da; }
.incidencia-FJ { background: #d1ecf1; }
.incidencia-FES { background: #cce5ff; }
.incidencia-INC { background: #e2e3e5; }
.incidencia-NI { background: #e2eafc; }
.incidencia-P { background: #fefefe; }
.incidencia-V { background: #e6ffe6; }
</style>
<div class="col-xs-12">
<div class="panel panel-default">
    <div class="panel-heading">
        <h3>Nómina</h3>
    </div>
    <div class="panel-body">
        <div class="row" style="margin-bottom:16px; display:flex; align-items:flex-end; flex-wrap:wrap; gap:10px;">
            <div class="col-xs-12 col-sm-5" style="min-width:340px;">
                <label>Periodo:</label>
                <div class="input-group" style="display:flex; align-items:center; gap:8px;">
                    <span class="input-group-addon" style="font-weight:bold; white-space:nowrap; width:auto; min-width:unset; padding:6px 16px 6px 8px; background:#f5f5f5; border:1px solid #ccc; border-radius:4px;">Quincena <?php echo isset($quincena_actual['quin_num']) ? htmlspecialchars($quincena_actual['quin_num'], ENT_QUOTES, 'UTF-8') : ''; ?></span>
                    <input type="date" name="fecha_inicio" id="fecha_inicio" class="form-control" value="<?php echo isset($quincena_actual['quin_f_ini']) ? htmlspecialchars($quincena_actual['quin_f_ini'], ENT_QUOTES, 'UTF-8') : ''; ?>" readonly style="max-width:150px;"/>
                    <span style="font-weight:bold;">a</span>
                    <input type="date" name="fecha_fin" id="fecha_fin" class="form-control" value="<?php echo isset($quincena_actual['quin_f_fin']) ? htmlspecialchars($quincena_actual['quin_f_fin'], ENT_QUOTES, 'UTF-8') : ''; ?>" style="max-width:150px;"/>
                </div>
            </div>
            <div class="col-xs-12 col-sm-7" style="min-width:320px; display:flex; gap:8px; align-items:flex-end;">
                <button type="button" class="btn btn-primary" onclick="consultarEmpleadosActivos()">Ver empleados activos</button>
                <button type="button" class="btn btn-secondary" onclick="consultarNominaTodos()">Ver todos los registros de nómina</button>
                <button type="button" class="btn btn-success" onclick="calcularResumenNominaPorEmpleado()">Calcular nómina por empleado</button>
                <button type="button" class="btn btn-danger" onclick="calcularNominaFinalPorEmpleado()">Cálculo final nómina (con incidencias)</button>
            </div>
        </div>
        <div id="tabla-empleados-activos-container" style="margin-top:20px;"></div>
        <div id="tabla-nomina-todos-container" style="margin-top:20px;"></div>
    <div id="tabla-nomina-por-empleado-container" style="margin-top:20px;"></div>
    <div id="tabla-nomina-final-por-empleado-container" style="margin-top:20px;"></div>
    </div>
</div>
<script>
        // Consulta empleados activos (status = 'ACTIVO')
        function consultarEmpleadosActivos() {
            var container = document.getElementById('tabla-empleados-activos-container');
            container.innerHTML = '<div class="text-info">Consultando empleados activos...</div>';
            fetch(base_url + 'persona/ajax_empleados_activos', {
                method: 'GET'
            })
            .then(response => response.json())
            .then(data => {
                var empleados = (data && data.content && data.content.content) ? data.content.content : [];
                if (data.status === 'OK' && empleados.length > 0) {
                    var html = '<table class="table table-bordered table-condensed"><thead><tr>' +
                        '<th>ID</th><th>Nombre</th><th>Puesto</th><th>Status</th></tr></thead><tbody>';
                    empleados.forEach(function(row) {
                        html += '<tr>' +
                            '<td>' + (row.clte_id ? row.clte_id : '') + '</td>' +
                            '<td>' + (row.clte_nombre ? row.clte_nombre : '') + ' ' + (row.clte_paterno ? row.clte_paterno : '') + ' ' + (row.clte_materno ? row.clte_materno : '') + '</td>' +
                            '<td>' + (row.clte_puesto ? row.clte_puesto : '') + '</td>' +
                            '<td>' + (row.status ? row.status : '') + '</td>' +
                        '</tr>';
                    });
                    html += '</tbody></table>';
                    container.innerHTML = html;
                } else {
                    container.innerHTML = '<div class="text-warning">No hay empleados activos.</div>';
                }
            })
            .catch(function() {
                container.innerHTML = '<div class="text-danger">Error al consultar empleados activos.</div>';
            });
        }

        // Consulta todos los registros de sis30_nomina
        function consultarNominaTodos() {
            var container = document.getElementById('tabla-nomina-todos-container');
            container.innerHTML = '<div class="text-info">Consultando registros de nómina...</div>';
            fetch(base_url + 'persona/ajax_nomina_todos', {
                method: 'GET'
            })
            .then(response => response.json())
            .then(data => {
                var nomina = (data && data.content && data.content.content) ? data.content.content : [];
                if (data.status === 'OK' && nomina.length > 0) {
                    var html = '<table class="table table-bordered table-condensed"><thead><tr>' +
                        '<th>ID</th><th>Empleado ID</th><th>Fecha inicio</th><th>Fecha fin</th><th>Tipo</th><th>Turnos Extras</th><th>Horas Extras</th><th>Observaciones</th></tr></thead><tbody>';
                    nomina.forEach(function(row) {
                        html += '<tr>' +
                            '<td>' + (row.nom_id ? row.nom_id : '') + '</td>' +
                            '<td>' + (row.nom_empleado_id ? row.nom_empleado_id : '') + '</td>' +
                            '<td>' + (row.nom_fecha_inicio ? row.nom_fecha_inicio : '') + '</td>' +
                            '<td>' + (row.nom_fecha_fin ? row.nom_fecha_fin : '') + '</td>' +
                            '<td>' + (row.nom_tipo ? row.nom_tipo : '') + '</td>' +
                            '<td>' + (row.nom_turnos_extras ? row.nom_turnos_extras : '') + '</td>' +
                            '<td>' + (row.nom_horas_extras ? row.nom_horas_extras : '') + '</td>' +
                            '<td>' + (row.nom_observaciones ? row.nom_observaciones : '') + '</td>' +
                        '</tr>';
                    });
                    html += '</tbody></table>';
                    container.innerHTML = html;
                } else {
                    container.innerHTML = '<div class="text-warning">No hay registros de nómina.</div>';
                }
            })
            .catch(function() {
                container.innerHTML = '<div class="text-danger">Error al consultar nómina.</div>';
            });
        }
        function consultarIncidenciasPeriodo() {
            var fecha_inicio = document.getElementById('fecha_inicio').value;
            var fecha_fin = document.getElementById('fecha_fin').value;
            var container = document.getElementById('tabla-incidencias-periodo-container');
            container.innerHTML = '<div class="text-info">Consultando incidencias...</div>';
            fetch(
                base_url + 'persona/ajax_incidencias_nomina_todos',
                {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                    body: 'fecha_inicio=' + encodeURIComponent(fecha_inicio) + '&fecha_fin=' + encodeURIComponent(fecha_fin)
                }
            )
            .then(response => response.json())
            .then(data => {
                console.log('Respuesta incidencias:', data);
                if (data.status === 'OK' && data.content && data.content.length > 0) {
                    var html = '<table class="table table-bordered table-condensed"><thead><tr>' +
                        '<th>ID</th><th>Empleado</th><th>Puesto</th><th>Fecha inicio</th><th>Fecha fin</th><th>Tipo</th><th>Turnos Extras</th><th>Horas Extras</th><th>Observaciones</th></tr></thead><tbody>';
                    data.content.forEach(function(row, idx) {
                        html += '<tr data-id="'+row.nom_id+'" data-idx="'+idx+'">' +
                            '<td>' + (row.clte_id ? row.clte_id : '') + '</td>' +
                            '<td>' + (row.nombre ? row.nombre : '') + '</td>' +
                            '<td>' + (row.puesto ? row.puesto : '') + '</td>' +
                            '<td>' + (row.nom_fecha_inicio ? row.nom_fecha_inicio : '') + '</td>' +
                            '<td>' + (row.nom_fecha_fin ? row.nom_fecha_fin : '') + '</td>' +
                            '<td>' + (row.nom_tipo ? row.nom_tipo : '') + '</td>' +
                            '<td>' + (row.nom_turnos_extras ? row.nom_turnos_extras : '') + '</td>' +
                            '<td>' + (row.nom_horas_extras ? row.nom_horas_extras : '') + '</td>' +
                            '<td>' + (row.nom_observaciones ? row.nom_observaciones : '') + '</td>' +
                        '</tr>';
                    });
                    html += '</tbody></table>';
                    container.innerHTML = html;
                } else {
                    container.innerHTML = '<div class="text-warning">No hay incidencias registradas para este periodo.</div>';
                }
            })
            .catch(function() {
                container.innerHTML = '<div class="text-danger">Error al consultar incidencias.</div>';
            });
        }
</script>
<script>
// --- Utilidades de cálculo (adaptadas de edit_empleado_nomina.php) ---
function calcularAntiguedad(fechaIngreso) {
    let partes;
    if (/^\d{2}\/\d{2}\/\d{4}$/.test(fechaIngreso)) {
        partes = fechaIngreso.split('/');
        fechaIngreso = `${partes[2]}-${partes[1]}-${partes[0]}`;
    } else if (/^\d{4}-\d{2}-\d{2}$/.test(fechaIngreso)) {
        // ok
    } else if (/^\d{2}-\d{2}-\d{4}$/.test(fechaIngreso)) {
        partes = fechaIngreso.split('-');
        fechaIngreso = `${partes[2]}-${partes[1]}-${partes[0]}`;
    } else if (/^\d{2}\/([A-Za-z]{3})\/\d{4}$/.test(fechaIngreso)) {
        partes = fechaIngreso.split('/');
        var meses = {
            'Ene': '01', 'Feb': '02', 'Mar': '03', 'Abr': '04', 'May': '05', 'Jun': '06',
            'Jul': '07', 'Ago': '08', 'Sep': '09', 'Oct': '10', 'Nov': '11', 'Dic': '12'
        };
        var mes = meses[partes[1]] || '01';
        fechaIngreso = `${partes[2]}-${mes}-${partes[0]}`;
    }
    let fecha = new Date(fechaIngreso);
    if (isNaN(fecha.getTime())) return 0;
    let hoy = new Date();
    let antiguedad = hoy.getFullYear() - fecha.getFullYear();
    if (hoy.getMonth() < fecha.getMonth() || (hoy.getMonth() === fecha.getMonth() && hoy.getDate() < fecha.getDate())) {
        antiguedad--;
    }
    return antiguedad;
}

function diasVacacionesPorAntiguedad(antiguedad) {
    if (antiguedad <= 0) return 0;
    if (antiguedad === 1) return 12;
    if (antiguedad === 2) return 14;
    if (antiguedad === 3) return 16;
    if (antiguedad === 4) return 18;
    if (antiguedad === 5) return 20;
    if (antiguedad >= 6 && antiguedad <= 10) return 22;
    if (antiguedad >= 11 && antiguedad <= 15) return 24;
    if (antiguedad >= 16 && antiguedad <= 20) return 26;
    if (antiguedad >= 21 && antiguedad <= 25) return 28;
    if (antiguedad >= 26 && antiguedad <= 30) return 30;
    if (antiguedad > 30) return 30;
    return 0;
}

// --- Lógica principal para cruzar y calcular nómina por empleado ---
function calcularResumenNominaPorEmpleado() {
    var container = document.getElementById('tabla-nomina-por-empleado-container');
    container.innerHTML = '<div class="text-info">Calculando nómina por empleado...</div>';
    Promise.all([
        fetch(base_url + 'persona/ajax_empleados_activos').then(r => r.json()),
        fetch(base_url + 'persona/ajax_nomina_todos').then(r => r.json())
    ]).then(function([empleadosData, nominaData]) {
        var empleados = (empleadosData && empleadosData.content && empleadosData.content.content) ? empleadosData.content.content : [];
        var nomina = (nominaData && nominaData.content && nominaData.content.content) ? nominaData.content.content : [];
        if (!empleados.length) {
            container.innerHTML = '<div class="text-warning">No hay empleados activos.</div>';
            return;
        }
        // Indexar nómina por empleado
        var nominaPorEmpleado = {};
        nomina.forEach(function(n) {
            if (!nominaPorEmpleado[n.nom_empleado_id]) nominaPorEmpleado[n.nom_empleado_id] = [];
            nominaPorEmpleado[n.nom_empleado_id].push(n);
        });
        // Construir tabla de resultados con todas las columnas de cálculo
        var html = '<table class="table table-bordered table-condensed"><thead><tr>' +
            '<th>ID</th><th>Nombre</th><th>Puesto</th>' +
            '<th>Sueldo Fiscal</th><th>Sueldo Proveedor</th><th>Sueldo Neto</th>' +
            '<th>Salario Diario</th><th>Salario Neto Fiscal</th><th>Salario Diario Proveedor</th>' +
            '<th>Días Vacaciones</th><th>Pago Vacaciones</th><th>Prima Vacacional</th>' +
            '<th>Aguinaldo (15 días)</th><th>Integral</th><th>SDI Año</th><th>SDI</th>' +
            '<th>Pago x Hora</th><th>Antigüedad</th>' +
            // '<th>Salario Neto Fiscal Manual</th><th>Salario Diario Proveedor Manual</th>' + // Manuales, comentados
            '</tr></thead><tbody>';
        empleados.forEach(function(emp) {
            // Buscar registro de nómina más reciente (por fecha inicio descendente)
            var registros = nominaPorEmpleado[emp.clte_id] || [];
            registros.sort(function(a, b) {
                return (b.nom_fecha_inicio || '').localeCompare(a.nom_fecha_inicio || '');
            });
            var nom = registros.length ? registros[0] : {};
            // Obtener sueldos: preferir nómina, si no, del empleado
            var fiscal = parseFloat(nom.nom_sueldo_fiscal || emp.clte_sueldo_f || 0) || 0;
            var proveedor = parseFloat(nom.nom_sueldo_proveedor || emp.clte_sueldo_p || 0) || 0;
            var neto = fiscal + proveedor;
            // var salario_neto_fiscal_input = parseFloat(nom.nom_salario_neto_fiscal_input || emp.clte_salario_neto_fiscal_input || 0) || 0; // Manual, comentado
            var jornadas_laborales = parseFloat(nom.nom_jornadas_laborales || emp.jornadas_laborales || 8) || 8;
            var salario_diario = neto / 30;
            var salario_neto_fiscal = fiscal / 30.4166;
            var salario_diario_proveedor = salario_diario - salario_neto_fiscal;
            // var salario_diario_proveedor_input = salario_diario - salario_neto_fiscal_input; // Manual, comentado
            var fechaIngreso = emp.f_ingreso || '';
            var antiguedad = calcularAntiguedad(fechaIngreso);
            var dias_vacaciones = diasVacacionesPorAntiguedad(antiguedad);
            var pago_vacaciones = salario_diario * dias_vacaciones;
            var doce_dias = salario_diario * 12;
            var prima_vacacional = (salario_diario * dias_vacaciones) * 0.25;
            var aguinaldo_dias = salario_diario * 15;
            var integral = doce_dias + prima_vacacional + aguinaldo_dias;
            var sdi_año = integral / 365;
            var sdi = salario_diario + sdi_año;
            var pago_x_hora = salario_diario / jornadas_laborales;
            html += '<tr>' +
                '<td>' + (emp.clte_id || '') + '</td>' +
                '<td>' + (emp.clte_nombre || '') + ' ' + (emp.clte_paterno || '') + ' ' + (emp.clte_materno || '') + '</td>' +
                '<td>' + (emp.clte_puesto || '') + '</td>' +
                '<td>' + fiscal.toFixed(2) + '</td>' +
                '<td>' + proveedor.toFixed(2) + '</td>' +
                '<td>' + neto.toFixed(2) + '</td>' +
                '<td>' + salario_diario.toFixed(2) + '</td>' +
                '<td>' + salario_neto_fiscal.toFixed(2) + '</td>' +
                '<td>' + salario_diario_proveedor.toFixed(2) + '</td>' +
                // '<td>' + salario_neto_fiscal_input.toFixed(2) + '</td>' + // Manual, comentado
                // '<td>' + salario_diario_proveedor_input.toFixed(2) + '</td>' + // Manual, comentado
                '<td>' + dias_vacaciones + '</td>' +
                '<td>' + pago_vacaciones.toFixed(2) + '</td>' +
                '<td>' + prima_vacacional.toFixed(2) + '</td>' +
                '<td>' + aguinaldo_dias.toFixed(2) + '</td>' +
                '<td>' + integral.toFixed(2) + '</td>' +
                '<td>' + sdi_año.toFixed(2) + '</td>' +
                '<td>' + sdi.toFixed(2) + '</td>' +
                '<td>' + pago_x_hora.toFixed(2) + '</td>' +
                '<td>' + antiguedad + '</td>' +
            '</tr>';
        });
        html += '</tbody></table>';
        container.innerHTML = html;
    }).catch(function() {
        container.innerHTML = '<div class="text-danger">Error al calcular nómina por empleado.</div>';
    });
}

// --- Cálculo real de nómina por empleado considerando incidencias, turnos y horas extra ---
function calcularNominaFinalPorEmpleado() {
    var container = document.getElementById('tabla-nomina-final-por-empleado-container');
    container.innerHTML = '<div class="text-info">Calculando nómina final por empleado...</div>';
    // Tomar fechas del periodo seleccionado
    var fecha_inicio = document.getElementById('fecha_inicio').value;
    var fecha_fin = document.getElementById('fecha_fin').value;
    Promise.all([
        fetch(base_url + 'persona/ajax_empleados_activos').then(r => r.json()),
        fetch(base_url + 'persona/ajax_nomina_todos').then(r => r.json())
    ]).then(function([empleadosData, nominaData]) {
        var empleados = (empleadosData && empleadosData.content && empleadosData.content.content) ? empleadosData.content.content : [];
        var nomina = (nominaData && nominaData.content && nominaData.content.content) ? nominaData.content.content : [];
        if (!empleados.length) {
            container.innerHTML = '<div class="text-warning">No hay empleados activos.</div>';
            return;
        }
        // Filtrar registros de nómina por periodo seleccionado
        var nominaPeriodo = nomina.filter(function(n) {
            return (!fecha_inicio || n.nom_fecha_inicio >= fecha_inicio) && (!fecha_fin || n.nom_fecha_fin <= fecha_fin);
        });
        // Indexar nómina por empleado
        var nominaPorEmpleado = {};
        nominaPeriodo.forEach(function(n) {
            if (!nominaPorEmpleado[n.nom_empleado_id]) nominaPorEmpleado[n.nom_empleado_id] = [];
            nominaPorEmpleado[n.nom_empleado_id].push(n);
        });
        // Construir tabla de resultados
        var html = '<table class="table table-bordered table-condensed"><thead><tr>' +
            '<th>ID</th><th>Nombre</th><th>Puesto</th>' +
            '<th>Faltas</th><th>Turnos Extra</th><th>Horas Extra</th><th>Pago Fiscal NOI</th>' +
            '<th>Pago Base</th><th>Salario Diario</th><th>S.D.P</th><th>S.D.F</th><th>Pago Proveedor</th><th>Pago Turnos Extra</th><th>Pago Horas Extra</th>' +
            '<th>Pago Total Quincenal</th>' +
            '</tr></thead><tbody>';
        empleados.forEach(function(emp) {
            var registros = nominaPorEmpleado[emp.clte_id] || [];
            // Sumarizar incidencias
            var faltas = 0, turnos_extra = 0, horas_extra = 0;
            registros.forEach(function(n) {
                // Suponiendo que tipo 'FI' es falta
                if (n.nom_tipo === 'FI') faltas++;
                turnos_extra += parseInt(n.nom_turnos_extras || 0);
                horas_extra += parseInt(n.nom_horas_extras || 0);
            });
            // Obtener sueldo base
            var fiscal = parseFloat(emp.clte_sueldo_f || 0) || 0;
            var proveedor = parseFloat(emp.clte_sueldo_p || 0) || 0;
            var neto = fiscal + proveedor;
            var salario_diario = neto / 30;
            var fiscal_quincenal = fiscal / 2;
            var salario_neto_fiscal_quincenal = fiscal_quincenal / 15.2083;
            var salario_neto_fiscal = fiscal / 30.4166;
            var salario_diario_proveedor = salario_diario - salario_neto_fiscal;
            var sueldo_proveedor = salario_diario_proveedor * (15.2083 - faltas);

            // Cálculo de pagos (ajusta según tus reglas)
            var pago_base = salario_diario * (30 - faltas); // Sueldo menos faltas
            var pago_turnos_extra = turnos_extra * salario_diario; // Ejemplo: cada turno extra = 1 día
            var pago_horas_extra = horas_extra * (salario_diario / 8); // Ejemplo: 8 horas = 1 día
            var pago_total = pago_base + pago_turnos_extra + pago_horas_extra;
            var pago_total_final = 4240.07 + (((neto / 30.4166) - salario_neto_fiscal_quincenal) * (15.2083 - faltas)); // Ajuste final fijo + variable
            // var pago_total_final = salario_neto_fiscal_quincenal * (15.2083 - faltas); // Ajuste final variable
            html += '<tr>' +
            //ID
                '<td>' + (emp.clte_id || '') + '</td>' +
            //Nombre
                '<td>' + (emp.clte_nombre || '') + ' ' + (emp.clte_paterno || '') + ' ' + (emp.clte_materno || '') + '</td>' +
            //Puesto
                '<td>' + (emp.clte_puesto || '') + '</td>' +
            //faltas, turnos extra, horas extra
                '<td>' + faltas + '</td>' +
                '<td>' + turnos_extra + '</td>' +
                '<td>' + horas_extra + '</td>' +
                // '<td>' + pago_base.toFixed(2) + '</td>' + en lugar del de abajo
            //Pago Fiscal NOI
                '<td>' + fiscal_quincenal + '</td>' +
            //Pago Base
                '<td>' + (proveedor / 2).toFixed(2) + '</td>' +
            //Salario Diario
                '<td>' + (neto / 30.4166).toFixed(2) + '</td>' +
            //S.D.P
                '<td>' + ((neto / 30.4166) - salario_neto_fiscal_quincenal).toFixed(2) + '</td>' +
            //S.D.F
                '<td>' + salario_neto_fiscal_quincenal.toFixed(2) + '</td>' +
            //Pago Proveedor
                '<td>' + (((neto / 30.4166) - salario_neto_fiscal_quincenal) * (15.2083 - faltas)).toFixed(2) + '</td>' +
            //Pago Turnos Extra
                '<td>' + pago_turnos_extra.toFixed(2) + '</td>' +
            //Pago Horas Extra
                '<td>' + pago_horas_extra.toFixed(2) + '</td>' +
            //Pago Total Quincenal
                '<td>' + pago_total_final.toFixed(2) + '</td>' +
            '</tr>';
        });
        html += '</tbody></table>';
        container.innerHTML = html;
    }).catch(function() {
        container.innerHTML = '<div class="text-danger">Error al calcular nómina final por empleado.</div>';
    });
}
</script>