<div class="col-xs-12">
    <div class="panel panel-default">
        <div class="panel-heading">
            <label class="header-panel-label">Empleados</label>
			<a href="<?php echo base_url('empleado/reporte_empleado'); ?>" class="btn btn-success btn-xs pull-right"><i class="fa fa-plus"></i> Reporte</a>
            <a href="<?php echo base_url('empleado/nuevo'); ?>" class="btn btn-success btn-xs pull-right"><i class="fa fa-plus"></i> Nuevo</a>
        </div>
        <div class="panel-body">
            <table class="table table-hover table-striped">
                <thead>
                    <tr>
                        <th>Nombre</th>
                        <th>Rol</th>
                        <th>Especialidad</th>
                        <th>Empresa</th>
						<th>CEI</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php

                        if($empleados): $array_rol = get_cat_nombre_var('ROL'); 
                            foreach ($empleados as $empleado): ?>
                                <tr>
                                    <td>
                                        <?php echo $empleado['usr_nombre']; ?> 
                                        <?php echo $empleado['usr_paterno']; ?> 
                                        <?php echo $empleado['usr_materno']; ?>
                                    </td>
                                    <td><?php echo get_cat_nombre_cache($array_rol, $empleado['perfil_id']); ?></td>
                                    <td><?php echo get_especialidad($empleado['esp_id']); ?></td>
                                    <td><?php echo get_empresa($empleado['emp_id']); ?></td>
									<td><?php echo get_cei($empleado['cei_id']); ?></td>
                                    <td>
                                        <a href="<?php echo base_url('empleado/edita/'.$empleado['usr_id']); ?>"><i class="fa fa-pencil fa-fw"></i></a>
                                    </td>
                                </tr>
                            <?php 
                            endforeach;
                        endif;
                    ?>
                </tbody>
				 <tfoot>
                    <tr><td align="center" colspan="5"><?php echo $this->pagination->create_links(); ?></td></tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
<script src="<?php echo base_url('../dist/js/empleado.js'); ?>"></script>