$(function() {
    Base64 = {
        _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",
        encode: function(e) {
            var t = "";
            var n, r, i, s, o, u, a;
            var f = 0;
            e = Base64._utf8_encode(e);
            while (f < e.length) {
                n = e.charCodeAt(f++);
                r = e.charCodeAt(f++);
                i = e.charCodeAt(f++);
                s = n >> 2;
                o = (n & 3) << 4 | r >> 4;
                u = (r & 15) << 2 | i >> 6;
                a = i & 63;
                if (isNaN(r)) { u = a = 64 } else if (isNaN(i)) { a = 64 }
                t = t + this._keyStr.charAt(s) + this._keyStr.charAt(o) + this._keyStr.charAt(u) + this._keyStr.charAt(a)
            }
            return t
        },
        decode: function(e) {
            var t = "";
            var n, r, i;
            var s, o, u, a;
            var f = 0;
            e = e.replace(/[^A-Za-z0-9\+\/\=]/g, "");
            while (f < e.length) {
                s = this._keyStr.indexOf(e.charAt(f++));
                o = this._keyStr.indexOf(e.charAt(f++));
                u = this._keyStr.indexOf(e.charAt(f++));
                a = this._keyStr.indexOf(e.charAt(f++));
                n = s << 2 | o >> 4;
                r = (o & 15) << 4 | u >> 2;
                i = (u & 3) << 6 | a;
                t = t + String.fromCharCode(n);
                if (u != 64) { t = t + String.fromCharCode(r) }
                if (a != 64) { t = t + String.fromCharCode(i) }
            }
            t = Base64._utf8_decode(t);
            return t
        },
        _utf8_encode: function(e) {
            e = e.replace(/\r\n/g, "\n");
            var t = "";
            for (var n = 0; n < e.length; n++) {
                var r = e.charCodeAt(n);
                if (r < 128) { t += String.fromCharCode(r) } else if (r > 127 && r < 2048) {
                    t += String.fromCharCode(r >> 6 | 192);
                    t += String.fromCharCode(r & 63 | 128)
                } else {
                    t += String.fromCharCode(r >> 12 | 224);
                    t += String.fromCharCode(r >> 6 & 63 | 128);
                    t += String.fromCharCode(r & 63 | 128)
                }
            }
            return t
        },
        _utf8_decode: function(e) {
            var t = "";
            var n = 0;
            var r = c1 = c2 = 0;
            while (n < e.length) {
                r = e.charCodeAt(n);
                if (r < 128) {
                    t += String.fromCharCode(r);
                    n++
                } else if (r > 191 && r < 224) {
                    c2 = e.charCodeAt(n + 1);
                    t += String.fromCharCode((r & 31) << 6 | c2 & 63);
                    n += 2
                } else {
                    c2 = e.charCodeAt(n + 1);
                    c3 = e.charCodeAt(n + 2);
                    t += String.fromCharCode((r & 15) << 12 | (c2 & 63) << 6 | c3 & 63);
                    n += 3
                }
            }
            return t
        }
    };
    fecha();
    //send_form_registro();

    send_form_file(
        function(data) {
            if (data.status == 'OK') {
                show_exito_afterClose(data.content.msg,
                    function() {
                        window.location = base_url + 'persona/id/' + data.content.id;
                    })
            } else {
                show_error(data.content);
            }
        });

    send_form_doc();
    valida_cp('.cp');
    send_form_fsm();
    autocompleta_enfermedad();
    send_form_hc();
    autocompleta_enfermedad2();
    borra(function() { location.reload(); });
    pierde_foco_talla();
    send_form_busca();
    autocompleta_cirugia();
    autocompleta_discapacidad();
    cambia_empresa();
	cambia_rol();
});

function send_form_registro() {
    //envia datos de usuario
    $('.send-form').off('submit');
    $('.send-form').on('submit', function(e) {
        e.preventDefault();
        var form = $(this);
        //form.find("button").prop("disabled", true);
        var dataAjax = new getDataAjax($(this));
        dataAjax.ok = function(data) {
            show_exito_afterClose(data.content, function() {
                window.location = base_url + 'persona'
                    //$('.persona_link').trigger('click');
            });
        };
        dataAjax.getData();
    });
}

function send_form_hc() {
    //envia datos de usuario
    $('.send-form').off('submit');
    $('.send-form').on('submit', function(e) {
        e.preventDefault();
        var form = $(this);
        //form.find("button").prop("disabled", true);
        var dataAjax = new getDataAjax($(this));
        dataAjax.ok = function(data) {
            show_exito_afterClose(data.content, function() {
                location.reload();
            });
        };
        dataAjax.getData();
    });
}

function send_form_fsm() {
    //envia datos de usuario
    $('.send-fsm').off('submit');
    $('.send-fsm').on('submit', function(e) {
        e.preventDefault();
        var form = $(this);
        //form.find("button").prop("disabled", true);
        var dataAjax = new getDataAjax($(this));
        dataAjax.ok = function(data) {
            show_exito_afterClose(data.content, function() {
                window.location = $('.persona_link').attr('href');
            });
        };
        dataAjax.getData();
    });
}

function send_form_doc() {
    $('.send-form-doc').off('submit');
    $('.send-form-doc').on('submit', function(e) {
        e.preventDefault();
        var url = $(this).attr('action');
        var formData = new FormData(this);
        var element = $(this).find('button:first');
        var spin = $('<div id="spin" />');
        element.append(spin);
        //muestra el spin
        show_spin(spin);

        $.ajax({
                type: "POST",
                url: url,
                enctype: 'multipart/form-data',
                data: formData,
                dataType: "json",
                cache: false,
                contentType: false,
                processData: false
            })
            .done(function(data) {
                if (data.status == 'OK') {
                    show_exito_afterClose(data.content, function() {
                        $('.persona_link').trigger('click');
                    });
                } else {
                    show_error(data.content);
                }
            })
            .always(function() {
                hide_spin(spin);
            })
            .fail(function() {
                show_error('Ha ocurrido un error. Intentelo de nuevo m&aacute;s tarde.');
            });
    });
}

function autocompleta_enfermedad() {
    base_url = $('#base_url').val();
    $(".enfermedad").autocomplete({
        source: base_url + 'catalogo/Enfermedad/busca_enfermedad_L1',
        minLength: 4,
        appendTo: ".result",
        select: function(event, ui) {
            if (ui.item.value !== '') {
                $(".enfermedad").val(ui.item.label);
                $('.cie').val(ui.item.clave);
            }

            return false;
        },
        change: function(event, ui) {

        },
        response: function(event, ui) {
            if (ui.content.length <= 0) {
                ui.content.push({ 'label': 'Sin resultados', 'value': '' });
            }
        }
    });
}

function autocompleta_enfermedad2() {
    base_url = $('#base_url').val();
    $(".enfermedad2").autocomplete({
        source: base_url + 'catalogo/Enfermedad/busca_enfermedad_L1',
        minLength: 4,
        appendTo: ".result",
        select: function(event, ui) {
            if (ui.item.value !== '') {
                $(".enfermedad2").val(ui.item.label);
                $('.cie2').val(ui.item.clave);
            }

            return false;
        },
        change: function(event, ui) {

        },
        response: function(event, ui) {
            if (ui.content.length <= 0) {
                ui.content.push({ 'label': 'Sin resultados', 'value': '' });
            }
        }
    });
}

function pierde_foco_talla() {
    $('#sig_talla').off('focusout');
    $('#sig_talla').on('focusout', function() {
        calcula_imc();
    });
}

function calcula_imc() {
    var peso = $('#sig_peso').val();
    var talla = $('#sig_talla').val() / 100;
    var imc = peso / (talla * talla);

    $('#sigvit_imc').val(imc)
}

function send_form_busca() {
    //envia datos de usuario
    $('.form-search').off('submit');
    $('.form-search').on('submit', function(e) {
        e.preventDefault();
        var dataAjax = new getDataAjax($(this));
        dataAjax.ok = function(data) {
            $('#resultado').html(data.content);
            $('tfoot').html('');
        };
        dataAjax.getData();
    });
}


function autocompleta_cirugia() {
    base_url = $('#base_url').val();
    $(".cirugia").autocomplete({
        source: base_url + 'catalogo/Procedimiento/busca',
        minLength: 4,
        appendTo: ".result",
        select: function(event, ui) {
            if (ui.item.value !== '') {
                $('.cirugia').val(ui.item.label);
                $('.proc_cve_proc').val(ui.item.value);
            }

            return false;
        },
        change: function(event, ui) {

        },
        response: function(event, ui) {
            if (ui.content.length <= 0) {
                ui.content.push({ 'label': 'Sin resultados', 'value': '' });
            }
        }
    });
}

function autocompleta_discapacidad() {
    base_url = $('#base_url').val();
    $(".dispacidad").autocomplete({
        source: base_url + 'catalogo/Discapacidad/busca_discap',
        minLength: 4,
        appendTo: ".result",
        select: function(event, ui) {
            if (ui.item.value !== '') {
                $('.dispacidad').val(ui.item.label);
                $('.discap_cve').val(ui.item.value);
            }

            return false;
        },
        change: function(event, ui) {

        },
        response: function(event, ui) {
            if (ui.content.length <= 0) {
                ui.content.push({ 'label': 'Sin resultados', 'value': '' });
            }
        }
    });
}

//cuando cambia la empresa trae los despachos
function cambia_empresa() {
    $('.empresa').off('change');
    $('.empresa').on('change', function() {
        var empresa = $(this).val();
        var dataAjax = new getDataAjax(base_url + 'empresa/despachos/' + empresa);
        dataAjax.ok = function(data) {
            $('.despachos').html('<option ="">Selecciona</option>');
            $.each(data.content, function(i, k) {
                $('.despachos').append('<option value="' + k.emp_id + '">' + k.emp_razon_social + '</option>');
            });
        };
        dataAjax.getData();
    });
}

function cambia_rol()
{
    $('.rol').off('change');
    $('.rol').on('change', function(){
        console.log('cambia rol');
		
        if($(this).val() == 94)
        {
            if($('.sucursal_tecnoval').hasClass('hidden'))
            {
                $('.sucursal_tecnoval').removeClass('hidden');
            }
        }
        else
        {
            if( ! $('.sucursal_tecnoval').hasClass('hidden'))
            {
                $('.sucursal_tecnoval').addClass('hidden');
            }
        }
		
        if($(this).val() == 30)
        {
            if($('.sucursal_cometra').hasClass('hidden'))
            {
                $('.sucursal_cometra').removeClass('hidden');
            }
        }
        else
        {
            if( ! $('.sucursal_cometra').hasClass('hidden'))
            {
                $('.sucursal_cometra').addClass('hidden');
            }
        }	

        if($(this).val() == 196)
        {
            if($('.sucursal_mercurio').hasClass('hidden'))
            {
                $('.sucursal_mercurio').removeClass('hidden');
            }
        }
        else
        {
            if( ! $('.sucursal_mercurio').hasClass('hidden'))
            {
                $('.sucursal_mercurio').addClass('hidden');
            }
        }
	
        if($(this).val() == 223)
        {
            if($('.sucursal_fabril').hasClass('hidden'))
            {
                $('.sucursal_fabril').removeClass('hidden');
            }
        }
        else
        {
            if( ! $('.sucursal_fabril').hasClass('hidden'))
            {
                $('.sucursal_fabril').addClass('hidden');
            }
        }	


        if($(this).val() == 117)
        {
            if($('.sucursal_gsisp').hasClass('hidden'))
            {
                $('.sucursal_gsisp').removeClass('hidden');
            }
        }
        else
        {
            if( ! $('.sucursal_gsisp').hasClass('hidden'))
            {
                $('.sucursal_gsisp').addClass('hidden');
            }
        }

        if($(this).val() == 204)
        {
            if($('.sucursal_regio').hasClass('hidden'))
            {
                $('.sucursal_regio').removeClass('hidden');
            }
        }
        else
        {
            if( ! $('.sucursal_regio').hasClass('hidden'))
            {
                $('.sucursal_regio').addClass('hidden');
            }
        }
		
        if($(this).val() == 92)
        {
            if($('.sucursal_seguritec').hasClass('hidden'))
            {
                $('.sucursal_seguritec').removeClass('hidden');
            }
        }
        else
        {
            if( ! $('.sucursal_seguritec').hasClass('hidden'))
            {
                $('.sucursal_seguritec').addClass('hidden');
            }
        }

        if($(this).val() == 218)
        {
            if($('.sucursal_sepsacv').hasClass('hidden'))
            {
                $('.sucursal_sepsacv').removeClass('hidden');
            }
        }
        else
        {
            if( ! $('.sucursal_sepsacv').hasClass('hidden'))
            {
                $('.sucursal_sepsacv').addClass('hidden');
            }
        }

        if($(this).val() == 132)
        {
            if($('.sucursal_sepsa').hasClass('hidden'))
            {
                $('.sucursal_sepsa').removeClass('hidden');
            }
        }
        else
        {
            if( ! $('.sucursal_sepsa').hasClass('hidden'))
            {
                $('.sucursal_sepsa').addClass('hidden');
            }
        }		

        if($(this).val() == 49)
        {
            if($('.sucursal_tameme').hasClass('hidden'))
            {
                $('.sucursal_tameme').removeClass('hidden');
            }
        }
        else
        {
            if( ! $('.sucursal_tameme').hasClass('hidden'))
            {
                $('.sucursal_tameme').addClass('hidden');
            }
        }


        if($(this).val() == 360)
        {
            if($('.sucursal_sps').hasClass('hidden'))
            {
                $('.sucursal_sps').removeClass('hidden');
            }
        }
        else
        {
            if( ! $('.sucursal_sps').hasClass('hidden'))
            {
                $('.sucursal_sps').addClass('hidden');
            }
        }



        if  (
				($(this).val() != 49) &&
				($(this).val() != 132) &&
				($(this).val() != 218) &&
				($(this).val() != 92) &&
				($(this).val() != 204) &&
				($(this).val() != 117) &&
				($(this).val() != 223) &&
				($(this).val() != 196) &&
				($(this).val() != 94) &&
				($(this).val() != 30) 			
			)
        {
            if($('.sin_sucursal').hasClass('hidden'))
            {
                $('.sin_sucursal').removeClass('hidden');
            }
        }
        else
        {
            if( ! $('.sin_sucursal').hasClass('hidden'))
            {
                $('.sin_sucursal').addClass('hidden');
            }
        }
		
		
    });
}