$(function(){
    //envia datos de inicio de sesion
    $('.send-login').on('submit',function(e){
        e.preventDefault();
        
        var recaptchaResponse = grecaptcha.getResponse();
        if (recaptchaResponse.length === 0) {
            alert('Por favor, completa el captcha.');
            return;
        }

        var urlRedirect = $(this).data('redirect');
        var base_url = $('#base_url').val();
        var data_form = $(this).serialize();
        data_form += '&res='+Base64.encode(get_dimensiones());
        data_form += '&g-recaptcha-response=' + recaptchaResponse;

        var dataAjax = new getDataAjax($(this));
        dataAjax.data = data_form;
        dataAjax.ok = function(data){
            show_exito_afterClose(data.content, function(){
                window.location = urlRedirect;
            });
        };
        dataAjax.error = function(data){
            if(data.content.tipo == 'msg')
            {
                show_error(data.content.msg);
            }
            else if(data.content.tipo == 'view')
            {
                $('.form-view').html(data.content.view);
            }
        };
        dataAjax.getData();
    });
});

function get_dimensiones()
{
    var dimensiones = {};
    dimensiones.screen_w = screen.width;
    dimensiones.screen_h = screen.height;
    
    dimensiones.screen_disp_w = screen.availWidth;
    dimensiones.screen_disp_h = screen.availHeight;
    
    dimensiones.window_w = $(window).width();
    dimensiones.window_h = $(window).height();
    
    var str = Object.keys(dimensiones).map(function(key){ 
        return encodeURIComponent(key) + '=' + encodeURIComponent(dimensiones[key]); 
    }).join('&');
    
    return str;
}